# Coverage.cmake
#
# Sets up custom target 'coverage', using a function from commons/CoverageFunction.
#
# Outcome will be written to html_dir.

set(coverage_ignore_dirs "'/usr/*'")
list(APPEND coverage_ignore_dirs "'*/auto/*'")
list(APPEND coverage_ignore_dirs "'*/Tests/*'")
list(APPEND coverage_ignore_dirs "'*/3rdparty/*'")
list(APPEND coverage_ignore_dirs "'*/build/*'")
list(APPEND coverage_ignore_dirs "'*/debug/*'")
list(APPEND coverage_ignore_dirs "'*/hugo/*'")

set(html_dir ${CMAKE_CURRENT_BINARY_DIR}/coverage)
file(MAKE_DIRECTORY ${html_dir})

add_coverage_target(coverage "${coverage_ignore_dirs}" ${html_dir})
