// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUIOgreRenderer.h"
#include "OgreRenderer.pypp.hpp"

namespace bp = boost::python;

struct OgreRenderer_wrapper : CEGUI::OgreRenderer, bp::wrapper< CEGUI::OgreRenderer > {

    virtual void beginRendering(  ) {
        if( bp::override func_beginRendering = this->get_override( "beginRendering" ) )
            func_beginRendering(  );
        else{
            this->CEGUI::OgreRenderer::beginRendering(  );
        }
    }
    
    void default_beginRendering(  ) {
        CEGUI::OgreRenderer::beginRendering( );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget(  ) {
        if( bp::override func_createTextureTarget = this->get_override( "createTextureTarget" ) )
            return func_createTextureTarget(  );
        else{
            return this->CEGUI::OgreRenderer::createTextureTarget(  );
        }
    }
    
    ::CEGUI::TextureTarget * default_createTextureTarget(  ) {
        return CEGUI::OgreRenderer::createTextureTarget( );
    }

    virtual void destroyAllGeometryBuffers(  ) {
        if( bp::override func_destroyAllGeometryBuffers = this->get_override( "destroyAllGeometryBuffers" ) )
            func_destroyAllGeometryBuffers(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllGeometryBuffers(  );
        }
    }
    
    void default_destroyAllGeometryBuffers(  ) {
        CEGUI::OgreRenderer::destroyAllGeometryBuffers( );
    }

    virtual void destroyAllTextureTargets(  ) {
        if( bp::override func_destroyAllTextureTargets = this->get_override( "destroyAllTextureTargets" ) )
            func_destroyAllTextureTargets(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllTextureTargets(  );
        }
    }
    
    void default_destroyAllTextureTargets(  ) {
        CEGUI::OgreRenderer::destroyAllTextureTargets( );
    }

    virtual void destroyAllTextures(  ) {
        if( bp::override func_destroyAllTextures = this->get_override( "destroyAllTextures" ) )
            func_destroyAllTextures(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllTextures(  );
        }
    }
    
    void default_destroyAllTextures(  ) {
        CEGUI::OgreRenderer::destroyAllTextures( );
    }

    virtual void destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        if( bp::override func_destroyGeometryBuffer = this->get_override( "destroyGeometryBuffer" ) )
            func_destroyGeometryBuffer( boost::ref(buffer) );
        else{
            this->CEGUI::OgreRenderer::destroyGeometryBuffer( boost::ref(buffer) );
        }
    }
    
    void default_destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        CEGUI::OgreRenderer::destroyGeometryBuffer( boost::ref(buffer) );
    }

    virtual void destroyTexture( ::CEGUI::Texture & texture ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(texture) );
        else{
            this->CEGUI::OgreRenderer::destroyTexture( boost::ref(texture) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::Texture & texture ) {
        CEGUI::OgreRenderer::destroyTexture( boost::ref(texture) );
    }

    virtual void destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        if( bp::override func_destroyTextureTarget = this->get_override( "destroyTextureTarget" ) )
            func_destroyTextureTarget( boost::python::ptr(target) );
        else{
            this->CEGUI::OgreRenderer::destroyTextureTarget( boost::python::ptr(target) );
        }
    }
    
    void default_destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        CEGUI::OgreRenderer::destroyTextureTarget( boost::python::ptr(target) );
    }

    virtual void endRendering(  ) {
        if( bp::override func_endRendering = this->get_override( "endRendering" ) )
            func_endRendering(  );
        else{
            this->CEGUI::OgreRenderer::endRendering(  );
        }
    }
    
    void default_endRendering(  ) {
        CEGUI::OgreRenderer::endRendering( );
    }

    virtual ::CEGUI::uint getMaxTextureSize(  ) const  {
        if( bp::override func_getMaxTextureSize = this->get_override( "getMaxTextureSize" ) )
            return func_getMaxTextureSize(  );
        else{
            return this->CEGUI::OgreRenderer::getMaxTextureSize(  );
        }
    }
    
    ::CEGUI::uint default_getMaxTextureSize(  ) const  {
        return CEGUI::OgreRenderer::getMaxTextureSize( );
    }

    virtual void setDisplaySize( ::CEGUI::Size const & sz ) {
        if( bp::override func_setDisplaySize = this->get_override( "setDisplaySize" ) )
            func_setDisplaySize( boost::ref(sz) );
        else{
            this->CEGUI::OgreRenderer::setDisplaySize( boost::ref(sz) );
        }
    }
    
    void default_setDisplaySize( ::CEGUI::Size const & sz ) {
        CEGUI::OgreRenderer::setDisplaySize( boost::ref(sz) );
    }

};

void register_OgreRenderer_class(){

    { //::CEGUI::OgreRenderer
        typedef bp::class_< OgreRenderer_wrapper, bp::bases< ::CEGUI::Renderer >, boost::noncopyable > OgreRenderer_exposer_t;
        OgreRenderer_exposer_t OgreRenderer_exposer = OgreRenderer_exposer_t( "OgreRenderer", "! CEGUI.Renderer implementation for the Ogre engine.\n", bp::no_init );
        bp::scope OgreRenderer_scope( OgreRenderer_exposer );
        { //::CEGUI::OgreRenderer::beginRendering
        
            typedef void ( ::CEGUI::OgreRenderer::*beginRendering_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_beginRendering_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "beginRendering"
                , beginRendering_function_type(&::CEGUI::OgreRenderer::beginRendering)
                , default_beginRendering_function_type(&OgreRenderer_wrapper::default_beginRendering) );
        
        }
        { //::CEGUI::OgreRenderer::bootstrapSystem
        
            typedef ::CEGUI::OgreRenderer & ( *bootstrapSystem_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OgreRenderer::bootstrapSystem )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates all the Ogre specific objects and\n\
                    then initialises the CEGUI system with them.\n\
            \n\
                    The created Renderer will use the default Ogre rendering window as the\n\
                    default output surface.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OgreRenderer\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.System\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OgreRenderer object that was created.\n\
            \n\
                \note\n\
                    For this to succeed you must have initialised Ogre to auto create the\n\
                    rendering window.  If you have not done this, then you'll be wanting to\n\
                    use the overload that takes an Ogre.RenderTarget as input.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::bootstrapSystem
        
            typedef ::CEGUI::OgreRenderer & ( *bootstrapSystem_function_type )( ::Ogre::RenderTarget & );
            
            OgreRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OgreRenderer::bootstrapSystem )
                , ( bp::arg("target") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates all the Ogre specific objects and\n\
                    then initialises the CEGUI system with them.\n\
            \n\
                    The create Renderer will use the specified Ogre.RenderTarget as the\n\
                    default output surface.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OgreRenderer\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.System\n\
            \n\
                @param target\n\
                    Reference to the Ogre.RenderTarget object that the created OgreRenderer\n\
                    will use as the default rendering root.\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OgreRenderer object that was created.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::create
        
            typedef ::CEGUI::OgreRenderer & ( *create_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OgreRenderer::create )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create an OgreRenderer object that uses the default Ogre rendering\n\
                    window as the default output surface.\n\
            \n\
                \note\n\
                    For this to succeed you must have initialised Ogre to auto create the\n\
                    rendering window.  If you have not done this, then you'll be wanting to\n\
                    use the overload that takes an Ogre.RenderTarget as input.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::create
        
            typedef ::CEGUI::OgreRenderer & ( *create_function_type )( ::Ogre::RenderTarget & );
            
            OgreRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OgreRenderer::create )
                , ( bp::arg("target") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                Create an OgreRenderer object that uses the specified Ogre.RenderTarget\n\
                as the default output surface.\n\
            *\n" );
        
        }
        { //::CEGUI::OgreRenderer::createGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::OgreRenderer::*createGeometryBuffer_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "createGeometryBuffer"
                , createGeometryBuffer_function_type(&::CEGUI::OgreRenderer::createGeometryBuffer)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createOgreImageCodec
        
            typedef ::CEGUI::OgreImageCodec & ( *createOgreImageCodec_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "createOgreImageCodec"
                , createOgreImageCodec_function_type( &::CEGUI::OgreRenderer::createOgreImageCodec )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! function to create a CEGUI.OgreImageCodec object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::createOgreResourceProvider
        
            typedef ::CEGUI::OgreResourceProvider & ( *createOgreResourceProvider_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "createOgreResourceProvider"
                , createOgreResourceProvider_function_type( &::CEGUI::OgreRenderer::createOgreResourceProvider )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! function to create a CEGUI.OgreResourceProvider object\n" );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::Ogre::TexturePtr &,bool ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type( &::CEGUI::OgreRenderer::createTexture )
                , ( bp::arg("tex"), bp::arg("take_ownership")=(bool)(false) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a CEGUI.Texture that wraps an existing Ogre texture.\n\
            \n\
                @param tex\n\
                    Ogre.TexturePtr for the texture that will be used by the created\n\
                    CEGUI.Texture.\n\
            \n\
                @param take_ownership\n\
                    - true if the created Texture will assume ownership of  tex and\n\
                    thus destroy  tex when the Texture is destroyed.\n\
                    - false if ownership of  tex remains with the client app, and so\n\
                    no attempt will be made to destroy  tex when the Texture is destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , ( bp::arg("filename"), bp::arg("resourceGroup") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::Size const & ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , ( bp::arg("size") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTextureTarget
        
            typedef ::CEGUI::TextureTarget * ( ::CEGUI::OgreRenderer::*createTextureTarget_function_type )(  ) ;
            typedef ::CEGUI::TextureTarget * ( OgreRenderer_wrapper::*default_createTextureTarget_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "createTextureTarget"
                , createTextureTarget_function_type(&::CEGUI::OgreRenderer::createTextureTarget)
                , default_createTextureTarget_function_type(&OgreRenderer_wrapper::default_createTextureTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::destroy
        
            typedef void ( *destroy_function_type )( ::CEGUI::OgreRenderer & );
            
            OgreRenderer_exposer.def( 
                "destroy"
                , destroy_function_type( &::CEGUI::OgreRenderer::destroy )
                , ( bp::arg("renderer") )
                , "! destory an OgreRenderer object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllGeometryBuffers
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllGeometryBuffers_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllGeometryBuffers_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllGeometryBuffers"
                , destroyAllGeometryBuffers_function_type(&::CEGUI::OgreRenderer::destroyAllGeometryBuffers)
                , default_destroyAllGeometryBuffers_function_type(&OgreRenderer_wrapper::default_destroyAllGeometryBuffers) );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllTextureTargets
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllTextureTargets_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllTextureTargets_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllTextureTargets"
                , destroyAllTextureTargets_function_type(&::CEGUI::OgreRenderer::destroyAllTextureTargets)
                , default_destroyAllTextureTargets_function_type(&OgreRenderer_wrapper::default_destroyAllTextureTargets) );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllTextures
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllTextures_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllTextures_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllTextures"
                , destroyAllTextures_function_type(&::CEGUI::OgreRenderer::destroyAllTextures)
                , default_destroyAllTextures_function_type(&OgreRenderer_wrapper::default_destroyAllTextures) );
        
        }
        { //::CEGUI::OgreRenderer::destroyGeometryBuffer
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            OgreRenderer_exposer.def( 
                "destroyGeometryBuffer"
                , destroyGeometryBuffer_function_type(&::CEGUI::OgreRenderer::destroyGeometryBuffer)
                , default_destroyGeometryBuffer_function_type(&OgreRenderer_wrapper::default_destroyGeometryBuffer)
                , ( bp::arg("buffer") ) );
        
        }
        { //::CEGUI::OgreRenderer::destroyOgreImageCodec
        
            typedef void ( *destroyOgreImageCodec_function_type )( ::CEGUI::OgreImageCodec & );
            
            OgreRenderer_exposer.def( 
                "destroyOgreImageCodec"
                , destroyOgreImageCodec_function_type( &::CEGUI::OgreRenderer::destroyOgreImageCodec )
                , ( bp::arg("ic") )
                , "! function to destroy a CEGUI.OgreImageCodec object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyOgreResourceProvider
        
            typedef void ( *destroyOgreResourceProvider_function_type )( ::CEGUI::OgreResourceProvider & );
            
            OgreRenderer_exposer.def( 
                "destroyOgreResourceProvider"
                , destroyOgreResourceProvider_function_type( &::CEGUI::OgreRenderer::destroyOgreResourceProvider )
                , ( bp::arg("rp") )
                , "! function to destroy a CEGUI.OgreResourceProvider object\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroySystem
        
            typedef void ( *destroySystem_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "destroySystem"
                , destroySystem_function_type( &::CEGUI::OgreRenderer::destroySystem )
                , "*!\n\
                \n\
                    Convenience function to cleanup the CEGUI system and related objects\n\
                    that were created by calling the bootstrapSystem function.\n\
            \n\
                    This function will destroy the following objects for you:\n\
                    - CEGUI.System\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreRenderer\n\
            \n\
                \note\n\
                    If you did not initialise CEGUI by calling the bootstrapSystem function,\n\
                    you should  e not call this, but rather delete any objects you created\n\
                    manually.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyTexture
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            
            OgreRenderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OgreRenderer::destroyTexture)
                , default_destroyTexture_function_type(&OgreRenderer_wrapper::default_destroyTexture)
                , ( bp::arg("texture") ) );
        
        }
        { //::CEGUI::OgreRenderer::destroyTextureTarget
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            
            OgreRenderer_exposer.def( 
                "destroyTextureTarget"
                , destroyTextureTarget_function_type(&::CEGUI::OgreRenderer::destroyTextureTarget)
                , default_destroyTextureTarget_function_type(&OgreRenderer_wrapper::default_destroyTextureTarget)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::OgreRenderer::endRendering
        
            typedef void ( ::CEGUI::OgreRenderer::*endRendering_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_endRendering_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "endRendering"
                , endRendering_function_type(&::CEGUI::OgreRenderer::endRendering)
                , default_endRendering_function_type(&OgreRenderer_wrapper::default_endRendering) );
        
        }
        { //::CEGUI::OgreRenderer::getDefaultRenderingRoot
        
            typedef ::CEGUI::RenderingRoot & ( ::CEGUI::OgreRenderer::*getDefaultRenderingRoot_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "getDefaultRenderingRoot"
                , getDefaultRenderingRoot_function_type(&::CEGUI::OgreRenderer::getDefaultRenderingRoot)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::getDisplayDPI
        
            typedef ::CEGUI::Vector2 const & ( ::CEGUI::OgreRenderer::*getDisplayDPI_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getDisplayDPI"
                , getDisplayDPI_function_type(&::CEGUI::OgreRenderer::getDisplayDPI)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getDisplaySize
        
            typedef ::CEGUI::Size const & ( ::CEGUI::OgreRenderer::*getDisplaySize_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getDisplaySize"
                , getDisplaySize_function_type(&::CEGUI::OgreRenderer::getDisplaySize)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getIdentifierString
        
            typedef ::CEGUI::String const & ( ::CEGUI::OgreRenderer::*getIdentifierString_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getIdentifierString"
                , getIdentifierString_function_type(&::CEGUI::OgreRenderer::getIdentifierString)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getMaxTextureSize
        
            typedef ::CEGUI::uint ( ::CEGUI::OgreRenderer::*getMaxTextureSize_function_type )(  ) const;
            typedef ::CEGUI::uint ( OgreRenderer_wrapper::*default_getMaxTextureSize_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getMaxTextureSize"
                , getMaxTextureSize_function_type(&::CEGUI::OgreRenderer::getMaxTextureSize)
                , default_getMaxTextureSize_function_type(&OgreRenderer_wrapper::default_getMaxTextureSize) );
        
        }
        { //::CEGUI::OgreRenderer::initialiseRenderStateSettings
        
            typedef void ( ::CEGUI::OgreRenderer::*initialiseRenderStateSettings_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "initialiseRenderStateSettings"
                , initialiseRenderStateSettings_function_type( &::CEGUI::OgreRenderer::initialiseRenderStateSettings )
                , "*!\n\
                \n\
                    Sets all the required render states needed for CEGUI rendering.\n\
            \n\
                    This is a low-level function intended for certain advanced concepts; in\n\
                    general it will not be required to call this function directly, since it\n\
                    is called automatically by the system when rendering is done.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::isFrameControlExecutionEnabled
        
            typedef bool ( ::CEGUI::OgreRenderer::*isFrameControlExecutionEnabled_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "isFrameControlExecutionEnabled"
                , isFrameControlExecutionEnabled_function_type( &::CEGUI::OgreRenderer::isFrameControlExecutionEnabled )
                , "*!\n\
                \n\
                    Returns whether rendering done by CEGUI will be wrapped with calls to\n\
                    Ogre.RenderSystem._beginFrame and Ogre.RenderSystem._endFrame.\n\
            \n\
                    This defaults to enabled and is required when using the default hook\n\
                    that automatically calls CEGUI.System.renderGUI via a frame listener.\n\
                    If you disable this setting, the automated rendering will also be\n\
                    disabled, which is useful when you wish to perform your own calls to the\n\
                    CEGUI.System.renderGUI function (and is the sole purpose for this\n\
                    setting).\n\
            \n\
                @return\n\
                    - true if _beginFrame and _endFrame will be called.\n\
                    - false if _beginFrame and _endFrame will not be called (also means\n\
                      default renderGUI call will not be made).\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::isRenderingEnabled
        
            typedef bool ( ::CEGUI::OgreRenderer::*isRenderingEnabled_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "isRenderingEnabled"
                , isRenderingEnabled_function_type( &::CEGUI::OgreRenderer::isRenderingEnabled )
                , "! return whether CEGUI rendering is enabled.\n" );
        
        }
        { //::CEGUI::OgreRenderer::setDefaultRootRenderTarget
        
            typedef void ( ::CEGUI::OgreRenderer::*setDefaultRootRenderTarget_function_type )( ::Ogre::RenderTarget & ) ;
            
            OgreRenderer_exposer.def( 
                "setDefaultRootRenderTarget"
                , setDefaultRootRenderTarget_function_type( &::CEGUI::OgreRenderer::setDefaultRootRenderTarget )
                , ( bp::arg("target") )
                , "*!\n\
                \n\
                    Sets the Ogre.RenderTarget that should be targetted by the default\n\
                    RenderingRoot.\n\
            \n\
                @param target\n\
                    Reference to the Ogre.RenderTarget object that is to be used as the\n\
                    target for output from the default RenderingRoot.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::setDisplaySize
        
            typedef void ( ::CEGUI::OgreRenderer::*setDisplaySize_function_type )( ::CEGUI::Size const & ) ;
            typedef void ( OgreRenderer_wrapper::*default_setDisplaySize_function_type )( ::CEGUI::Size const & ) ;
            
            OgreRenderer_exposer.def( 
                "setDisplaySize"
                , setDisplaySize_function_type(&::CEGUI::OgreRenderer::setDisplaySize)
                , default_setDisplaySize_function_type(&OgreRenderer_wrapper::default_setDisplaySize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OgreRenderer::setFrameControlExecutionEnabled
        
            typedef void ( ::CEGUI::OgreRenderer::*setFrameControlExecutionEnabled_function_type )( bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setFrameControlExecutionEnabled"
                , setFrameControlExecutionEnabled_function_type( &::CEGUI::OgreRenderer::setFrameControlExecutionEnabled )
                , ( bp::arg("enabled") )
                , "*!\n\
                \n\
                    Controls whether rendering done by CEGUI will be wrapped with calls to\n\
                    Ogre.RenderSystem._beginFrame and Ogre.RenderSystem._endFrame.\n\
            \n\
                    This defaults to enabled and is required when using the default hook\n\
                    that automatically calls CEGUI.System.renderGUI via a frame listener.\n\
                    If you disable this setting, the automated rendering will also be\n\
                    disabled, which is useful when you wish to perform your own calls to the\n\
                    CEGUI.System.renderGUI function (and is the sole purpose for this\n\
                    setting).\n\
            \n\
                @param enabled\n\
                    - true if _beginFrame and _endFrame should be called.\n\
                    - false if _beginFrame and _endFrame should not be called (also disables\n\
                      default renderGUI call).\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::setRenderingEnabled
        
            typedef void ( ::CEGUI::OgreRenderer::*setRenderingEnabled_function_type )( bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setRenderingEnabled"
                , setRenderingEnabled_function_type( &::CEGUI::OgreRenderer::setRenderingEnabled )
                , ( bp::arg("enabled") )
                , "! set whether CEGUI rendering will occur\n" );
        
        }
        { //::CEGUI::OgreRenderer::setupRenderingBlendMode
        
            typedef void ( ::CEGUI::OgreRenderer::*setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setupRenderingBlendMode"
                , setupRenderingBlendMode_function_type( &::CEGUI::OgreRenderer::setupRenderingBlendMode )
                , ( bp::arg("mode"), bp::arg("force")=(bool const)(false) )
                , "! set the render states for the specified BlendMode.\n" );
        
        }
        OgreRenderer_exposer.staticmethod( "bootstrapSystem" );
        OgreRenderer_exposer.staticmethod( "create" );
        OgreRenderer_exposer.staticmethod( "createOgreImageCodec" );
        OgreRenderer_exposer.staticmethod( "createOgreResourceProvider" );
        OgreRenderer_exposer.staticmethod( "destroy" );
        OgreRenderer_exposer.staticmethod( "destroyOgreImageCodec" );
        OgreRenderer_exposer.staticmethod( "destroyOgreResourceProvider" );
        OgreRenderer_exposer.staticmethod( "destroySystem" );
    }

}
