// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUIOgreRenderer.h"
#include "OgreRenderer.pypp.hpp"

namespace bp = boost::python;

struct OgreRenderer_wrapper : CEGUI::OgreRenderer, bp::wrapper< CEGUI::OgreRenderer > {

    OgreRenderer_wrapper( )
    : CEGUI::OgreRenderer( )
      , bp::wrapper< CEGUI::OgreRenderer >(){
        // null constructor
    
    }

    OgreRenderer_wrapper(::Ogre::RenderTarget & target )
    : CEGUI::OgreRenderer( boost::ref(target) )
      , bp::wrapper< CEGUI::OgreRenderer >(){
        // constructor
    
    }

    virtual void beginRendering(  ) {
        if( bp::override func_beginRendering = this->get_override( "beginRendering" ) )
            func_beginRendering(  );
        else{
            this->CEGUI::OgreRenderer::beginRendering(  );
        }
    }
    
    void default_beginRendering(  ) {
        CEGUI::OgreRenderer::beginRendering( );
    }

    void checkOgreInitialised(  ){
        CEGUI::OgreRenderer::checkOgreInitialised(  );
    }

    void cleanupShaders(  ){
        CEGUI::OgreRenderer::cleanupShaders(  );
    }

    void constructor_impl( ::Ogre::RenderTarget & target ){
        CEGUI::OgreRenderer::constructor_impl( boost::ref(target) );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget(  ) {
        if( bp::override func_createTextureTarget = this->get_override( "createTextureTarget" ) )
            return func_createTextureTarget(  );
        else{
            return this->CEGUI::OgreRenderer::createTextureTarget(  );
        }
    }
    
    ::CEGUI::TextureTarget * default_createTextureTarget(  ) {
        return CEGUI::OgreRenderer::createTextureTarget( );
    }

    virtual void destroyAllGeometryBuffers(  ) {
        if( bp::override func_destroyAllGeometryBuffers = this->get_override( "destroyAllGeometryBuffers" ) )
            func_destroyAllGeometryBuffers(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllGeometryBuffers(  );
        }
    }
    
    void default_destroyAllGeometryBuffers(  ) {
        CEGUI::OgreRenderer::destroyAllGeometryBuffers( );
    }

    virtual void destroyAllTextureTargets(  ) {
        if( bp::override func_destroyAllTextureTargets = this->get_override( "destroyAllTextureTargets" ) )
            func_destroyAllTextureTargets(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllTextureTargets(  );
        }
    }
    
    void default_destroyAllTextureTargets(  ) {
        CEGUI::OgreRenderer::destroyAllTextureTargets( );
    }

    virtual void destroyAllTextures(  ) {
        if( bp::override func_destroyAllTextures = this->get_override( "destroyAllTextures" ) )
            func_destroyAllTextures(  );
        else{
            this->CEGUI::OgreRenderer::destroyAllTextures(  );
        }
    }
    
    void default_destroyAllTextures(  ) {
        CEGUI::OgreRenderer::destroyAllTextures( );
    }

    virtual void destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        if( bp::override func_destroyGeometryBuffer = this->get_override( "destroyGeometryBuffer" ) )
            func_destroyGeometryBuffer( boost::ref(buffer) );
        else{
            this->CEGUI::OgreRenderer::destroyGeometryBuffer( boost::ref(buffer) );
        }
    }
    
    void default_destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        CEGUI::OgreRenderer::destroyGeometryBuffer( boost::ref(buffer) );
    }

    virtual void destroyTexture( ::CEGUI::Texture & texture ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(texture) );
        else{
            this->CEGUI::OgreRenderer::destroyTexture( boost::ref(texture) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::Texture & texture ) {
        CEGUI::OgreRenderer::destroyTexture( boost::ref(texture) );
    }

    virtual void destroyTexture( ::CEGUI::String const & name ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(name) );
        else{
            this->CEGUI::OgreRenderer::destroyTexture( boost::ref(name) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::String const & name ) {
        CEGUI::OgreRenderer::destroyTexture( boost::ref(name) );
    }

    virtual void destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        if( bp::override func_destroyTextureTarget = this->get_override( "destroyTextureTarget" ) )
            func_destroyTextureTarget( boost::python::ptr(target) );
        else{
            this->CEGUI::OgreRenderer::destroyTextureTarget( boost::python::ptr(target) );
        }
    }
    
    void default_destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        CEGUI::OgreRenderer::destroyTextureTarget( boost::python::ptr(target) );
    }

    virtual void endRendering(  ) {
        if( bp::override func_endRendering = this->get_override( "endRendering" ) )
            func_endRendering(  );
        else{
            this->CEGUI::OgreRenderer::endRendering(  );
        }
    }
    
    void default_endRendering(  ) {
        CEGUI::OgreRenderer::endRendering( );
    }

    virtual ::CEGUI::uint getMaxTextureSize(  ) const  {
        if( bp::override func_getMaxTextureSize = this->get_override( "getMaxTextureSize" ) )
            return func_getMaxTextureSize(  );
        else{
            return this->CEGUI::OgreRenderer::getMaxTextureSize(  );
        }
    }
    
    ::CEGUI::uint default_getMaxTextureSize(  ) const  {
        return CEGUI::OgreRenderer::getMaxTextureSize( );
    }

    void initialiseShaders(  ){
        CEGUI::OgreRenderer::initialiseShaders(  );
    }

    virtual bool isTextureDefined( ::CEGUI::String const & name ) const  {
        if( bp::override func_isTextureDefined = this->get_override( "isTextureDefined" ) )
            return func_isTextureDefined( boost::ref(name) );
        else{
            return this->CEGUI::OgreRenderer::isTextureDefined( boost::ref(name) );
        }
    }
    
    bool default_isTextureDefined( ::CEGUI::String const & name ) const  {
        return CEGUI::OgreRenderer::isTextureDefined( boost::ref(name) );
    }

    static void logTextureCreation( ::CEGUI::String const & name ){
        CEGUI::OgreRenderer::logTextureCreation( boost::ref(name) );
    }

    static void logTextureDestruction( ::CEGUI::String const & name ){
        CEGUI::OgreRenderer::logTextureDestruction( boost::ref(name) );
    }

    virtual void setDisplaySize( ::CEGUI::Sizef const & sz ) {
        if( bp::override func_setDisplaySize = this->get_override( "setDisplaySize" ) )
            func_setDisplaySize( boost::ref(sz) );
        else{
            this->CEGUI::OgreRenderer::setDisplaySize( boost::ref(sz) );
        }
    }
    
    void default_setDisplaySize( ::CEGUI::Sizef const & sz ) {
        CEGUI::OgreRenderer::setDisplaySize( boost::ref(sz) );
    }

    void throwIfNameExists( ::CEGUI::String const & name ) const {
        CEGUI::OgreRenderer::throwIfNameExists( boost::ref(name) );
    }

};

void register_OgreRenderer_class(){

    { //::CEGUI::OgreRenderer
        typedef bp::class_< OgreRenderer_wrapper, bp::bases< ::CEGUI::Renderer >, boost::noncopyable > OgreRenderer_exposer_t;
        OgreRenderer_exposer_t OgreRenderer_exposer = OgreRenderer_exposer_t( "OgreRenderer", "! CEGUI.Renderer implementation for the Ogre engine.\n", bp::no_init );
        bp::scope OgreRenderer_scope( OgreRenderer_exposer );
        OgreRenderer_exposer.def( bp::init< >("! default constructor.\n") );
        OgreRenderer_exposer.def( bp::init< Ogre::RenderTarget & >(( bp::arg("target") ), "! default constructor.\n\
        ! constructor takin the Ogre.RenderTarget to use as the default root.\n") );
        { //::CEGUI::OgreRenderer::beginRendering
        
            typedef void ( ::CEGUI::OgreRenderer::*beginRendering_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_beginRendering_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "beginRendering"
                , beginRendering_function_type(&::CEGUI::OgreRenderer::beginRendering)
                , default_beginRendering_function_type(&OgreRenderer_wrapper::default_beginRendering) );
        
        }
        { //::CEGUI::OgreRenderer::bindShaders
        
            typedef void ( ::CEGUI::OgreRenderer::*bindShaders_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "bindShaders"
                , bindShaders_function_type( &::CEGUI::OgreRenderer::bindShaders )
                , "*!\n\
                \n\
                    Perform required operations to bind shaders (or unbind them) depending\n\
                    on whether shader based rendering is currently enabled.\n\
            \n\
                    Normally you would not need to call this function directly, although\n\
                    that might be required if you are using RenderEffect objects that\n\
                    also use shaders.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::bootstrapSystem
        
            typedef ::CEGUI::OgreRenderer & ( *bootstrapSystem_function_type )( int const );
            
            OgreRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OgreRenderer::bootstrapSystem )
                , ( bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates all the Ogre specific objects and\n\
                    then initialises the CEGUI system with them.\n\
            \n\
                    The created Renderer will use the default Ogre rendering window as the\n\
                    default output surface.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OgreRenderer\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.System\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OgreRenderer object that was created.\n\
            \n\
                \note\n\
                    For this to succeed you must have initialised Ogre to auto create the\n\
                    rendering window.  If you have not done this, then you'll be wanting to\n\
                    use the overload that takes an Ogre.RenderTarget as input.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::bootstrapSystem
        
            typedef ::CEGUI::OgreRenderer & ( *bootstrapSystem_function_type )( ::Ogre::RenderTarget &,int const );
            
            OgreRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OgreRenderer::bootstrapSystem )
                , ( bp::arg("target"), bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Convenience function that creates all the Ogre specific objects and\n\
                    then initialises the CEGUI system with them.\n\
            \n\
                    The create Renderer will use the specified Ogre.RenderTarget as the\n\
                    default output surface.\n\
            \n\
                    This will create and initialise the following objects for you:\n\
                    - CEGUI.OgreRenderer\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.System\n\
            \n\
                @param target\n\
                    Reference to the Ogre.RenderTarget object that the created OgreRenderer\n\
                    will use as the default rendering root.\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
            \n\
                @return\n\
                    Reference to the CEGUI.OgreRenderer object that was created.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::checkOgreInitialised
        
            typedef void ( OgreRenderer_wrapper::*checkOgreInitialised_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "checkOgreInitialised"
                , checkOgreInitialised_function_type( &OgreRenderer_wrapper::checkOgreInitialised )
                , "! checks Ogre initialisation.  throws exceptions if an issue is detected.\n" );
        
        }
        { //::CEGUI::OgreRenderer::cleanupShaders
        
            typedef void ( OgreRenderer_wrapper::*cleanupShaders_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "cleanupShaders"
                , cleanupShaders_function_type( &OgreRenderer_wrapper::cleanupShaders )
                , "! helper that creates and sets up shaders\n\
            ! helper to clean up shaders\n" );
        
        }
        { //::CEGUI::OgreRenderer::constructor_impl
        
            typedef void ( OgreRenderer_wrapper::*constructor_impl_function_type )( ::Ogre::RenderTarget & ) ;
            
            OgreRenderer_exposer.def( 
                "constructor_impl"
                , constructor_impl_function_type( &OgreRenderer_wrapper::constructor_impl )
                , ( bp::arg("target") )
                , "! common parts of constructor\n" );
        
        }
        { //::CEGUI::OgreRenderer::create
        
            typedef ::CEGUI::OgreRenderer & ( *create_function_type )( int const );
            
            OgreRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OgreRenderer::create )
                , ( bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create an OgreRenderer object that uses the default Ogre rendering\n\
                    window as the default output surface.\n\
            \n\
                \note\n\
                    For this to succeed you must have initialised Ogre to auto create the\n\
                    rendering window.  If you have not done this, then you'll be wanting to\n\
                    use the overload that takes an Ogre.RenderTarget as input.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::create
        
            typedef ::CEGUI::OgreRenderer & ( *create_function_type )( ::Ogre::RenderTarget &,int const );
            
            OgreRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OgreRenderer::create )
                , ( bp::arg("target"), bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                Create an OgreRenderer object that uses the specified Ogre.RenderTarget\n\
                as the default output surface.\n\
            *\n" );
        
        }
        { //::CEGUI::OgreRenderer::createGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::OgreRenderer::*createGeometryBuffer_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "createGeometryBuffer"
                , createGeometryBuffer_function_type(&::CEGUI::OgreRenderer::createGeometryBuffer)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createOgreImageCodec
        
            typedef ::CEGUI::OgreImageCodec & ( *createOgreImageCodec_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "createOgreImageCodec"
                , createOgreImageCodec_function_type( &::CEGUI::OgreRenderer::createOgreImageCodec )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! function to create a CEGUI.OgreImageCodec object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::createOgreResourceProvider
        
            typedef ::CEGUI::OgreResourceProvider & ( *createOgreResourceProvider_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "createOgreResourceProvider"
                , createOgreResourceProvider_function_type( &::CEGUI::OgreRenderer::createOgreResourceProvider )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! function to create a CEGUI.OgreResourceProvider object\n" );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::String const &,::Ogre::TexturePtr &,bool ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type( &::CEGUI::OgreRenderer::createTexture )
                , ( bp::arg("name"), bp::arg("tex"), bp::arg("take_ownership")=(bool)(false) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a CEGUI.Texture that wraps an existing Ogre texture.\n\
            \n\
                @param name\n\
                    The name for tne new texture being created.\n\
            \n\
                @param tex\n\
                    Ogre.TexturePtr for the texture that will be used by the created\n\
                    CEGUI.Texture.\n\
            \n\
                @param take_ownership\n\
                    - true if the created Texture will assume ownership of  tex and\n\
                    thus destroy  tex when the Texture is destroyed.\n\
                    - false if ownership of  tex remains with the client app, and so\n\
                    no attempt will be made to destroy  tex when the Texture is destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::String const & ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::String const &,::CEGUI::String const & ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , ( bp::arg("name"), bp::arg("filename"), bp::arg("resourceGroup") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::Sizef const & ) ;
            
            OgreRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OgreRenderer::createTexture)
                , ( bp::arg("name"), bp::arg("size") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::createTextureTarget
        
            typedef ::CEGUI::TextureTarget * ( ::CEGUI::OgreRenderer::*createTextureTarget_function_type )(  ) ;
            typedef ::CEGUI::TextureTarget * ( OgreRenderer_wrapper::*default_createTextureTarget_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "createTextureTarget"
                , createTextureTarget_function_type(&::CEGUI::OgreRenderer::createTextureTarget)
                , default_createTextureTarget_function_type(&OgreRenderer_wrapper::default_createTextureTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::destroy
        
            typedef void ( *destroy_function_type )( ::CEGUI::OgreRenderer & );
            
            OgreRenderer_exposer.def( 
                "destroy"
                , destroy_function_type( &::CEGUI::OgreRenderer::destroy )
                , ( bp::arg("renderer") )
                , "! destory an OgreRenderer object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllGeometryBuffers
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllGeometryBuffers_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllGeometryBuffers_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllGeometryBuffers"
                , destroyAllGeometryBuffers_function_type(&::CEGUI::OgreRenderer::destroyAllGeometryBuffers)
                , default_destroyAllGeometryBuffers_function_type(&OgreRenderer_wrapper::default_destroyAllGeometryBuffers) );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllTextureTargets
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllTextureTargets_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllTextureTargets_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllTextureTargets"
                , destroyAllTextureTargets_function_type(&::CEGUI::OgreRenderer::destroyAllTextureTargets)
                , default_destroyAllTextureTargets_function_type(&OgreRenderer_wrapper::default_destroyAllTextureTargets) );
        
        }
        { //::CEGUI::OgreRenderer::destroyAllTextures
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyAllTextures_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyAllTextures_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "destroyAllTextures"
                , destroyAllTextures_function_type(&::CEGUI::OgreRenderer::destroyAllTextures)
                , default_destroyAllTextures_function_type(&OgreRenderer_wrapper::default_destroyAllTextures) );
        
        }
        { //::CEGUI::OgreRenderer::destroyGeometryBuffer
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            OgreRenderer_exposer.def( 
                "destroyGeometryBuffer"
                , destroyGeometryBuffer_function_type(&::CEGUI::OgreRenderer::destroyGeometryBuffer)
                , default_destroyGeometryBuffer_function_type(&OgreRenderer_wrapper::default_destroyGeometryBuffer)
                , ( bp::arg("buffer") ) );
        
        }
        { //::CEGUI::OgreRenderer::destroyOgreImageCodec
        
            typedef void ( *destroyOgreImageCodec_function_type )( ::CEGUI::OgreImageCodec & );
            
            OgreRenderer_exposer.def( 
                "destroyOgreImageCodec"
                , destroyOgreImageCodec_function_type( &::CEGUI::OgreRenderer::destroyOgreImageCodec )
                , ( bp::arg("ic") )
                , "! function to destroy a CEGUI.OgreImageCodec object.\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyOgreResourceProvider
        
            typedef void ( *destroyOgreResourceProvider_function_type )( ::CEGUI::OgreResourceProvider & );
            
            OgreRenderer_exposer.def( 
                "destroyOgreResourceProvider"
                , destroyOgreResourceProvider_function_type( &::CEGUI::OgreRenderer::destroyOgreResourceProvider )
                , ( bp::arg("rp") )
                , "! function to destroy a CEGUI.OgreResourceProvider object\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroySystem
        
            typedef void ( *destroySystem_function_type )(  );
            
            OgreRenderer_exposer.def( 
                "destroySystem"
                , destroySystem_function_type( &::CEGUI::OgreRenderer::destroySystem )
                , "*!\n\
                \n\
                    Convenience function to cleanup the CEGUI system and related objects\n\
                    that were created by calling the bootstrapSystem function.\n\
            \n\
                    This function will destroy the following objects for you:\n\
                    - CEGUI.System\n\
                    - CEGUI.OgreImageCodec\n\
                    - CEGUI.OgreResourceProvider\n\
                    - CEGUI.OgreRenderer\n\
            \n\
                \note\n\
                    If you did not initialise CEGUI by calling the bootstrapSystem function,\n\
                    you should  e not call this, but rather delete any objects you created\n\
                    manually.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::destroyTexture
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            
            OgreRenderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OgreRenderer::destroyTexture)
                , default_destroyTexture_function_type(&OgreRenderer_wrapper::default_destroyTexture)
                , ( bp::arg("texture") ) );
        
        }
        { //::CEGUI::OgreRenderer::destroyTexture
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyTexture_function_type )( ::CEGUI::String const & ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::String const & ) ;
            
            OgreRenderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OgreRenderer::destroyTexture)
                , default_destroyTexture_function_type(&OgreRenderer_wrapper::default_destroyTexture)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OgreRenderer::destroyTextureTarget
        
            typedef void ( ::CEGUI::OgreRenderer::*destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            typedef void ( OgreRenderer_wrapper::*default_destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            
            OgreRenderer_exposer.def( 
                "destroyTextureTarget"
                , destroyTextureTarget_function_type(&::CEGUI::OgreRenderer::destroyTextureTarget)
                , default_destroyTextureTarget_function_type(&OgreRenderer_wrapper::default_destroyTextureTarget)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::OgreRenderer::endRendering
        
            typedef void ( ::CEGUI::OgreRenderer::*endRendering_function_type )(  ) ;
            typedef void ( OgreRenderer_wrapper::*default_endRendering_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "endRendering"
                , endRendering_function_type(&::CEGUI::OgreRenderer::endRendering)
                , default_endRendering_function_type(&OgreRenderer_wrapper::default_endRendering) );
        
        }
        { //::CEGUI::OgreRenderer::getDefaultRenderTarget
        
            typedef ::CEGUI::RenderTarget & ( ::CEGUI::OgreRenderer::*getDefaultRenderTarget_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "getDefaultRenderTarget"
                , getDefaultRenderTarget_function_type(&::CEGUI::OgreRenderer::getDefaultRenderTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::getDisplayDPI
        
            typedef ::CEGUI::Vector2f const & ( ::CEGUI::OgreRenderer::*getDisplayDPI_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getDisplayDPI"
                , getDisplayDPI_function_type(&::CEGUI::OgreRenderer::getDisplayDPI)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getDisplaySize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::OgreRenderer::*getDisplaySize_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getDisplaySize"
                , getDisplaySize_function_type(&::CEGUI::OgreRenderer::getDisplaySize)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getIdentifierString
        
            typedef ::CEGUI::String const & ( ::CEGUI::OgreRenderer::*getIdentifierString_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getIdentifierString"
                , getIdentifierString_function_type(&::CEGUI::OgreRenderer::getIdentifierString)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OgreRenderer::getMaxTextureSize
        
            typedef ::CEGUI::uint ( ::CEGUI::OgreRenderer::*getMaxTextureSize_function_type )(  ) const;
            typedef ::CEGUI::uint ( OgreRenderer_wrapper::*default_getMaxTextureSize_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getMaxTextureSize"
                , getMaxTextureSize_function_type(&::CEGUI::OgreRenderer::getMaxTextureSize)
                , default_getMaxTextureSize_function_type(&OgreRenderer_wrapper::default_getMaxTextureSize) );
        
        }
        { //::CEGUI::OgreRenderer::getProjectionMatrix
        
            typedef ::Ogre::Matrix4 const & ( ::CEGUI::OgreRenderer::*getProjectionMatrix_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getProjectionMatrix"
                , getProjectionMatrix_function_type( &::CEGUI::OgreRenderer::getProjectionMatrix )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return a const reference to the current view matrix.\n\
            ! return a const reference to the current projection matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::getTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OgreRenderer::*getTexture_function_type )( ::CEGUI::String const & ) const;
            
            OgreRenderer_exposer.def( 
                "getTexture"
                , getTexture_function_type(&::CEGUI::OgreRenderer::getTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OgreRenderer::getViewMatrix
        
            typedef ::Ogre::Matrix4 const & ( ::CEGUI::OgreRenderer::*getViewMatrix_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getViewMatrix"
                , getViewMatrix_function_type( &::CEGUI::OgreRenderer::getViewMatrix )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return a const reference to the current world matrix.\n\
            ! return a const reference to the current view matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::getWorldMatrix
        
            typedef ::Ogre::Matrix4 const & ( ::CEGUI::OgreRenderer::*getWorldMatrix_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getWorldMatrix"
                , getWorldMatrix_function_type( &::CEGUI::OgreRenderer::getWorldMatrix )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Set the current projection matrix to the given matrix.\n\
            ! return a const reference to the current world matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::getWorldViewProjMatrix
        
            typedef ::Ogre::Matrix4 const & ( ::CEGUI::OgreRenderer::*getWorldViewProjMatrix_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "getWorldViewProjMatrix"
                , getWorldViewProjMatrix_function_type( &::CEGUI::OgreRenderer::getWorldViewProjMatrix )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return a const reference to the final transformation matrix that\n\
                    should be used when transforming geometry.\n\
            \n\
                \note\n\
                    The projection used when building this matrix is correctly adjusted\n\
                    according to whether the current Ogre.RenderTarget requires textures\n\
                    to be flipped (i.e it does the right thing for both D3D and OpenGL).\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::initialiseRenderStateSettings
        
            typedef void ( ::CEGUI::OgreRenderer::*initialiseRenderStateSettings_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "initialiseRenderStateSettings"
                , initialiseRenderStateSettings_function_type( &::CEGUI::OgreRenderer::initialiseRenderStateSettings )
                , "*!\n\
                \n\
                    Sets all the required render states needed for CEGUI rendering.\n\
            \n\
                    This is a low-level function intended for certain advanced concepts; in\n\
                    general it will not be required to call this function directly, since it\n\
                    is called automatically by the system when rendering is done.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::initialiseShaders
        
            typedef void ( OgreRenderer_wrapper::*initialiseShaders_function_type )(  ) ;
            
            OgreRenderer_exposer.def( 
                "initialiseShaders"
                , initialiseShaders_function_type( &OgreRenderer_wrapper::initialiseShaders )
                , "! common parts of constructor\n\
            ! helper that creates and sets up shaders\n" );
        
        }
        { //::CEGUI::OgreRenderer::isFrameControlExecutionEnabled
        
            typedef bool ( ::CEGUI::OgreRenderer::*isFrameControlExecutionEnabled_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "isFrameControlExecutionEnabled"
                , isFrameControlExecutionEnabled_function_type( &::CEGUI::OgreRenderer::isFrameControlExecutionEnabled )
                , "*!\n\
                \n\
                    Returns whether rendering done by CEGUI will be wrapped with calls to\n\
                    Ogre.RenderSystem._beginFrame and Ogre.RenderSystem._endFrame.\n\
            \n\
                    This defaults to enabled and is required when using the default hook\n\
                    that automatically calls CEGUI.System.renderGUI via a frame listener.\n\
                    If you disable this setting, the automated rendering will also be\n\
                    disabled, which is useful when you wish to perform your own calls to the\n\
                    CEGUI.System.renderGUI function (and is the sole purpose for this\n\
                    setting).\n\
            \n\
                @return\n\
                    - true if _beginFrame and _endFrame will be called.\n\
                    - false if _beginFrame and _endFrame will not be called (also means\n\
                      default renderGUI call will not be made).\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::isRenderingEnabled
        
            typedef bool ( ::CEGUI::OgreRenderer::*isRenderingEnabled_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "isRenderingEnabled"
                , isRenderingEnabled_function_type( &::CEGUI::OgreRenderer::isRenderingEnabled )
                , "! return whether CEGUI rendering is enabled.\n" );
        
        }
        { //::CEGUI::OgreRenderer::isTextureDefined
        
            typedef bool ( ::CEGUI::OgreRenderer::*isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            typedef bool ( OgreRenderer_wrapper::*default_isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            
            OgreRenderer_exposer.def( 
                "isTextureDefined"
                , isTextureDefined_function_type(&::CEGUI::OgreRenderer::isTextureDefined)
                , default_isTextureDefined_function_type(&OgreRenderer_wrapper::default_isTextureDefined)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OgreRenderer::isUsingShaders
        
            typedef bool ( ::CEGUI::OgreRenderer::*isUsingShaders_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "isUsingShaders"
                , isUsingShaders_function_type( &::CEGUI::OgreRenderer::isUsingShaders )
                , "*!\n\
                \n\
                    Returns whether the OgreRenderer is currently set to use shaders when\n\
                    doing its rendering operations.\n\
            \n\
                @return\n\
                    - true if rendering is being done using shaders.\n\
                    - false if rendering is being done using the fixed function pipeline\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::logTextureCreation
        
            typedef void ( *logTextureCreation_function_type )( ::CEGUI::String const & );
            
            OgreRenderer_exposer.def( 
                "logTextureCreation"
                , logTextureCreation_function_type( &OgreRenderer_wrapper::logTextureCreation )
                , ( bp::arg("name") )
                , "! helper to throw exception if name is already used.\n\
            ! helper to safely log the creation of a named texture\n" );
        
        }
        { //::CEGUI::OgreRenderer::logTextureDestruction
        
            typedef void ( *logTextureDestruction_function_type )( ::CEGUI::String const & );
            
            OgreRenderer_exposer.def( 
                "logTextureDestruction"
                , logTextureDestruction_function_type( &OgreRenderer_wrapper::logTextureDestruction )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n\
            ! helper to safely log the destruction of a named texture\n" );
        
        }
        { //::CEGUI::OgreRenderer::setDefaultRootRenderTarget
        
            typedef void ( ::CEGUI::OgreRenderer::*setDefaultRootRenderTarget_function_type )( ::Ogre::RenderTarget & ) ;
            
            OgreRenderer_exposer.def( 
                "setDefaultRootRenderTarget"
                , setDefaultRootRenderTarget_function_type( &::CEGUI::OgreRenderer::setDefaultRootRenderTarget )
                , ( bp::arg("target") )
                , "*!\n\
                \n\
                    Sets the Ogre.RenderTarget that should be targetted by the default\n\
                    GUIContext.\n\
            \n\
                @param target\n\
                    Reference to the Ogre.RenderTarget object that is to be used as the\n\
                    target for output from the default GUIContext.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::setDisplaySize
        
            typedef void ( ::CEGUI::OgreRenderer::*setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            typedef void ( OgreRenderer_wrapper::*default_setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            
            OgreRenderer_exposer.def( 
                "setDisplaySize"
                , setDisplaySize_function_type(&::CEGUI::OgreRenderer::setDisplaySize)
                , default_setDisplaySize_function_type(&OgreRenderer_wrapper::default_setDisplaySize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OgreRenderer::setFrameControlExecutionEnabled
        
            typedef void ( ::CEGUI::OgreRenderer::*setFrameControlExecutionEnabled_function_type )( bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setFrameControlExecutionEnabled"
                , setFrameControlExecutionEnabled_function_type( &::CEGUI::OgreRenderer::setFrameControlExecutionEnabled )
                , ( bp::arg("enabled") )
                , "*!\n\
                \n\
                    Controls whether rendering done by CEGUI will be wrapped with calls to\n\
                    Ogre.RenderSystem._beginFrame and Ogre.RenderSystem._endFrame.\n\
            \n\
                    This defaults to enabled and is required when using the default hook\n\
                    that automatically calls CEGUI.System.renderGUI via a frame listener.\n\
                    If you disable this setting, the automated rendering will also be\n\
                    disabled, which is useful when you wish to perform your own calls to the\n\
                    CEGUI.System.renderGUI function (and is the sole purpose for this\n\
                    setting).\n\
            \n\
                @param enabled\n\
                    - true if _beginFrame and _endFrame should be called.\n\
                    - false if _beginFrame and _endFrame should not be called (also disables\n\
                      default renderGUI call).\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::setProjectionMatrix
        
            typedef void ( ::CEGUI::OgreRenderer::*setProjectionMatrix_function_type )( ::Ogre::Matrix4 const & ) ;
            
            OgreRenderer_exposer.def( 
                "setProjectionMatrix"
                , setProjectionMatrix_function_type( &::CEGUI::OgreRenderer::setProjectionMatrix )
                , ( bp::arg("m") )
                , "! Set the current view matrix to the given matrix.\n\
            ! Set the current projection matrix to the given matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::setRenderingEnabled
        
            typedef void ( ::CEGUI::OgreRenderer::*setRenderingEnabled_function_type )( bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setRenderingEnabled"
                , setRenderingEnabled_function_type( &::CEGUI::OgreRenderer::setRenderingEnabled )
                , ( bp::arg("enabled") )
                , "! set whether CEGUI rendering will occur\n" );
        
        }
        { //::CEGUI::OgreRenderer::setUsingShaders
        
            typedef void ( ::CEGUI::OgreRenderer::*setUsingShaders_function_type )( bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setUsingShaders"
                , setUsingShaders_function_type( &::CEGUI::OgreRenderer::setUsingShaders )
                , ( bp::arg("use_shaders") )
                , "*!\n\
                \n\
                    Set whether the OgreRenderer shound use shaders when performing its\n\
                    rendering operations.\n\
            \n\
                @param use_shaders\n\
                    - true if rendering shaders should be used to perform rendering.\n\
                    - false if the fixed function pipeline should be used to perform\n\
                      rendering.\n\
            \n\
                \note\n\
                    When compiled against Ogre 1.8 or later, shaders will automatically\n\
                    be enabled if the render sytem does not support the fixed function\n\
                    pipeline (such as with Direct3D 11). If you are compiling against\n\
                    earlier releases of Ogre, you must explicity enable the use of\n\
                    shaders by calling this function - if you are unsure what you'll be\n\
                    compiling against, it is safe to call this function anyway.\n\
                *\n" );
        
        }
        { //::CEGUI::OgreRenderer::setViewMatrix
        
            typedef void ( ::CEGUI::OgreRenderer::*setViewMatrix_function_type )( ::Ogre::Matrix4 const & ) ;
            
            OgreRenderer_exposer.def( 
                "setViewMatrix"
                , setViewMatrix_function_type( &::CEGUI::OgreRenderer::setViewMatrix )
                , ( bp::arg("m") )
                , "! Set the current world matrix to the given matrix.\n\
            ! Set the current view matrix to the given matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::setWorldMatrix
        
            typedef void ( ::CEGUI::OgreRenderer::*setWorldMatrix_function_type )( ::Ogre::Matrix4 const & ) ;
            
            OgreRenderer_exposer.def( 
                "setWorldMatrix"
                , setWorldMatrix_function_type( &::CEGUI::OgreRenderer::setWorldMatrix )
                , ( bp::arg("m") )
                , "! Set the current world matrix to the given matrix.\n" );
        
        }
        { //::CEGUI::OgreRenderer::setupRenderingBlendMode
        
            typedef void ( ::CEGUI::OgreRenderer::*setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            
            OgreRenderer_exposer.def( 
                "setupRenderingBlendMode"
                , setupRenderingBlendMode_function_type( &::CEGUI::OgreRenderer::setupRenderingBlendMode )
                , ( bp::arg("mode"), bp::arg("force")=(bool const)(false) )
                , "! set the render states for the specified BlendMode.\n" );
        
        }
        { //::CEGUI::OgreRenderer::throwIfNameExists
        
            typedef void ( OgreRenderer_wrapper::*throwIfNameExists_function_type )( ::CEGUI::String const & ) const;
            
            OgreRenderer_exposer.def( 
                "throwIfNameExists"
                , throwIfNameExists_function_type( &OgreRenderer_wrapper::throwIfNameExists )
                , ( bp::arg("name") )
                , "! checks Ogre initialisation.  throws exceptions if an issue is detected.\n\
            ! helper to throw exception if name is already used.\n" );
        
        }
        { //::CEGUI::OgreRenderer::updateShaderParams
        
            typedef void ( ::CEGUI::OgreRenderer::*updateShaderParams_function_type )(  ) const;
            
            OgreRenderer_exposer.def( 
                "updateShaderParams"
                , updateShaderParams_function_type( &::CEGUI::OgreRenderer::updateShaderParams )
                , "*!\n\
                \n\
                    Updates the shader constant parameters (i.e. uniforms).\n\
            \n\
                    You do not normally need to call this function directly. Some may need\n\
                    to call this function if you're doing non-standard or advanced things.\n\
                *\n" );
        
        }
        OgreRenderer_exposer.staticmethod( "bootstrapSystem" );
        OgreRenderer_exposer.staticmethod( "create" );
        OgreRenderer_exposer.staticmethod( "createOgreImageCodec" );
        OgreRenderer_exposer.staticmethod( "createOgreResourceProvider" );
        OgreRenderer_exposer.staticmethod( "destroy" );
        OgreRenderer_exposer.staticmethod( "destroyOgreImageCodec" );
        OgreRenderer_exposer.staticmethod( "destroyOgreResourceProvider" );
        OgreRenderer_exposer.staticmethod( "destroySystem" );
        OgreRenderer_exposer.staticmethod( "logTextureCreation" );
        OgreRenderer_exposer.staticmethod( "logTextureDestruction" );
    }

}
