# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'browser/search_engines/prepopulated_engines.gyp:prepopulated_engines',
        'browser_ui',
        'cert_logger_proto',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common_net',
        'feedback_proto',
        'in_memory_url_index_cache_proto',
        'probe_message_proto',
        'safe_browsing_proto',
        'safe_browsing_report_proto',
        'suggestions_proto',
        '../components/component_strings.gyp:component_strings',
        '../components/components.gyp:autofill_core_browser',
        '../components/components.gyp:cloud_devices',
        '../components/components.gyp:encryptor',
        '../components/components.gyp:navigation_metrics',
        '../components/components.gyp:password_manager_core_common',
        '../components/components.gyp:password_manager_core_browser',
        '../components/components.gyp:policy_component',
        '../components/components.gyp:precache_core',
        '../components/components.gyp:signin_core',
        '../components/components.gyp:startup_metric_utils',
        '../components/components.gyp:sync_driver',
        '../components/components.gyp:translate_core_browser',
        '../components/components.gyp:translate_core_common',
        '../components/components.gyp:user_prefs',
        # This depends directly on the variations target, rather than just
        # transitively via the common target because the proto sources need to
        # be generated before code in this target can start building.
        '../components/components.gyp:variations',
        '../components/components.gyp:webdata_common',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../google_apis/gcm/gcm.gyp:gcm',
        '../google_apis/google_apis.gyp:google_apis',
        '../jingle/jingle.gyp:notifier',
        '../media/cast/transport/cast_transport.gyp:cast_transport',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/widevine/cdm/widevine_cdm.gyp:widevine_cdm_version_h',
        '../third_party/zlib/google/zip.gyp:zip',
        '../third_party/zlib/zlib.gyp:minizip',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/events/events.gyp:events_base',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/shell_dialogs/shell_dialogs.gyp:shell_dialogs',
        '../ui/ui.gyp:ui',
        '../webkit/common/user_agent/webkit_user_agent.gyp:user_agent',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed by chrome_content_renderer_client.cc. &
        # plugin_info_message_filter.cc.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'export_dependent_settings': [
        '../components/components.gyp:autofill_core_browser',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
      ],
      'sources': [
        # All .cc, .h, .m, and .mm files under browser except for:
        # * tests and mocks.
        # * code below browser/chromeos
        # * code below browser/extensions
        'browser/about_flags.cc',
        'browser/about_flags.h',
        'browser/accessibility/accessibility_extension_api_constants.cc',
        'browser/accessibility/accessibility_extension_api_constants.h',
        'browser/accessibility/accessibility_events.cc',
        'browser/accessibility/accessibility_events.h',
        'browser/accessibility/invert_bubble_prefs.cc',
        'browser/accessibility/invert_bubble_prefs.h',
        'browser/android/accessibility_util.cc',
        'browser/android/accessibility_util.h',
        'browser/android/activity_type_id_list.h',
        'browser/android/activity_type_ids.cc',
        'browser/android/activity_type_ids.h',
        'browser/android/banners/app_banner_manager.cc',
        'browser/android/banners/app_banner_manager.h',
        'browser/android/banners/app_banner_settings_helper.cc',
        'browser/android/banners/app_banner_settings_helper.h',
        'browser/android/bookmarks/managed_bookmarks_shim.cc',
        'browser/android/bookmarks/managed_bookmarks_shim.h',
        'browser/android/bookmarks/bookmarks_bridge.cc',
        'browser/android/bookmarks/bookmarks_bridge.h',
        'browser/android/bookmarks/partner_bookmarks_shim.cc',
        'browser/android/bookmarks/partner_bookmarks_shim.h',
        'browser/android/chrome_jni_registrar.cc',
        'browser/android/chrome_jni_registrar.h',
        'browser/android/chrome_startup_flags.cc',
        'browser/android/chrome_startup_flags.h',
        'browser/android/chrome_web_contents_delegate_android.cc',
        'browser/android/chrome_web_contents_delegate_android.h',
        'browser/android/chromium_application.cc',
        'browser/android/chromium_application.h',
        'browser/android/content_view_util.cc',
        'browser/android/content_view_util.h',
        'browser/android/dev_tools_server.cc',
        'browser/android/dev_tools_server.h',
        'browser/android/favicon_helper.cc',
        'browser/android/favicon_helper.h',
        'browser/android/field_trial_helper.cc',
        'browser/android/field_trial_helper.h',
        'browser/android/foreign_session_helper.cc',
        'browser/android/foreign_session_helper.h',
        'browser/android/meta_tag_observer.cc',
        'browser/android/meta_tag_observer.h',
        'browser/android/new_tab_page_prefs.cc',
        'browser/android/new_tab_page_prefs.h',
        'browser/android/google_location_settings_helper.h',
        'browser/android/intent_helper.cc',
        'browser/android/intent_helper.h',
        'browser/android/intercept_download_resource_throttle.cc',
        'browser/android/intercept_download_resource_throttle.h',
        'browser/android/most_visited_sites.cc',
        'browser/android/most_visited_sites.h',
        'browser/android/omnibox/omnibox_prerender.cc',
        'browser/android/omnibox/omnibox_prerender.h',
        'browser/android/password_authentication_manager.cc',
        'browser/android/password_authentication_manager.h',
        'browser/android/password_ui_view_android.cc',
        'browser/android/password_ui_view_android.h',
        'browser/android/prerender_condition_platform.cc',
        'browser/android/prerender_condition_platform.h',
        'browser/android/profiles/profile_downloader_android.cc',
        'browser/android/profiles/profile_downloader_android.h',
        'browser/android/provider/blocking_ui_thread_async_request.cc',
        'browser/android/provider/blocking_ui_thread_async_request.h',
        'browser/android/provider/bookmark_model_observer_task.cc',
        'browser/android/provider/bookmark_model_observer_task.h',
        'browser/android/provider/chrome_browser_provider.cc',
        'browser/android/provider/chrome_browser_provider.h',
        'browser/android/provider/run_on_ui_thread_blocking.h',
        'browser/android/recently_closed_tabs_bridge.cc',
        'browser/android/recently_closed_tabs_bridge.h',
        'browser/android/resource_mapper.cc',
        'browser/android/resource_mapper.h',
        'browser/android/resource_id.h',
        'browser/android/shortcut_helper.cc',
        'browser/android/shortcut_helper.h',
        'browser/android/signin/account_management_screen_helper.cc',
        'browser/android/signin/account_management_screen_helper.h',
        'browser/android/signin/signin_manager_android.cc',
        'browser/android/signin/signin_manager_android.h',
        'browser/android/tab_android.cc',
        'browser/android/tab_android.h',
        'browser/android/uma_bridge.cc',
        'browser/android/uma_bridge.h',
        'browser/android/uma_utils.cc',
        'browser/android/uma_utils.h',
        'browser/android/url_utilities.cc',
        'browser/android/url_utilities.h',
        'browser/android/voice_search_tab_helper.cc',
        'browser/android/voice_search_tab_helper.h',
        'browser/android/webapps/single_tab_mode_tab_helper.cc',
        'browser/android/webapps/single_tab_mode_tab_helper.h',
        'browser/app_controller_mac.h',
        'browser/app_controller_mac.mm',
        'browser/app_icon_win.cc',
        'browser/app_icon_win.h',
        'browser/app_mode/app_mode_utils.cc',
        'browser/app_mode/app_mode_utils.h',
        'browser/autocomplete/autocomplete_classifier.cc',
        'browser/autocomplete/autocomplete_classifier.h',
        'browser/autocomplete/autocomplete_classifier_factory.cc',
        'browser/autocomplete/autocomplete_classifier_factory.h',
        'browser/autocomplete/autocomplete_controller.cc',
        'browser/autocomplete/autocomplete_controller.h',
        'browser/autocomplete/autocomplete_controller_delegate.h',
        'browser/autocomplete/autocomplete_input.cc',
        'browser/autocomplete/autocomplete_input.h',
        'browser/autocomplete/autocomplete_match.cc',
        'browser/autocomplete/autocomplete_match.h',
        'browser/autocomplete/autocomplete_provider.cc',
        'browser/autocomplete/autocomplete_provider.h',
        'browser/autocomplete/autocomplete_provider_listener.h',
        'browser/autocomplete/autocomplete_result.cc',
        'browser/autocomplete/autocomplete_result.h',
        'browser/autocomplete/base_search_provider.cc',
        'browser/autocomplete/base_search_provider.h',
        'browser/autocomplete/bookmark_provider.cc',
        'browser/autocomplete/bookmark_provider.h',
        'browser/autocomplete/builtin_provider.cc',
        'browser/autocomplete/builtin_provider.h',
        'browser/autocomplete/contact_provider_chromeos.cc',
        'browser/autocomplete/contact_provider_chromeos.h',
        'browser/autocomplete/extension_app_provider.cc',
        'browser/autocomplete/extension_app_provider.h',
        'browser/autocomplete/history_provider.cc',
        'browser/autocomplete/history_provider.h',
        'browser/autocomplete/history_provider_util.cc',
        'browser/autocomplete/history_provider_util.h',
        'browser/autocomplete/history_quick_provider.cc',
        'browser/autocomplete/history_quick_provider.h',
        'browser/autocomplete/history_url_provider.cc',
        'browser/autocomplete/history_url_provider.h',
        'browser/autocomplete/keyword_provider.cc',
        'browser/autocomplete/keyword_provider.h',
        'browser/autocomplete/search_provider.cc',
        'browser/autocomplete/search_provider.h',
        'browser/autocomplete/shortcuts_provider.cc',
        'browser/autocomplete/shortcuts_provider.h',
        'browser/autocomplete/url_prefix.cc',
        'browser/autocomplete/url_prefix.h',
        'browser/autocomplete/zero_suggest_provider.cc',
        'browser/autocomplete/zero_suggest_provider.h',
        'browser/autofill/android/personal_data_manager_android.cc',
        'browser/autofill/android/personal_data_manager_android.h',
        'browser/autofill/autofill_cc_infobar_delegate.cc',
        'browser/autofill/autofill_cc_infobar_delegate.h',
        'browser/autofill/personal_data_manager_factory.cc',
        'browser/autofill/personal_data_manager_factory.h',
        'browser/autofill/validation_rules_storage_factory.cc',
        'browser/autofill/validation_rules_storage_factory.h',
        'browser/auto_launch_trial.cc',
        'browser/auto_launch_trial.h',
        'browser/automation/automation_browser_tracker.cc',
        'browser/automation/automation_browser_tracker.h',
        'browser/automation/automation_event_observers.cc',
        'browser/automation/automation_event_observers.h',
        'browser/automation/automation_event_observers_chromeos.cc',
        'browser/automation/automation_event_queue.cc',
        'browser/automation/automation_event_queue.h',
        'browser/automation/automation_provider.cc',
        'browser/automation/automation_provider.h',
        'browser/automation/automation_provider_json.cc',
        'browser/automation/automation_provider_json.h',
        'browser/automation/automation_provider_list.cc',
        'browser/automation/automation_provider_list.h',
        'browser/automation/automation_provider_list_generic.cc',
        'browser/automation/automation_provider_list_mac.mm',
        'browser/automation/automation_provider_observers.cc',
        'browser/automation/automation_provider_observers.h',
        'browser/automation/automation_provider_observers_chromeos.cc',
        'browser/automation/automation_resource_tracker.cc',
        'browser/automation/automation_resource_tracker.h',
        'browser/automation/automation_tab_tracker.cc',
        'browser/automation/automation_tab_tracker.h',
        'browser/automation/automation_util.cc',
        'browser/automation/automation_util.h',
        'browser/automation/automation_window_tracker.cc',
        'browser/automation/automation_window_tracker.h',
        'browser/automation/testing_automation_provider.cc',
        'browser/automation/testing_automation_provider.h',
        'browser/automation/testing_automation_provider_aura.cc',
        'browser/automation/testing_automation_provider_chromeos.cc',
        'browser/automation/testing_automation_provider_gtk.cc',
        'browser/automation/testing_automation_provider_mac.mm',
        'browser/automation/testing_automation_provider_views.cc',
        'browser/automation/testing_automation_provider_win.cc',
        'browser/background/background_application_list_model.cc',
        'browser/background/background_application_list_model.h',
        'browser/background/background_contents_service.cc',
        'browser/background/background_contents_service.h',
        'browser/background/background_contents_service_factory.cc',
        'browser/background/background_contents_service_factory.h',
        'browser/background/background_mode_manager.cc',
        'browser/background/background_mode_manager.h',
        'browser/background/background_mode_manager_chromeos.cc',
        'browser/background/background_mode_manager_aura.cc',
        'browser/background/background_mode_manager_gtk.cc',
        'browser/background/background_mode_manager_mac.mm',
        'browser/background/background_mode_manager_win.cc',
        'browser/bitmap_fetcher.cc',
        'browser/bitmap_fetcher.h',
        'browser/bitmap_fetcher_delegate.h',
        'browser/bookmarks/base_bookmark_model_observer.cc',
        'browser/bookmarks/base_bookmark_model_observer.h',
        'browser/bookmarks/bookmark_codec.cc',
        'browser/bookmarks/bookmark_codec.h',
        'browser/bookmarks/bookmark_expanded_state_tracker.cc',
        'browser/bookmarks/bookmark_expanded_state_tracker.h',
        'browser/bookmarks/bookmark_html_writer.cc',
        'browser/bookmarks/bookmark_html_writer.h',
        'browser/bookmarks/bookmark_index.cc',
        'browser/bookmarks/bookmark_index.h',
        'browser/bookmarks/bookmark_model.cc',
        'browser/bookmarks/bookmark_model.h',
        'browser/bookmarks/bookmark_model_factory.cc',
        'browser/bookmarks/bookmark_model_factory.h',
        'browser/bookmarks/bookmark_model_observer.h',
        'browser/bookmarks/bookmark_node_data.cc',
        'browser/bookmarks/bookmark_node_data.h',
        'browser/bookmarks/bookmark_node_data_mac.cc',
        'browser/bookmarks/bookmark_node_data_views.cc',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.mm',
        'browser/bookmarks/bookmark_prompt_prefs.cc',
        'browser/bookmarks/bookmark_prompt_prefs.h',
        'browser/bookmarks/bookmark_service.cc',
        'browser/bookmarks/bookmark_service.h',
        'browser/bookmarks/bookmark_stats.cc',
        'browser/bookmarks/bookmark_stats.h',
        'browser/bookmarks/bookmark_storage.cc',
        'browser/bookmarks/bookmark_storage.h',
        'browser/bookmarks/bookmark_tag_model.cc',
        'browser/bookmarks/bookmark_tag_model.h',
        'browser/bookmarks/bookmark_tag_model_observer.h',
        'browser/bookmarks/bookmark_title_match.cc',
        'browser/bookmarks/bookmark_title_match.h',
        'browser/bookmarks/bookmark_utils.cc',
        'browser/bookmarks/bookmark_utils.h',
        'browser/bookmarks/enhanced_bookmarks_features.cc',
        'browser/bookmarks/enhanced_bookmarks_features.h',
        'browser/browser_about_handler.cc',
        'browser/browser_about_handler.h',
        'browser/browser_process.cc',
        'browser/browser_process.h',
        'browser/browser_process_impl.cc',
        'browser/browser_process_impl.h',
        'browser/browser_process_platform_part.h',
        'browser/browser_process_platform_part_android.cc',
        'browser/browser_process_platform_part_android.h',
        'browser/browser_process_platform_part_aurawin.cc',
        'browser/browser_process_platform_part_aurawin.h',
        'browser/browser_process_platform_part_base.cc',
        'browser/browser_process_platform_part_base.h',
        'browser/browser_process_platform_part_chromeos.cc',
        'browser/browser_process_platform_part_chromeos.h',
        'browser/browser_process_platform_part_mac.h',
        'browser/browser_process_platform_part_mac.mm',
        'browser/browser_shutdown.cc',
        'browser/browser_shutdown.h',
        'browser/browser_util_win.cc',
        'browser/browser_util_win.h',
        'browser/browsing_data/browsing_data_appcache_helper.cc',
        'browser/browsing_data/browsing_data_appcache_helper.h',
        'browser/browsing_data/browsing_data_database_helper.cc',
        'browser/browsing_data/browsing_data_database_helper.h',
        'browser/browsing_data/browsing_data_file_system_helper.cc',
        'browser/browsing_data/browsing_data_file_system_helper.h',
        'browser/browsing_data/browsing_data_flash_lso_helper.cc',
        'browser/browsing_data/browsing_data_flash_lso_helper.h',
        'browser/browsing_data/browsing_data_helper.cc',
        'browser/browsing_data/browsing_data_helper.h',
        'browser/browsing_data/browsing_data_indexed_db_helper.cc',
        'browser/browsing_data/browsing_data_indexed_db_helper.h',
        'browser/browsing_data/browsing_data_local_storage_helper.cc',
        'browser/browsing_data/browsing_data_local_storage_helper.h',
        'browser/browsing_data/local_data_container.cc',
        'browser/browsing_data/local_data_container.h',
        'browser/browsing_data/browsing_data_quota_helper.cc',
        'browser/browsing_data/browsing_data_quota_helper.h',
        'browser/browsing_data/browsing_data_quota_helper_impl.cc',
        'browser/browsing_data/browsing_data_quota_helper_impl.h',
        'browser/browsing_data/browsing_data_remover.cc',
        'browser/browsing_data/browsing_data_remover.h',
        'browser/browsing_data/browsing_data_server_bound_cert_helper.cc',
        'browser/browsing_data/browsing_data_server_bound_cert_helper.h',
        'browser/browsing_data/browsing_data_cookie_helper.cc',
        'browser/browsing_data/browsing_data_cookie_helper.h',
        'browser/browsing_data/cookies_tree_model.cc',
        'browser/browsing_data/cookies_tree_model.h',
        'browser/feedback/feedback_data.cc',
        'browser/feedback/feedback_data.h',
        'browser/feedback/feedback_profile_observer.cc',
        'browser/feedback/feedback_profile_observer.h',
        'browser/feedback/feedback_report.cc',
        'browser/feedback/feedback_report.h',
        'browser/feedback/feedback_util.cc',
        'browser/feedback/feedback_util.h',
        'browser/feedback/feedback_uploader.cc',
        'browser/feedback/feedback_uploader.h',
        'browser/feedback/feedback_uploader_delegate.cc',
        'browser/feedback/feedback_uploader_delegate.h',
        'browser/feedback/feedback_uploader_factory.cc',
        'browser/feedback/feedback_uploader_factory.h',
        'browser/feedback/system_logs/about_system_logs_fetcher.cc',
        'browser/feedback/system_logs/about_system_logs_fetcher.h',
        'browser/feedback/system_logs/scrubbed_system_logs_fetcher.cc',
        'browser/feedback/system_logs/scrubbed_system_logs_fetcher.h',
        'browser/feedback/system_logs/system_logs_fetcher_base.cc',
        'browser/feedback/system_logs/system_logs_fetcher_base.h',
        'browser/feedback/system_logs/log_sources/chrome_internal_log_source.cc',
        'browser/feedback/system_logs/log_sources/chrome_internal_log_source.h',
        'browser/feedback/system_logs/log_sources/memory_details_log_source.cc',
        'browser/feedback/system_logs/log_sources/memory_details_log_source.h',
        'browser/feedback/tracing_manager.cc',
        'browser/feedback/tracing_manager.h',
        'browser/captive_portal/captive_portal_detector.cc',
        'browser/captive_portal/captive_portal_detector.h',
        'browser/captive_portal/captive_portal_login_detector.cc',
        'browser/captive_portal/captive_portal_login_detector.h',
        'browser/captive_portal/captive_portal_service.cc',
        'browser/captive_portal/captive_portal_service.h',
        'browser/captive_portal/captive_portal_service_factory.cc',
        'browser/captive_portal/captive_portal_service_factory.h',
        'browser/captive_portal/captive_portal_tab_helper.cc',
        'browser/captive_portal/captive_portal_tab_helper.h',
        'browser/captive_portal/captive_portal_tab_reloader.cc',
        'browser/captive_portal/captive_portal_tab_reloader.h',
        'browser/certificate_manager_model.cc',
        'browser/certificate_manager_model.h',
        'browser/certificate_viewer.cc',
        'browser/certificate_viewer.h',
        'browser/character_encoding.cc',
        'browser/character_encoding.h',
        'browser/chrome_net_benchmarking_message_filter.cc',
        'browser/chrome_net_benchmarking_message_filter.h',
        'browser/chrome_browser_application_mac.h',
        'browser/chrome_browser_application_mac.mm',
        'browser/chrome_browser_field_trials.cc',
        'browser/chrome_browser_field_trials.h',
        'browser/chrome_browser_field_trials_desktop.cc',
        'browser/chrome_browser_field_trials_desktop.h',
        'browser/chrome_browser_field_trials_mobile.cc',
        'browser/chrome_browser_field_trials_mobile.h',
        'browser/chrome_browser_main.cc',
        'browser/chrome_browser_main.h',
        'browser/chrome_browser_main_android.cc',
        'browser/chrome_browser_main_android.h',
        'browser/chrome_browser_main_extra_parts.h',
        'browser/chrome_browser_main_extra_parts_x11.cc',
        'browser/chrome_browser_main_extra_parts_x11.h',
        'browser/chrome_browser_main_linux.cc',
        'browser/chrome_browser_main_linux.h',
        'browser/chrome_browser_main_mac.h',
        'browser/chrome_browser_main_mac.mm',
        'browser/chrome_browser_main_posix.cc',
        'browser/chrome_browser_main_posix.h',
        'browser/chrome_browser_main_win.cc',
        'browser/chrome_browser_main_win.h',
        'browser/chrome_content_browser_client.cc',
        'browser/chrome_content_browser_client.h',
        'browser/chrome_elf_init_win.cc',
        'browser/chrome_elf_init_win.h',
        'browser/chrome_notification_types.h',
        'browser/chrome_page_zoom.cc',
        'browser/chrome_page_zoom.h',
        'browser/chrome_page_zoom_constants.cc',
        'browser/chrome_page_zoom_constants.h',
        'browser/chrome_process_singleton.cc',
        'browser/chrome_process_singleton.h',
        'browser/chrome_quota_permission_context.cc',
        'browser/chrome_quota_permission_context.h',
        'browser/command_observer.h',
        'browser/command_updater.cc',
        'browser/command_updater.h',
        'browser/command_updater_delegate.h',
        'browser/common/cancelable_request.cc',
        'browser/common/cancelable_request.h',
        'browser/component_updater/background_downloader_win.cc',
        'browser/component_updater/background_downloader_win.h',
        'browser/component_updater/component_patcher.cc',
        'browser/component_updater/component_patcher.h',
        'browser/component_updater/component_patcher_operation.cc',
        'browser/component_updater/component_patcher_operation.h',
        'browser/component_updater/component_patcher_win.cc',
        'browser/component_updater/component_patcher_win.h',
        'browser/component_updater/component_updater_configurator.cc',
        'browser/component_updater/component_updater_configurator.h',
        'browser/component_updater/component_unpacker.cc',
        'browser/component_updater/component_unpacker.h',
        'browser/component_updater/component_updater_ping_manager.cc',
        'browser/component_updater/component_updater_ping_manager.h',
        'browser/component_updater/component_updater_service.cc',
        'browser/component_updater/component_updater_service.h',
        'browser/component_updater/component_updater_utils.cc',
        'browser/component_updater/component_updater_utils.h',
        'browser/component_updater/crx_update_item.h',
        'browser/component_updater/crx_downloader.cc',
        'browser/component_updater/crx_downloader.h',
        'browser/component_updater/default_component_installer.cc',
        'browser/component_updater/default_component_installer.h',
        'browser/component_updater/flash_component_installer.h',
        'browser/component_updater/pepper_flash_component_installer.cc',
        'browser/component_updater/pnacl/pnacl_component_installer.cc',
        'browser/component_updater/pnacl/pnacl_component_installer.h',
        'browser/component_updater/pnacl/pnacl_profile_observer.cc',
        'browser/component_updater/pnacl/pnacl_profile_observer.h',
        'browser/component_updater/ppapi_utils.cc',
        'browser/component_updater/ppapi_utils.h',
        'browser/component_updater/recovery_component_installer.cc',
        'browser/component_updater/recovery_component_installer.h',
        'browser/component_updater/swiftshader_component_installer.cc',
        'browser/component_updater/swiftshader_component_installer.h',
        'browser/component_updater/update_checker.cc',
        'browser/component_updater/update_checker.h',
        'browser/component_updater/update_response.cc',
        'browser/component_updater/update_response.h',
        'browser/component_updater/url_fetcher_downloader.cc',
        'browser/component_updater/url_fetcher_downloader.h',
        'browser/component_updater/widevine_cdm_component_installer.cc',
        'browser/component_updater/widevine_cdm_component_installer.h',
        'browser/content_settings/content_settings_default_provider.cc',
        'browser/content_settings/content_settings_default_provider.h',
        'browser/content_settings/content_settings_details.cc',
        'browser/content_settings/content_settings_details.h',
        'browser/content_settings/content_settings_custom_extension_provider.cc',
        'browser/content_settings/content_settings_custom_extension_provider.h',
        'browser/content_settings/content_settings_observable_provider.cc',
        'browser/content_settings/content_settings_observable_provider.h',
        'browser/content_settings/content_settings_observer.h',
        'browser/content_settings/content_settings_origin_identifier_value_map.cc',
        'browser/content_settings/content_settings_origin_identifier_value_map.h',
        'browser/content_settings/content_settings_internal_extension_provider.cc',
        'browser/content_settings/content_settings_internal_extension_provider.h',
        'browser/content_settings/content_settings_policy_provider.cc',
        'browser/content_settings/content_settings_policy_provider.h',
        'browser/content_settings/content_settings_pref_provider.cc',
        'browser/content_settings/content_settings_pref_provider.h',
        'browser/content_settings/content_settings_provider.h',
        'browser/content_settings/content_settings_rule.cc',
        'browser/content_settings/content_settings_rule.h',
        'browser/content_settings/content_settings_usages_state.cc',
        'browser/content_settings/content_settings_usages_state.h',
        'browser/content_settings/content_settings_utils.cc',
        'browser/content_settings/content_settings_utils.h',
        'browser/content_settings/cookie_settings.cc',
        'browser/content_settings/cookie_settings.h',
        'browser/content_settings/host_content_settings_map.cc',
        'browser/content_settings/host_content_settings_map.h',
        'browser/content_settings/local_shared_objects_container.cc',
        'browser/content_settings/local_shared_objects_container.h',
        'browser/content_settings/permission_queue_controller.cc',
        'browser/content_settings/permission_queue_controller.h',
        'browser/content_settings/permission_request_id.cc',
        'browser/content_settings/permission_request_id.h',
        'browser/content_settings/tab_specific_content_settings.cc',
        'browser/content_settings/tab_specific_content_settings.h',
        'browser/crash_upload_list.cc',
        'browser/crash_upload_list.h',
        'browser/crash_upload_list_win.cc',
        'browser/crash_upload_list_win.h',
        'browser/custom_handlers/protocol_handler_registry.cc',
        'browser/custom_handlers/protocol_handler_registry.h',
        'browser/custom_handlers/protocol_handler_registry_factory.cc',
        'browser/custom_handlers/protocol_handler_registry_factory.h',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.cc',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.h',
        'browser/custom_handlers/register_protocol_handler_permission_request.cc',
        'browser/custom_handlers/register_protocol_handler_permission_request.h',
        'browser/custom_home_pages_table_model.cc',
        'browser/custom_home_pages_table_model.h',
        'browser/defaults.cc',
        'browser/defaults.h',
        'browser/diagnostics/diagnostics_controller.cc',
        'browser/diagnostics/diagnostics_controller.h',
        'browser/diagnostics/diagnostics_metrics.cc',
        'browser/diagnostics/diagnostics_metrics.h',
        'browser/diagnostics/diagnostics_model.cc',
        'browser/diagnostics/diagnostics_model.h',
        'browser/diagnostics/diagnostics_test.cc',
        'browser/diagnostics/diagnostics_test.h',
        'browser/diagnostics/diagnostics_writer.cc',
        'browser/diagnostics/diagnostics_writer.h',
        'browser/diagnostics/recon_diagnostics.cc',
        'browser/diagnostics/recon_diagnostics.h',
        'browser/diagnostics/sqlite_diagnostics.cc',
        'browser/diagnostics/sqlite_diagnostics.h',
        'browser/dom_distiller/dom_distiller_service_factory.cc',
        'browser/dom_distiller/dom_distiller_service_factory.h',
        'browser/download/all_download_item_notifier.cc',
        'browser/download/all_download_item_notifier.h',
        'browser/download/chrome_download_manager_delegate.cc',
        'browser/download/chrome_download_manager_delegate.h',
        'browser/download/download_completion_blocker.cc',
        'browser/download/download_completion_blocker.h',
        'browser/download/download_crx_util.cc',
        'browser/download/download_crx_util.h',
        'browser/download/download_crx_util_android.cc',
        'browser/download/download_danger_prompt.cc',
        'browser/download/download_danger_prompt.h',
        'browser/download/download_extensions.cc',
        'browser/download/download_extensions.h',
        'browser/download/download_file_picker.cc',
        'browser/download/download_file_picker.h',
        'browser/download/download_history.cc',
        'browser/download/download_history.h',
        'browser/download/download_item_model.cc',
        'browser/download/download_item_model.h',
        'browser/download/download_path_reservation_tracker.cc',
        'browser/download/download_path_reservation_tracker.h',
        'browser/download/download_prefs.cc',
        'browser/download/download_prefs.h',
        'browser/download/download_query.cc',
        'browser/download/download_query.h',
        'browser/download/download_request_infobar_delegate.cc',
        'browser/download/download_request_infobar_delegate.h',
        'browser/download/download_request_limiter.cc',
        'browser/download/download_request_limiter.h',
        'browser/download/download_resource_throttle.cc',
        'browser/download/download_resource_throttle.h',
        'browser/download/download_service.cc',
        'browser/download/download_service.h',
        'browser/download/download_service_factory.cc',
        'browser/download/download_service_factory.h',
        'browser/download/download_shelf.cc',
        'browser/download/download_shelf.h',
        'browser/download/download_shelf_context_menu.cc',
        'browser/download/download_shelf_context_menu.h',
        'browser/download/download_started_animation.h',
        'browser/download/download_stats.cc',
        'browser/download/download_stats.h',
        'browser/download/download_status_updater.cc',
        'browser/download/download_status_updater.h',
        'browser/download/download_status_updater_gtk.cc',
        'browser/download/download_status_updater_mac.mm',
        'browser/download/download_status_updater_win.cc',
        'browser/download/download_target_determiner.cc',
        'browser/download/download_target_determiner.h',
        'browser/download/download_target_determiner_delegate.h',
        'browser/download/download_target_info.h',
        'browser/download/download_ui_controller.cc',
        'browser/download/download_ui_controller.h',
        'browser/download/drag_download_item.h',
        'browser/download/drag_download_item_views.cc',
        'browser/download/save_package_file_picker.cc',
        'browser/download/save_package_file_picker.h',
        'browser/drive/drive_app_registry.cc',
        'browser/drive/drive_app_registry.h',
        'browser/drive/drive_api_service.cc',
        'browser/drive/drive_api_service.h',
        'browser/drive/drive_api_util.cc',
        'browser/drive/drive_api_util.h',
        'browser/drive/drive_notification_manager.cc',
        'browser/drive/drive_notification_manager.h',
        'browser/drive/drive_notification_manager_factory.cc',
        'browser/drive/drive_notification_manager_factory.h',
        'browser/drive/drive_notification_observer.h',
        'browser/drive/drive_service_interface.cc',
        'browser/drive/drive_service_interface.h',
        'browser/drive/drive_switches.cc',
        'browser/drive/drive_switches.h',
        'browser/drive/drive_uploader.cc',
        'browser/drive/drive_uploader.h',
        'browser/drive/event_logger.cc',
        'browser/drive/event_logger.h',
        'browser/drive/gdata_wapi_service.cc',
        'browser/drive/gdata_wapi_service.h',
        'browser/enumerate_modules_model_win.cc',
        'browser/enumerate_modules_model_win.h',
        'browser/extensions/signin/gaia_auth_extension_loader.cc',
        'browser/extensions/signin/gaia_auth_extension_loader.h',
        'browser/extensions/signin/scoped_gaia_auth_extension.cc',
        'browser/extensions/signin/scoped_gaia_auth_extension.h',
        'browser/extensions/token_cache/token_cache_service.cc',
        'browser/extensions/token_cache/token_cache_service.h',
        'browser/extensions/token_cache/token_cache_service_factory.cc',
        'browser/extensions/token_cache/token_cache_service_factory.h',
        'browser/external_protocol/external_protocol_handler.cc',
        'browser/external_protocol/external_protocol_handler.h',
        'browser/external_protocol/external_protocol_observer.cc',
        'browser/external_protocol/external_protocol_observer.h',
        'browser/favicon/favicon_changed_details.cc',
        'browser/favicon/favicon_changed_details.h',
        'browser/favicon/favicon_handler.cc',
        'browser/favicon/favicon_handler.h',
        'browser/favicon/favicon_handler_delegate.h',
        'browser/favicon/favicon_service.cc',
        'browser/favicon/favicon_service.h',
        'browser/favicon/favicon_service_factory.cc',
        'browser/favicon/favicon_service_factory.h',
        'browser/favicon/favicon_tab_helper.cc',
        'browser/favicon/favicon_tab_helper.h',
        'browser/favicon/favicon_util.cc',
        'browser/favicon/favicon_util.h',
        'browser/file_select_helper.cc',
        'browser/file_select_helper.h',
        'browser/first_run/first_run.cc',
        'browser/first_run/first_run.h',
        'browser/first_run/first_run_dialog.h',
        'browser/first_run/first_run_internal.h',
        'browser/first_run/first_run_internal_linux.cc',
        'browser/first_run/first_run_internal_mac.mm',
        'browser/first_run/first_run_internal_posix.cc',
        'browser/first_run/first_run_internal_win.cc',
        'browser/first_run/try_chrome_dialog_view.cc',
        'browser/first_run/try_chrome_dialog_view.h',
        'browser/first_run/upgrade_util.cc',
        'browser/first_run/upgrade_util.h',
        'browser/first_run/upgrade_util_linux.cc',
        'browser/first_run/upgrade_util_linux.h',
        'browser/first_run/upgrade_util_mac.cc',
        'browser/first_run/upgrade_util_win.cc',
        'browser/first_run/upgrade_util_win.h',
        'browser/flags_storage.h',
        'browser/fullscreen.h',
        'browser/fullscreen_aura.cc',
        'browser/fullscreen_chromeos.cc',
        'browser/fullscreen_gtk.cc',
        'browser/fullscreen_mac.mm',
        'browser/fullscreen_win.cc',
        'browser/geolocation/chrome_access_token_store.cc',
        'browser/geolocation/chrome_access_token_store.h',
        'browser/geolocation/chrome_geolocation_permission_context.cc',
        'browser/geolocation/chrome_geolocation_permission_context.h',
        'browser/geolocation/chrome_geolocation_permission_context_android.cc',
        'browser/geolocation/chrome_geolocation_permission_context_android.h',
        'browser/geolocation/chrome_geolocation_permission_context_factory.cc',
        'browser/geolocation/chrome_geolocation_permission_context_factory.h',
        'browser/geolocation/geolocation_infobar_delegate.cc',
        'browser/geolocation/geolocation_infobar_delegate.h',
        'browser/geolocation/geolocation_infobar_delegate_android.cc',
        'browser/geolocation/geolocation_infobar_delegate_android.h',
        'browser/geolocation/geolocation_prefs.cc',
        'browser/geolocation/geolocation_prefs.h',
        'browser/global_keyboard_shortcuts_mac.h',
        'browser/global_keyboard_shortcuts_mac.mm',
        'browser/google/google_search_counter.cc',
        'browser/google/google_search_counter.h',
        'browser/google/google_search_metrics.cc',
        'browser/google/google_search_metrics.h',
        'browser/google/google_update_settings_posix.cc',
        'browser/google/google_update_win.cc',
        'browser/google/google_update_win.h',
        'browser/google/google_url_tracker.cc',
        'browser/google/google_url_tracker.h',
        'browser/google/google_url_tracker_factory.cc',
        'browser/google/google_url_tracker_factory.h',
        'browser/google/google_url_tracker_infobar_delegate.cc',
        'browser/google/google_url_tracker_infobar_delegate.h',
        'browser/google/google_url_tracker_map_entry.cc',
        'browser/google/google_url_tracker_map_entry.h',
        'browser/google/google_url_tracker_navigation_helper.h',
        'browser/google/google_url_tracker_navigation_helper_impl.cc',
        'browser/google/google_url_tracker_navigation_helper_impl.h',
        'browser/google/google_util.cc',
        'browser/google/google_util.h',
        'browser/google/google_util_chromeos.cc',
        'browser/google/google_util_chromeos.h',
        'browser/gpu/gl_string_manager.cc',
        'browser/gpu/gl_string_manager.h',
        'browser/gpu/gpu_feature_checker.cc',
        'browser/gpu/gpu_feature_checker.h',
        'browser/gpu/gpu_mode_manager.cc',
        'browser/gpu/gpu_mode_manager.h',
        'browser/guestview/adview/adview_constants.cc',
        'browser/guestview/adview/adview_constants.h',
        'browser/guestview/adview/adview_guest.cc',
        'browser/guestview/adview/adview_guest.h',
        'browser/guestview/guestview_constants.cc',
        'browser/guestview/guestview_constants.h',
        'browser/guestview/guestview.cc',
        'browser/guestview/guestview.h',
        'browser/guestview/webview/plugin_permission_helper.cc',
        'browser/guestview/webview/plugin_permission_helper.h',
        'browser/guestview/webview/webview_constants.cc',
        'browser/guestview/webview/webview_constants.h',
        'browser/guestview/webview/webview_guest.cc',
        'browser/guestview/webview/webview_guest.h',
        'browser/guestview/webview/webview_permission_types.h',
        'browser/hang_monitor/hang_crash_dump_win.cc',
        'browser/hang_monitor/hang_crash_dump_win.h',
        'browser/hang_monitor/hung_plugin_action.cc',
        'browser/hang_monitor/hung_plugin_action.h',
        'browser/hang_monitor/hung_window_detector.cc',
        'browser/hang_monitor/hung_window_detector.h',
        'browser/history/android/android_cache_database.cc',
        'browser/history/android/android_cache_database.h',
        'browser/history/android/android_history_provider_service.cc',
        'browser/history/android/android_history_provider_service.h',
        'browser/history/android/android_history_types.cc',
        'browser/history/android/android_history_types.h',
        'browser/history/android/android_provider_backend.cc',
        'browser/history/android/android_provider_backend.h',
        'browser/history/android/android_time.h',
        'browser/history/android/android_urls_database.cc',
        'browser/history/android/android_urls_database.h',
        'browser/history/android/android_urls_sql_handler.cc',
        'browser/history/android/android_urls_sql_handler.h',
        'browser/history/android/bookmark_model_sql_handler.cc',
        'browser/history/android/bookmark_model_sql_handler.h',
        'browser/history/android/favicon_sql_handler.cc',
        'browser/history/android/favicon_sql_handler.h',
        'browser/history/android/sql_handler.cc',
        'browser/history/android/sql_handler.h',
        'browser/history/android/sqlite_cursor.cc',
        'browser/history/android/sqlite_cursor.h',
        'browser/history/android/urls_sql_handler.cc',
        'browser/history/android/urls_sql_handler.h',
        'browser/history/android/visit_sql_handler.cc',
        'browser/history/android/visit_sql_handler.h',
        'browser/history/archived_database.cc',
        'browser/history/archived_database.h',
        'browser/history/delete_directive_handler.cc',
        'browser/history/delete_directive_handler.h',
        'browser/history/download_database.cc',
        'browser/history/download_database.h',
        'browser/history/download_row.cc',
        'browser/history/download_row.h',
        'browser/history/expire_history_backend.cc',
        'browser/history/expire_history_backend.h',
        'browser/history/history_backend.cc',
        'browser/history/history_backend.h',
        'browser/history/history_backend_android.cc',
        'browser/history/history_database.cc',
        'browser/history/history_database.h',
        'browser/history/history_db_task.h',
        'browser/history/history_details.h',
        'browser/history/history_marshaling.h',
        'browser/history/history_marshaling_android.h',
        'browser/history/history_notifications.cc',
        'browser/history/history_notifications.h',
        'browser/history/history_service.cc',
        'browser/history/history_service.h',
        'browser/history/history_service_factory.cc',
        'browser/history/history_service_factory.h',
        'browser/history/history_tab_helper.cc',
        'browser/history/history_tab_helper.h',
        'browser/history/history_types.cc',
        'browser/history/history_types.h',
        'browser/history/in_memory_database.cc',
        'browser/history/in_memory_database.h',
        'browser/history/in_memory_history_backend.cc',
        'browser/history/in_memory_history_backend.h',
        'browser/history/in_memory_url_index.cc',
        'browser/history/in_memory_url_index.h',
        'browser/history/in_memory_url_index_types.cc',
        'browser/history/in_memory_url_index_types.h',
        'browser/history/most_visited_tiles_experiment.cc',
        'browser/history/most_visited_tiles_experiment.h',
        'browser/history/page_usage_data.cc',
        'browser/history/page_usage_data.h',
        'browser/history/query_parser.cc',
        'browser/history/query_parser.h',
        'browser/history/scored_history_match.cc',
        'browser/history/scored_history_match.h',
        'browser/history/select_favicon_frames.cc',
        'browser/history/select_favicon_frames.h',
        'browser/history/snippet.cc',
        'browser/history/snippet.h',
        'browser/history/shortcuts_backend.cc',
        'browser/history/shortcuts_backend.h',
        'browser/history/shortcuts_backend_factory.cc',
        'browser/history/shortcuts_backend_factory.h',
        'browser/history/shortcuts_database.cc',
        'browser/history/shortcuts_database.h',
        'browser/history/thumbnail_database.cc',
        'browser/history/thumbnail_database.h',
        'browser/history/top_sites.cc',
        'browser/history/top_sites.h',
        'browser/history/top_sites_backend.cc',
        'browser/history/top_sites_backend.h',
        'browser/history/top_sites_cache.cc',
        'browser/history/top_sites_cache.h',
        'browser/history/top_sites_database.cc',
        'browser/history/top_sites_database.h',
        'browser/history/top_sites_impl.cc',
        'browser/history/top_sites_impl.h',
        'browser/history/typed_url_syncable_service.cc',
        'browser/history/typed_url_syncable_service.h',
        'browser/history/url_database.cc',
        'browser/history/url_database.h',
        'browser/history/url_index_private_data.cc',
        'browser/history/url_index_private_data.h',
        'browser/history/url_utils.cc',
        'browser/history/url_utils.h',
        'browser/history/visit_database.cc',
        'browser/history/visit_database.h',
        'browser/history/visit_filter.cc',
        'browser/history/visit_filter.h',
        'browser/history/visit_tracker.cc',
        'browser/history/visit_tracker.h',
        'browser/history/visitsegment_database.cc',
        'browser/history/visitsegment_database.h',
        'browser/history/web_history_service.cc',
        'browser/history/web_history_service.h',
        'browser/history/web_history_service_factory.cc',
        'browser/history/web_history_service_factory.h',
        'browser/icon_loader.cc',
        'browser/icon_loader.h',
        'browser/icon_loader_android.cc',
        'browser/icon_loader_auralinux.cc',
        'browser/icon_loader_chromeos.cc',
        'browser/icon_loader_linux.cc',
        'browser/icon_loader_mac.mm',
        'browser/icon_loader_win.cc',
        'browser/icon_manager.cc',
        'browser/icon_manager.h',
        'browser/idle.cc',
        'browser/idle.h',
        'browser/idle_android.cc',
        'browser/idle_chromeos.cc',
        'browser/idle_linux.cc',
        'browser/idle_mac.mm',
        'browser/idle_query_x11.cc',
        'browser/idle_query_x11.h',
        'browser/idle_win.cc',
        'browser/image_decoder.cc',
        'browser/image_decoder.h',
        'browser/importer/external_process_importer_client.cc',
        'browser/importer/external_process_importer_client.h',
        'browser/importer/external_process_importer_host.cc',
        'browser/importer/external_process_importer_host.h',
        'browser/importer/firefox_profile_lock.cc',
        'browser/importer/firefox_profile_lock.h',
        'browser/importer/firefox_profile_lock_posix.cc',
        'browser/importer/firefox_profile_lock_win.cc',
        'browser/importer/importer_list.cc',
        'browser/importer/importer_list.h',
        'browser/importer/importer_list_observer.h',
        'browser/importer/importer_lock_dialog.h',
        'browser/importer/importer_progress_observer.h',
        'browser/importer/importer_uma.cc',
        'browser/importer/importer_uma.h',
        'browser/importer/in_process_importer_bridge.cc',
        'browser/importer/in_process_importer_bridge.h',
        'browser/importer/profile_writer.cc',
        'browser/importer/profile_writer.h',
        'browser/infobars/confirm_infobar_delegate.cc',
        'browser/infobars/confirm_infobar_delegate.h',
        'browser/infobars/infobar.cc',
        'browser/infobars/infobar.h',
        'browser/infobars/infobar_container.cc',
        'browser/infobars/infobar_container.h',
        'browser/infobars/infobar_delegate.cc',
        'browser/infobars/infobar_delegate.h',
        'browser/infobars/infobar_service.cc',
        'browser/infobars/infobar_service.h',
        'browser/infobars/insecure_content_infobar_delegate.cc',
        'browser/infobars/insecure_content_infobar_delegate.h',
        'browser/infobars/simple_alert_infobar_delegate.cc',
        'browser/infobars/simple_alert_infobar_delegate.h',
        'browser/install_verification/win/imported_module_verification.cc',
        'browser/install_verification/win/imported_module_verification.h',
        'browser/install_verification/win/install_verification.cc',
        'browser/install_verification/win/install_verification.h',
        'browser/install_verification/win/loaded_module_verification.cc',
        'browser/install_verification/win/loaded_module_verification.h',
        'browser/install_verification/win/loaded_modules_snapshot.cc',
        'browser/install_verification/win/loaded_modules_snapshot.h',
        'browser/install_verification/win/module_ids.cc',
        'browser/install_verification/win/module_ids.h',
        'browser/install_verification/win/module_info.h',
        'browser/install_verification/win/module_list.cc',
        'browser/install_verification/win/module_list.h',
        'browser/install_verification/win/module_verification_common.cc',
        'browser/install_verification/win/module_verification_common.h',
        'browser/internal_auth.cc',
        'browser/internal_auth.h',
        'browser/intranet_redirect_detector.cc',
        'browser/intranet_redirect_detector.h',
        'browser/invalidation/invalidation_logger.cc',
        'browser/invalidation/invalidation_logger.h',
        'browser/invalidation/fake_invalidation_service.cc',
        'browser/invalidation/fake_invalidation_service.h',
        'browser/invalidation/gcm_network_channel_delegate_impl.cc',
        'browser/invalidation/gcm_network_channel_delegate_impl.h',
        'browser/invalidation/invalidation_controller_android.cc',
        'browser/invalidation/invalidation_controller_android.h',
        'browser/invalidation/invalidation_service.h',
        'browser/invalidation/invalidation_service_android.cc',
        'browser/invalidation/invalidation_service_android.h',
        'browser/invalidation/invalidation_service_factory.cc',
        'browser/invalidation/invalidation_service_factory.h',
        'browser/invalidation/invalidation_service_util.cc',
        'browser/invalidation/invalidation_service_util.h',
        'browser/invalidation/invalidator_storage.cc',
        'browser/invalidation/invalidator_storage.h',
        'browser/invalidation/p2p_invalidation_service.cc',
        'browser/invalidation/p2p_invalidation_service.h',
        'browser/invalidation/ticl_invalidation_service.cc',
        'browser/invalidation/ticl_invalidation_service.h',
        'browser/io_thread.cc',
        'browser/io_thread.h',
        'browser/jankometer.cc',
        'browser/jankometer.h',
        'browser/jankometer_android.cc',
        'browser/jankometer_mac.cc',
        'browser/jumplist_win.cc',
        'browser/jumplist_win.h',
        'browser/lifetime/application_lifetime.cc',
        'browser/lifetime/application_lifetime.h',
        'browser/lifetime/application_lifetime_android.cc',
        'browser/lifetime/application_lifetime_android.h',
        'browser/lifetime/application_lifetime_aura.cc',
        'browser/lifetime/application_lifetime_gtk.cc',
        'browser/lifetime/application_lifetime_mac.mm',
        'browser/lifetime/application_lifetime_stub.cc',
        'browser/lifetime/application_lifetime_win.cc',
        'browser/lifetime/browser_close_manager.cc',
        'browser/lifetime/browser_close_manager.h',
        'browser/local_discovery/cloud_print_base_api_flow.cc',
        'browser/local_discovery/cloud_print_base_api_flow.h',
        'browser/local_discovery/cloud_print_printer_list.cc',
        'browser/local_discovery/cloud_print_printer_list.h',
        'browser/local_discovery/device_description.cc',
        'browser/local_discovery/device_description.h',
        'browser/local_discovery/privet_confirm_api_flow.cc',
        'browser/local_discovery/privet_confirm_api_flow.h',
        'browser/local_discovery/privet_constants.cc',
        'browser/local_discovery/privet_constants.h',
        'browser/local_discovery/privet_device_lister.cc',
        'browser/local_discovery/privet_device_lister.h',
        'browser/local_discovery/privet_device_lister_impl.cc',
        'browser/local_discovery/privet_device_lister_impl.h',
        'browser/local_discovery/privet_device_resolver.cc',
        'browser/local_discovery/privet_device_resolver.h',
        'browser/local_discovery/privet_http.h',
        'browser/local_discovery/privet_http_impl.cc',
        'browser/local_discovery/privet_http_impl.h',
        'browser/local_discovery/privet_local_printer_lister.h',
        'browser/local_discovery/privet_local_printer_lister.cc',
        'browser/local_discovery/privet_url_fetcher.cc',
        'browser/local_discovery/privet_url_fetcher.h',
        'browser/local_discovery/pwg_raster_converter.cc',
        'browser/local_discovery/pwg_raster_converter.h',
        'browser/local_discovery/service_discovery_client_mac.h',
        'browser/local_discovery/service_discovery_client_mac.mm',
        'browser/local_discovery/service_discovery_client_mac_factory.h',
        'browser/local_discovery/service_discovery_client_mac_factory.mm',
        'browser/local_discovery/service_discovery_device_lister.cc',
        'browser/local_discovery/service_discovery_device_lister.h',
        'browser/local_discovery/service_discovery_shared_client.cc',
        'browser/local_discovery/service_discovery_shared_client.h',
        'browser/local_discovery/storage/privet_filesystem_async_util.cc',
        'browser/local_discovery/storage/privet_filesystem_async_util.h',
        'browser/local_discovery/storage/privet_filesystem_backend.cc',
        'browser/local_discovery/storage/privet_filesystem_backend.h',
        'browser/local_discovery/storage/privet_filesystem_constants.cc',
        'browser/local_discovery/storage/privet_filesystem_constants.h',
        'browser/local_discovery/storage/privet_volume_lister.cc',
        'browser/local_discovery/storage/privet_volume_lister.h',
        'browser/mac/dock.h',
        'browser/mac/dock.mm',
        'browser/mac/install_from_dmg.h',
        'browser/mac/install_from_dmg.mm',
        'browser/mac/keychain_reauthorize.h',
        'browser/mac/keychain_reauthorize.mm',
        'browser/mac/keystone_glue.h',
        'browser/mac/keystone_glue.mm',
        'browser/mac/keystone_registration.h',
        'browser/mac/keystone_registration.mm',
        'browser/mac/master_prefs.h',
        'browser/mac/master_prefs.mm',
        'browser/mac/obsolete_system.cc',
        'browser/mac/obsolete_system.h',
        'browser/mac/relauncher.cc',
        'browser/mac/relauncher.h',
        'browser/mac/security_wrappers.cc',
        'browser/mac/security_wrappers.h',
        'browser/managed_mode/custodian_profile_downloader_service.cc',
        'browser/managed_mode/custodian_profile_downloader_service.h',
        'browser/managed_mode/custodian_profile_downloader_service_factory.cc',
        'browser/managed_mode/custodian_profile_downloader_service_factory.h',
        'browser/managed_mode/managed_mode_interstitial.cc',
        'browser/managed_mode/managed_mode_interstitial.h',
        'browser/managed_mode/managed_mode_navigation_observer.cc',
        'browser/managed_mode/managed_mode_navigation_observer.h',
        'browser/managed_mode/managed_mode_resource_throttle.cc',
        'browser/managed_mode/managed_mode_resource_throttle.h',
        'browser/managed_mode/managed_mode_site_list.cc',
        'browser/managed_mode/managed_mode_site_list.h',
        'browser/managed_mode/managed_mode_url_filter.cc',
        'browser/managed_mode/managed_mode_url_filter.h',
        'browser/managed_mode/managed_user_constants.cc',
        'browser/managed_mode/managed_user_constants.h',
        'browser/managed_mode/managed_user_refresh_token_fetcher.cc',
        'browser/managed_mode/managed_user_refresh_token_fetcher.h',
        'browser/managed_mode/managed_user_registration_utility.cc',
        'browser/managed_mode/managed_user_registration_utility.h',
        'browser/managed_mode/managed_user_registration_utility_stub.cc',
        'browser/managed_mode/managed_user_registration_utility_stub.h',
        'browser/managed_mode/managed_user_settings_service.cc',
        'browser/managed_mode/managed_user_settings_service.h',
        'browser/managed_mode/managed_user_settings_service_factory.cc',
        'browser/managed_mode/managed_user_settings_service_factory.h',
        'browser/managed_mode/managed_user_service.cc',
        'browser/managed_mode/managed_user_service.h',
        'browser/managed_mode/managed_user_service_factory.cc',
        'browser/managed_mode/managed_user_service_factory.h',
        'browser/managed_mode/managed_user_shared_settings_service.cc',
        'browser/managed_mode/managed_user_shared_settings_service.h',
        'browser/managed_mode/managed_user_shared_settings_service_factory.cc',
        'browser/managed_mode/managed_user_shared_settings_service_factory.h',
        'browser/managed_mode/managed_user_shared_settings_update.cc',
        'browser/managed_mode/managed_user_shared_settings_update.h',
        'browser/managed_mode/managed_user_signin_manager_wrapper.cc',
        'browser/managed_mode/managed_user_signin_manager_wrapper.h',
        'browser/managed_mode/managed_user_sync_service.cc',
        'browser/managed_mode/managed_user_sync_service.h',
        'browser/managed_mode/managed_user_sync_service_factory.cc',
        'browser/managed_mode/managed_user_sync_service_factory.h',
        'browser/managed_mode/managed_user_sync_service_observer.h',
        'browser/managed_mode/managed_user_theme.cc',
        'browser/managed_mode/managed_user_theme.h',
        'browser/managed_mode/managed_users.h',
        'browser/managed_mode/supervised_user_pref_mapping_service.cc',
        'browser/managed_mode/supervised_user_pref_mapping_service.h',
        'browser/managed_mode/supervised_user_pref_mapping_service_factory.cc',
        'browser/managed_mode/supervised_user_pref_mapping_service_factory.h',
        'browser/managed_mode/supervised_user_pref_store.cc',
        'browser/managed_mode/supervised_user_pref_store.h',
        'browser/media/audio_stream_indicator.cc',
        'browser/media/audio_stream_indicator.h',
        'browser/media/cast_transport_host_filter.cc',
        'browser/media/cast_transport_host_filter.h',
        'browser/media/chrome_midi_permission_context.cc',
        'browser/media/chrome_midi_permission_context.h',
        'browser/media/chrome_midi_permission_context_factory.cc',
        'browser/media/chrome_midi_permission_context_factory.h',
        'browser/media/desktop_media_list.h',
        'browser/media/desktop_media_list_ash.cc',
        'browser/media/desktop_media_list_ash.h',
        'browser/media/desktop_media_picker.h',
        'browser/media/desktop_streams_registry.cc',
        'browser/media/desktop_streams_registry.h',
        'browser/media/encrypted_media_message_filter_android.cc',
        'browser/media/encrypted_media_message_filter_android.h',
        'browser/media/media_capture_devices_dispatcher.cc',
        'browser/media/media_capture_devices_dispatcher.h',
        'browser/media/media_device_id_salt.cc',
        'browser/media/media_device_id_salt.h',
        'browser/media/media_stream_capture_indicator.cc',
        'browser/media/media_stream_capture_indicator.h',
        'browser/media/media_stream_devices_controller.cc',
        'browser/media/media_stream_devices_controller.h',
        'browser/media/media_stream_infobar_delegate.cc',
        'browser/media/media_stream_infobar_delegate.h',
        'browser/media/midi_permission_infobar_delegate.cc',
        'browser/media/midi_permission_infobar_delegate.h',
        'browser/media/native_desktop_media_list.cc',
        'browser/media/native_desktop_media_list.h',
        'browser/media/webrtc_log_upload_list.cc',
        'browser/media/webrtc_log_upload_list.h',
        'browser/media/webrtc_log_uploader.cc',
        'browser/media/webrtc_log_uploader.h',
        'browser/media/webrtc_logging_handler_host.cc',
        'browser/media/webrtc_logging_handler_host.h',
        'browser/media_galleries/fileapi/av_scanning_file_validator.cc',
        'browser/media_galleries/fileapi/av_scanning_file_validator.h',
        'browser/media_galleries/fileapi/device_media_async_file_util.cc',
        'browser/media_galleries/fileapi/device_media_async_file_util.h',
        'browser/media_galleries/fileapi/iapps_finder.h',
        'browser/media_galleries/fileapi/iapps_finder_impl.h',
        'browser/media_galleries/fileapi/iapps_finder_impl.cc',
        'browser/media_galleries/fileapi/iapps_finder_impl_mac.mm',
        'browser/media_galleries/fileapi/iapps_finder_impl_win.cc',
        'browser/media_galleries/fileapi/media_file_system_backend.cc',
        'browser/media_galleries/fileapi/media_file_system_backend.h',
        'browser/media_galleries/fileapi/media_file_validator_factory.h',
        'browser/media_galleries/fileapi/media_file_validator_factory.cc',
        'browser/media_galleries/fileapi/media_path_filter.cc',
        'browser/media_galleries/fileapi/media_path_filter.h',
        'browser/media_galleries/fileapi/mtp_device_async_delegate.cc',
        'browser/media_galleries/fileapi/mtp_device_async_delegate.h',
        'browser/media_galleries/fileapi/mtp_device_map_service.cc',
        'browser/media_galleries/fileapi/mtp_device_map_service.h',
        'browser/media_galleries/fileapi/mtp_file_stream_reader.cc',
        'browser/media_galleries/fileapi/mtp_file_stream_reader.h',
        'browser/media_galleries/fileapi/native_media_file_util.cc',
        'browser/media_galleries/fileapi/native_media_file_util.h',
        'browser/media_galleries/fileapi/picasa_finder.cc',
        'browser/media_galleries/fileapi/picasa_finder.h',
        'browser/media_galleries/fileapi/picasa_finder_mac.mm',
        'browser/media_galleries/fileapi/safe_audio_video_checker.cc',
        'browser/media_galleries/fileapi/safe_audio_video_checker.h',
        'browser/media_galleries/fileapi/safe_media_metadata_parser.cc',
        'browser/media_galleries/fileapi/safe_media_metadata_parser.h',
        'browser/media_galleries/fileapi/supported_audio_video_checker.cc',
        'browser/media_galleries/fileapi/supported_audio_video_checker.h',
        'browser/media_galleries/fileapi/supported_image_type_validator.cc',
        'browser/media_galleries/fileapi/supported_image_type_validator.h',
        'browser/media_galleries/imported_media_gallery_registry.cc',
        'browser/media_galleries/imported_media_gallery_registry.h',
        'browser/media_galleries/linux/mtp_device_delegate_impl_linux.cc',
        'browser/media_galleries/linux/mtp_device_delegate_impl_linux.h',
        'browser/media_galleries/linux/mtp_device_object_enumerator.cc',
        'browser/media_galleries/linux/mtp_device_object_enumerator.h',
        'browser/media_galleries/linux/mtp_device_task_helper.cc',
        'browser/media_galleries/linux/mtp_device_task_helper.h',
        'browser/media_galleries/linux/mtp_device_task_helper_map_service.cc',
        'browser/media_galleries/linux/mtp_device_task_helper_map_service.h',
        'browser/media_galleries/linux/mtp_read_file_worker.cc',
        'browser/media_galleries/linux/mtp_read_file_worker.h',
        'browser/media_galleries/linux/snapshot_file_details.cc',
        'browser/media_galleries/linux/snapshot_file_details.h',
        'browser/media_galleries/mac/mtp_device_delegate_impl_mac.h',
        'browser/media_galleries/mac/mtp_device_delegate_impl_mac.mm',
        'browser/media_galleries/media_file_system_registry.cc',
        'browser/media_galleries/media_file_system_registry.h',
        'browser/media_galleries/media_folder_finder.cc',
        'browser/media_galleries/media_folder_finder.h',
        'browser/media_galleries/media_galleries_dialog_controller.cc',
        'browser/media_galleries/media_galleries_dialog_controller.h',
        'browser/media_galleries/media_galleries_histograms.cc',
        'browser/media_galleries/media_galleries_histograms.h',
        'browser/media_galleries/media_galleries_preferences.cc',
        'browser/media_galleries/media_galleries_preferences.h',
        'browser/media_galleries/media_galleries_preferences_factory.cc',
        'browser/media_galleries/media_galleries_preferences_factory.h',
        'browser/media_galleries/media_galleries_scan_result_dialog_controller.cc',
        'browser/media_galleries/media_galleries_scan_result_dialog_controller.h',
        'browser/media_galleries/media_gallery_context_menu.cc',
        'browser/media_galleries/media_gallery_context_menu.h',
        'browser/media_galleries/media_scan_manager.cc',
        'browser/media_galleries/media_scan_manager.h',
        'browser/media_galleries/media_scan_manager_observer.h',
        'browser/media_galleries/media_scan_types.cc',
        'browser/media_galleries/media_scan_types.h',
        'browser/media_galleries/win/mtp_device_delegate_impl_win.cc',
        'browser/media_galleries/win/mtp_device_delegate_impl_win.h',
        'browser/media_galleries/win/mtp_device_object_entry.cc',
        'browser/media_galleries/win/mtp_device_object_entry.h',
        'browser/media_galleries/win/mtp_device_object_enumerator.cc',
        'browser/media_galleries/win/mtp_device_object_enumerator.h',
        'browser/media_galleries/win/mtp_device_operations_util.cc',
        'browser/media_galleries/win/mtp_device_operations_util.h',
        'browser/media_galleries/win/portable_device_map_service.cc',
        'browser/media_galleries/win/portable_device_map_service.h',
        'browser/media_galleries/win/snapshot_file_details.cc',
        'browser/media_galleries/win/snapshot_file_details.h',
        'browser/memory_details.cc',
        'browser/memory_details.h',
        'browser/memory_details_android.cc',
        'browser/memory_details_linux.cc',
        'browser/memory_details_mac.cc',
        'browser/memory_details_win.cc',
        'browser/memory_purger.cc',
        'browser/memory_purger.h',
        'browser/metrics/chrome_browser_main_extra_parts_metrics.cc',
        'browser/metrics/chrome_browser_main_extra_parts_metrics.h',
        'browser/metrics/compression_utils.cc',
        'browser/metrics/compression_utils.h',
        'browser/metrics/field_trial_synchronizer.cc',
        'browser/metrics/field_trial_synchronizer.h',
        'browser/metrics/metric_event_duration_details.h',
        'browser/metrics/metrics_log.cc',
        'browser/metrics/metrics_log.h',
        'browser/metrics/metrics_log_chromeos.cc',
        'browser/metrics/metrics_log_chromeos.h',
        'browser/metrics/metrics_log_serializer.cc',
        'browser/metrics/metrics_log_serializer.h',
        'browser/metrics/metrics_network_observer.cc',
        'browser/metrics/metrics_network_observer.h',
        'browser/metrics/metrics_reporting_scheduler.cc',
        'browser/metrics/metrics_reporting_scheduler.h',
        'browser/metrics/metrics_service_android.cc',
        'browser/metrics/metrics_service.cc',
        'browser/metrics/metrics_service.h',
        'browser/metrics/perf_provider_chromeos.cc',
        'browser/metrics/perf_provider_chromeos.h',
        'browser/metrics/thread_watcher.cc',
        'browser/metrics/thread_watcher.h',
        'browser/metrics/time_ticks_experiment_win.cc',
        'browser/metrics/time_ticks_experiment_win.h',
        'browser/metrics/tracking_synchronizer.cc',
        'browser/metrics/tracking_synchronizer.h',
        'browser/metrics/tracking_synchronizer_observer.h',
        'browser/metrics/variations/variations_http_header_provider.cc',
        'browser/metrics/variations/variations_http_header_provider.h',
        'browser/metrics/variations/variations_registry_syncer_win.cc',
        'browser/metrics/variations/variations_registry_syncer_win.h',
        'browser/metrics/variations/variations_request_scheduler.cc',
        'browser/metrics/variations/variations_request_scheduler.h',
        'browser/metrics/variations/variations_request_scheduler_mobile.cc',
        'browser/metrics/variations/variations_request_scheduler_mobile.h',
        'browser/metrics/variations/variations_service.cc',
        'browser/metrics/variations/variations_service.h',
        'browser/metrics/variations/variations_seed_store.cc',
        'browser/metrics/variations/variations_seed_store.h',
        'browser/metro_viewer/chrome_metro_viewer_process_host_aurawin.cc',
        'browser/metro_viewer/chrome_metro_viewer_process_host_aurawin.h',
        'browser/native_window_notification_source.h',
        'browser/net/about_protocol_handler.cc',
        'browser/net/about_protocol_handler.h',
        'browser/net/async_dns_field_trial.cc',
        'browser/net/async_dns_field_trial.h',
        'browser/net/basic_http_user_agent_settings.cc',
        'browser/net/basic_http_user_agent_settings.h',
        'browser/net/chrome_cookie_notification_details.h',
        'browser/net/chrome_fraudulent_certificate_reporter.cc',
        'browser/net/chrome_fraudulent_certificate_reporter.h',
        'browser/net/chrome_http_user_agent_settings.cc',
        'browser/net/chrome_http_user_agent_settings.h',
        'browser/net/chrome_net_log.cc',
        'browser/net/chrome_net_log.h',
        'browser/net/chrome_network_delegate.cc',
        'browser/net/chrome_network_delegate.h',
        'browser/net/chrome_url_request_context.cc',
        'browser/net/chrome_url_request_context.h',
        'browser/net/client_hints.cc',
        'browser/net/client_hints.h',
        'browser/net/connect_interceptor.cc',
        'browser/net/connect_interceptor.h',
        'browser/net/connection_tester.cc',
        'browser/net/connection_tester.h',
        'browser/net/cookie_store_util.cc',
        'browser/net/cookie_store_util.h',
        'browser/net/crl_set_fetcher.cc',
        'browser/net/crl_set_fetcher.h',
        'browser/net/dns_probe_runner.cc',
        'browser/net/dns_probe_runner.h',
        'browser/net/dns_probe_service.cc',
        'browser/net/dns_probe_service.h',
        'browser/net/evicted_domain_cookie_counter.cc',
        'browser/net/evicted_domain_cookie_counter.h',
        'browser/net/firefox_proxy_settings.cc',
        'browser/net/firefox_proxy_settings.h',
        'browser/net/http_pipelining_compatibility_client.cc',
        'browser/net/http_pipelining_compatibility_client.h',
        'browser/net/http_server_properties_manager.cc',
        'browser/net/http_server_properties_manager.h',
        'browser/net/net_error_tab_helper.cc',
        'browser/net/net_error_tab_helper.h',
        'browser/net/net_log_temp_file.cc',
        'browser/net/net_log_temp_file.h',
        'browser/net/net_pref_observer.cc',
        'browser/net/net_pref_observer.h',
        'browser/net/network_stats.cc',
        'browser/net/network_stats.h',
        'browser/net/nss_context_chromeos.cc',
        'browser/net/nss_context_linux.cc',
        'browser/net/nss_context.cc',
        'browser/net/nss_context.h',
        'browser/net/preconnect.cc',
        'browser/net/preconnect.h',
        'browser/net/predictor.cc',
        'browser/net/predictor.h',
        'browser/net/predictor_tab_helper.cc',
        'browser/net/predictor_tab_helper.h',
        'browser/net/pref_proxy_config_tracker.cc',
        'browser/net/pref_proxy_config_tracker.h',
        'browser/net/pref_proxy_config_tracker_impl.cc',
        'browser/net/pref_proxy_config_tracker_impl.h',
        'browser/net/probe_message.cc',
        'browser/net/probe_message.h',
        'browser/net/proxy_policy_handler.cc',
        'browser/net/proxy_policy_handler.h',
        'browser/net/proxy_service_factory.cc',
        'browser/net/proxy_service_factory.h',
        'browser/net/referrer.cc',
        'browser/net/referrer.h',
        'browser/net/sdch_dictionary_fetcher.cc',
        'browser/net/sdch_dictionary_fetcher.h',
        'browser/net/service_providers_win.cc',
        'browser/net/service_providers_win.h',
        'browser/net/spdyproxy/data_reduction_proxy_settings.cc',
        'browser/net/spdyproxy/data_reduction_proxy_settings.h',
        'browser/net/spdyproxy/data_reduction_proxy_settings_android.cc',
        'browser/net/spdyproxy/data_reduction_proxy_settings_android.h',
        'browser/net/spdyproxy/data_reduction_proxy_settings_ios.cc',
        'browser/net/spdyproxy/data_reduction_proxy_settings_ios.h',
        'browser/net/spdyproxy/data_saving_metrics.cc',
        'browser/net/spdyproxy/data_saving_metrics.h',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy.cc',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy.h',
        'browser/net/spdyproxy/proxy_advisor.cc',
        'browser/net/spdyproxy/proxy_advisor.h',
        'browser/net/sqlite_server_bound_cert_store.cc',
        'browser/net/sqlite_server_bound_cert_store.h',
        'browser/net/ssl_config_service_manager.h',
        'browser/net/ssl_config_service_manager_pref.cc',
        'browser/net/timed_cache.cc',
        'browser/net/timed_cache.h',
        'browser/net/url_info.cc',
        'browser/net/url_info.h',
        'browser/network_time/navigation_time_helper.cc',
        'browser/network_time/navigation_time_helper.h',
        'browser/network_time/network_time.h',
        'browser/network_time/network_time_service.cc',
        'browser/network_time/network_time_service.h',
        'browser/network_time/network_time_service_factory.cc',
        'browser/network_time/network_time_service_factory.h',
        'browser/network_time/network_time_tracker.cc',
        'browser/network_time/network_time_tracker.h',
        'browser/notifications/balloon.cc',
        'browser/notifications/balloon.h',
        'browser/notifications/balloon_collection.cc',
        'browser/notifications/balloon_collection.h',
        'browser/notifications/balloon_collection_base.cc',
        'browser/notifications/balloon_collection_base.h',
        'browser/notifications/balloon_collection_impl.cc',
        'browser/notifications/balloon_collection_impl.h',
        'browser/notifications/balloon_host.cc',
        'browser/notifications/balloon_host.h',
        'browser/notifications/balloon_notification_ui_manager.cc',
        'browser/notifications/balloon_notification_ui_manager.h',
        'browser/notifications/desktop_notification_service.cc',
        'browser/notifications/desktop_notification_service.h',
        'browser/notifications/desktop_notification_service_factory.cc',
        'browser/notifications/desktop_notification_service_factory.h',
        'browser/notifications/desktop_notification_service_win.cc',
        'browser/notifications/fake_balloon_view.cc',
        'browser/notifications/fake_balloon_view.h',
        'browser/notifications/message_center_notification_manager.cc',
        'browser/notifications/message_center_notification_manager.h',
        'browser/notifications/message_center_notification_manager_win.cc',
        'browser/notifications/message_center_settings_controller.cc',
        'browser/notifications/message_center_settings_controller.h',
        'browser/notifications/message_center_stats_collector.cc',
        'browser/notifications/message_center_stats_collector.h',
        'browser/notifications/notification.cc',
        'browser/notifications/notification.h',
        'browser/notifications/screen_lock_notification_blocker.cc',
        'browser/notifications/screen_lock_notification_blocker.h',
        'browser/notifications/fullscreen_notification_blocker.cc',
        'browser/notifications/fullscreen_notification_blocker.h',
        'browser/notifications/login_state_notification_blocker_chromeos.cc',
        'browser/notifications/login_state_notification_blocker_chromeos.h',
        'browser/notifications/notification_delegate.cc',
        'browser/notifications/notification_delegate.h',
        'browser/notifications/notification_object_proxy.cc',
        'browser/notifications/notification_object_proxy.h',
        'browser/notifications/notification_options_menu_model.cc',
        'browser/notifications/notification_options_menu_model.h',
        'browser/notifications/notification_prefs_manager.cc',
        'browser/notifications/notification_prefs_manager.h',
        'browser/notifications/notification_system_observer.cc',
        'browser/notifications/notification_system_observer.h',
        'browser/notifications/notification_ui_manager.cc',
        'browser/notifications/notification_ui_manager.h',
        'browser/notifications/notification_ui_manager_mac.mm',
        'browser/notifications/notification_ui_manager_mac.h',
        'browser/notifications/sync_notifier/chrome_notifier_delegate.cc',
        'browser/notifications/sync_notifier/chrome_notifier_delegate.h',
        'browser/notifications/sync_notifier/chrome_notifier_service.cc',
        'browser/notifications/sync_notifier/chrome_notifier_service.h',
        'browser/notifications/sync_notifier/chrome_notifier_service_factory.cc',
        'browser/notifications/sync_notifier/chrome_notifier_service_factory.h',
        'browser/notifications/sync_notifier/synced_notification.cc',
        'browser/notifications/sync_notifier/synced_notification.h',
        'browser/notifications/sync_notifier/welcome_delegate.cc',
        'browser/notifications/sync_notifier/welcome_delegate.h',
        'browser/notifications/extension_welcome_notification.cc',
        'browser/notifications/extension_welcome_notification.h',
        'browser/omaha_query_params/omaha_query_params.h',
        'browser/omaha_query_params/omaha_query_params.cc',
        'browser/omnibox/omnibox_field_trial.cc',
        'browser/omnibox/omnibox_field_trial.h',
        'browser/omnibox/omnibox_log.cc',
        'browser/omnibox/omnibox_log.h',
        'browser/parsers/metadata_parser.cc',
        'browser/parsers/metadata_parser.h',
        'browser/parsers/metadata_parser_factory.h',
        'browser/parsers/metadata_parser_filebase.cc',
        'browser/parsers/metadata_parser_filebase.h',
        'browser/parsers/metadata_parser_jpeg.cc',
        'browser/parsers/metadata_parser_jpeg.h',
        'browser/parsers/metadata_parser_jpeg_factory.cc',
        'browser/parsers/metadata_parser_jpeg_factory.h',
        'browser/parsers/metadata_parser_manager.cc',
        'browser/parsers/metadata_parser_manager.h',
        'browser/password_manager/chrome_password_manager_client.cc',
        'browser/password_manager/chrome_password_manager_client.h',
        'browser/password_manager/content_password_manager_driver.cc',
        'browser/password_manager/content_password_manager_driver.h',
        'browser/password_manager/native_backend_gnome_x.cc',
        'browser/password_manager/native_backend_gnome_x.h',
        'browser/password_manager/native_backend_kwallet_x.cc',
        'browser/password_manager/native_backend_kwallet_x.h',
        'browser/password_manager/password_form_manager.cc',
        'browser/password_manager/password_form_manager.h',
        'browser/password_manager/password_generation_manager.cc',
        'browser/password_manager/password_generation_manager.h',
        'browser/password_manager/password_manager.cc',
        'browser/password_manager/password_manager.h',
        'browser/password_manager/password_manager_client.cc',
        'browser/password_manager/password_manager_client.h',
        'browser/password_manager/password_manager_driver.h',
        'browser/password_manager/password_manager_util.h',
        'browser/password_manager/password_manager_util_android.cc',
        'browser/password_manager/password_manager_util_mac.mm',
        'browser/password_manager/password_manager_util_linux.cc',
        'browser/password_manager/password_manager_util_win.cc',
        'browser/password_manager/password_store_factory.cc',
        'browser/password_manager/password_store_factory.h',
        'browser/password_manager/password_store_mac.cc',
        'browser/password_manager/password_store_mac.h',
        'browser/password_manager/password_store_mac_internal.h',
        'browser/password_manager/password_store_win.cc',
        'browser/password_manager/password_store_win.h',
        'browser/password_manager/password_store_x.cc',
        'browser/password_manager/password_store_x.h',
        'browser/password_manager/save_password_infobar_delegate.cc',
        'browser/password_manager/save_password_infobar_delegate.h',
        'browser/pepper_broker_infobar_delegate.cc',
        'browser/pepper_broker_infobar_delegate.h',
        'browser/pepper_flash_settings_manager.cc',
        'browser/pepper_flash_settings_manager.h',
        'browser/performance_monitor/constants.cc',
        'browser/performance_monitor/constants.h',
        'browser/performance_monitor/database.cc',
        'browser/performance_monitor/database.h',
        'browser/performance_monitor/event.cc',
        'browser/performance_monitor/event.h',
        'browser/performance_monitor/key_builder.cc',
        'browser/performance_monitor/key_builder.h',
        'browser/performance_monitor/metric.cc',
        'browser/performance_monitor/metric.h',
        'browser/performance_monitor/performance_monitor.cc',
        'browser/performance_monitor/performance_monitor.h',
        'browser/performance_monitor/performance_monitor_util.cc',
        'browser/performance_monitor/performance_monitor_util.h',
        'browser/performance_monitor/process_metrics_history.cc',
        'browser/performance_monitor/process_metrics_history.h',
        'browser/performance_monitor/startup_timer.cc',
        'browser/performance_monitor/startup_timer.h',
        'browser/platform_util.h',
        'browser/platform_util_android.cc',
        'browser/platform_util_aura.cc',
        'browser/platform_util_chromeos.cc',
        'browser/platform_util_common_linux.cc',
        'browser/platform_util_linux.cc',
        'browser/platform_util_mac.mm',
        'browser/platform_util_win.cc',
        'browser/plugins/chrome_plugin_service_filter.cc',
        'browser/plugins/chrome_plugin_service_filter.h',
        'browser/plugins/plugins_resource_service.cc',
        'browser/plugins/plugins_resource_service.h',
        'browser/plugins/plugin_data_remover_helper.cc',
        'browser/plugins/plugin_data_remover_helper.h',
        'browser/plugins/plugin_finder.cc',
        'browser/plugins/plugin_finder.h',
        'browser/plugins/plugin_infobar_delegates.cc',
        'browser/plugins/plugin_infobar_delegates.h',
        'browser/plugins/plugin_info_message_filter.cc',
        'browser/plugins/plugin_info_message_filter.h',
        'browser/plugins/plugin_installer.cc',
        'browser/plugins/plugin_installer.h',
        'browser/plugins/plugin_installer_observer.cc',
        'browser/plugins/plugin_installer_observer.h',
        'browser/plugins/plugin_metadata.cc',
        'browser/plugins/plugin_metadata.h',
        'browser/plugins/plugin_observer.cc',
        'browser/plugins/plugin_observer.h',
        'browser/plugins/plugin_prefs.cc',
        'browser/plugins/plugin_prefs.h',
        'browser/plugins/plugin_prefs_factory.cc',
        'browser/plugins/plugin_prefs_factory.h',
        'browser/plugins/plugin_status_pref_setter.cc',
        'browser/plugins/plugin_status_pref_setter.h',
        'browser/policy/chrome_browser_policy_connector.cc',
        'browser/policy/chrome_browser_policy_connector.h',
        'browser/policy/cloud/cloud_policy_invalidator.cc',
        'browser/policy/cloud/cloud_policy_invalidator.h',
        'browser/policy/cloud/policy_header_service_factory.h',
        'browser/policy/cloud/policy_header_service_factory.cc',
        'browser/policy/cloud/user_cloud_policy_invalidator_factory.cc',
        'browser/policy/cloud/user_cloud_policy_invalidator_factory.h',
        'browser/policy/cloud/user_cloud_policy_invalidator.cc',
        'browser/policy/cloud/user_cloud_policy_invalidator.h',
        'browser/policy/cloud/user_cloud_policy_manager_factory.cc',
        'browser/policy/cloud/user_cloud_policy_manager_factory.h',
        'browser/policy/cloud/user_policy_signin_service.cc',
        'browser/policy/cloud/user_policy_signin_service.h',
        'browser/policy/cloud/user_policy_signin_service_android.cc',
        'browser/policy/cloud/user_policy_signin_service_android.h',
        'browser/policy/cloud/user_policy_signin_service_base.cc',
        'browser/policy/cloud/user_policy_signin_service_base.h',
        'browser/policy/cloud/user_policy_signin_service_factory.cc',
        'browser/policy/cloud/user_policy_signin_service_factory.h',
        'browser/policy/cloud/user_policy_signin_service_ios.h',
        'browser/policy/cloud/user_policy_signin_service_ios.mm',
        'browser/policy/configuration_policy_handler_android.cc',
        'browser/policy/configuration_policy_handler_android.h',
        'browser/policy/configuration_policy_handler_list_factory.cc',
        'browser/policy/configuration_policy_handler_list_factory.h',
        'browser/policy/file_selection_dialogs_policy_handler.cc',
        'browser/policy/file_selection_dialogs_policy_handler.h',
        'browser/policy/javascript_policy_handler.cc',
        'browser/policy/javascript_policy_handler.h',
        'browser/policy/policy_helpers.cc',
        'browser/policy/policy_helpers.h',
        'browser/policy/profile_policy_connector.cc',
        'browser/policy/profile_policy_connector_stub.cc',
        'browser/policy/profile_policy_connector.h',
        'browser/policy/profile_policy_connector_factory.cc',
        'browser/policy/profile_policy_connector_factory.h',
        'browser/policy/schema_registry_service.cc',
        'browser/policy/schema_registry_service.h',
        'browser/policy/schema_registry_service_factory.cc',
        'browser/policy/schema_registry_service_factory.h',
        'browser/precache/most_visited_urls_provider.cc',
        'browser/precache/most_visited_urls_provider.h',
        'browser/predictors/autocomplete_action_predictor.cc',
        'browser/predictors/autocomplete_action_predictor.h',
        'browser/predictors/autocomplete_action_predictor_factory.cc',
        'browser/predictors/autocomplete_action_predictor_factory.h',
        'browser/predictors/autocomplete_action_predictor_table.cc',
        'browser/predictors/autocomplete_action_predictor_table.h',
        'browser/predictors/logged_in_predictor_table.cc',
        'browser/predictors/logged_in_predictor_table.h',
        'browser/predictors/predictor_database.cc',
        'browser/predictors/predictor_database.h',
        'browser/predictors/predictor_database_factory.cc',
        'browser/predictors/predictor_database_factory.h',
        'browser/predictors/predictor_table_base.cc',
        'browser/predictors/predictor_table_base.h',
        'browser/pref_service_flags_storage.cc',
        'browser/pref_service_flags_storage.h',
        'browser/prefetch/prefetch.cc',
        'browser/prefetch/prefetch.h',
        'browser/prefetch/prefetch_field_trial.cc',
        'browser/prefetch/prefetch_field_trial.h',
        'browser/prefs/browser_prefs.cc',
        'browser/prefs/browser_prefs.h',
        'browser/prefs/chrome_pref_service_factory.cc',
        'browser/prefs/chrome_pref_service_factory.h',
        'browser/prefs/command_line_pref_store.cc',
        'browser/prefs/command_line_pref_store.h',
        'browser/prefs/incognito_mode_prefs.cc',
        'browser/prefs/incognito_mode_prefs.h',
        'browser/prefs/pref_hash_calculator.cc',
        'browser/prefs/pref_hash_calculator.h',
        'browser/prefs/pref_hash_filter.cc',
        'browser/prefs/pref_hash_filter.h',
        'browser/prefs/pref_hash_store.h',
        'browser/prefs/pref_hash_store_impl.cc',
        'browser/prefs/pref_hash_store_impl.h',
        'browser/prefs/pref_hash_store_transaction.h',
        'browser/prefs/pref_metrics_service.cc',
        'browser/prefs/pref_metrics_service.h',
        'browser/prefs/pref_model_associator.cc',
        'browser/prefs/pref_model_associator.h',
        'browser/prefs/pref_service_syncable.cc',
        'browser/prefs/pref_service_syncable.h',
        'browser/prefs/pref_service_syncable_factory.cc',
        'browser/prefs/pref_service_syncable_factory.h',
        'browser/prefs/pref_service_syncable_observer.h',
        'browser/prefs/proxy_config_dictionary.cc',
        'browser/prefs/proxy_config_dictionary.h',
        'browser/prefs/proxy_prefs.cc',
        'browser/prefs/proxy_prefs.h',
        'browser/prefs/session_startup_pref.cc',
        'browser/prefs/session_startup_pref.h',
        'browser/prefs/synced_pref_change_registrar.cc',
        'browser/prefs/synced_pref_change_registrar.h',
        'browser/prefs/synced_pref_observer.h',
        'browser/prefs/tracked/tracked_atomic_preference.cc',
        'browser/prefs/tracked/tracked_atomic_preference.h',
        'browser/prefs/tracked/tracked_preference.h',
        'browser/prefs/tracked/tracked_preference_helper.cc',
        'browser/prefs/tracked/tracked_preference_helper.h',
        'browser/prefs/tracked/tracked_split_preference.cc',
        'browser/prefs/tracked/tracked_split_preference.h',
        'browser/prerender/external_prerender_handler_android.cc',
        'browser/prerender/external_prerender_handler_android.h',
        'browser/prerender/prerender_condition.h',
        'browser/prerender/prerender_config.cc',
        'browser/prerender/prerender_config.h',
        'browser/prerender/prerender_contents.cc',
        'browser/prerender/prerender_contents.h',
        'browser/prerender/prerender_events.cc',
        'browser/prerender/prerender_events.h',
        'browser/prerender/prerender_field_trial.cc',
        'browser/prerender/prerender_field_trial.h',
        'browser/prerender/prerender_final_status.cc',
        'browser/prerender/prerender_final_status.h',
        'browser/prerender/prerender_handle.cc',
        'browser/prerender/prerender_handle.h',
        'browser/prerender/prerender_histograms.cc',
        'browser/prerender/prerender_histograms.h',
        'browser/prerender/prerender_history.cc',
        'browser/prerender/prerender_history.h',
        'browser/prerender/prerender_link_manager.cc',
        'browser/prerender/prerender_link_manager.h',
        'browser/prerender/prerender_link_manager_factory.cc',
        'browser/prerender/prerender_link_manager_factory.h',
        'browser/prerender/prerender_local_predictor.cc',
        'browser/prerender/prerender_local_predictor.h',
        'browser/prerender/prerender_manager.cc',
        'browser/prerender/prerender_manager.h',
        'browser/prerender/prerender_manager_factory.cc',
        'browser/prerender/prerender_manager_factory.h',
        'browser/prerender/prerender_message_filter.cc',
        'browser/prerender/prerender_message_filter.h',
        'browser/prerender/prerender_origin.cc',
        'browser/prerender/prerender_origin.h',
        'browser/prerender/prerender_pending_swap_throttle.cc',
        'browser/prerender/prerender_pending_swap_throttle.h',
        'browser/prerender/prerender_resource_throttle.cc',
        'browser/prerender/prerender_resource_throttle.h',
        'browser/prerender/prerender_tab_helper.cc',
        'browser/prerender/prerender_tab_helper.h',
        'browser/prerender/prerender_tracker.cc',
        'browser/prerender/prerender_tracker.h',
        'browser/prerender/prerender_util.cc',
        'browser/prerender/prerender_util.h',
        'browser/printing/background_printing_manager.cc',
        'browser/printing/background_printing_manager.h',
        'browser/printing/cloud_print/cloud_print_proxy_service.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service.h',
        'browser/printing/cloud_print/cloud_print_proxy_service_factory.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service_factory.h',
        'browser/printing/cloud_print/cloud_print_url.cc',
        'browser/printing/cloud_print/cloud_print_url.h',
        'browser/printing/print_dialog_cloud.cc',
        'browser/printing/print_dialog_cloud.h',
        'browser/printing/print_dialog_gtk.cc',
        'browser/printing/print_dialog_gtk.h',
        'browser/printing/print_error_dialog.cc',
        'browser/printing/print_error_dialog.h',
        'browser/printing/print_job.cc',
        'browser/printing/print_job.h',
        'browser/printing/print_job_manager.cc',
        'browser/printing/print_job_manager.h',
        'browser/printing/print_job_worker.cc',
        'browser/printing/print_job_worker.h',
        'browser/printing/print_job_worker_owner.h',
        'browser/printing/print_preview_context_menu_observer.cc',
        'browser/printing/print_preview_context_menu_observer.h',
        'browser/printing/print_preview_data_service.cc',
        'browser/printing/print_preview_data_service.h',
        'browser/printing/print_preview_dialog_controller.cc',
        'browser/printing/print_preview_dialog_controller.h',
        'browser/printing/print_preview_message_handler.cc',
        'browser/printing/print_preview_message_handler.h',
        'browser/printing/print_view_manager_base.cc',
        'browser/printing/print_view_manager_base.h',
        'browser/printing/print_view_manager_basic.cc',
        'browser/printing/print_view_manager_basic.h',
        'browser/printing/print_view_manager.cc',
        'browser/printing/print_view_manager.h',
        'browser/printing/print_view_manager_observer.h',
        'browser/printing/printer_manager_dialog.h',
        'browser/printing/printer_manager_dialog_linux.cc',
        'browser/printing/printer_manager_dialog_mac.mm',
        'browser/printing/printer_manager_dialog_win.cc',
        'browser/printing/printer_query.cc',
        'browser/printing/printer_query.h',
        'browser/printing/printing_message_filter.cc',
        'browser/printing/printing_message_filter.h',
        'browser/printing/printing_ui_web_contents_observer.cc',
        'browser/printing/printing_ui_web_contents_observer.h',
        'browser/process_info_snapshot.h',
        'browser/process_info_snapshot_mac.cc',
        'browser/process_singleton.h',
        'browser/process_singleton_linux.cc',
        'browser/process_singleton_mac.cc',
        'browser/process_singleton_modal_dialog_lock.cc',
        'browser/process_singleton_modal_dialog_lock.h',
        'browser/process_singleton_startup_lock.cc',
        'browser/process_singleton_startup_lock.h',
        'browser/process_singleton_win.cc',
        'browser/profile_resetter/automatic_profile_resetter.h',
        'browser/profile_resetter/automatic_profile_resetter.cc',
        'browser/profile_resetter/automatic_profile_resetter_delegate.h',
        'browser/profile_resetter/automatic_profile_resetter_delegate.cc',
        'browser/profile_resetter/automatic_profile_resetter_factory.h',
        'browser/profile_resetter/automatic_profile_resetter_factory.cc',
        'browser/profile_resetter/automatic_profile_resetter_mementos.h',
        'browser/profile_resetter/automatic_profile_resetter_mementos.cc',
        'browser/profile_resetter/brandcoded_default_settings.h',
        'browser/profile_resetter/brandcoded_default_settings.cc',
        'browser/profile_resetter/brandcode_config_fetcher.h',
        'browser/profile_resetter/brandcode_config_fetcher.cc',
        'browser/profile_resetter/profile_reset_global_error.h',
        'browser/profile_resetter/profile_reset_global_error.cc',
        'browser/profile_resetter/profile_resetter.h',
        'browser/profile_resetter/profile_resetter.cc',
        'browser/profile_resetter/jtl_foundation.h',
        'browser/profile_resetter/jtl_foundation.cc',
        'browser/profile_resetter/jtl_instructions.h',
        'browser/profile_resetter/jtl_interpreter.h',
        'browser/profile_resetter/jtl_interpreter.cc',
        'browser/profile_resetter/resettable_settings_snapshot.h',
        'browser/profile_resetter/resettable_settings_snapshot.cc',
        'browser/profiles/avatar_menu.cc',
        'browser/profiles/avatar_menu.h',
        'browser/profiles/avatar_menu_actions.h',
        'browser/profiles/avatar_menu_actions_desktop.h',
        'browser/profiles/avatar_menu_actions_desktop.cc',
        'browser/profiles/avatar_menu_desktop.cc',
        'browser/profiles/avatar_menu_observer.h',
        'browser/profiles/bookmark_model_loaded_observer.cc',
        'browser/profiles/bookmark_model_loaded_observer.h',
        'browser/profiles/chrome_browser_main_extra_parts_profiles.cc',
        'browser/profiles/chrome_browser_main_extra_parts_profiles.h',
        'browser/profiles/chrome_version_service.cc',
        'browser/profiles/chrome_version_service.h',
        'browser/profiles/file_path_verifier_win.cc',
        'browser/profiles/file_path_verifier_win.h',
        'browser/profiles/gaia_info_update_service.cc',
        'browser/profiles/gaia_info_update_service.h',
        'browser/profiles/gaia_info_update_service_factory.cc',
        'browser/profiles/gaia_info_update_service_factory.h',
        'browser/profiles/incognito_helpers.cc',
        'browser/profiles/incognito_helpers.h',
        'browser/profiles/incognito_mode_policy_handler.cc',
        'browser/profiles/incognito_mode_policy_handler.h',
        'browser/profiles/off_the_record_profile_impl.cc',
        'browser/profiles/off_the_record_profile_impl.h',
        'browser/profiles/off_the_record_profile_io_data.cc',
        'browser/profiles/off_the_record_profile_io_data.h',
        'browser/profiles/profile.cc',
        'browser/profiles/profile.h',
        'browser/profiles/profile_android.cc',
        'browser/profiles/profile_android.h',
        'browser/profiles/profile_destroyer.cc',
        'browser/profiles/profile_destroyer.h',
        'browser/profiles/profile_downloader.cc',
        'browser/profiles/profile_downloader.h',
        'browser/profiles/profile_downloader_delegate.h',
        'browser/profiles/profile_impl.cc',
        'browser/profiles/profile_impl.h',
        'browser/profiles/profile_impl_io_data.cc',
        'browser/profiles/profile_impl_io_data.h',
        'browser/profiles/profile_info_cache.cc',
        'browser/profiles/profile_info_cache.h',
        'browser/profiles/profile_info_cache_observer.h',
        'browser/profiles/profile_info_interface.h',
        'browser/profiles/profile_info_util.cc',
        'browser/profiles/profile_info_util.h',
        'browser/profiles/profile_io_data.cc',
        'browser/profiles/profile_io_data.h',
        'browser/profiles/profile_list.h',
        'browser/profiles/profile_list_desktop.cc',
        'browser/profiles/profile_list_desktop.h',
        'browser/profiles/profile_manager.cc',
        'browser/profiles/profile_manager.h',
        'browser/profiles/profile_metrics.cc',
        'browser/profiles/profile_metrics.h',
        'browser/profiles/profile_shortcut_manager.cc',
        'browser/profiles/profile_shortcut_manager.h',
        'browser/profiles/profile_shortcut_manager_stub.cc',
        'browser/profiles/profile_shortcut_manager_win.cc',
        'browser/profiles/profile_shortcut_manager_win.h',
        'browser/profiles/profile_window.cc',
        'browser/profiles/profile_window.h',
        'browser/profiles/profiles_state.cc',
        'browser/profiles/profiles_state.h',
        'browser/profiles/startup_task_runner_service.cc',
        'browser/profiles/startup_task_runner_service.h',
        'browser/profiles/startup_task_runner_service_factory.cc',
        'browser/profiles/startup_task_runner_service_factory.h',
        'browser/profiles/storage_partition_descriptor.h',
        'browser/remove_rows_table_model.h',
        'browser/renderer_host/chrome_render_message_filter.cc',
        'browser/renderer_host/chrome_render_message_filter.h',
        'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.h',
        'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.mm',
        'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper.h',
        'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper.mm',
        'browser/renderer_host/chrome_resource_dispatcher_host_delegate.cc',
        'browser/renderer_host/chrome_resource_dispatcher_host_delegate.h',
        'browser/renderer_host/offline_resource_throttle.cc',
        'browser/renderer_host/offline_resource_throttle.h',
        'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.cc',
        'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.h',
        'browser/renderer_host/pepper/device_id_fetcher.h',
        'browser/renderer_host/pepper/device_id_fetcher.cc',
        'browser/renderer_host/pepper/pepper_broker_message_filter.cc',
        'browser/renderer_host/pepper/pepper_broker_message_filter.h',
        'browser/renderer_host/pepper/pepper_extensions_common_message_filter.cc',
        'browser/renderer_host/pepper/pepper_extensions_common_message_filter.h',
        'browser/renderer_host/pepper/pepper_flash_browser_host.cc',
        'browser/renderer_host/pepper/pepper_flash_browser_host.h',
        'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.cc',
        'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.h',
        'browser/renderer_host/pepper/pepper_flash_drm_host.cc',
        'browser/renderer_host/pepper/pepper_flash_drm_host.h',
        'browser/renderer_host/pepper/pepper_isolated_file_system_message_filter.cc',
        'browser/renderer_host/pepper/pepper_isolated_file_system_message_filter.h',
        'browser/renderer_host/pepper/pepper_output_protection_message_filter.cc',
        'browser/renderer_host/pepper/pepper_output_protection_message_filter.h',
        'browser/renderer_host/pepper/pepper_platform_verification_message_filter.cc',
        'browser/renderer_host/pepper/pepper_platform_verification_message_filter.h',
        'browser/renderer_host/pepper/pepper_talk_host.cc',
        'browser/renderer_host/pepper/pepper_talk_host.h',
        'browser/renderer_host/safe_browsing_resource_throttle.cc',
        'browser/renderer_host/safe_browsing_resource_throttle.h',
        'browser/renderer_host/safe_browsing_resource_throttle_factory.cc',
        'browser/renderer_host/safe_browsing_resource_throttle_factory.h',
        'browser/renderer_host/web_cache_manager.cc',
        'browser/renderer_host/web_cache_manager.h',
        'browser/renderer_preferences_util.cc',
        'browser/renderer_preferences_util.h',
        'browser/repost_form_warning_controller.cc',
        'browser/repost_form_warning_controller.h',
        'browser/resources_util.cc',
        'browser/resources_util.h',
        'browser/rlz/rlz.cc',
        'browser/rlz/rlz.h',
        'browser/safe_browsing/browser_feature_extractor.cc',
        'browser/safe_browsing/browser_feature_extractor.h',
        'browser/safe_browsing/browser_features.cc',
        'browser/safe_browsing/browser_features.h',
        'browser/safe_browsing/chunk_range.cc',
        'browser/safe_browsing/chunk_range.h',
        'browser/safe_browsing/client_side_detection_host.cc',
        'browser/safe_browsing/client_side_detection_host.h',
        'browser/safe_browsing/client_side_detection_service.cc',
        'browser/safe_browsing/client_side_detection_service.h',
        'browser/safe_browsing/database_manager.cc',
        'browser/safe_browsing/database_manager.h',
        'browser/safe_browsing/download_feedback.cc',
        'browser/safe_browsing/download_feedback.h',
        'browser/safe_browsing/download_feedback_service.cc',
        'browser/safe_browsing/download_feedback_service.h',
        'browser/safe_browsing/download_protection_service.cc',
        'browser/safe_browsing/download_protection_service.h',
        'browser/safe_browsing/malware_details.cc',
        'browser/safe_browsing/malware_details.h',
        'browser/safe_browsing/malware_details_cache.cc',
        'browser/safe_browsing/malware_details_cache.h',
        'browser/safe_browsing/malware_details_history.cc',
        'browser/safe_browsing/malware_details_history.h',
        'browser/safe_browsing/ping_manager.cc',
        'browser/safe_browsing/ping_manager.h',
        'browser/safe_browsing/prefix_set.cc',
        'browser/safe_browsing/prefix_set.h',
        'browser/safe_browsing/protocol_manager.cc',
        'browser/safe_browsing/protocol_manager.h',
        'browser/safe_browsing/protocol_manager_helper.cc',
        'browser/safe_browsing/protocol_manager_helper.h',
        'browser/safe_browsing/protocol_parser.cc',
        'browser/safe_browsing/protocol_parser.h',
        'browser/safe_browsing/safe_browsing_blocking_page.cc',
        'browser/safe_browsing/safe_browsing_blocking_page.h',
        'browser/safe_browsing/safe_browsing_database.cc',
        'browser/safe_browsing/safe_browsing_database.h',
        'browser/safe_browsing/safe_browsing_service.cc',
        'browser/safe_browsing/safe_browsing_service.h',
        'browser/safe_browsing/safe_browsing_store.cc',
        'browser/safe_browsing/safe_browsing_store.h',
        'browser/safe_browsing/safe_browsing_store_file.cc',
        'browser/safe_browsing/safe_browsing_store_file.h',
        'browser/safe_browsing/safe_browsing_tab_observer.cc',
        'browser/safe_browsing/safe_browsing_tab_observer.h',
        'browser/safe_browsing/safe_browsing_util.cc',
        'browser/safe_browsing/safe_browsing_util.h',
        'browser/safe_browsing/sandboxed_zip_analyzer.cc',
        'browser/safe_browsing/sandboxed_zip_analyzer.h',
        'browser/safe_browsing/signature_util_posix.cc',
        'browser/safe_browsing/signature_util_win.cc',
        'browser/safe_browsing/signature_util.h',
        'browser/safe_browsing/two_phase_uploader.cc',
        'browser/safe_browsing/two_phase_uploader.h',
        'browser/safe_browsing/ui_manager.cc',
        'browser/safe_browsing/ui_manager.h',
        'browser/safe_json_parser.cc',
        'browser/safe_json_parser.h',
        'browser/screensaver_window_finder_x11.cc',
        'browser/screensaver_window_finder_x11.h',
        'browser/search/hotword_service.cc',
        'browser/search/hotword_service.h',
        'browser/search/hotword_service_factory.cc',
        'browser/search/hotword_service_factory.h',
        'browser/search/iframe_source.cc',
        'browser/search/iframe_source.h',
        'browser/search/instant_io_context.cc',
        'browser/search/instant_io_context.h',
        'browser/search/instant_service.cc',
        'browser/search/instant_service.h',
        'browser/search/instant_service_factory.cc',
        'browser/search/instant_service_factory.h',
        'browser/search/instant_service_observer.cc',
        'browser/search/instant_service_observer.h',
        'browser/search/local_ntp_source.cc',
        'browser/search/local_ntp_source.h',
        'browser/search/most_visited_iframe_source.cc',
        'browser/search/most_visited_iframe_source.h',
        'browser/search/search.cc',
        'browser/search/search.h',
        'browser/search/search_terms_tracker.cc',
        'browser/search/search_terms_tracker.h',
        'browser/search/suggestions/suggestions_service.cc',
        'browser/search/suggestions/suggestions_service.h',
        'browser/search/suggestions/suggestions_service_factory.cc',
        'browser/search/suggestions/suggestions_service_factory.h',
        'browser/search_engines/default_search_policy_handler.cc',
        'browser/search_engines/default_search_policy_handler.h',
        'browser/search_engines/search_engine_type.h',
        'browser/search_engines/search_host_to_urls_map.cc',
        'browser/search_engines/search_host_to_urls_map.h',
        'browser/search_engines/search_provider_install_data.cc',
        'browser/search_engines/search_provider_install_data.h',
        'browser/search_engines/search_provider_install_state_message_filter.cc',
        'browser/search_engines/search_provider_install_state_message_filter.h',
        'browser/search_engines/search_terms_data.cc',
        'browser/search_engines/search_terms_data.h',
        'browser/search_engines/search_terms_data_android.cc',
        'browser/search_engines/search_terms_data_android.h',
        'browser/search_engines/template_url.cc',
        'browser/search_engines/template_url.h',
        'browser/search_engines/template_url_fetcher.cc',
        'browser/search_engines/template_url_fetcher.h',
        'browser/search_engines/template_url_fetcher_callbacks.h',
        'browser/search_engines/template_url_fetcher_factory.cc',
        'browser/search_engines/template_url_fetcher_factory.h',
        'browser/search_engines/template_url_id.h',
        'browser/search_engines/template_url_parser.cc',
        'browser/search_engines/template_url_parser.h',
        'browser/search_engines/template_url_prepopulate_data.cc',
        'browser/search_engines/template_url_prepopulate_data.h',
        'browser/search_engines/template_url_service.cc',
        'browser/search_engines/template_url_service.h',
        'browser/search_engines/template_url_service_android.cc',
        'browser/search_engines/template_url_service_android.h',
        'browser/search_engines/template_url_service_factory.cc',
        'browser/search_engines/template_url_service_factory.h',
        'browser/search_engines/template_url_service_observer.h',
        'browser/search_engines/util.cc',
        'browser/search_engines/util.h',
        'browser/services/gcm/gcm_client_factory.cc',
        'browser/services/gcm/gcm_client_factory.h',
        'browser/services/gcm/gcm_event_router.h',
        'browser/services/gcm/gcm_profile_service.cc',
        'browser/services/gcm/gcm_profile_service.h',
        'browser/services/gcm/gcm_profile_service_factory.cc',
        'browser/services/gcm/gcm_profile_service_factory.h',
        'browser/service_process/service_process_control.cc',
        'browser/service_process/service_process_control_mac.mm',
        'browser/service_process/service_process_control.h',
        'browser/sessions/base_session_service.cc',
        'browser/sessions/base_session_service.h',
        'browser/sessions/persistent_tab_restore_service.cc',
        'browser/sessions/persistent_tab_restore_service.h',
        'browser/sessions/restore_on_startup_policy_handler.cc',
        'browser/sessions/restore_on_startup_policy_handler.h',
        'browser/sessions/session_backend.cc',
        'browser/sessions/session_backend.h',
        'browser/sessions/session_command.cc',
        'browser/sessions/session_command.h',
        'browser/sessions/session_data_deleter.cc',
        'browser/sessions/session_data_deleter.h',
        'browser/sessions/session_id.cc',
        'browser/sessions/session_id.h',
        'browser/sessions/session_restore.cc',
        'browser/sessions/session_restore.h',
        'browser/sessions/session_restore_android.cc',
        'browser/sessions/session_service.cc',
        'browser/sessions/session_service.h',
        'browser/sessions/session_service_factory.cc',
        'browser/sessions/session_service_factory.h',
        'browser/sessions/session_tab_helper.cc',
        'browser/sessions/session_tab_helper.h',
        'browser/sessions/session_types.cc',
        'browser/sessions/session_types.h',
        'browser/sessions/tab_restore_service.cc',
        'browser/sessions/tab_restore_service.h',
        'browser/sessions/tab_restore_service_factory.cc',
        'browser/sessions/tab_restore_service_factory.h',
        'browser/sessions/tab_restore_service_helper.cc',
        'browser/sessions/tab_restore_service_helper.h',
        'browser/shell_integration.cc',
        'browser/shell_integration.h',
        'browser/shell_integration_android.cc',
        'browser/shell_integration_chromeos.cc',
        'browser/shell_integration_linux.cc',
        'browser/shell_integration_linux.h',
        'browser/shell_integration_mac.mm',
        'browser/shell_integration_win.cc',
        'browser/signin/about_signin_internals.cc',
        'browser/signin/about_signin_internals.h',
        'browser/signin/about_signin_internals_factory.cc',
        'browser/signin/about_signin_internals_factory.h',
        'browser/signin/account_reconcilor.cc',
        'browser/signin/account_reconcilor.h',
        'browser/signin/account_reconcilor_factory.cc',
        'browser/signin/account_reconcilor_factory.h',
        'browser/signin/chrome_signin_manager_delegate.cc',
        'browser/signin/chrome_signin_manager_delegate.h',
        'browser/signin/local_auth.cc',
        'browser/signin/local_auth.h',
        'browser/signin/mutable_profile_oauth2_token_service.cc',
        'browser/signin/mutable_profile_oauth2_token_service.h',
        'browser/signin/principals_message_filter.cc',
        'browser/signin/principals_message_filter.h',
        'browser/signin/profile_oauth2_token_service.cc',
        'browser/signin/profile_oauth2_token_service.h',
        'browser/signin/profile_oauth2_token_service_factory.cc',
        'browser/signin/profile_oauth2_token_service_factory.h',
        'browser/signin/profile_oauth2_token_service_request.cc',
        'browser/signin/profile_oauth2_token_service_request.h',
        'browser/signin/signin_account_id_helper.cc',
        'browser/signin/signin_account_id_helper.h',
        'browser/signin/signin_global_error.cc',
        'browser/signin/signin_global_error.h',
        'browser/signin/signin_internals_util.cc',
        'browser/signin/signin_internals_util.h',
        'browser/signin/signin_manager.cc',
        'browser/signin/signin_manager.h',
        'browser/signin/signin_manager_base.cc',
        'browser/signin/signin_manager_base.h',
        'browser/signin/signin_manager_factory.cc',
        'browser/signin/signin_manager_factory.h',
        'browser/signin/signin_names_io_thread.cc',
        'browser/signin/signin_names_io_thread.h',
        'browser/signin/signin_oauth_helper.cc',
        'browser/signin/signin_oauth_helper.h',
        'browser/signin/signin_header_helper.cc',
        'browser/signin/signin_header_helper.h',
        'browser/signin/signin_tracker.cc',
        'browser/signin/signin_tracker.h',
        'browser/signin/signin_promo.cc',
        'browser/signin/signin_promo.h',
        'browser/signin/signin_ui_util.cc',
        'browser/signin/signin_ui_util.h',
        'browser/site_details.cc',
        'browser/site_details.h',
        'browser/speech/chrome_speech_recognition_manager_delegate.cc',
        'browser/speech/chrome_speech_recognition_manager_delegate.h',
        'browser/speech/chrome_speech_recognition_manager_delegate_bubble_ui.cc',
        'browser/speech/chrome_speech_recognition_manager_delegate_bubble_ui.h',
        'browser/speech/extension_api/tts_extension_api_constants.cc',
        'browser/speech/extension_api/tts_extension_api_constants.h',
        'browser/speech/speech_recognition_bubble.cc',
        'browser/speech/speech_recognition_bubble.h',
        'browser/speech/speech_recognition_bubble_controller.cc',
        'browser/speech/speech_recognition_bubble_controller.h',
        'browser/speech/tts_android.cc',
        'browser/speech/tts_android.h',
        'browser/speech/tts_chromeos.cc',
        'browser/speech/tts_controller.cc',
        'browser/speech/tts_controller.h',
        'browser/speech/tts_extension_loader_chromeos.cc',
        'browser/speech/tts_extension_loader_chromeos.h',
        'browser/speech/tts_linux.cc',
        'browser/speech/tts_mac.mm',
        'browser/speech/tts_platform.cc',
        'browser/speech/tts_platform.h',
        'browser/speech/tts_message_filter.cc',
        'browser/speech/tts_message_filter.h',
        'browser/speech/tts_win.cc',
        'browser/spellchecker/feedback.cc',
        'browser/spellchecker/feedback.h',
        'browser/spellchecker/feedback_sender.cc',
        'browser/spellchecker/feedback_sender.h',
        'browser/spellchecker/misspelling.cc',
        'browser/spellchecker/misspelling.h',
        'browser/spellchecker/spellcheck_action.cc',
        'browser/spellchecker/spellcheck_action.h',
        'browser/spellchecker/spellcheck_custom_dictionary.cc',
        'browser/spellchecker/spellcheck_custom_dictionary.h',
        'browser/spellchecker/spellcheck_dictionary.h',
        'browser/spellchecker/spellcheck_factory.cc',
        'browser/spellchecker/spellcheck_factory.h',
        'browser/spellchecker/spellcheck_host_metrics.cc',
        'browser/spellchecker/spellcheck_host_metrics.h',
        'browser/spellchecker/spellcheck_hunspell_dictionary.cc',
        'browser/spellchecker/spellcheck_hunspell_dictionary.h',
        'browser/spellchecker/spellcheck_message_filter.cc',
        'browser/spellchecker/spellcheck_message_filter.h',
        'browser/spellchecker/spellcheck_message_filter_mac.cc',
        'browser/spellchecker/spellcheck_message_filter_mac.h',
        'browser/spellchecker/spellcheck_platform_mac.h',
        'browser/spellchecker/spellcheck_platform_mac.mm',
        'browser/spellchecker/spellcheck_service.cc',
        'browser/spellchecker/spellcheck_service.h',
        'browser/spellchecker/spelling_service_client.cc',
        'browser/spellchecker/spelling_service_client.h',
        'browser/spellchecker/word_trimmer.cc',
        'browser/spellchecker/word_trimmer.h',
        'browser/ssl/ssl_add_certificate.cc',
        'browser/ssl/ssl_add_certificate.h',
        'browser/ssl/ssl_add_cert_handler.cc',
        'browser/ssl/ssl_add_cert_handler.h',
        'browser/ssl/ssl_add_cert_handler_mac.mm',
        'browser/ssl/ssl_blocking_page.cc',
        'browser/ssl/ssl_blocking_page.h',
        'browser/ssl/ssl_client_auth_observer.cc',
        'browser/ssl/ssl_client_auth_observer.h',
        'browser/ssl/ssl_client_certificate_selector.h',
        'browser/ssl/ssl_error_info.cc',
        'browser/ssl/ssl_error_info.h',
        'browser/ssl/ssl_tab_helper.cc',
        'browser/ssl/ssl_tab_helper.h',
        'browser/status_icons/desktop_notification_balloon.cc',
        'browser/status_icons/desktop_notification_balloon.h',
        'browser/status_icons/status_icon.cc',
        'browser/status_icons/status_icon.h',
        'browser/status_icons/status_icon_menu_model.cc',
        'browser/status_icons/status_icon_menu_model.h',
        'browser/status_icons/status_icon_observer.h',
        'browser/status_icons/status_tray.cc',
        'browser/status_icons/status_tray.h',
        'browser/sxs_linux.cc',
        'browser/sxs_linux.h',
        'browser/sync/about_sync_util.cc',
        'browser/sync/about_sync_util.h',
        'browser/sync/backend_migrator.cc',
        'browser/sync/backend_migrator.h',
        'browser/sync/backend_unrecoverable_error_handler.cc',
        'browser/sync/backend_unrecoverable_error_handler.h',
        'browser/sync/open_tabs_ui_delegate.cc',
        'browser/sync/open_tabs_ui_delegate.h',
        'browser/sync/glue/autofill_data_type_controller.cc',
        'browser/sync/glue/autofill_data_type_controller.h',
        'browser/sync/glue/autofill_profile_data_type_controller.cc',
        'browser/sync/glue/autofill_profile_data_type_controller.h',
        'browser/sync/glue/bookmark_change_processor.cc',
        'browser/sync/glue/bookmark_change_processor.h',
        'browser/sync/glue/bookmark_data_type_controller.cc',
        'browser/sync/glue/bookmark_data_type_controller.h',
        'browser/sync/glue/bookmark_model_associator.cc',
        'browser/sync/glue/bookmark_model_associator.h',
        'browser/sync/glue/browser_thread_model_worker.cc',
        'browser/sync/glue/browser_thread_model_worker.h',
        'browser/sync/glue/change_processor.cc',
        'browser/sync/glue/change_processor.h',
        'browser/sync/glue/chrome_report_unrecoverable_error.cc',
        'browser/sync/glue/chrome_report_unrecoverable_error.h',
        'browser/sync/glue/data_type_manager_impl.cc',
        'browser/sync/glue/data_type_manager_impl.h',
        'browser/sync/glue/device_info.cc',
        'browser/sync/glue/device_info.h',
        'browser/sync/glue/extension_data_type_controller.cc',
        'browser/sync/glue/extension_data_type_controller.h',
        'browser/sync/glue/extension_setting_data_type_controller.cc',
        'browser/sync/glue/extension_setting_data_type_controller.h',
        'browser/sync/glue/extensions_activity_monitor.cc',
        'browser/sync/glue/extensions_activity_monitor.h',
        'browser/sync/glue/favicon_cache.cc',
        'browser/sync/glue/favicon_cache.h',
        'browser/sync/glue/frontend_data_type_controller.cc',
        'browser/sync/glue/frontend_data_type_controller.h',
        'browser/sync/glue/generic_change_processor.cc',
        'browser/sync/glue/generic_change_processor.h',
        'browser/sync/glue/history_model_worker.cc',
        'browser/sync/glue/history_model_worker.h',
        'browser/sync/glue/non_frontend_data_type_controller.cc',
        'browser/sync/glue/non_frontend_data_type_controller.h',
        'browser/sync/glue/non_ui_data_type_controller.cc',
        'browser/sync/glue/non_ui_data_type_controller.h',
        'browser/sync/glue/password_change_processor.cc',
        'browser/sync/glue/password_change_processor.h',
        'browser/sync/glue/password_data_type_controller.cc',
        'browser/sync/glue/password_data_type_controller.h',
        'browser/sync/glue/password_model_associator.cc',
        'browser/sync/glue/password_model_associator.h',
        'browser/sync/glue/password_model_worker.cc',
        'browser/sync/glue/password_model_worker.h',
        'browser/sync/glue/search_engine_data_type_controller.cc',
        'browser/sync/glue/search_engine_data_type_controller.h',
        'browser/sync/glue/session_change_processor.cc',
        'browser/sync/glue/session_change_processor.h',
        'browser/sync/glue/session_data_type_controller.cc',
        'browser/sync/glue/session_data_type_controller.h',
        'browser/sync/glue/session_model_associator.cc',
        'browser/sync/glue/session_model_associator.h',
        'browser/sync/glue/shared_change_processor.cc',
        'browser/sync/glue/shared_change_processor.h',
        'browser/sync/glue/shared_change_processor_ref.cc',
        'browser/sync/glue/shared_change_processor_ref.h',
        'browser/sync/glue/sync_backend_host.cc',
        'browser/sync/glue/sync_backend_host.h',
        'browser/sync/glue/sync_backend_host_core.cc',
        'browser/sync/glue/sync_backend_host_core.h',
        'browser/sync/glue/sync_backend_host_impl.cc',
        'browser/sync/glue/sync_backend_host_impl.h',
        'browser/sync/glue/sync_backend_registrar.cc',
        'browser/sync/glue/sync_backend_registrar.h',
        'browser/sync/glue/sync_start_util.cc',
        'browser/sync/glue/sync_start_util.h',
        'browser/sync/glue/synced_device_tracker.cc',
        'browser/sync/glue/synced_device_tracker.h',
        'browser/sync/glue/synced_session.cc',
        'browser/sync/glue/synced_session.h',
        'browser/sync/glue/synced_session_tracker.cc',
        'browser/sync/glue/synced_session_tracker.h',
        'browser/sync/glue/synced_tab_delegate.cc',
        'browser/sync/glue/synced_tab_delegate_android.cc',
        'browser/sync/glue/synced_tab_delegate_android.h',
        'browser/sync/glue/synced_window_delegate.h',
        'browser/sync/glue/synced_window_delegate_android.cc',
        'browser/sync/glue/synced_window_delegate_android.h',
        'browser/sync/glue/tab_node_pool.cc',
        'browser/sync/glue/tab_node_pool.h',
        'browser/sync/glue/theme_data_type_controller.cc',
        'browser/sync/glue/theme_data_type_controller.h',
        'browser/sync/glue/typed_url_change_processor.cc',
        'browser/sync/glue/typed_url_change_processor.h',
        'browser/sync/glue/typed_url_data_type_controller.cc',
        'browser/sync/glue/typed_url_data_type_controller.h',
        'browser/sync/glue/typed_url_model_associator.cc',
        'browser/sync/glue/typed_url_model_associator.h',
        'browser/sync/glue/ui_data_type_controller.cc',
        'browser/sync/glue/ui_data_type_controller.h',
        'browser/sync/glue/ui_model_worker.cc',
        'browser/sync/glue/ui_model_worker.h',
        'browser/sync/profile_sync_components_factory.h',
        'browser/sync/profile_sync_components_factory_impl.cc',
        'browser/sync/profile_sync_components_factory_impl.h',
        'browser/sync/profile_sync_service.cc',
        'browser/sync/profile_sync_service.h',
        'browser/sync/profile_sync_service_android.cc',
        'browser/sync/profile_sync_service_android.h',
        'browser/sync/profile_sync_service_base.h',
        'browser/sync/profile_sync_service_base.cc',
        'browser/sync/profile_sync_service_factory.cc',
        'browser/sync/profile_sync_service_factory.h',
        'browser/sync/profile_sync_service_model_type_selection_android.h',
        'browser/sync/profile_sync_service_observer.cc',
        'browser/sync/profile_sync_service_observer.h',
        'browser/sync/sessions2/notification_service_sessions_router.cc',
        'browser/sync/sessions2/notification_service_sessions_router.h',
        'browser/sync/sessions2/session_data_type_controller2.cc',
        'browser/sync/sessions2/session_data_type_controller2.h',
        'browser/sync/sessions2/sessions_sync_manager.cc',
        'browser/sync/sessions2/sessions_sync_manager.h',
        'browser/sync/sessions2/sessions_util.cc',
        'browser/sync/sessions2/sessions_util.h',
        'browser/sync/sessions2/synced_window_delegates_getter.cc',
        'browser/sync/sessions2/synced_window_delegates_getter.h',
        'browser/sync/sessions2/tab_node_pool2.cc',
        'browser/sync/sessions2/tab_node_pool2.h',
        'browser/sync/sync_global_error.cc',
        'browser/sync/sync_global_error.h',
        'browser/sync/sync_policy_handler.cc',
        'browser/sync/sync_policy_handler.h',
        'browser/sync/sync_prefs.cc',
        'browser/sync/sync_prefs.h',
        'browser/sync/sync_startup_tracker.cc',
        'browser/sync/sync_startup_tracker.h',
        'browser/sync/sync_ui_util.cc',
        'browser/sync/sync_ui_util.h',
        'browser/sync_file_system/conflict_resolution_policy.h',
        'browser/sync_file_system/conflict_resolution_resolver.cc',
        'browser/sync_file_system/conflict_resolution_resolver.h',
        'browser/sync_file_system/drive_backend/conflict_resolver.cc',
        'browser/sync_file_system/drive_backend/conflict_resolver.h',
        'browser/sync_file_system/drive_backend/drive_backend_constants.cc',
        'browser/sync_file_system/drive_backend/drive_backend_constants.h',
        'browser/sync_file_system/drive_backend/drive_backend_util.cc',
        'browser/sync_file_system/drive_backend/drive_backend_util.h',
        'browser/sync_file_system/drive_backend/folder_creator.cc',
        'browser/sync_file_system/drive_backend/folder_creator.h',
        'browser/sync_file_system/drive_backend/list_changes_task.cc',
        'browser/sync_file_system/drive_backend/list_changes_task.h',
        'browser/sync_file_system/drive_backend/local_to_remote_syncer.cc',
        'browser/sync_file_system/drive_backend/local_to_remote_syncer.h',
        'browser/sync_file_system/drive_backend/metadata_database.cc',
        'browser/sync_file_system/drive_backend/metadata_database.h',
        'browser/sync_file_system/drive_backend/metadata_db_migration_util.cc',
        'browser/sync_file_system/drive_backend/metadata_db_migration_util.h',
        'browser/sync_file_system/drive_backend/register_app_task.cc',
        'browser/sync_file_system/drive_backend/register_app_task.h',
        'browser/sync_file_system/drive_backend/remote_to_local_syncer.cc',
        'browser/sync_file_system/drive_backend/remote_to_local_syncer.h',
        'browser/sync_file_system/drive_backend/sync_engine.cc',
        'browser/sync_file_system/drive_backend/sync_engine.h',
        'browser/sync_file_system/drive_backend/sync_engine_context.h',
        'browser/sync_file_system/drive_backend/sync_engine_initializer.cc',
        'browser/sync_file_system/drive_backend/sync_engine_initializer.h',
        'browser/sync_file_system/drive_backend/tracker_set.cc',
        'browser/sync_file_system/drive_backend/tracker_set.h',
        'browser/sync_file_system/drive_backend/uninstall_app_task.cc',
        'browser/sync_file_system/drive_backend/uninstall_app_task.h',
        'browser/sync_file_system/drive_backend_v1/api_util.cc',
        'browser/sync_file_system/drive_backend_v1/api_util.h',
        'browser/sync_file_system/drive_backend_v1/api_util_interface.h',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_service.cc',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_service.h',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_util.cc',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_util.h',
        'browser/sync_file_system/drive_backend_v1/drive_metadata_store.cc',
        'browser/sync_file_system/drive_backend_v1/drive_metadata_store.h',
        'browser/sync_file_system/drive_backend_v1/local_sync_delegate.cc',
        'browser/sync_file_system/drive_backend_v1/local_sync_delegate.h',
        'browser/sync_file_system/drive_backend_v1/local_sync_operation_resolver.cc',
        'browser/sync_file_system/drive_backend_v1/local_sync_operation_resolver.h',
        'browser/sync_file_system/drive_backend_v1/origin_operation_queue.cc',
        'browser/sync_file_system/drive_backend_v1/origin_operation_queue.h',
        'browser/sync_file_system/drive_backend_v1/remote_change_handler.cc',
        'browser/sync_file_system/drive_backend_v1/remote_change_handler.h',
        'browser/sync_file_system/drive_backend_v1/remote_sync_delegate.cc',
        'browser/sync_file_system/drive_backend_v1/remote_sync_delegate.h',
        'browser/sync_file_system/drive_backend_v1/remote_sync_operation_resolver.cc',
        'browser/sync_file_system/drive_backend_v1/remote_sync_operation_resolver.h',
        'browser/sync_file_system/file_change.cc',
        'browser/sync_file_system/file_change.h',
        'browser/sync_file_system/file_status_observer.h',
        'browser/sync_file_system/local/local_file_change_tracker.cc',
        'browser/sync_file_system/local/local_file_change_tracker.h',
        'browser/sync_file_system/local/local_file_sync_context.cc',
        'browser/sync_file_system/local/local_file_sync_context.h',
        'browser/sync_file_system/local/local_file_sync_service.cc',
        'browser/sync_file_system/local/local_file_sync_service.h',
        'browser/sync_file_system/local/local_file_sync_status.cc',
        'browser/sync_file_system/local/local_file_sync_status.h',
        'browser/sync_file_system/local/local_origin_change_observer.h',
        'browser/sync_file_system/local/root_delete_helper.cc',
        'browser/sync_file_system/local/root_delete_helper.h',
        'browser/sync_file_system/local/sync_file_system_backend.cc',
        'browser/sync_file_system/local/sync_file_system_backend.h',
        'browser/sync_file_system/local/syncable_file_operation_runner.cc',
        'browser/sync_file_system/local/syncable_file_operation_runner.h',
        'browser/sync_file_system/local/syncable_file_system_operation.cc',
        'browser/sync_file_system/local/syncable_file_system_operation.h',
        'browser/sync_file_system/local_change_processor.h',
        'browser/sync_file_system/logger.cc',
        'browser/sync_file_system/logger.h',
        'browser/sync_file_system/remote_change_processor.h',
        'browser/sync_file_system/remote_file_sync_service.cc',
        'browser/sync_file_system/remote_file_sync_service.h',
        'browser/sync_file_system/sync_action.cc',
        'browser/sync_file_system/sync_action.h',
        'browser/sync_file_system/sync_callbacks.h',
        'browser/sync_file_system/sync_direction.h',
        'browser/sync_file_system/sync_event_observer.h',
        'browser/sync_file_system/sync_file_metadata.cc',
        'browser/sync_file_system/sync_file_metadata.h',
        'browser/sync_file_system/sync_file_status.h',
        'browser/sync_file_system/sync_file_system_service.cc',
        'browser/sync_file_system/sync_file_system_service.h',
        'browser/sync_file_system/sync_file_system_service_factory.cc',
        'browser/sync_file_system/sync_file_system_service_factory.h',
        'browser/sync_file_system/sync_file_type.h',
        'browser/sync_file_system/sync_operation_type.cc',
        'browser/sync_file_system/sync_operation_type.h',
        'browser/sync_file_system/sync_process_runner.cc',
        'browser/sync_file_system/sync_process_runner.h',
        'browser/sync_file_system/sync_service_state.h',
        'browser/sync_file_system/sync_status_code.cc',
        'browser/sync_file_system/sync_status_code.h',
        'browser/sync_file_system/sync_task.h',
        'browser/sync_file_system/sync_task_manager.cc',
        'browser/sync_file_system/sync_task_manager.h',
        'browser/sync_file_system/syncable_file_system_util.cc',
        'browser/sync_file_system/syncable_file_system_util.h',
        'browser/tab_contents/background_contents.cc',
        'browser/tab_contents/background_contents.h',
        'browser/tab_contents/navigation_metrics_recorder.cc',
        'browser/tab_contents/navigation_metrics_recorder.h',
        'browser/tab_contents/render_view_context_menu.cc',
        'browser/tab_contents/render_view_context_menu.h',
        'browser/tab_contents/render_view_context_menu_observer.cc',
        'browser/tab_contents/render_view_context_menu_observer.h',
        'browser/tab_contents/retargeting_details.h',
        'browser/tab_contents/tab_util.cc',
        'browser/tab_contents/tab_util.h',
        'browser/tab_contents/spellchecker_submenu_observer.h',
        'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
        'browser/tab_contents/spellchecker_submenu_observer_mac.cc',
        'browser/tab_contents/spelling_bubble_model.cc',
        'browser/tab_contents/spelling_bubble_model.h',
        'browser/tab_contents/spelling_menu_observer.cc',
        'browser/tab_contents/spelling_menu_observer.h',
        'browser/task_manager/background_resource_provider.cc',
        'browser/task_manager/background_resource_provider.h',
        'browser/task_manager/browser_process_resource_provider.cc',
        'browser/task_manager/browser_process_resource_provider.h',
        'browser/task_manager/child_process_resource_provider.cc',
        'browser/task_manager/child_process_resource_provider.h',
        'browser/task_manager/extension_process_resource_provider.cc',
        'browser/task_manager/extension_process_resource_provider.h',
        'browser/task_manager/guest_resource_provider.cc',
        'browser/task_manager/guest_resource_provider.h',
        'browser/task_manager/notification_resource_provider.cc',
        'browser/task_manager/notification_resource_provider.h',
        'browser/task_manager/panel_resource_provider.cc',
        'browser/task_manager/panel_resource_provider.h',
        'browser/task_manager/renderer_resource.cc',
        'browser/task_manager/renderer_resource.h',
        'browser/task_manager/resource_provider.cc',
        'browser/task_manager/resource_provider.h',
        'browser/task_manager/tab_contents_resource_provider.cc',
        'browser/task_manager/tab_contents_resource_provider.h',
        'browser/task_manager/task_manager.cc',
        'browser/task_manager/task_manager.h',
        'browser/task_manager/task_manager_util.cc',
        'browser/task_manager/task_manager_util.h',
        'browser/task_manager/worker_resource_provider.cc',
        'browser/task_manager/worker_resource_provider.h',
        'browser/task_profiler/auto_tracking.cc',
        'browser/task_profiler/auto_tracking.h',
        'browser/task_profiler/task_profiler_data_serializer.cc',
        'browser/task_profiler/task_profiler_data_serializer.h',
        'browser/themes/browser_theme_pack.cc',
        'browser/themes/browser_theme_pack.h',
        'browser/themes/custom_theme_supplier.cc',
        'browser/themes/custom_theme_supplier.h',
        'browser/themes/theme_properties.cc',
        'browser/themes/theme_properties.h',
        'browser/themes/theme_service.cc',
        'browser/themes/theme_service_factory.cc',
        'browser/themes/theme_service_factory.h',
        'browser/themes/theme_service.h',
        'browser/themes/theme_service_aurax11.cc',
        'browser/themes/theme_service_aurax11.h',
        'browser/themes/theme_service_gtk.cc',
        'browser/themes/theme_service_mac.mm',
        'browser/themes/theme_syncable_service.cc',
        'browser/themes/theme_syncable_service.h',
        'browser/three_d_api_observer.cc',
        'browser/three_d_api_observer.h',
        'browser/thumbnails/content_analysis.cc',
        'browser/thumbnails/content_analysis.h',
        'browser/thumbnails/content_based_thumbnailing_algorithm.cc',
        'browser/thumbnails/content_based_thumbnailing_algorithm.h',
        'browser/thumbnails/simple_thumbnail_crop.cc',
        'browser/thumbnails/simple_thumbnail_crop.h',
        'browser/thumbnails/thumbnail_service.h',
        'browser/thumbnails/thumbnail_service_factory.cc',
        'browser/thumbnails/thumbnail_service_factory.h',
        'browser/thumbnails/thumbnail_service_impl.cc',
        'browser/thumbnails/thumbnail_service_impl.h',
        'browser/thumbnails/thumbnail_tab_helper.cc',
        'browser/thumbnails/thumbnail_tab_helper.h',
        'browser/thumbnails/thumbnailing_algorithm.h',
        'browser/thumbnails/thumbnailing_context.cc',
        'browser/thumbnails/thumbnailing_context.h',
        'browser/translate/options_menu_model.cc',
        'browser/translate/options_menu_model.h',
        'browser/translate/translate_accept_languages_factory.cc',
        'browser/translate/translate_accept_languages_factory.h',
        'browser/translate/translate_infobar_delegate.cc',
        'browser/translate/translate_infobar_delegate.h',
        'browser/translate/translate_manager.cc',
        'browser/translate/translate_manager.h',
        'browser/translate/translate_service.cc',
        'browser/translate/translate_service.h',
        'browser/translate/translate_tab_helper.cc',
        'browser/translate/translate_tab_helper.h',
        'browser/translate/translate_ui_delegate.cc',
        'browser/translate/translate_ui_delegate.h',
        'browser/undo/bookmark_renumber_observer.h',
        'browser/undo/bookmark_undo_service.cc',
        'browser/undo/bookmark_undo_service.h',
        'browser/undo/bookmark_undo_service_factory.cc',
        'browser/undo/bookmark_undo_service_factory.h',
        'browser/undo/bookmark_undo_utils.cc',
        'browser/undo/bookmark_undo_utils.h',
        'browser/undo/undo_manager.cc',
        'browser/undo/undo_manager.h',
        'browser/undo/undo_operation.h',
        'browser/upgrade_detector.cc',
        'browser/upgrade_detector.h',
        'browser/upgrade_detector_impl.cc',
        'browser/upgrade_detector_impl.h',
        'browser/upload_list.cc',
        'browser/upload_list.h',
        'browser/usb/usb_device.cc',
        'browser/usb/usb_device.h',
        'browser/usb/usb_device_handle.cc',
        'browser/usb/usb_device_handle.h',
        'browser/usb/usb_interface.cc',
        'browser/usb/usb_interface.h',
        'browser/usb/usb_context.cc',
        'browser/usb/usb_context.h',
        'browser/usb/usb_service.cc',
        'browser/usb/usb_service.h',
        'browser/value_store/leveldb_value_store.cc',
        'browser/value_store/leveldb_value_store.h',
        'browser/value_store/testing_value_store.cc',
        'browser/value_store/testing_value_store.h',
        'browser/value_store/value_store.cc',
        'browser/value_store/value_store.h',
        'browser/value_store/value_store_change.cc',
        'browser/value_store/value_store_change.h',
        'browser/value_store/value_store_frontend.cc',
        'browser/value_store/value_store_frontend.h',
        'browser/value_store/value_store_util.cc',
        'browser/value_store/value_store_util.h',
        'browser/web_applications/web_app.cc',
        'browser/web_applications/web_app.h',
        'browser/web_applications/web_app_android.cc',
        'browser/web_applications/web_app_chromeos.cc',
        'browser/web_applications/web_app_linux.cc',
        'browser/web_applications/web_app_mac.h',
        'browser/web_applications/web_app_mac.mm',
        'browser/web_applications/web_app_win.h',
        'browser/web_applications/web_app_win.cc',
        'browser/web_resource/eula_accepted_notifier.cc',
        'browser/web_resource/eula_accepted_notifier.h',
        'browser/web_resource/json_asynchronous_unpacker.cc',
        'browser/web_resource/json_asynchronous_unpacker.h',
        'browser/web_resource/notification_promo.cc',
        'browser/web_resource/notification_promo.h',
        'browser/web_resource/promo_resource_service.cc',
        'browser/web_resource/promo_resource_service.h',
        'browser/web_resource/resource_request_allowed_notifier.cc',
        'browser/web_resource/resource_request_allowed_notifier.h',
        'browser/web_resource/web_resource_service.cc',
        'browser/web_resource/web_resource_service.h',
        'browser/webdata/autocomplete_syncable_service.cc',
        'browser/webdata/autocomplete_syncable_service.h',
        'browser/webdata/keyword_table.cc',
        'browser/webdata/keyword_table.h',
        'browser/webdata/logins_table.cc',
        'browser/webdata/logins_table.h',
        'browser/webdata/logins_table_win.cc',
        'browser/webdata/web_apps_table.cc',
        'browser/webdata/web_apps_table.h',
        'browser/webdata/web_data_service.cc',
        'browser/webdata/web_data_service.h',
        'browser/webdata/web_data_service_factory.cc',
        'browser/webdata/web_data_service_factory.h',
        'browser/webdata/web_data_service_win.cc',
        'browser/webdata/web_intents_table.cc',
        'browser/webdata/web_intents_table.h',

        # These files are generated by GRIT.
        '<(grit_out_dir)/grit/component_extension_resources_map.cc',
        '<(grit_out_dir)/grit/theme_resources_map.cc',
        '<(SHARED_INTERMEDIATE_DIR)/ui/ui_resources/grit/ui_resources_map.cc',
      ],
      'conditions': [
        ['OS != "ios"', {
          'dependencies': [
            'apps',
            'browser/performance_monitor/performance_monitor.gyp:performance_monitor',
            'browser_extensions',
            'common/extensions/api/api.gyp:api',
            'debugger',
            'installer_util',
            'sync_file_system_drive_proto',
            'sync_file_system_proto',
            '../third_party/re2/re2.gyp:re2',
            '../cc/cc.gyp:cc',
            '../components/components.gyp:autofill_content_browser',
            '../components/components.gyp:browser_context_keyed_service',
            '../components/components.gyp:dom_distiller_content',
            '../components/components.gyp:navigation_interception',
            '../components/components.gyp:precache_content',
            '../components/components.gyp:sessions',
            '../components/components.gyp:storage_monitor',
            '../components/components.gyp:translate_content_browser',
            '../components/components.gyp:url_matcher',
            '../components/components.gyp:visitedlink_browser',
            '../components/components.gyp:visitedlink_common',
            '../components/components.gyp:web_modal',
            '../media/media.gyp:media',
            '../net/net.gyp:net_with_v8',
            # TODO(tonyg): Remove this dependency (crbug.com/280157).
            '../testing/perf/perf_test.gyp:*',
            '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
            '../third_party/expat/expat.gyp:expat',
            '../third_party/hunspell/hunspell.gyp:hunspell',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
            '../third_party/libusb/libusb.gyp:libusb',
            '../third_party/libyuv/libyuv.gyp:libyuv',
            '../third_party/npapi/npapi.gyp:npapi',
            '../third_party/webrtc/modules/modules.gyp:desktop_capture',
            '../ui/gl/gl.gyp:gl',
            '../ui/surface/surface.gyp:surface',
            '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/common/webkit_common.gyp:webkit_common',
            '../webkit/storage_browser.gyp:webkit_storage_browser',
            '../webkit/storage_common.gyp:webkit_storage_common',
            '../webkit/webkit_resources.gyp:webkit_resources',
          ],
          'defines': [
            '<@(nacl_defines)',
          ],
          'direct_dependent_settings': {
            'defines': [
              '<@(nacl_defines)',
            ],
          },
        }, {  # OS == "ios"
          'dependencies': [
            '../net/net.gyp:net',
          ],
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^browser/browser_process\\.cc$'],
            ['include', '^browser/browser_process_platform_part_base\\.cc$'],
            ['include', '^browser/google/'],
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/CoreTelephony.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreText.framework',
              '$(SDKROOT)/System/Library/Frameworks/MobileCoreServices.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
            ],
            # CoreImage is iOS 5+, but iOS 4.3 is still supported.
            'xcode_settings': {'OTHER_LDFLAGS': ['-weak_framework CoreImage']},
          },
        }],
        ['enable_printing!=0', {
          'dependencies': [
            '../printing/printing.gyp:printing',
          ],
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [
            'browser/media_galleries/fileapi/iapps_data_provider.cc',
            'browser/media_galleries/fileapi/iapps_data_provider.h',
            'browser/media_galleries/fileapi/file_path_watcher_util.cc',
            'browser/media_galleries/fileapi/file_path_watcher_util.h',
            'browser/media_galleries/fileapi/itunes_data_provider.cc',
            'browser/media_galleries/fileapi/itunes_data_provider.h',
            'browser/media_galleries/fileapi/itunes_file_util.cc',
            'browser/media_galleries/fileapi/itunes_file_util.h',
            'browser/media_galleries/fileapi/picasa_data_provider.cc',
            'browser/media_galleries/fileapi/picasa_data_provider.h',
            'browser/media_galleries/fileapi/picasa_file_util.cc',
            'browser/media_galleries/fileapi/picasa_file_util.h',
            'browser/media_galleries/fileapi/safe_iapps_library_parser.cc',
            'browser/media_galleries/fileapi/safe_iapps_library_parser.h',
            'browser/media_galleries/fileapi/safe_itunes_pref_parser_win.cc',
            'browser/media_galleries/fileapi/safe_itunes_pref_parser_win.h',
            'browser/media_galleries/fileapi/safe_picasa_album_table_reader.cc',
            'browser/media_galleries/fileapi/safe_picasa_album_table_reader.h',
            'browser/media_galleries/fileapi/safe_picasa_albums_indexer.cc',
            'browser/media_galleries/fileapi/safe_picasa_albums_indexer.h',
          ],
        }],
        ['OS!="android" and OS!="ios" and chromeos==0 and configuration_policy==1', {
          'sources': [
            'browser/download/download_dir_policy_handler.cc',
            'browser/download/download_dir_policy_handler.h',
            'browser/net/disk_cache_dir_policy_handler.cc',
            'browser/net/disk_cache_dir_policy_handler.h',
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            'app_shim',
          ],
          'sources': [
            'browser/media_galleries/fileapi/iphoto_data_provider.cc',
            'browser/media_galleries/fileapi/iphoto_data_provider.h',
            'browser/media_galleries/fileapi/iphoto_file_util.cc',
            'browser/media_galleries/fileapi/iphoto_file_util.h',
          ],
        }],
        ['enable_extensions==1', {
          'sources': [
            # Only extension API implementations should go here.
            'browser/accessibility/accessibility_extension_api.cc',
            'browser/accessibility/accessibility_extension_api.h',
            'browser/infobars/infobar_extension_api.cc',
            'browser/infobars/infobar_extension_api.h',
            'browser/speech/extension_api/tts_extension_api.cc',
            'browser/speech/extension_api/tts_extension_api.h',
            'browser/speech/extension_api/tts_engine_extension_api.cc',
            'browser/speech/extension_api/tts_engine_extension_api.h',
          ],
        }, {
          'sources!': [
            'browser/content_settings/content_settings_custom_extension_provider.cc',
            'browser/content_settings/content_settings_custom_extension_provider.h',
            'browser/content_settings/content_settings_internal_extension_provider.cc',
            'browser/content_settings/content_settings_internal_extension_provider.h',
          ],
        }],
        ['enable_background==0', {
          'sources/': [
            ['exclude', '^browser/background/'],
          ],
        }],
        ['enable_task_manager==0', {
          'sources/': [
            ['exclude', '^browser/task_manager/'],
          ],
        }],
        ['enable_spellcheck==0', {
          'sources/': [
             ['exclude', '^browser/spellchecker/'],
          ],
          'dependencies!': [
            '../third_party/hunspell/hunspell.gyp:hunspell',
          ],
        }],
        ['disable_nacl==0', {
          'sources': [
            'browser/nacl_host/nacl_browser_delegate_impl.cc',
            'browser/nacl_host/nacl_browser_delegate_impl.h',
            'browser/nacl_host/nacl_infobar_delegate.cc',
            'browser/nacl_host/nacl_infobar_delegate.h',
          ],
          'dependencies': [
            '../components/nacl.gyp:nacl_browser',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['configuration_policy==1', {
          'sources!': [
            'browser/policy/profile_policy_connector_stub.cc',
          ],
          'dependencies': [
            '../components/components.gyp:cloud_policy_proto',
            '../components/components.gyp:policy',
          ],
          'conditions': [
            ['OS!="android" and OS!="ios"', {
              'dependencies': [
                'policy_path_parser',
              ],
            }],
            ['OS=="ios"', {
              # Explicitly add the browser/policy files that should be included
              # on iOS builds.
              'sources/': [
                ['include', '^browser/net/proxy_policy_handler.cc'],
                ['include', '^browser/net/proxy_policy_handler.h'],
                ['include', '^browser/policy/cloud/cloud_policy_invalidator.cc'],
                ['include', '^browser/policy/cloud/cloud_policy_invalidator.h'],
                ['include', '^browser/policy/cloud/policy_header_service_factory.cc'],
                ['include', '^browser/policy/cloud/policy_header_service_factory.h'],
                ['include', '^browser/policy/cloud/user_cloud_policy_invalidator.cc'],
                ['include', '^browser/policy/cloud/user_cloud_policy_invalidator.h'],
                ['include', '^browser/policy/cloud/user_cloud_policy_invalidator_factory.cc'],
                ['include', '^browser/policy/cloud/user_cloud_policy_invalidator_factory.h'],
                ['include', '^browser/policy/cloud/user_cloud_policy_manager_factory.cc'],
                ['include', '^browser/policy/cloud/user_cloud_policy_manager_factory.h'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_base.cc'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_base.h'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_factory.cc'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_factory.h'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_ios.h'],
                ['include', '^browser/policy/cloud/user_policy_signin_service_ios.mm'],
                ['include', '^browser/policy/configuration_policy_handler_list_factory.cc'],
                ['include', '^browser/policy/configuration_policy_handler_list_factory.h'],
                ['include', '^browser/policy/policy_helpers.cc'],
                ['include', '^browser/policy/policy_helpers.h'],
                ['include', '^browser/policy/profile_policy_connector.cc'],
                ['include', '^browser/policy/profile_policy_connector.h'],
                ['include', '^browser/policy/profile_policy_connector_factory.cc'],
                ['include', '^browser/policy/profile_policy_connector_factory.h'],
                ['include', '^browser/policy/schema_registry_service.cc'],
                ['include', '^browser/policy/schema_registry_service.h'],
                ['include', '^browser/policy/schema_registry_service_factory.cc'],
                ['include', '^browser/policy/schema_registry_service_factory.h'],
                ['include', '^browser/profiles/incognito_mode_policy_handler.cc'],
                ['include', '^browser/profiles/incognito_mode_policy_handler.h'],
                ['include', '^browser/search_engines/default_search_policy_handler.cc'],
                ['include', '^browser/search_engines/default_search_policy_handler.h'],
              ],
            }],
          ],
        }, {  # configuration_policy==0
          'sources/': [
            ['exclude', '^browser/policy/'],
            ['exclude', '^browser/net/disk_cache_dir_policy_handler.cc'],
            ['exclude', '^browser/net/disk_cache_dir_policy_handler.h'],
            ['exclude', '^browser/net/proxy_policy_handler.cc'],
            ['exclude', '^browser/net/proxy_policy_handler.h'],
            ['exclude', '^browser/profiles/incognito_mode_policy_handler.cc'],
            ['exclude', '^browser/profiles/incognito_mode_policy_handler.h'],
            ['exclude', '^browser/search_engines/default_search_policy_handler.cc'],
            ['exclude', '^browser/search_engines/default_search_policy_handler.h'],
            ['exclude', '^browser/sessions/restore_on_startup_policy_handler.cc'],
            ['exclude', '^browser/sessions/restore_on_startup_policy_handler.h'],
            ['exclude', '^browser/sync/sync_policy_handler.cc'],
            ['exclude', '^browser/sync/sync_policy_handler.h'],
            ['include', '^browser/policy/profile_policy_connector_stub.cc'],
            ['include', '^browser/policy/profile_policy_connector.h'],
            ['include', '^browser/policy/profile_policy_connector_factory.cc'],
            ['include', '^browser/policy/profile_policy_connector_factory.h'],
          ],
        }],
        ['enable_plugins==1', {
          'dependencies': [
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
          ],
        }, {  # enable_plugins==0
          'sources/': [
            ['exclude', '^browser/guestview/webview/plugin_permission_helper'],
            ['exclude', '^browser/pepper_'],
            ['exclude', '^browser/plugins/'],
            ['exclude', '^browser/renderer_host/pepper/'],
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }],
        ['safe_browsing==2', {
          'defines': [
            'MOBILE_SAFE_BROWSING',
          ],
          'dependencies!': [
            'safe_browsing_proto',
          ],
          'sources!': [
            'browser/download/download_completion_blocker.cc',
            'browser/download/download_completion_blocker.h',
            'browser/renderer_host/safe_browsing_resource_throttle.cc',
            'browser/renderer_host/safe_browsing_resource_throttle.h',
          ],
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['include', '^browser/safe_browsing/malware_details.cc'],
            ['include', '^browser/safe_browsing/malware_details.h'],
            ['include', '^browser/safe_browsing/malware_details_cache.cc'],
            ['include', '^browser/safe_browsing/malware_details_cache.h'],
            ['include', '^browser/safe_browsing/malware_details_history.cc'],
            ['include', '^browser/safe_browsing/malware_details_history.h'],
            ['include', '^browser/safe_browsing/ping_manager.cc'],
            ['include', '^browser/safe_browsing/ping_manager.h'],
            ['include', '^browser/safe_browsing/protocol_manager_helper.cc'],
            ['include', '^browser/safe_browsing/protocol_manager_helper.h'],
            ['include', '^browser/safe_browsing/safe_browsing_blocking_page.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_blocking_page.h'],
            ['include', '^browser/safe_browsing/safe_browsing_service.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_service.h'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.h'],
            ['include', '^browser/safe_browsing/safe_browsing_util.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_util.h'],
            ['include', '^browser/safe_browsing/ui_manager.cc'],
            ['include', '^browser/safe_browsing/ui_manager.h'],
          ],
        }],
        ['safe_browsing==0', {
          'dependencies!': [
            'safe_browsing_proto',
            'safe_browsing_report_proto',
          ],
          'sources!': [
            'browser/download/download_completion_blocker.cc',
            'browser/download/download_completion_blocker.h',
            'browser/renderer_host/safe_browsing_resource_throttle.cc',
            'browser/renderer_host/safe_browsing_resource_throttle.h',
            'browser/renderer_host/safe_browsing_resource_throttle_factory.cc',
            'browser/renderer_host/safe_browsing_resource_throttle_factory.h',
          ],
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.h'],
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:udev',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:mtp_file_entry_proto',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:mtp_storage_info_proto',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:device_media_transfer_protocol',
          ],
        }],
        ['OS=="linux" and chromeos==0', {
          'dependencies': [
            '../build/linux/system.gyp:libspeechd',
          ],
        }],
        ['chromeos==0', {
          'sources!': [
            'browser/extensions/api/input_ime/input_ime_api.cc',
            'browser/extensions/api/input_ime/input_ime_api.h',
            'browser/extensions/api/terminal/terminal_extension_helper.cc',
            'browser/extensions/api/terminal/terminal_extension_helper.h',
            'browser/extensions/api/terminal/terminal_private_api.cc',
            'browser/extensions/api/terminal/terminal_private_api.h',
            'browser/renderer_host/offline_resource_throttle.cc',
            'browser/renderer_host/offline_resource_throttle.h',
            'browser/renderer_host/pepper/pepper_platform_verification_message_filter.cc',
            'browser/renderer_host/pepper/pepper_platform_verification_message_filter.h',
          ],
        }, {  # chromeos==1
          'dependencies': [
            'browser_chromeos',
          ],
          'sources!': [
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            'browser/first_run/upgrade_util_linux.cc',
            'browser/icon_loader_auralinux.cc',
            'browser/icon_loader_linux.cc',
            'browser/icon_manager_linux.cc',
            'browser/idle_linux.cc',
            'browser/notifications/balloon_collection.cc',
            'browser/notifications/balloon_collection.h',
            'browser/notifications/balloon_collection_base.cc',
            'browser/notifications/balloon_collection_base.h',
            'browser/notifications/balloon_collection_impl.cc',
            'browser/notifications/balloon_collection_impl.h',
            'browser/notifications/balloon_host.cc',
            'browser/notifications/balloon_host.h',
            'browser/notifications/balloon_notification_ui_manager.cc',
            'browser/notifications/balloon_notification_ui_manager.h',
            'browser/notifications/notification_options_menu_model.cc',
            'browser/notifications/notification_options_menu_model.h',
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
            'browser/password_manager/native_backend_kwallet_x.cc',
            'browser/password_manager/native_backend_kwallet_x.h',
            'browser/platform_util_linux.cc',
            'browser/policy/cloud/user_cloud_policy_manager_factory.cc',
            'browser/policy/cloud/user_cloud_policy_manager_factory.h',
            'browser/policy/cloud/user_policy_signin_service.cc',
            'browser/policy/cloud/user_policy_signin_service.h',
            'browser/policy/cloud/user_policy_signin_service_base.cc',
            'browser/policy/cloud/user_policy_signin_service_base.h',
            'browser/policy/cloud/user_policy_signin_service_factory.cc',
            'browser/policy/cloud/user_policy_signin_service_factory.h',
            'browser/profiles/avatar_menu_desktop.cc',
            'browser/profiles/avatar_menu_actions_desktop.cc',
            'browser/profiles/avatar_menu_actions_desktop.h',
            'browser/profiles/profile_list_desktop.cc',
            'browser/profiles/profile_list_desktop.h',
            'browser/screensaver_window_finder_x11.cc',
            'browser/screensaver_window_finder_x11.h',
            'browser/shell_integration_linux.cc',
            'browser/shell_integration_linux.h',
            'browser/signin/signin_manager.cc',
            'browser/speech/tts_linux.cc',
            'browser/sxs_linux.cc',
            'browser/sxs_linux.h',
            'browser/task_manager/notification_resource_provider.cc',
            'browser/task_manager/notification_resource_provider.h',
            'browser/themes/theme_service_aurax11.cc',
            'browser/themes/theme_service_aurax11.h',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',
            'browser/web_applications/web_app_linux.cc',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_gnome_keyring==0', {
          'sources!': [
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
          ],
        }, {
          'dependencies': [
            '../build/linux/system.gyp:gnome_keyring',
          ],
        }],
        ['use_aura==1', {
          'sources/': [
            ['exclude', '^browser/automation/testing_automation_provider_win.cc'],
            ['exclude', '^browser/icon_loader_linux.cc'],
            ['exclude', '^browser/lifetime/application_lifetime_stub.cc'],
            ['exclude', '^browser/renderer_host/render_widget_host_view_views*'],
          ],
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
            '../ui/compositor/compositor.gyp:compositor',
            '../ui/keyboard/keyboard.gyp:keyboard',
          ],
          'conditions': [
            ['OS=="win"', {
              'sources/': [
                ['exclude', '^browser/automation/automation_provider_aura.cc'],
                ['exclude', '^browser/background/background_mode_manager_aura.cc'],
              ],
              'dependencies': [
                'launcher_support',
                '../ui/metro_viewer/metro_viewer.gyp:metro_viewer_messages',
                '../win8/win8.gyp:metro_viewer',
              ],
            }],
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['use_x11==1', {
          'dependencies': [
            '../build/linux/system.gyp:xscrnsaver',
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios"', {
          'sources': [
            'app/chrome_breakpad_client.cc',
            'app/chrome_breakpad_client.h',
          ],
          'dependencies': [
            '../components/components.gyp:breakpad_component',
            '../components/components.gyp:breakpad_host',
          ],
        }],
        ['use_nss==1', {
          'sources': [
            'third_party/mozilla_security_manager/nsNSSCertHelper.cpp',
            'third_party/mozilla_security_manager/nsNSSCertHelper.h',
            'third_party/mozilla_security_manager/nsNSSCertificate.cpp',
            'third_party/mozilla_security_manager/nsNSSCertificate.h',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.cpp',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.h',
          ],
        }, {  # use_nss==0
          'sources!': [
            'browser/certificate_manager_model.cc',
            'browser/certificate_manager_model.h',
            'browser/net/nss_context_chromeos.cc',
            'browser/net/nss_context_linux.cc',
            'browser/net/nss_context.cc',
            'browser/net/nss_context.h',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:ssl',
            '../build/linux/system.gyp:x11',
            '../dbus/dbus.gyp:dbus',
            '../third_party/undoview/undoview.gyp:undoview',
          ],
          'sources': [
            'browser/printing/printing_gtk_util.cc',
            'browser/printing/printing_gtk_util.h',
          ],
          'conditions': [
            ['OS=="linux"', {
              'link_settings': {
                'libraries': [
                  # For dlsym() in 'browser/zygote_main_linux.cc'
                  '-ldl',
                ],
              },
            }],
          ],
        }],
        ['input_speech==0', {
          'sources/': [
            ['exclude', '^browser/speech/chrome_speech_recognition_manager_delegate_bubble_ui'],
            ['exclude', '^browser/speech/speech_recognition_bubble'],
          ],
        }],
        ['notifications==0', {
          'sources/': [
            ['exclude', '^browser/notifications/'],
          ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/sync/glue/theme_data_type_controller.cc',
          ],
          'sources/': [
            ['exclude', '^browser/themes/'],
          ],
        }],
        ['enable_automation!=1', {
          'sources/': [
            ['exclude', '^browser/automation/'],
          ],
        }],
        ['enable_printing==0', {
          'sources/': [
            ['exclude', '^browser/printing/'],
          ],
        }],
        ['enable_printing==1', {
          'sources/': [
            ['exclude', '^browser/printing/print_view_manager_basic.*'],
          ],
        }],
        ['enable_printing==2', {
          'sources/': [
            ['exclude', '^browser/printing/background_printing_manager.*'],
            ['exclude', '^browser/printing/print_view_manager.cc'],
            ['exclude', '^browser/printing/print_error_dialog.*'],
            ['exclude', '^browser/printing/print_preview.*'],
            ['exclude', '^browser/printing/print_view_manager.cc'],
            ['exclude', '^browser/printing/print_view_manager.h'],
            ['exclude', '^browser/printing/printer_manager_dialog.*'],
          ],
        }],
        ['enable_captive_portal_detection!=1', {
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
          ],
        }],
        ['enable_session_service!=1', {
          'sources!': [
            'browser/sessions/session_restore.cc',
            'browser/sessions/session_service.cc',
            'browser/sessions/session_service.h',
            'browser/sessions/session_service_factory.cc',
            'browser/sessions/session_service_factory.h',
          ],
        }],
        ['OS=="android" or OS=="ios"', {
          'sources!': [
            'browser/chrome_browser_field_trials_desktop.cc',
            'browser/chrome_browser_field_trials_desktop.h',
          ],
        }, {  # OS!="android" and OS!="ios"
          'sources!': [
            'browser/chrome_browser_field_trials_mobile.cc',
            'browser/chrome_browser_field_trials_mobile.h',
            'browser/metrics/variations/variations_request_scheduler_mobile.cc',
            'browser/metrics/variations/variations_request_scheduler_mobile.h',
            'browser/net/spdyproxy/data_reduction_proxy_settings.cc',
            'browser/net/spdyproxy/data_reduction_proxy_settings.h',
            'browser/net/spdyproxy/proxy_advisor.cc',
            'browser/net/spdyproxy/proxy_advisor.h',
          ],
        }],
        ['OS=="android"', {
          'dependencies': [
            '../components/components.gyp:web_contents_delegate_android',
            'chrome_browser_jni_headers',
          ],
          'dependencies!': [
            '../components/components.gyp:storage_monitor',
            '../components/components.gyp:web_modal',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
            '../third_party/libusb/libusb.gyp:libusb',
          ],
          'sources': [
            'browser/sessions/in_memory_tab_restore_service.cc',
            'browser/sessions/in_memory_tab_restore_service.h',
            'browser/signin/android_profile_oauth2_token_service.cc',
            'browser/signin/android_profile_oauth2_token_service.h',
            'browser/ssl/ssl_add_certificate_android.cc',
            'browser/web_resource/notification_promo_mobile_ntp.cc',
            'browser/web_resource/notification_promo_mobile_ntp.h',
            'browser/media/protected_media_identifier_infobar_delegate.cc',
            'browser/media/protected_media_identifier_infobar_delegate.h',
            'browser/media/protected_media_identifier_permission_context.cc',
            'browser/media/protected_media_identifier_permission_context.h',
            'browser/media/protected_media_identifier_permission_context_factory.cc',
            'browser/media/protected_media_identifier_permission_context_factory.h',
          ],
          'sources!': [
            # Bookmark export/import are handled via the BookmarkColumns
            # ContentProvider.
            'browser/bookmarks/bookmark_html_writer.cc',
            'browser/ssl/ssl_add_certificate.cc',

            'browser/jankometer.cc',
            'browser/sync/sync_global_error.cc',
            'browser/sync/sync_global_error.h',

            'browser/download/download_crx_util.cc',
            'browser/policy/cloud/user_policy_signin_service.cc',
            'browser/policy/cloud/user_policy_signin_service.h',
            'browser/sessions/persistent_tab_restore_service.cc',
            'browser/sessions/persistent_tab_restore_service.h',
            'browser/sessions/session_backend.cc',
            'browser/sessions/session_backend.h',
            'browser/tab_contents/background_contents.cc',
            'browser/tab_contents/background_contents.h',
            'browser/tab_contents/render_view_context_menu.cc',
            'browser/tab_contents/render_view_context_menu.h',
            'browser/tab_contents/render_view_context_menu_observer.cc',
            'browser/tab_contents/render_view_context_menu_observer.h',
            'browser/tab_contents/spellchecker_submenu_observer.h',
            'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
            'browser/tab_contents/spelling_bubble_model.cc',
            'browser/tab_contents/spelling_bubble_model.h',
            'browser/tab_contents/spelling_menu_observer.cc',
            'browser/tab_contents/spelling_menu_observer.h',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',

            # Not used by Android
            'browser/accessibility/accessibility_events.cc',
            'browser/accessibility/accessibility_extension_api_constants.cc',
            'browser/accessibility/invert_bubble_prefs.cc',
            'browser/auto_launch_trial.cc',
            'browser/certificate_viewer.cc',
            'browser/chrome_browser_main_posix.cc',
            'browser/chrome_browser_main_posix.h',
            'browser/chrome_process_singleton.cc',
            'browser/component_updater/pnacl/pnacl_profile_observer.cc',
            'browser/component_updater/widevine_cdm_component_installer.cc',
            'browser/custom_home_pages_table_model.cc',
            'browser/download/download_danger_prompt.cc',
            'browser/download/download_shelf.cc',
            'browser/download/download_shelf_context_menu.cc',
            'browser/drive/drive_switches.cc',
            'browser/external_protocol/external_protocol_observer.cc',
            'browser/feedback/proto/annotations.proto',
            'browser/feedback/proto/chrome.proto',
            'browser/feedback/proto/common.proto',
            'browser/feedback/proto/dom.proto',
            'browser/feedback/proto/math.proto',
            'browser/gpu/chrome_gpu_util.cc',
            'browser/idle_android.cc',
            'browser/idle.cc',
            'browser/lifetime/application_lifetime_stub.cc',
            'browser/lifetime/browser_close_manager.cc',
            'browser/net/predictor_tab_helper.cc',
            'browser/parsers/metadata_parser_jpeg.cc',
            'browser/parsers/metadata_parser_jpeg_factory.cc',
            'browser/parsers/metadata_parser_manager.cc',
            'browser/process_singleton.cc',
            'browser/process_singleton_modal_dialog_lock.cc',
            'browser/process_singleton_startup_lock.cc',
            'browser/profiles/profile_shortcut_manager.cc',
            'browser/repost_form_warning_controller.cc',
            'browser/search/search_terms_tracker.cc',
            'browser/sessions/session_command.cc',
            'browser/speech/extension_api/tts_extension_api_constants.cc',
            'browser/ssl/ssl_add_cert_handler.cc',
            'browser/ssl/ssl_client_auth_observer.cc',
            'browser/status_icons/desktop_notification_balloon.cc',
            'browser/signin/mutable_profile_oauth2_token_service.cc',
            'browser/signin/mutable_profile_oauth2_token_service.h',
            'browser/signin/signin_ui_util.cc',
            'browser/sync/profile_sync_service_base.cc',
            'browser/sync/sync_ui_util.cc',
            'browser/sync/sync_ui_util.h',
            'browser/undo/bookmark_undo_service.cc',
            'browser/undo/bookmark_undo_service_factory.cc',
            'browser/undo/bookmark_undo_utils.cc',
            'browser/undo/undo_manager.cc',
            'browser/web_applications/web_app_android.cc',
            'test/base/test_switches.cc',

            # Android uses a different invalidation service
            'browser/invalidation/gcm_network_channel_delegate_impl.cc',
            'browser/invalidation/gcm_network_channel_delegate_impl.h',
            'browser/invalidation/ticl_invalidation_service.cc',
            'browser/invalidation/ticl_invalidation_service.h',

            'browser/sync/glue/synced_tab_delegate.cc',
          ],
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
            ['exclude', '^browser/diagnostics/'],
            ['exclude', '^browser/first_run/'],
            ['exclude', '^browser/importer/'],
            ['exclude', '^browser/media_galleries/'],
            ['exclude', '^browser/net/firefox_*'],
            ['exclude', '^browser/profile_resetter/'],
            ['exclude', '^browser/service/'],
            ['exclude', '^browser/sync/glue/app_'],
            ['exclude', '^browser/sync/glue/extension_'],
            ['exclude', '^browser/sync/glue/theme_'],
            ['exclude', '^browser/usb/'],
            ['exclude', '^third_party/mozilla_security_manager/'],
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            '../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
            '../third_party/mozilla/mozilla.gyp:mozilla',
          ],
          'sources!': [
            'browser/automation/automation_provider_list_generic.cc',
            'browser/first_run/upgrade_util.cc',
            'browser/jankometer.cc',
            'browser/lifetime/application_lifetime_stub.cc',
            'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Accelerate.framework',
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/AudioUnit.framework',
              '$(SDKROOT)/System/Library/Frameworks/DiskArbitration.framework',
              '$(SDKROOT)/System/Library/Frameworks/IOKit.framework',
              '$(SDKROOT)/System/Library/Frameworks/ImageCaptureCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/SecurityInterface.framework',
            ],
          },
        }],
        ['enable_rlz==1', {
          'dependencies': [
            '../rlz/rlz.gyp:rlz_lib',
          ],
        }, {  # enable_rlz!=1
          'sources/': [
            # Exclude all of rlz.
            ['exclude', '^browser/rlz/'],
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'chrome_process_finder',
            'installer_util_strings',
            '../chrome/chrome.gyp:chrome_version_header',
            '../chrome_elf/chrome_elf.gyp:chrome_elf',
            '../chrome_elf/chrome_elf.gyp:chrome_elf_constants',
            '../chrome_elf/chrome_elf.gyp:dll_hash',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
            '../win8/win8.gyp:win8_util',
          ],
          'export_dependent_settings': [
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'sources!': [
            'browser/first_run/first_run_dialog.h',
            'browser/lifetime/application_lifetime_stub.cc',
            'browser/profiles/profile_shortcut_manager_stub.cc',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'sources/': [
            # Exclude files that should be excluded for all non-Windows platforms.
            ['exclude', '^browser/first_run/try_chrome_dialog_view.cc'],
            ['exclude', '^browser/first_run/try_chrome_dialog_view.h'],

            # Exclude all of hang_monitor.
            ['exclude', '^browser/hang_monitor/'],
          ],
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../ui/views/controls/webview/webview.gyp:webview',
                '../ui/views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                ['include', '^browser/printing/print_dialog_cloud.cc'],
                ['include', '^browser/printing/print_dialog_cloud.h'],
              ],
            }],
            ['gcc_version == 45', {
              # Avoid gcc 4.5 miscompilation of template_url.cc
              # as per http://crbug.com/41887
              'cflags': [
                '-fno-ipa-cp',
              ],
            }],
          ],
        }],
        ['OS=="linux"', {
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../build/linux/system.gyp:dbus',
                '../build/linux/system.gyp:fontconfig',
                '../build/linux/system.gyp:x11',
                '../dbus/dbus.gyp:dbus',
              ],
              'sources/': [
                ['exclude', '^browser/platform_util_common_linux.cc'],
              ],
            }],
            # GTK build only
            ['toolkit_uses_gtk==1', {
              'sources/': [
                ['exclude', '^browser/lifetime/application_lifetime_stub.cc'],
              ],
            }],
          ],
        }],
        ['enable_plugin_installation==0', {
          'sources!': [
            'browser/plugins/plugin_installer.cc',
            'browser/plugins/plugin_installer.h',
            'browser/plugins/plugin_installer_observer.cc',
            'browser/plugins/plugin_installer_observer.h',
            'browser/plugins/plugins_resource_service.cc',
            'browser/plugins/plugins_resource_service.h',
          ],
        }],
        ['enable_app_list==1', {
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list',
          ]
        }],
        ['enable_managed_users!=1', {
          'sources/': [
            ['exclude', '^browser/managed_mode/'],
          ],
        }],
        ['enable_webrtc==0', {
          'sources!': [
            'browser/media/webrtc_log_upload_list.cc',
            'browser/media/webrtc_log_upload_list.h',
            'browser/media/webrtc_log_uploader.cc',
            'browser/media/webrtc_log_uploader.h',
            'browser/media/webrtc_logging_handler_host.cc',
            'browser/media/webrtc_logging_handler_host.h',
          ]
        }],
        ['enable_mdns==1', {
          'sources' : [
            'browser/local_discovery/privet_http_asynchronous_factory.cc',
            'browser/local_discovery/privet_http_asynchronous_factory.h',
            'browser/local_discovery/privet_notifications.cc',
            'browser/local_discovery/privet_notifications.h',
            'browser/local_discovery/privet_notifications_factory.cc',
            'browser/local_discovery/privet_notifications_factory.h',
            'browser/local_discovery/privet_traffic_detector.cc',
            'browser/local_discovery/privet_traffic_detector.h',
            'browser/local_discovery/service_discovery_client_mdns.cc',
            'browser/local_discovery/service_discovery_client_mdns.h',
            'browser/local_discovery/service_discovery_host_client.cc',
            'browser/local_discovery/service_discovery_host_client.h',
            'browser/local_discovery/privet_local_printer_lister.h',
            'browser/local_discovery/privet_local_printer_lister.cc'
          ]
        }],
        ['enable_autofill_dialog!=1 or OS=="android" or OS=="ios"', {
          'sources!': [
            'browser/autofill/validation_rules_storage_factory.cc',
            'browser/autofill/validation_rules_storage_factory.h',
          ],
        }],
      ],
    },
    {
      # Protobuf compiler / generator for the fraudulent certificate reporting
      # protocol buffer.
      'target_name': 'cert_logger_proto',
      'type': 'static_library',
      'sources': [ 'browser/net/cert_logger.proto', ],
      'variables': {
        'proto_in_dir': 'browser/net',
        'proto_out_dir': 'chrome/browser/net',
      },
      'includes': [ '../build/protoc.gypi', ],
    },
    {
      # Protobuf compiler / generator for the suggestions service proto.
      'target_name': 'suggestions_proto',
      'type': 'static_library',
      'sources': [ 'browser/search/suggestions/proto/suggestions.proto', ],
      'variables': {
        'proto_in_dir': 'browser/search/suggestions/proto',
        'proto_out_dir': 'chrome/browser/search/suggestions/proto',
      },
      'includes': [ '../build/protoc.gypi', ],
    },
    {
      # Protobuf compiler / generator for Probe Message.
      'target_name': 'probe_message_proto',
      'type': 'static_library',
      'sources': [ 'browser/net/probe_message.proto' ],
      'variables': {
        'proto_in_dir': 'browser/net',
        'proto_out_dir': 'chrome/browser/net',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generate rule for feedback
      'target_name': 'feedback_proto',
      'type': 'static_library',
      'sources': [
        'browser/feedback/proto/annotations.proto',
        'browser/feedback/proto/chrome.proto',
        'browser/feedback/proto/common.proto',
        'browser/feedback/proto/dom.proto',
        'browser/feedback/proto/extension.proto',
        'browser/feedback/proto/math.proto',
        'browser/feedback/proto/web.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/feedback/proto',
        'proto_out_dir': 'chrome/browser/feedback/proto',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing reporting
      # protocol buffer.
      'target_name': 'safe_browsing_report_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/report.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing',
        'proto_out_dir': 'chrome/browser/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the InMemoryURLIndex caching
      # protocol buffer.
      'target_name': 'in_memory_url_index_cache_proto',
      'type': 'static_library',
      'sources': [ 'browser/history/in_memory_url_index_cache.proto' ],
      'variables': {
        'proto_in_dir': 'browser/history',
        'proto_out_dir': 'chrome/browser/history',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for Sync FileSystem protocol buffer.
      'target_name': 'sync_file_system_proto',
      'type': 'static_library',
      'sources': [
        'browser/sync_file_system/sync_file_system.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/sync_file_system',
        'proto_out_dir': 'chrome/browser/sync_file_system',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for Sync FileSystem protocol buffer.
      'target_name': 'sync_file_system_drive_proto',
      'type': 'static_library',
      'sources': [
        'browser/sync_file_system/drive_backend/metadata_database.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/sync_file_system/drive_backend',
        'proto_out_dir': 'chrome/browser/sync_file_system/drive_backend',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
  ],
  'conditions': [
    ['OS=="android"', {
      'targets': [
        {
          'target_name': 'chrome_browser_jni_headers',
          'type': 'none',
          'sources': [
            'android/java/src/org/chromium/chrome/browser/AccessibilityUtil.java',
            'android/java/src/org/chromium/chrome/browser/ApplicationLifetime.java',
            'android/java/src/org/chromium/chrome/browser/autofill/AutofillDialogControllerAndroid.java',
            'android/java/src/org/chromium/chrome/browser/autofill/AutofillDialogResult.java',
            'android/java/src/org/chromium/chrome/browser/autofill/AutofillPopupGlue.java',
            'android/java/src/org/chromium/chrome/browser/autofill/PersonalDataManager.java',
            'android/java/src/org/chromium/chrome/browser/BookmarksBridge.java',
            'android/java/src/org/chromium/chrome/browser/banners/AppBannerManager.java',
            'android/java/src/org/chromium/chrome/browser/CertificateViewer.java',
            'android/java/src/org/chromium/chrome/browser/ChromiumApplication.java',
            'android/java/src/org/chromium/chrome/browser/ChromeBrowserProvider.java',
            'android/java/src/org/chromium/chrome/browser/ChromeHttpAuthHandler.java',
            'android/java/src/org/chromium/chrome/browser/ChromeWebContentsDelegateAndroid.java',
            'android/java/src/org/chromium/chrome/browser/ContentViewUtil.java',
            'android/java/src/org/chromium/chrome/browser/contextmenu/ContextMenuHelper.java',
            'android/java/src/org/chromium/chrome/browser/contextmenu/ContextMenuParams.java',
            'android/java/src/org/chromium/chrome/browser/DevToolsServer.java',
            'android/java/src/org/chromium/chrome/browser/database/SQLiteCursor.java',
            'android/java/src/org/chromium/chrome/browser/favicon/FaviconHelper.java',
            'android/java/src/org/chromium/chrome/browser/FieldTrialHelper.java',
            'android/java/src/org/chromium/chrome/browser/ForeignSessionHelper.java',
            'android/java/src/org/chromium/chrome/browser/NewTabPagePrefs.java',
            'android/java/src/org/chromium/chrome/browser/IntentHelper.java',
            'android/java/src/org/chromium/chrome/browser/JavascriptAppModalDialog.java',
            'android/java/src/org/chromium/chrome/browser/NavigationPopup.java',
            'android/java/src/org/chromium/chrome/browser/net/spdyproxy/DataReductionProxySettings.java',
            'android/java/src/org/chromium/chrome/browser/omnibox/OmniboxPrerender.java',
            'android/java/src/org/chromium/chrome/browser/password_manager/PasswordAuthenticationManager.java',
            'android/java/src/org/chromium/chrome/browser/PasswordUIView.java',
            'android/java/src/org/chromium/chrome/browser/profiles/MostVisitedSites.java',
            'android/java/src/org/chromium/chrome/browser/profiles/Profile.java',
            'android/java/src/org/chromium/chrome/browser/profiles/ProfileDownloader.java',
            'android/java/src/org/chromium/chrome/browser/prerender/ExternalPrerenderHandler.java',
            'android/java/src/org/chromium/chrome/browser/RecentlyClosedBridge.java',
            'android/java/src/org/chromium/chrome/browser/ShortcutHelper.java',
            'android/java/src/org/chromium/chrome/browser/SSLClientCertificateRequest.java',
            'android/java/src/org/chromium/chrome/browser/search_engines/TemplateUrlService.java',
            'android/java/src/org/chromium/chrome/browser/signin/AccountManagementScreenHelper.java',
            'android/java/src/org/chromium/chrome/browser/signin/OAuth2TokenService.java',
            'android/java/src/org/chromium/chrome/browser/signin/SigninManager.java',
            'android/java/src/org/chromium/chrome/browser/sync/ProfileSyncService.java',
            'android/java/src/org/chromium/chrome/browser/TabBase.java',
            'android/java/src/org/chromium/chrome/browser/TtsPlatformImpl.java',
            'android/java/src/org/chromium/chrome/browser/UmaBridge.java',
            'android/java/src/org/chromium/chrome/browser/UmaUtils.java',
            'android/java/src/org/chromium/chrome/browser/UrlUtilities.java',
            'android/java/src/org/chromium/chrome/browser/VoiceSearchTabHelper.java',
            'android/java/src/org/chromium/chrome/browser/WebsiteSettingsPopup.java',
            'android/java/src/org/chromium/chrome/browser/infobar/AutoLoginDelegate.java',
            'android/java/src/org/chromium/chrome/browser/infobar/ConfirmInfoBarDelegate.java',
            'android/java/src/org/chromium/chrome/browser/infobar/InfoBar.java',
            'android/java/src/org/chromium/chrome/browser/infobar/InfoBarContainer.java',
            'android/java/src/org/chromium/chrome/browser/infobar/SavePasswordInfoBarDelegate.java',
            'android/java/src/org/chromium/chrome/browser/infobar/TranslateInfoBarDelegate.java',
            'android/java/src/org/chromium/chrome/browser/invalidation/InvalidationController.java',
            'android/java/src/org/chromium/chrome/browser/toolbar/ToolbarModel.java'
          ],
          'variables': {
            'jni_gen_package': 'chrome',
            'jni_generator_ptr_type': 'long',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'activity_type_ids_java',
          'type': 'none',
          'sources': [
            'android/java/ActivityTypeIds.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser',
            'template_deps': ['browser/android/activity_type_id_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'resource_id_java',
          'type': 'none',
          'sources': [
            'android/java/ResourceId.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser',
            'template_deps': ['browser/android/resource_id.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'profile_sync_service_model_type_selection_java',
          'type': 'none',
          'sources': [
            'android/java/ModelTypeSelection.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser/sync',
            'template_deps': ['browser/sync/profile_sync_service_model_type_selection_android.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'toolbar_model_security_levels_java',
          'type': 'none',
          'sources': [
            'android/java/ToolbarModelSecurityLevel.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser/ui/toolbar',
            'template_deps': ['browser/ui/toolbar/toolbar_model_security_level_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
      ],
     },
    ],
  ],
}
