.TH CRASHME 1
.SH NAME
crashme \- test operating environment software robustness
.SH SYNOPSIS
.B crashme
[NBYTES] [SRAND] [NTRYS] [NSUB] [VERBOSE]
.SH DESCRIPTION
.I crashme
is a very simple program that tests the operating environment's
robustness by invoking random data as if it were a procedure.
The standard signals are caught and handled with a setjmp back
to a loop which will try again to produce a fault by executing
random data. Some people call this stress testing.

.RE
.SS COMMAND LINE OPTIONS
.TP 8
.BI [NBYTES]
The
.I [NBYTES]
should be an integer, specifying the size of the random data string
in bytes. If given negative then the bytes are printed instead of
being executed. If given with an explicit plus sign then the
storage for the bytes is freshly malloc'ed each time. This can have an
effect on machines with separate I and D cache mechanisms. The argument
can also have a dot in it, X.Y, in which case Y is a increment for
a pointer into the random data. The buffer is recalculated only when
the pointer gets near the end of the data.

The are two magic values for
.I [NBYTES]
:
A value of 81920 avoids malloc and returns a pointer to
static data. This makes the operation of crashme more
repeatable on architectures where malloc is designed to
return unpredictable locations. A value of 1025 avoids a call
that sets the protection of the data to READ+WRITE+EXEC.

.TP
.BI [SRAND]
The 
.I [SRAND]
is an input seed to the random number generator, passed to srand.
.TP
.BI [NTRIES]
The
.I [NTRIES]
is how many times to loop before exiting normally from the program.
.TP
.BI [NSUB]
The
.I [NSUB] 
is optional, the number of vfork subprocesses running all at once.
If negative run one after another. If given as a 
time hrs:mns:scs (hours, minutes, seconds) then
one subprocess will be run to completion, followed by another, until
the time limit has been reached.  If this argument is given as the empty 
string or . then it is ignored.

When in sequential-subprocess mode there is a 30 second time limit on
each subprocess. This is to allow the instruction-set-space random
walk to continue when a process bashes itself into an infinite loop.
For example, the ntrys can be bashed to a very large number with
nbytes bashed to zero. (10 second limit on Windows NT).

The SRAND argument is incremented by one for each subprocess.

.TP
.BI [VERBOSE]
The
.I [VERBOSE] 
arg is optional. 0 is the least verbose, 5 the most.

.SS ENVIRONMENT VARIABLES
.TP 8
.BI CRASHLOG
The
.I CRASHLOG
is the name of the file which the parent process opens in write mode
and all child processes open in append mode. There is frequent flushing
of the file but no locking, so the output may be interleaved. If the
operating system crashes then this file might provide a short-cut
to a more resent random number seed sequence to allow for quicker
finding of the special case that caused the crash.

.TP
.BI CRASHPRNG
The
.I CRASHPRNG
can be set to RAND to use the system-provided rand function, or MT
to use the Mersenne twister (default) as coded by
Takuji Nishimura and Makoto Matsumoto, or VNSQ to use the author's
kludge interpretation of Von Neumann's middle-square method.


.SH EXAMPLE
This is a suggested test, to run it for a least an hour.

crashme +2000 666 100 1:00:00

.SH FILES
crashme.c
.PD
.SH DIAGNOSTICS
When a signal is caught the number and nature of the signal is indicated.
Setting the environment variable CRASHLOG will cause each subprocess to
record the arguments it was given.
.SH BUGS
Not all signals are caught, and the state of the user program/process
environment can be sufficiently damaged such that the program terminates
before going through all [NTRIES] operations.

If the architecture uses some kind of procedure descriptor but no
special code has been not been added to castaway() in crashme.c
then the stress test will not be as potent as it would otherwise be.

Beware: This program can crash your computer if the
operating system or hardware of same is buggy. User data may be lost.
.SH AUTHOR
George J Carrette. GJC\@alum.mit.edu
http://people.delphiforums.com/gjc/crashme.html
http://crashme.codeplex.com/
.SH VERSION
2.8.5 6-AUG-2014
