package do4odoc.tacollections;

import java.util.*;

public class Team {
	
	private String name;
	
	private List<Pilot> pilots;
	
	public Team(String name){
		this.name = name;
	}
	
	public void addPilot(Pilot pilot){
		if(pilots == null){
			pilots = new ArrayList<Pilot>();
		}
		pilots.add(pilot);
	}
	
	@Override
	public String toString() {
		StringBuilder str = new StringBuilder();
		str.append(String.format("Team %s", name));
		if(pilots != null){
			str.append(" with pilots: \n");
			for (Pilot p : pilots){
				str.append(String.format("    %s \n", p));
			}
		}
		return str.toString();
	}
	
	public String getName(){
		return name;
	}

}
