/* $Id: cim_string.c,v 1.6 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "cim_string.h"

static void
cim_string_set(void *_css, const char *val)
{
	struct cim_string *css = (struct cim_string *) _css;
	char buf[1024];

	assert(strlen(val) < sizeof(buf));
	strcpy(buf, val);
	cim_send(&css->bridge, buf, sizeof(buf));
}

static void
cim_string_receive(void *_css, void *_val, unsigned int size)
{
	struct cim_string *css = (struct cim_string *) _css;
	const char *val = (const char *) _val;

	assert(size == 1024);

	sig_string_set(css->sig_string, css, val);
}

void
cim_string_init(struct cim_string *css, struct sig_string *sig_string)
{
	static const struct sig_string_funcs funcs = {
		.set = cim_string_set,
	};

	cim_connect(&css->bridge, cim_string_receive, css);

	css->sig_string = sig_string;
	sig_string_connect(sig_string, css, &funcs);
}

void
cim_string_create(struct cim_string *css)
{
	cim_create(&css->bridge);
}

void
cim_string_destroy(struct cim_string *css)
{
	cim_destroy(&css->bridge);
}
