#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Line number for cursor")

    def run(self):
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()
        self.env["runtime"]["OutputManager"].present_text(
            str(cursor_pos["y"] + 1), interrupt=True
        )
        self.env["runtime"]["OutputManager"].announce_active_cursor()
        self.env["runtime"]["OutputManager"].present_text(
            " line number", interrupt=False
        )

    def set_callback(self, callback):
        pass
