/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class AliconaReader
extends FormatReader {
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
    }

    public boolean isThisType(byte[] block) {
        return new String(block).indexOf("Alicona") != -1;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int pad = (8 - this.core.sizeX[0] % 8) % 8;
        for (int i = 0; i < this.numBytes; ++i) {
            this.in.seek(this.textureOffset + no * (this.core.sizeX[0] + pad) * this.core.sizeY[0] * (i + 1));
            for (int j = 0; j < this.core.sizeX[0] * this.core.sizeY[0]; ++j) {
                buf[j * this.numBytes + i] = this.in.readByte();
                if (j % this.core.sizeX[0] != this.core.sizeX[0] - 1) continue;
                this.in.skipBytes(pad);
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("AliconaReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        this.status("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String pntX = null;
        String pntY = null;
        String pntZ = null;
        for (int i = 0; i < count; ++i) {
            String key = this.in.readString(20).trim();
            String value = this.in.readString(30).trim();
            this.addMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
                continue;
            }
            if (key.equals("Rows")) {
                this.core.sizeY[0] = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Cols")) {
                this.core.sizeX[0] = Integer.parseInt(value);
                continue;
            }
            if (key.equals("NumberOfPlanes")) {
                this.core.imageCount[0] = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
                continue;
            }
            if (key.equals("Voltage")) {
                voltage = value;
                continue;
            }
            if (key.equals("Magnification")) {
                magnification = value;
                continue;
            }
            if (key.equals("PlanePntX")) {
                pntX = value;
                continue;
            }
            if (key.equals("PlanePntY")) {
                pntY = value;
                continue;
            }
            if (!key.equals("PlanePntZ")) continue;
            pntZ = value;
        }
        this.status("Populating metadata");
        this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.core.sizeX[0] * this.core.sizeY[0] * this.core.imageCount[0]);
        this.core.sizeC[0] = hasC ? 3 : 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = this.core.imageCount[0] / this.core.sizeC[0];
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.core.pixelType[0] = this.numBytes == 2 ? 3 : 1;
        this.core.currentOrder[0] = "XYCTZ";
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        if (voltage != null) {
            store.setDetector(null, null, null, null, null, new Float(voltage), null, null, null);
        }
        if (magnification != null) {
            store.setObjective(null, null, null, null, new Float(magnification), null, null);
        }
        if (pntX != null && pntY != null && pntZ != null) {
            store.setDimensions(new Float(pntX.trim()), new Float(pntY.trim()), new Float(pntZ.trim()), null, null, null);
        }
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

