/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.QueryCapability;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.ProgressMonitor;
import thredds.ui.ProgressMonitorTask;
import thredds.ui.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.HttpClientManager;
import ucar.util.prefs.PreferencesExt;

public class TextGetPutPane
extends TextHistoryPane {
    private PreferencesExt prefs;
    private JComboBox cb;
    private JPanel buttPanel;
    private boolean addFileButton = true;
    private AbstractAction fileAction = null;
    private FileManager fileChooserReader;
    private GetContentsTask task;
    private EventListenerList listenerList = new EventListenerList();
    private InvCatalogFactory catFactory = null;
    private DqcFactory dqcFactory = null;

    public TextGetPutPane(PreferencesExt prefs) {
        super(true);
        this.prefs = prefs;
        this.cb = new JComboBox();
        this.cb.setEditable(true);
        if (prefs != null) {
            this.setList((ArrayList)prefs.getBean("list", null));
        }
        if (this.addFileButton) {
            this.fileChooserReader = new FileManager(null, null, "xml", "THREDDS catalogs", prefs == null ? null : (PreferencesExt)prefs.node("fileChooserReader"));
            this.fileAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename = TextGetPutPane.this.fileChooserReader.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    TextGetPutPane.this.cb.setSelectedItem("file:" + filename);
                }
            };
            BAMutil.setActionProperties(this.fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
        }
        JButton getButton = new JButton("Get");
        getButton.setToolTipText("GET URL contents");
        getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextGetPutPane.this.setURL((String)TextGetPutPane.this.cb.getSelectedItem());
            }
        });
        JButton validButton = new JButton("Validate");
        validButton.setToolTipText("Validate catalog");
        validButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextGetPutPane.this.validate((String)TextGetPutPane.this.cb.getSelectedItem());
            }
        });
        JButton putButton = new JButton("Put");
        putButton.setToolTipText("PUT URL contents");
        putButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TextGetPutPane.this.putURL((String)TextGetPutPane.this.cb.getSelectedItem());
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage());
                }
                TextGetPutPane.this.firePutActionEvent();
            }
        });
        this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        if (null != this.fileAction) {
            BAMutil.addActionToContainer(this.buttPanel, this.fileAction);
        }
        this.buttPanel.add(getButton);
        this.buttPanel.add(validButton);
        this.buttPanel.add(putButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("URL:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)this.buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    public void addButton(Component c) {
        this.buttPanel.add(c);
    }

    public void addPutActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removePutActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void firePutActionEvent() {
        ActionEvent event = new ActionEvent(this, 0, "Put");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void setURL(String urlString) {
        if (urlString == null) {
            return;
        }
        if (urlString.startsWith("file:")) {
            String contents;
            urlString = urlString.substring(5);
            try {
                contents = IO.readFile(urlString);
            }
            catch (IOException e) {
                contents = e.getMessage();
            }
            this.ta.setText(contents);
            return;
        }
        this.task = new GetContentsTask(urlString);
        ProgressMonitor pm = new ProgressMonitor(this.task);
        pm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("success")) {
                    TextGetPutPane.this.ta.setText(((TextGetPutPane)TextGetPutPane.this).task.contents);
                    ArrayList list = TextGetPutPane.this.getList();
                    if (!list.contains(((TextGetPutPane)TextGetPutPane.this).task.urlString)) {
                        TextGetPutPane.this.cb.addItem(((TextGetPutPane)TextGetPutPane.this).task.urlString);
                    }
                    TextGetPutPane.this.cb.setSelectedItem(((TextGetPutPane)TextGetPutPane.this).task.urlString);
                }
            }
        });
        pm.start(this, "Open URL " + urlString, 10);
    }

    public void setCatalog(String urlString, InvCatalogImpl cat) throws IOException {
        ArrayList list = this.getList();
        if (!list.contains(urlString)) {
            this.cb.addItem(urlString);
        }
        this.cb.setSelectedItem(urlString);
        ByteArrayOutputStream os = new ByteArrayOutputStream(20000);
        cat.writeXML(os, true);
        this.ta.setText(os.toString());
    }

    void validate(String urlString) {
        URI uri;
        if (urlString == null) {
            return;
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, "URISyntaxException on URL (" + urlString + ") " + e.getMessage() + "\n");
            return;
        }
        String contents = this.getText();
        boolean isCatalog = contents.indexOf("queryCapability") < 0;
        ByteArrayInputStream is = new ByteArrayInputStream(contents.getBytes());
        if (isCatalog) {
            if (this.catFactory == null) {
                this.catFactory = InvCatalogFactory.getDefaultFactory(true);
            }
            InvCatalogImpl catalog = this.catFactory.readXML(is, uri);
            StringBuilder buff = new StringBuilder();
            boolean check = catalog.check(buff);
            JOptionPane.showMessageDialog(this, "Catalog Validation = " + check + "\n" + buff.toString());
        } else {
            try {
                if (this.dqcFactory == null) {
                    this.dqcFactory = new DqcFactory(true);
                }
                QueryCapability dqc = this.dqcFactory.readXML(is, uri);
                JOptionPane.showMessageDialog(this, "DQC Errors = \n" + dqc.getErrorMessages());
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "IO Error = " + ioe);
            }
        }
    }

    void putURL(String uriString) throws IOException {
        URI uri;
        if (uriString == null) {
            return;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            System.out.println("** TextGetPutPane URISyntaxException=" + uriString);
            return;
        }
        String contents = this.ta.getText();
        String s = uri.getScheme();
        if (s.equalsIgnoreCase("file")) {
            String path = uri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            IO.writeToFile(contents, path);
        } else {
            int status = HttpClientManager.putContent(uriString, contents);
            JOptionPane.showMessageDialog(this, "Status code= " + status);
        }
    }

    void setList(ArrayList list) {
        if (list == null) {
            return;
        }
        this.cb.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            this.cb.addItem(list.get(i));
        }
        this.cb.revalidate();
    }

    ArrayList getList() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.cb.getItemCount(); ++i) {
            list.add(this.cb.getItemAt(i));
        }
        return list;
    }

    public void save() {
        if (this.prefs != null) {
            this.prefs.putBeanObject("list", this.getList());
        }
    }

    public void clear() {
        this.ta.setText(null);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    private class GetContentsTask
    extends ProgressMonitorTask {
        String urlString;
        String contents;

        GetContentsTask(String urlString) {
            this.urlString = urlString;
        }

        public void run() {
            try {
                this.contents = HttpClientManager.getContent(this.urlString);
            }
            catch (IOException e) {
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }
}

