/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

class SliceReader
implements ProxyReader {
    private static Logger log = LoggerFactory.getLogger(SliceReader.class);
    private Variable orgVar;
    private int sliceDim;
    private Section slice;

    SliceReader(Variable orgVar, int dim, Section slice) throws InvalidRangeException {
        this.orgVar = orgVar;
        this.sliceDim = dim;
        this.slice = slice;
    }

    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        Array data;
        try {
            data = this.orgVar._read(this.slice);
        }
        catch (InvalidRangeException e) {
            log.error("InvalidRangeException in slice, var=" + this.orgVar.getName());
            throw new IllegalStateException(e.getMessage());
        }
        data = data.reduce(this.sliceDim);
        return data;
    }

    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Section orgSection = new Section(section.getRanges());
        orgSection.insertRange(this.sliceDim, this.slice.getRange(this.sliceDim));
        Array data = this.orgVar._read(orgSection);
        data.reduce(this.sliceDim);
        return data;
    }
}

