<?php
/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// include Flatnuke APIs
include_once "functions.php";

// headersite
include "header.php";

// first microtime to calculate time generation page
$time1 = get_microtime();

// automatically run PHP scripts contained in include/autoexec.d
load_php_code("include/autoexec.d");

/**
 * Flatnuke MAIN function
 *
 * This is the function that manages all Flatnuke actions.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @author Aldo Boccacci <zorba_@tin.it>
 */
function getflopt(){
	global $home_section, $theme;

	$op   = get_mod();
	$file = stripslashes(getparam("file",PAR_GET,SAN_FLAT));
	$id   = getparam("id",PAR_GET,SAN_FLAT);
	$fnaction = getparam("fnaction",PAR_POST,SAN_FLAT);
	$sect     = getparam("sect",PAR_GET,SAN_FLAT);
	$fnfile   = getparam("fnfile",PAR_GET,SAN_FLAT);
	$fneditor = getparam("fneditor",PAR_GET,SAN_FLAT);
	
	// check option to execute
	switch($op){
		// no option given: homepage
		case "":
			if ($fnaction !="") continue;
			// print motd content if exists
			if(file_exists("misc/motd.php") AND trim(get_file("misc/motd.php"))!="") {
				OpenTable();
				echo "<div class=\"motd\">";
				// print motd image if exists
				if(file_exists("themes/$theme/images/motd.png")) {
					echo "<img src='themes/$theme/images/motd.png' align='left' hspace='10' vspace='10' alt='Motd' />";
				} else echo "<!-- MOTD image \"themes/$theme/images/motd.png\" not found -->";
				include ("misc/motd.php");
				echo "</div>";
				CloseTable();
			}
			if(($home_section == "") or !isset($home_section))
				create_news();		// display news as default
			else
				view_section($home_section);	// display section in homepage
		break;
		// read details of a news
		case "read":
			read_news($id);
		break;
		// publish a news
		case "news":
			if(is_admin())
				insert_news();
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// modify a file
		case "modcont":
			if(is_admin())
				edit_content($file,$fneditor);
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// insert a comment to a news
		case "comment":
			insert_comment($id);
		break;
		case "fnrenamesectinterface":
			rename_sect_interface($sect);
		break;
		case "fnnewsectinterface":
			create_sect_interface($sect);
		break;
		case "fnnewfileinterface":
			create_file_interface($sect);
		break;
		case "fndeletesectinterface":
			delete_sect_interface($sect);
		break;
		case "fnmovesectinterface":
			move_sect_interface($sect);
		break;
		case "fnmovefileinterface":
			fn_move_file_interface($fnfile);
		break;
		case "fndeletefileinterface":
			delete_file_interface($fnfile);
		break;
		case "fnrenamefileinterface":
			rename_file_interface($fnfile);
		break;
		case "usermodcont":
			user_edit_content($file,$fneditor);
		break;
		case "fnchoosesecttypeinterface":
			choose_sect_type_interface($sect);
		break;
		// view a section
		default:
			if (trim($fnaction=="")) view_section($op);
		break;
	}
	
	switch($fnaction){
		// save news comment
		case "fnsavenewscomment": fn_save_news_comment();	break;
		// manage sections
		case "fnrenamesect"    : rename_section();      break;
		case "fnmovesect"      : move_section();        break;
		case "fncreatesect"    : create_section();      break;
		case "fndeletesect"    : delete_section();      break;
		case "fnchangesecttype": change_section_type(); break;
		// manage files
		case "fncreatefile": create_file();    break;
		case "fndeletefile": delete_file();    break;
		case "fnrenamefile": fn_rename_file(); break;
		case "fnmovefile"  : fn_move_file();   break;
		// manage permissions
		case "fnaddusersectperm"           : fn_add_user_view_perm();    break;
		case "fnremoveusersectperm"        : fn_remove_user_view_perm(); break;
		case "fnaddusereditsectpermconfirm": fn_add_edit_perm_confirm(); break;
		case "fnaddusereditsectperm"       : fn_add_user_edit_perm();    break;
		case "fnremoveusereditsectperm"    : fn_remove_user_edit_perm(); break;
	}

}

// include theme APIs and layout
include_once "themes/$theme/theme.php";
include "themes/$theme/structure.php";

// footersite
if(defined('_THEME_VER')) {
	if(_THEME_VER > 0) {
	}
} else {
	$footer_elements = get_footer_array();
	echo $footer_elements['img_fn']." ";
	echo $footer_elements['img_w3c']." ";
	echo $footer_elements['img_css']." ";
	echo $footer_elements['img_rss']." ";
	echo $footer_elements['img_mail']."<br />";
	echo $footer_elements['legal']."<br />";
	echo $footer_elements['time'];
}

// fix for non-xhtml themes
if (!eregi("xhtml",_THEME_DOCTYPE)){
	$str=ob_get_contents();
	ob_end_clean();
	$str=str_replace(" />",">",$str);
	$str=str_replace("/>",">",$str);
	die($str);
}

?>

