#
# Class for serializing a calendar to iCalendar format (RFC 2445).
#
class iCalWriter:

    def __init__(self):

        pass



    def save(self, filename, cal):

        print "saving to ", filename
        
        data = self.__write_calendar(cal)

        # only save when there is data so the user does not lose data due
        # because bugs
        if (data):
            fd = open(filename, "w")
            fd.write(data)
            fd.close()



    def __write_calendar(self, cal):

        out = ""
        out += "BEGIN:VCALENDAR\r\n"
        out += "PROGID:-//www.pycage.de//NONSGML gDeskCal//EN\r\n"
        out += "VERSION:2.0\r\n"

        for e in cal.get_all_events():
            out += self.__write_event(e)
        
        out += "END:VCALENDAR\r\n"

        return out



    def __write_event(self, event):

        out = ""
        out += "BEGIN:VEVENT\r\n"
        
        out += "DTSTART:" + self.__write_time(event.get_start()) + "\r\n"
        out += "SUMMARY:" + event.get_summary() + "\r\n"

        recs = event.get_recurrences()
        if (recs):
            for r in recs.get_rules():
                out += "RRULE:" + self.__write_rrule(r) + "\r\n"
        #end if
        
        out += "END:VEVENT\r\n"

        return out



    def __write_time(self, t):

        year, month, day = t.get_day()
        hour, min, sec = t.get_daytime()
        part1 = "%(year)04d%(month)02d%(day)02d" % vars()
        part2 = "%(hour)02d%(min)02d%(sec)02d" % vars()

        return part1 + "T" + part2



    def __write_rrule(self, rrule):

        interval = rrule.get_interval()
        freq = rrule.get_frequency()
        count = rrule.get_count()
        #by = rrule.get_by()

        out = ""
        out += "FREQ=" + ["DAILY", "WEEKLY", "MONTHLY", "YEARLY"][freq] + ";"
        out += "INTERVAL=" + str(interval) + ";"
        out += "COUNT=" + str(count)
        #print out

        return out
