#    Copyright (C) 2006 Pete Savage & Jordan Mantha
#    This file is part of gisomount.

#    gisomount is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    gisomount is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with gisomount; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import sys 
import os

class configFile:

	def __init__(self):
		self.filename=os.environ['HOME']+"/.gisomount/gisomount.conf"
		if not os.path.isdir(os.environ['HOME']+"/.gisomount"):
			os.mkdir(os.environ['HOME']+"/.gisomount",0755)
		if not os.path.isfile(os.environ['HOME']+"/.gisomount/gisomount.conf"):
			f=open(self.filename,'w')
			f.write("")
			f.close()
		f=open(self.filename,'r+')
		self.lines=f.readlines()
		f.close()

	def getValue(self,search):
		for line in self.lines:
			observe=line.replace("\n","")
			observe=observe.split("=")
			if observe[0].strip()==search:
				return observe[1]
		return None

	def setValue(self,search,value):
		self.filename=os.environ['HOME']+"/.gisomount/gisomount.conf"
		f=open(self.filename,'w')
		linesw=[]
		written=0
		for line in self.lines:
			observe=line.replace("\n","")
			if line[0]=='#':
				linesw.append(line)
			elif observe!="":
				observe=observe.split("=")
				if observe[0].strip()==search:
					observe[1]=value
					written=1
				line=observe[0].strip()+"="+observe[1].strip()+"\n"
				linesw.append(line)
			else:
				linesw.append(line)
		if written==0:
			linesw.append(search+"="+value+"\n")
		f.writelines(linesw)
		f.close()
		self.lines=linesw
		f=open(self.filename,'r')
		self.lines=f.readlines()
		f.close()
