//  JavaScript

//    Conjugation generator
//    beta stage, unfinished, the root for a new way to generate flexions…


/* jshint esversion:6, -W097 */
/* jslint esversion:6 */

"use strict";


var conj_generator = {

    conjugate: function (sVerb, sVerbTag="i_____a", bVarPpas=true) {
        let lEntry = [];
        let cGroup = this.getVerbGroupChar(sVerb);
        for (let [nCut, sAdd, sFlexTags, sPattern] of this.getConjRules(sVerb, bVarPpas)) {
            if (!sPattern || RegExp(sPattern).test(sVerb)) {
                let sFlexion = (nCut > 0) ? sVerb.slice(0, -nCut) + sAdd : sVerb + sAdd;
                lEntry.push( [sFlexion, ":V" + cGroup + "_" + sVerbTag + sFlexTags] );
            }
        }
        return lEntry;
    },

    getVerbGroupChar: function (sVerb) {
        sVerb = sVerb.toLowerCase();
        if (sVerb.endsWith("er")) {
            return "1";
        }
        if (sVerb.endsWith("ir")) {
            return "2";
        }
        if (sVerb == "être" || sVerb == "avoir") {
            return "0";
        }
        if (sVerb.endsWith("re")) {
            return "3";
        }
        return "4";
    },

    getConjRules: function (sVerb, bVarPpas=true, nGroup=2) {
        let lConj = null;
        let sVarPpas = (bVarPpas) ? "true" : "false";
        if (sVerb.endsWith("er")) {
            // premier groupe, conjugaison en fonction de la terminaison du lemme
            // 5 lettres
            if (sVerb.slice(-5) in this.oConj["V1"]) {
                lConj = Array.from(this.oConj["V1"][sVerb.slice(-5)]);
            }
            // 4 lettres
            else if (sVerb.slice(-4) in this.oConj["V1"]) {
                if (sVerb.endsWith("eler") || sVerb.endsWith("eter")) {
                    lConj = Array.from(this.oConj["V1"][sVerb.slice(-4)]["1"]);
                } else {
                    lConj = Array.from(this.oConj["V1"][sVerb.slice(-4)]);
                }
            }
            // 3 lettres
            else if (sVerb.slice(-3) in this.oConj["V1"]) {
                lConj = Array.from(this.oConj["V1"][sVerb.slice(-3)]);
            }
            // 2 lettres
            else {
                lConj = Array.from(this.oConj["V1"]["er"]);
            }
            lConj.push(...this.oConj["V1_ppas"][sVarPpas]);
        }
        else if (sVerb.endsWith("ir") && nGroup <= 2) {
            // deuxième groupe
            lConj = Array.from(this.oConj["V2"]);
            lConj.push(...this.oConj["V2_ppas"][sVarPpas]);
        }
        else {
            // TODO: troisième groupe
            lConj = [ [0, "", ":Y/*", false] ];
        }
        return lConj;
    },

    oConj: {
        "V1_ppas": {
            "true": [
                [2,     "é",           ":Q:A:1ŝ:m:s/*",     false],
                [2,     "és",          ":Q:A:m:p/*",        false],
                [2,     "ée",          ":Q:A:f:s/*",        false],
                [2,     "ées",         ":Q:A:f:p/*",        false],
            ],
            "false": [
                [2,     "é",           ":Q:e:i/*",          false],
            ]
        },

        "V2_ppas": {
            "true": [
                [2,     "i",           ":Q:A:m:s/*",        false],
                [2,     "is",          ":Q:A:m:p/*",        false],
                [2,     "ie",          ":Q:A:f:s/*",        false],
                [2,     "ies",         ":Q:A:f:p/*",        false],
            ],
            "false": [
                [2,     "i",           ":Q:e:i/*",          false],
            ]
        },

        // deuxième groupe (le seul groupe régulier)
        "V2": [
            [2,     "ir",           ":Y/*",             false],
            [2,     "issant",       ":P/*",             false],
            [2,     "is",           ":Ip:Is:1s:2s/*",   false],
            [2,     "it",           ":Ip:Is:3s/*",      false],
            [2,     "issons",       ":Ip:1p/*",         false],
            [2,     "issez",        ":Ip:2p/*",         false],
            [2,     "issent",       ":Ip:Sp:Sq:3p/*",   false],
            [2,     "issais",       ":Iq:1s:2s/*",      false],
            [2,     "issait",       ":Iq:3s/*",         false],
            [2,     "issions",      ":Iq:Sp:Sq:1p/*",   false],
            [2,     "issiez",       ":Iq:Sp:Sq:2p/*",   false],
            [2,     "issaient",     ":Iq:3p/*",         false],
            [2,     "îmes",         ":Is:1p/*",         false],
            [2,     "îtes",         ":Is:2p/*",         false],
            [2,     "irent",        ":Is:3p!/*",        false],
            [2,     "irai",         ":If:1s/*",         false],
            [2,     "iras",         ":If:2s/*",         false],
            [2,     "ira",          ":If:3s/*",         false],
            [2,     "irons",        ":If:1p/*",         false],
            [2,     "irez",         ":If:2p/*",         false],
            [2,     "iront",        ":If:3p!/*",        false],
            [2,     "irais",        ":K:1s:2s/*",       false],
            [2,     "irait",        ":K:3s/*",          false],
            [2,     "irions",       ":K:1p/*",          false],
            [2,     "iriez",        ":K:2p/*",          false],
            [2,     "iraient",      ":K:3p/*",          false],
            [2,     "isse",         ":Sp:Sq:1s/*",      false],
            [2,     "isses",        ":Sp:Sq:2s/*",      false],
            [2,     "isse",         ":Sp:3s/*",         false],
            [2,     "ît",           ":Sq:3s/*",         false],
            [2,     "is",           ":E:2s/*",          false],
            [2,     "issons",       ":E:1p/*",          false],
            [2,     "issez",        ":E:2p/*",          false]
        ],

        // premier groupe (bien plus irrégulier que prétendu)
        "V1": {
            // a
            // verbes en -er, -ger, -yer, -cer
            "er": [
                [2,      "er",        ":Y/*",               false],
                [2,      "ant",       ":P/*",               false],
                [2,      "e",         ":Ip:Sp:1s:3s/*",     false],
                [2,      "è",         ":Ip:1ś/*",           false],
                [2,      "es",        ":Ip:Sp:2s/*",        false],
                [2,      "ons",       ":Ip:1p/*",           false],
                [2,      "ez",        ":Ip:2p/*",           false],
                [2,      "ent",       ":Ip:Sp:3p/*",        false],
                [2,      "ais",       ":Iq:1s:2s/*",        false],
                [2,      "ait",       ":Iq:3s/*",           false],
                [2,      "ions",      ":Iq:Sp:1p/*",        false],
                [2,      "iez",       ":Iq:Sp:2p/*",        false],
                [2,      "aient",     ":Iq:3p/*",           false],
                [2,      "ai",        ":Is:1s/*",           false],
                [2,      "as",        ":Is:2s/*",           false],
                [2,      "a",         ":Is:3s/*",           false],
                [2,      "âmes",      ":Is:1p/*",           false],
                [2,      "âtes",      ":Is:2p/*",           false],
                [2,      "èrent",     ":Is:3p!/*",          false],
                [2,      "erai",      ":If:1s/*",           false],
                [2,      "eras",      ":If:2s/*",           false],
                [2,      "era",       ":If:3s/*",           false],
                [2,      "erons",     ":If:1p/*",           false],
                [2,      "erez",      ":If:2p/*",           false],
                [2,      "eront",     ":If:3p!/*",          false],
                [2,      "erais",     ":K:1s:2s/*",         false],
                [2,      "erait",     ":K:3s/*",            false],
                [2,      "erions",    ":K:1p/*",            false],
                [2,      "eriez",     ":K:2p/*",            false],
                [2,      "eraient",   ":K:3p/*",            false],
                [2,      "asse",      ":Sq:1s/*",           false],
                [2,      "asses",     ":Sq:2s/*",           false],
                [2,      "ât",        ":Sq:3s/*",           false],
                [2,      "assions",   ":Sq:1p/*",           false],
                [2,      "assiez",    ":Sq:2p/*",           false],
                [2,      "assent",    ":Sq:3p/*",           false],
                [2,      "e",         ":E:2s/*",            false],
                [2,      "ons",       ":E:1p/*",            false],
                [2,      "ez",        ":E:2p/*",            false]
            ],

            "ger": [
                [2,      "er",        ":Y/*",               false],
                [2,      "eant",      ":P/*",               false],
                [2,      "e",         ":Ip:Sp:1s:3s/*",     false],
                [2,      "è",         ":Ip:1ś/*",           false],
                [2,      "es",        ":Ip:Sp:2s/*",        false],
                [2,      "eons",      ":Ip:1p/*",           false],
                [2,      "ez",        ":Ip:2p/*",           false],
                [2,      "ent",       ":Ip:Sp:3p/*",        false],
                [2,      "eais",      ":Iq:1s:2s/*",        false],
                [2,      "eait",      ":Iq:3s/*",           false],
                [2,      "ions",      ":Iq:Sp:1p/*",        false],
                [2,      "iez",       ":Iq:Sp:2p/*",        false],
                [2,      "eaient",    ":Iq:3p/*",           false],
                [2,      "eai",       ":Is:1s/*",           false],
                [2,      "eas",       ":Is:2s/*",           false],
                [2,      "ea",        ":Is:3s/*",           false],
                [2,      "eâmes",     ":Is:1p/*",           false],
                [2,      "eâtes",     ":Is:2p/*",           false],
                [2,      "èrent",     ":Is:3p!/*",          false],
                [2,      "erai",      ":If:1s/*",           false],
                [2,      "eras",      ":If:2s/*",           false],
                [2,      "era",       ":If:3s/*",           false],
                [2,      "erons",     ":If:1p/*",           false],
                [2,      "erez",      ":If:2p/*",           false],
                [2,      "eront",     ":If:3p!/*",          false],
                [2,      "erais",     ":K:1s:2s/*",         false],
                [2,      "erait",     ":K:3s/*",            false],
                [2,      "erions",    ":K:1p/*",            false],
                [2,      "eriez",     ":K:2p/*",            false],
                [2,      "eraient",   ":K:3p/*",            false],
                [2,      "easse",     ":Sq:1s/*",           false],
                [2,      "easses",    ":Sq:2s/*",           false],
                [2,      "eât",       ":Sq:3s/*",           false],
                [2,      "eassions",  ":Sq:1p/*",           false],
                [2,      "eassiez",   ":Sq:2p/*",           false],
                [2,      "eassent",   ":Sq:3p/*",           false],
                [2,      "e",         ":E:2s/*",            false],
                [2,      "eons",      ":E:1p/*",            false],
                [2,      "ez",        ":E:2p/*",            false]
            ],

            "cer": [
                [2,      "er",        ":Y/*",               false],
                [3,      "çant",      ":P/*",               false],
                [2,      "e",         ":Ip:Sp:1s:3s/*",     false],
                [2,      "è",         ":Ip:1ś/*",           false],
                [2,      "es",        ":Ip:Sp:2s/*",        false],
                [3,      "çons",      ":Ip:1p/*",           false],
                [2,      "ez",        ":Ip:2p/*",           false],
                [2,      "ent",       ":Ip:Sp:3p/*",        false],
                [3,      "çais",      ":Iq:1s:2s/*",        false],
                [3,      "çait",      ":Iq:3s/*",           false],
                [2,      "ions",      ":Iq:Sp:1p/*",        false],
                [2,      "iez",       ":Iq:Sp:2p/*",        false],
                [3,      "çaient",    ":Iq:3p/*",           false],
                [3,      "çai",       ":Is:1s/*",           false],
                [3,      "ças",       ":Is:2s/*",           false],
                [3,      "ça",        ":Is:3s/*",           false],
                [3,      "çâmes",     ":Is:1p/*",           false],
                [3,      "çâtes",     ":Is:2p/*",           false],
                [2,      "èrent",     ":Is:3p!/*",          false],
                [2,      "erai",      ":If:1s/*",           false],
                [2,      "eras",      ":If:2s/*",           false],
                [2,      "era",       ":If:3s/*",           false],
                [2,      "erons",     ":If:1p/*",           false],
                [2,      "erez",      ":If:2p/*",           false],
                [2,      "eront",     ":If:3p!/*",          false],
                [2,      "erais",     ":K:1s:2s/*",         false],
                [2,      "erait",     ":K:3s/*",            false],
                [2,      "erions",    ":K:1p/*",            false],
                [2,      "eriez",     ":K:2p/*",            false],
                [2,      "eraient",   ":K:3p/*",            false],
                [3,      "çasse",     ":Sq:1s/*",           false],
                [3,      "çasses",    ":Sq:2s/*",           false],
                [3,      "çât",       ":Sq:3s/*",           false],
                [3,      "çassions",  ":Sq:1p/*",           false],
                [3,      "çassiez",   ":Sq:2p/*",           false],
                [3,      "çassent",   ":Sq:3p/*",           false],
                [2,      "e",         ":E:2s/*",            false],
                [3,      "çons",      ":E:1p/*",            false],
                [2,      "ez",        ":E:2p/*",            false]
            ],

            "yer": [
                [2,     "er",         ":Y/*",               false],
                [2,     "ant",        ":P/*",               false],
                [3,     "ye",         ":Ip:Sp:1s:3s/*",     "[^ou]yer$"],
                [3,     "ie",         ":Ip:Sp:1s:3s/*",     "[aou]yer$"],
                [2,     "è",          ":Ip:1ś/*",           false],
                [3,     "yes",        ":Ip:Sp:2s/*",        "[^ou]yer$"],
                [3,     "ies",        ":Ip:Sp:2s/*",        "[aou]yer$"],
                [2,     "ons",        ":Ip:1p/*",           false],
                [2,     "ez",         ":Ip:2p/*",           false],
                [3,     "yent",       ":Ip:Sp:3p/*",        "[^ou]yer$"],
                [3,     "ient",       ":Ip:Sp:3p/*",        "[aou]yer$"],
                [2,     "ais",        ":Iq:1s:2s/*",        false],
                [2,     "ait",        ":Iq:3s/*",           false],
                [2,     "ions",       ":Iq:Sp:1p/*",        false],
                [2,     "iez",        ":Iq:Sp:2p/*",        false],
                [2,     "aient",      ":Iq:3p/*",           false],
                [2,     "ai",         ":Is:1s/*",           false],
                [2,     "as",         ":Is:2s/*",           false],
                [2,     "a",          ":Is:3s/*",           false],
                [2,     "âmes",       ":Is:1p/*",           false],
                [2,     "âtes",       ":Is:2p/*",           false],
                [2,     "èrent",      ":Is:3p!/*",          false],
                [3,     "yerai",      ":If:1s/*",           "[^ou]yer$"],
                [3,     "ierai",      ":If:1s/*",           "[aou]yer$"],
                [3,     "yeras",      ":If:2s/*",           "[^ou]yer$"],
                [3,     "ieras",      ":If:2s/*",           "[aou]yer$"],
                [3,     "yera",       ":If:3s/*",           "[^ou]yer$"],
                [3,     "iera",       ":If:3s/*",           "[aou]yer$"],
                [3,     "yerons",     ":If:1p/*",           "[^ou]yer$"],
                [3,     "ierons",     ":If:1p/*",           "[aou]yer$"],
                [3,     "yerez",      ":If:2p/*",           "[^ou]yer$"],
                [3,     "ierez",      ":If:2p/*",           "[aou]yer$"],
                [3,     "yeront",     ":If:3p!/*",          "[^ou]yer$"],
                [3,     "ieront",     ":If:3p!/*",          "[aou]yer$"],
                [3,     "yerais",     ":K:1s:2s/*",         "[^ou]yer$"],
                [3,     "ierais",     ":K:1s:2s/*",         "[aou]yer$"],
                [3,     "yerait",     ":K:3s/*",            "[^ou]yer$"],
                [3,     "ierait",     ":K:3s/*",            "[aou]yer$"],
                [3,     "yerions",    ":K:1p/*",            "[^ou]yer$"],
                [3,     "ierions",    ":K:1p/*",            "[aou]yer$"],
                [3,     "yeriez",     ":K:2p/*",            "[^ou]yer$"],
                [3,     "ieriez",     ":K:2p/*",            "[aou]yer$"],
                [3,     "yeraient",   ":K:3p/*",            "[^ou]yer$"],
                [3,     "ieraient",   ":K:3p/*",            "[aou]yer$"],
                [2,     "asse",       ":Sq:1s/*",           false],
                [2,     "asses",      ":Sq:2s/*",           false],
                [2,     "ât",         ":Sq:3s/*",           false],
                [2,     "assions",    ":Sq:1p/*",           false],
                [2,     "assiez",     ":Sq:2p/*",           false],
                [2,     "assent",     ":Sq:3p/*",           false],
                [3,     "ye",         ":E:2s/*",            "[^ou]yer$"],
                [3,     "ie",         ":E:2s/*",            "[aou]yer$"],
                [2,     "ons",        ":E:1p/*",            false],
                [2,     "ez",         ":E:2p/*",            false]
            ],

            // b
            // verbes en -ecer, -emer, -ener, -eper, -erer, -eser, -ever, -evrer
            // verbes en -eler, -eter (pas de doublement de la consonne: acheter, celer, déceler, receler, ciseler, démanteler,
            // écarteler, encasteler, geler, dégeler, congeler, surgeler, marteler, modeler, peler, acheter, racheter,
            // bégueter, corseter, crocheter, fileter, fureter, haleter)
            // changement du e en è avant syllabe muette
            "ecer": [
                [2,     "er",           ":Y/*",                 false],
                [3,     "çant",         ":P/*",                 false],
                [4,     "èce",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èces",         ":Ip:Sp:2s/*",          false],
                [3,     "çons",         ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ècent",        ":Ip:Sp:3p/*",          false],
                [3,     "çais",         ":Iq:1s:2s/*",          false],
                [3,     "çait",         ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [3,     "çaient",       ":Iq:3p/*",             false],
                [3,     "çai",          ":Is:1s/*",             false],
                [3,     "ças",          ":Is:2s/*",             false],
                [3,     "ça",           ":Is:3s/*",             false],
                [3,     "çâmes",        ":Is:1p/*",             false],
                [3,     "çâtes",        ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "ècerai",       ":If:1s/*",             false],
                [4,     "èceras",       ":If:2s/*",             false],
                [4,     "ècera",        ":If:3s/*",             false],
                [4,     "ècerons",      ":If:1p/*",             false],
                [4,     "ècerez",       ":If:2p/*",             false],
                [4,     "èceront",      ":If:3p!/*",            false],
                [4,     "ècerais",      ":K:1s:2s/*",           false],
                [4,     "ècerait",      ":K:3s/*",              false],
                [4,     "ècerions",     ":K:1p/*",              false],
                [4,     "èceriez",      ":K:2p/*",              false],
                [4,     "èceraient",    ":K:3p/*",              false],
                [3,     "çasse",        ":Sq:1s/*",             false],
                [3,     "çasses",       ":Sq:2s/*",             false],
                [3,     "çât",          ":Sq:3s/*",             false],
                [3,     "çassions",     ":Sq:1p/*",             false],
                [3,     "çassiez",      ":Sq:2p/*",             false],
                [3,     "çassent",      ":Sq:3p/*",             false],
                [4,     "èce",          ":E:2s/*",              false],
                [3,     "çons",         ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "eler": {
                "1": [
                    [2,     "er",           ":Y/*",             false],
                    [2,     "ant",          ":P/*",             false],
                    [4,     "èle",          ":Ip:Sp:1s:3s/*",   false],
                    [2,     "è",            ":Ip:1ś/R",         false],
                    [4,     "èles",         ":Ip:Sp:2s/*",      false],
                    [2,     "ons",          ":Ip:1p/*",         false],
                    [2,     "ez",           ":Ip:2p/*",         false],
                    [4,     "èlent",        ":Ip:Sp:3p/*",      false],
                    [2,     "ais",          ":Iq:1s:2s/*",      false],
                    [2,     "ait",          ":Iq:3s/*",         false],
                    [2,     "ions",         ":Iq:Sp:1p/*",      false],
                    [2,     "iez",          ":Iq:Sp:2p/*",      false],
                    [2,     "aient",        ":Iq:3p/*",         false],
                    [2,     "ai",           ":Is:1s/*",         false],
                    [2,     "as",           ":Is:2s/*",         false],
                    [2,     "a",            ":Is:3s/*",         false],
                    [2,     "âmes",         ":Is:1p/*",         false],
                    [2,     "âtes",         ":Is:2p/*",         false],
                    [2,     "èrent",        ":Is:3p!/*",        false],
                    [4,     "èlerai",       ":If:1s/*",         false],
                    [4,     "èleras",       ":If:2s/*",         false],
                    [4,     "èlera",        ":If:3s/*",         false],
                    [4,     "èlerons",      ":If:1p/*",         false],
                    [4,     "èlerez",       ":If:2p/*",         false],
                    [4,     "èleront",      ":If:3p!/*",        false],
                    [4,     "èlerais",      ":K:1s:2s/*",       false],
                    [4,     "èlerait",      ":K:3s/*",          false],
                    [4,     "èlerions",     ":K:1p/*",          false],
                    [4,     "èleriez",      ":K:2p/*",          false],
                    [4,     "èleraient",    ":K:3p/*",          false],
                    [2,     "asse",         ":Sq:1s/*",         false],
                    [2,     "asses",        ":Sq:2s/*",         false],
                    [2,     "ât",           ":Sq:3s/*",         false],
                    [2,     "assions",      ":Sq:1p/*",         false],
                    [2,     "assiez",       ":Sq:2p/*",         false],
                    [2,     "assent",       ":Sq:3p/*",         false],
                    [4,     "èle",          ":E:2s/*",          false],
                    [2,     "ons",          ":E:1p/*",          false],
                    [2,     "ez",           ":E:2p/*",          false]
                ],
                "2": [
                    // d. verbes en -eler : doublement de la consonne l.
                    [2,     "er",           ":Y/*",             false],
                    [2,     "ant",          ":P/*",             false],
                    [4,     "elle",         ":Ip:Sp:1s:3s/*",   "ppeler$"],
                    [4,     "elle",         ":Ip:Sp:1s:3s/M",   "[^p].eler$"],
                    [4,     "èle",          ":Ip:Sp:1s:3s/R",   "[^p].eler$"],
                    [2,     "è",            ":Ip:1ś/R",         false],
                    [4,     "elles",        ":Ip:Sp:2s/*",      "ppeler$"],
                    [4,     "elles",        ":Ip:Sp:2s/M",      "[^p].eler$"],
                    [4,     "èles",         ":Ip:Sp:2s/R",      "[^p].eler$"],
                    [2,     "ons",          ":Ip:1p/*",         false],
                    [2,     "ez",           ":Ip:2p/*",         false],
                    [4,     "ellent",       ":Ip:Sp:3p/*",      "ppeler$"],
                    [4,     "ellent",       ":Ip:Sp:3p/M",      "[^p].eler$"],
                    [4,     "èlent",        ":Ip:Sp:3p/R",      "[^p].eler$"],
                    [2,     "ais",          ":Iq:1s:2s/*",      false],
                    [2,     "ait",          ":Iq:3s/*",         false],
                    [2,     "ions",         ":Iq:Sp:1p/*",      false],
                    [2,     "iez",          ":Iq:Sp:2p/*",      false],
                    [2,     "aient",        ":Iq:3p/*",         false],
                    [2,     "ai",           ":Is:1s/*",         false],
                    [2,     "as",           ":Is:2s/*",         false],
                    [2,     "a",            ":Is:3s/*",         false],
                    [2,     "âmes",         ":Is:1p/*",         false],
                    [2,     "âtes",         ":Is:2p/*",         false],
                    [2,     "èrent",        ":Is:3p!/*",        false],
                    [4,     "ellerai",      ":If:1s/*",         "ppeler$"],
                    [4,     "ellerai",      ":If:1s/M",         "[^p].eler$"],
                    [4,     "èlerai",       ":If:1s/R",         "[^p].eler$"],
                    [4,     "elleras",      ":If:2s/*",         "ppeler$"],
                    [4,     "elleras",      ":If:2s/M",         "[^p].eler$"],
                    [4,     "èleras",       ":If:2s/R",         "[^p].eler$"],
                    [4,     "ellera",       ":If:3s/*",         "ppeler$"],
                    [4,     "ellera",       ":If:3s/M",         "[^p].eler$"],
                    [4,     "èlera",        ":If:3s/R",         "[^p].eler$"],
                    [4,     "ellerons",     ":If:1p/*",         "ppeler$"],
                    [4,     "ellerons",     ":If:1p/M",         "[^p].eler$"],
                    [4,     "èlerons",      ":If:1p/R",         "[^p].eler$"],
                    [4,     "ellerez",      ":If:2p/*",         "ppeler$"],
                    [4,     "ellerez",      ":If:2p/M",         "[^p].eler$"],
                    [4,     "èlerez",       ":If:2p/R",         "[^p].eler$"],
                    [4,     "elleront",     ":If:3p!/*",        "ppeler$"],
                    [4,     "elleront",     ":If:3p!/M",        "[^p].eler$"],
                    [4,     "èleront",      ":If:3p!/R",        "[^p].eler$"],
                    [4,     "ellerais",     ":K:1s:2s/*",       "ppeler$"],
                    [4,     "ellerais",     ":K:1s:2s/M",       "[^p].eler$"],
                    [4,     "èlerais",      ":K:1s:2s/R",       "[^p].eler$"],
                    [4,     "ellerait",     ":K:3s/*",          "ppeler$"],
                    [4,     "ellerait",     ":K:3s/M",          "[^p].eler$"],
                    [4,     "èlerait",      ":K:3s/R",          "[^p].eler$"],
                    [4,     "ellerions",    ":K:1p/*",          "ppeler$"],
                    [4,     "ellerions",    ":K:1p/M",          "[^p].eler$"],
                    [4,     "èlerions",     ":K:1p/R",          "[^p].eler$"],
                    [4,     "elleriez",     ":K:2p/*",          "ppeler$"],
                    [4,     "elleriez",     ":K:2p/M",          "[^p].eler$"],
                    [4,     "èleriez",      ":K:2p/R",          "[^p].eler$"],
                    [4,     "elleraient",   ":K:3p/*",          "ppeler$"],
                    [4,     "elleraient",   ":K:3p/M",          "[^p].eler$"],
                    [4,     "èleraient",    ":K:3p/R",          "[^p].eler$"],
                    [2,     "asse",         ":Sq:1s/*",         false],
                    [2,     "asses",        ":Sq:2s/*",         false],
                    [2,     "ât",           ":Sq:3s/*",         false],
                    [2,     "assions",      ":Sq:1p/*",         false],
                    [2,     "assiez",       ":Sq:2p/*",         false],
                    [2,     "assent",       ":Sq:3p/*",         false],
                    [4,     "elle",         ":E:2s/*",          "ppeler$"],
                    [4,     "elle",         ":E:2s/M",          "[^p].eler$"],
                    [4,     "èle",          ":E:2s/R",          "[^p].eler$"],
                    [2,     "ons",          ":E:1p/*",          false],
                    [2,     "ez",           ":E:2p/*",          false]
                ],
            },

            "emer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ème",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èmes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èment",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "èmerai",       ":If:1s/*",             false],
                [4,     "èmeras",       ":If:2s/*",             false],
                [4,     "èmera",        ":If:3s/*",             false],
                [4,     "èmerons",      ":If:1p/*",             false],
                [4,     "èmerez",       ":If:2p/*",             false],
                [4,     "èmeront",      ":If:3p!/*",            false],
                [4,     "èmerais",      ":K:1s:2s/*",           false],
                [4,     "èmerait",      ":K:3s/*",              false],
                [4,     "èmerions",     ":K:1p/*",              false],
                [4,     "èmeriez",      ":K:2p/*",              false],
                [4,     "èmeraient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ème",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "ener": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ène",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "ènes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ènent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "ènerai",       ":If:1s/*",             false],
                [4,     "èneras",       ":If:2s/*",             false],
                [4,     "ènera",        ":If:3s/*",             false],
                [4,     "ènerons",      ":If:1p/*",             false],
                [4,     "ènerez",       ":If:2p/*",             false],
                [4,     "èneront",      ":If:3p!/*",            false],
                [4,     "ènerais",      ":K:1s:2s/*",           false],
                [4,     "ènerait",      ":K:3s/*",              false],
                [4,     "ènerions",     ":K:1p/*",              false],
                [4,     "èneriez",      ":K:2p/*",              false],
                [4,     "èneraient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ène",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "eper": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èpe",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èpes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èpent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "èperai",       ":If:1s/*",             false],
                [4,     "èperas",       ":If:2s/*",             false],
                [4,     "èpera",        ":If:3s/*",             false],
                [4,     "èperons",      ":If:1p/*",             false],
                [4,     "èperez",       ":If:2p/*",             false],
                [4,     "èperont",      ":If:3p!/*",            false],
                [4,     "èperais",      ":K:1s:2s/*",           false],
                [4,     "èperait",      ":K:3s/*",              false],
                [4,     "èperions",     ":K:1p/*",              false],
                [4,     "èperiez",      ":K:2p/*",              false],
                [4,     "èperaient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èpe",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "erer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ère",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "ères",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èrent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "èrerai",       ":If:1s/*",             false],
                [4,     "èreras",       ":If:2s/*",             false],
                [4,     "èrera",        ":If:3s/*",             false],
                [4,     "èrerons",      ":If:1p/*",             false],
                [4,     "èrerez",       ":If:2p/*",             false],
                [4,     "èreront",      ":If:3p!/*",            false],
                [4,     "èrerais",      ":K:1s:2s/*",           false],
                [4,     "èrerait",      ":K:3s/*",              false],
                [4,     "èrerions",     ":K:1p/*",              false],
                [4,     "èreriez",      ":K:2p/*",              false],
                [4,     "èreraient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ère",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "eser": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èse",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èses",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èsent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "èserai",       ":If:1s/*",             false],
                [4,     "èseras",       ":If:2s/*",             false],
                [4,     "èsera",        ":If:3s/*",             false],
                [4,     "èserons",      ":If:1p/*",             false],
                [4,     "èserez",       ":If:2p/*",             false],
                [4,     "èseront",      ":If:3p!/*",            false],
                [4,     "èserais",      ":K:1s:2s/*",           false],
                [4,     "èserait",      ":K:3s/*",              false],
                [4,     "èserions",     ":K:1p/*",              false],
                [4,     "èseriez",      ":K:2p/*",              false],
                [4,     "èseraient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èse",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "eter": {
                "1": [
                    [2,     "er",           ":Y/*",                 false],
                    [2,     "ant",          ":P/*",                 false],
                    [4,     "ète",          ":Ip:Sp:1s:3s/*",       false],
                    [2,     "è",            ":Ip:1ś/R",             false],
                    [4,     "ètes",         ":Ip:Sp:2s/*",          false],
                    [2,     "ons",          ":Ip:1p/*",             false],
                    [2,     "ez",           ":Ip:2p/*",             false],
                    [4,     "ètent",        ":Ip:Sp:3p/*",          false],
                    [2,     "ais",          ":Iq:1s:2s/*",          false],
                    [2,     "ait",          ":Iq:3s/*",             false],
                    [2,     "ions",         ":Iq:Sp:1p/*",          false],
                    [2,     "iez",          ":Iq:Sp:2p/*",          false],
                    [2,     "aient",        ":Iq:3p/*",             false],
                    [2,     "ai",           ":Is:1s/*",             false],
                    [2,     "as",           ":Is:2s/*",             false],
                    [2,     "a",            ":Is:3s/*",             false],
                    [2,     "âmes",         ":Is:1p/*",             false],
                    [2,     "âtes",         ":Is:2p/*",             false],
                    [2,     "èrent",        ":Is:3p!/*",            false],
                    [4,     "èterai",       ":If:1s/*",             false],
                    [4,     "èteras",       ":If:2s/*",             false],
                    [4,     "ètera",        ":If:3s/*",             false],
                    [4,     "èterons",      ":If:1p/*",             false],
                    [4,     "èterez",       ":If:2p/*",             false],
                    [4,     "èteront",      ":If:3p!/*",            false],
                    [4,     "èterais",      ":K:1s:2s/*",           false],
                    [4,     "èterait",      ":K:3s/*",              false],
                    [4,     "èterions",     ":K:1p/*",              false],
                    [4,     "èteriez",      ":K:2p/*",              false],
                    [4,     "èteraient",    ":K:3p/*",              false],
                    [2,     "asse",         ":Sq:1s/*",             false],
                    [2,     "asses",        ":Sq:2s/*",             false],
                    [2,     "ât",           ":Sq:3s/*",             false],
                    [2,     "assions",      ":Sq:1p/*",             false],
                    [2,     "assiez",       ":Sq:2p/*",             false],
                    [2,     "assent",       ":Sq:3p/*",             false],
                    [4,     "ète",          ":E:2s/*",              false],
                    [2,     "ons",          ":E:1p/*",              false],
                    [2,     "ez",           ":E:2p/*",              false]
                ],
                "2": [
                    // d. verbes en -eter : doublement de la consonne t
                    [2,     "er",           ":Y/*",                 false],
                    [2,     "ant",          ":P/*",                 false],
                    [4,     "ette",         ":Ip:Sp:1s:3s/*",       "jeter$"],
                    [4,     "ette",         ":Ip:Sp:1s:3s/M",       "[^j]eter$"],
                    [4,     "ète",          ":Ip:Sp:1s:3s/R",       "[^j]eter$"],
                    [2,     "è",            ":Ip:1ś/R",             false],
                    [4,     "ettes",        ":Ip:Sp:2s/*",          "jeter$"],
                    [4,     "ettes",        ":Ip:Sp:2s/M",          "[^j]eter$"],
                    [4,     "ètes",         ":Ip:Sp:2s/R",          "[^j]eter$"],
                    [2,     "ons",          ":Ip:1p/*",             false],
                    [2,     "ez",           ":Ip:2p/*",             false],
                    [4,     "ettent",       ":Ip:Sp:3p/*",          "jeter$"],
                    [4,     "ettent",       ":Ip:Sp:3p/M",          "[^j]eter$"],
                    [4,     "ètent",        ":Ip:Sp:3p/R",          "[^j]eter$"],
                    [2,     "ais",          ":Iq:1s:2s/*",          false],
                    [2,     "ait",          ":Iq:3s/*",             false],
                    [2,     "ions",         ":Iq:Sp:1p/*",          false],
                    [2,     "iez",          ":Iq:Sp:2p/*",          false],
                    [2,     "aient",        ":Iq:3p/*",             false],
                    [2,     "ai",           ":Is:1s/*",             false],
                    [2,     "as",           ":Is:2s/*",             false],
                    [2,     "a",            ":Is:3s/*",             false],
                    [2,     "âmes",         ":Is:1p/*",             false],
                    [2,     "âtes",         ":Is:2p/*",             false],
                    [2,     "èrent",        ":Is:3p!/*",            false],
                    [4,     "etterai",      ":If:1s/*",             "jeter$"],
                    [4,     "etterai",      ":If:1s/M",             "[^j]eter$"],
                    [4,     "èterai",       ":If:1s/R",             "[^j]eter$"],
                    [4,     "etteras",      ":If:2s/*",             "jeter$"],
                    [4,     "etteras",      ":If:2s/M",             "[^j]eter$"],
                    [4,     "èteras",       ":If:2s/R",             "[^j]eter$"],
                    [4,     "ettera",       ":If:3s/*",             "jeter$"],
                    [4,     "ettera",       ":If:3s/M",             "[^j]eter$"],
                    [4,     "ètera",        ":If:3s/R",             "[^j]eter$"],
                    [4,     "etterons",     ":If:1p/*",             "jeter$"],
                    [4,     "etterons",     ":If:1p/M",             "[^j]eter$"],
                    [4,     "èterons",      ":If:1p/R",             "[^j]eter$"],
                    [4,     "etterez",      ":If:2p/*",             "jeter$"],
                    [4,     "etterez",      ":If:2p/M",             "[^j]eter$"],
                    [4,     "èterez",       ":If:2p/R",             "[^j]eter$"],
                    [4,     "etteront",     ":If:3p!/*",            "jeter$"],
                    [4,     "etteront",     ":If:3p!/M",            "[^j]eter$"],
                    [4,     "èteront",      ":If:3p!/R",            "[^j]eter$"],
                    [4,     "etterais",     ":K:1s:2s/*",           "jeter$"],
                    [4,     "etterais",     ":K:1s:2s/M",           "[^j]eter$"],
                    [4,     "èterais",      ":K:1s:2s/R",           "[^j]eter$"],
                    [4,     "etterait",     ":K:3s/*",              "jeter$"],
                    [4,     "etterait",     ":K:3s/M",              "[^j]eter$"],
                    [4,     "èterait",      ":K:3s/R",              "[^j]eter$"],
                    [4,     "etterions",    ":K:1p/*",              "jeter$"],
                    [4,     "etterions",    ":K:1p/M",              "[^j]eter$"],
                    [4,     "èterions",     ":K:1p/R",              "[^j]eter$"],
                    [4,     "etteriez",     ":K:2p/*",              "jeter$"],
                    [4,     "etteriez",     ":K:2p/M",              "[^j]eter$"],
                    [4,     "èteriez",      ":K:2p/R",              "[^j]eter$"],
                    [4,     "etteraient",   ":K:3p/*",              "jeter$"],
                    [4,     "etteraient",   ":K:3p/M",              "[^j]eter$"],
                    [4,     "èteraient",    ":K:3p/R",              "[^j]eter$"],
                    [2,     "asse",         ":Sq:1s/*",             false],
                    [2,     "asses",        ":Sq:2s/*",             false],
                    [2,     "ât",           ":Sq:3s/*",             false],
                    [2,     "assions",      ":Sq:1p/*",             false],
                    [2,     "assiez",       ":Sq:2p/*",             false],
                    [2,     "assent",       ":Sq:3p/*",             false],
                    [4,     "ette",         ":E:2s/*",              "jeter$"],
                    [4,     "ette",         ":E:2s/M",              "[^j]eter$"],
                    [4,     "ète",          ":E:2s/R",              "[^j]eter$"],
                    [2,     "ons",          ":E:1p/*",              false],
                    [2,     "ez",           ":E:2p/*",              false]
                ]
            },

            "ever": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ève",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èves",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èvent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [4,     "èverai",       ":If:1s/*",             false],
                [4,     "èveras",       ":If:2s/*",             false],
                [4,     "èvera",        ":If:3s/*",             false],
                [4,     "èverons",      ":If:1p/*",             false],
                [4,     "èverez",       ":If:2p/*",             false],
                [4,     "èveront",      ":If:3p!/*",            false],
                [4,     "èverais",      ":K:1s:2s/*",           false],
                [4,     "èverait",      ":K:3s/*",              false],
                [4,     "èverions",     ":K:1p/*",              false],
                [4,     "èveriez",      ":K:2p/*",              false],
                [4,     "èveraient",    ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ève",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "evrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "èvre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "èvres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èvrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [5,     "èvrerai",      ":If:1s/*",             false],
                [5,     "èvreras",      ":If:2s/*",             false],
                [5,     "èvrera",       ":If:3s/*",             false],
                [5,     "èvrerons",     ":If:1p/*",             false],
                [5,     "èvrerez",      ":If:2p/*",             false],
                [5,     "èvreront",     ":If:3p!/*",            false],
                [5,     "èvrerais",     ":K:1s:2s/*",           false],
                [5,     "èvrerait",     ":K:3s/*",              false],
                [5,     "èvrerions",    ":K:1p/*",              false],
                [5,     "èvreriez",     ":K:2p/*",              false],
                [5,     "èvreraient",   ":K:3p/*",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "èvre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            // c
            // verbes en -ébrer, -écer, -écher, -écrer, -éder, -éger, -égler, -égner, -égrer, -éguer,
            //           -éler, -émer, -éner, -éper, -équer, -érer, -éser, -éter, -étrer, -évrer, -éyer
            // changement du é en è

            "écer": [
                [2,     "er",           ":Y/*",                 false],
                [4,     "éçant",        ":P/*",                 false],
                [4,     "èce",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èces",         ":Ip:Sp:2s/*",          false],
                [4,     "éçons",        ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ècent",        ":Ip:Sp:3p/*",          false],
                [4,     "éçais",        ":Iq:1s:2s/*",          false],
                [4,     "éçait",        ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [4,     "éçaient",      ":Iq:3p/*",             false],
                [4,     "éçai",         ":Is:1s/*",             false],
                [4,     "éças",         ":Is:2s/*",             false],
                [4,     "éça",          ":Is:3s/*",             false],
                [4,     "éçâmes",       ":Is:1p/*",             false],
                [4,     "éçâtes",       ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "ècerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èceras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "ècera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "ècerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "ècerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èceront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "ècerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "ècerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "ècerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èceriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èceraient",    ":K:3p/R",              false],
                [4,     "éçasse",       ":Sq:1s/*",             false],
                [4,     "éçasses",      ":Sq:2s/*",             false],
                [4,     "éçât",         ":Sq:3s/*",             false],
                [4,     "éçassions",    ":Sq:1p/*",             false],
                [4,     "éçassiez",     ":Sq:2p/*",             false],
                [4,     "éçassent",     ":Sq:3p/*",             false],
                [4,     "èce",          ":E:2s/*",              false],
                [4,     "éçons",        ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éger": [
                [2,     "er",           ":Y/*",                 false],
                [4,     "égeant",       ":P/*",                 false],
                [4,     "ège",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èges",         ":Ip:Sp:2s/*",          false],
                [4,     "égeons",       ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ègent",        ":Ip:Sp:3p/*",          false],
                [4,     "égeais",       ":Iq:1s:2s/*",          false],
                [4,     "égeait",       ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [4,     "égeaient",     ":Iq:3p/*",             false],
                [4,     "égeai",        ":Is:1s/*",             false],
                [4,     "égeas",        ":Is:2s/*",             false],
                [4,     "égea",         ":Is:3s/*",             false],
                [4,     "égeâmes",      ":Is:1p/*",             false],
                [4,     "égeâtes",      ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "ègerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "ègeras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "ègera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "ègerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "ègerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "ègeront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "ègerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "ègerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "ègerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "ègeriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "ègeraient",    ":K:3p/R",              false],
                [4,     "égeasse",      ":Sq:1s/*",             false],
                [4,     "égeasses",     ":Sq:2s/*",             false],
                [4,     "égeât",        ":Sq:3s/*",             false],
                [4,     "égeassions",   ":Sq:1p/*",             false],
                [4,     "égeassiez",    ":Sq:2p/*",             false],
                [4,     "égeassent",    ":Sq:3p/*",             false],
                [4,     "ège",          ":E:2s/*",              false],
                [4,     "égeons",       ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "ébrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "èbre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "èbres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èbrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "èbrerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "èbreras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èbrera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "èbrerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "èbrerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "èbreront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "èbrerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "èbrerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "èbrerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "èbreriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "èbreraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "èbre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "écher": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "èche",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "èches",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èchent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "ècherai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ècheras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èchera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "ècherons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "ècherez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ècheront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "ècherais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "ècherait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "ècherions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ècheriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ècheraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "èche",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "écrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ècre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ècres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "ècrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "ècrerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ècreras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "ècrera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "ècrerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "ècrerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ècreront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "ècrerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "ècrerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "ècrerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ècreriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ècreraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ècre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éder": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ède",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èdes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èdent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èderai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èderas",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èdera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èderons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èderez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èderont",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èderais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èderait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èderions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èderiez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èderaient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ède",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "égler": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ègle",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ègles",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èglent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "èglerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ègleras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èglera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "èglerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "èglerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ègleront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "èglerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "èglerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "èglerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ègleriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ègleraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ègle",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "égner": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ègne",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ègnes",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "ègnent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "ègnerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ègneras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "ègnera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "ègnerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "ègnerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ègneront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "ègnerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "ègnerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "ègnerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ègneriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ègneraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ègne",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "égrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ègre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ègres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "ègrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "ègrerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ègreras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "ègrera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "ègrerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "ègrerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ègreront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "ègrerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "ègrerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "ègrerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ègreriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ègreraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ègre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éguer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ègue",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ègues",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èguent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "èguerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ègueras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èguera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "èguerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "èguerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ègueront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "èguerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "èguerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "èguerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ègueriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ègueraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ègue",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éler": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èle",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èles",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èlent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èlerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èleras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èlera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èlerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èlerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èleront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èlerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èlerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èlerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èleriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èleraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èle",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "émer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ème",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èmes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èment",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èmerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èmeras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èmera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èmerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èmerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èmeront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èmerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èmerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èmerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èmeriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èmeraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ème",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éner": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ène",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "ènes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ènent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "ènerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èneras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "ènera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "ènerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "ènerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èneront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "ènerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "ènerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "ènerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èneriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èneraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ène",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éper": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èpe",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èpes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èpent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èperai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èperas",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èpera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èperons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èperez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èperont",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èperais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èperait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èperions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èperiez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èperaient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èpe",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "équer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "èque",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "èques",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èquent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "èquerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "èqueras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èquera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "èquerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "èquerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "èqueront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "èquerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "èquerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "èquerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "èqueriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "èqueraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "èque",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "érer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ère",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "ères",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èrent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èrerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èreras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èrera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èrerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èrerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èreront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èrerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èrerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èrerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èreriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èreraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ère",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éser": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èse",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èses",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èsent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èserai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èseras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èsera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èserons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èserez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èseront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èserais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èserait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èserions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èseriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èseraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èse",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éter": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "ète",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "ètes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "ètent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èterai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èteras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "ètera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èterons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èterez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èteront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èterais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èterait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èterions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èteriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èteraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "ète",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "étrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "ètre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "ètres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "ètrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "ètrerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "ètreras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "ètrera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "ètrerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "ètrerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "ètreront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "ètrerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "ètrerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "ètrerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "ètreriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "ètreraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "ètre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "évrer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [5,     "èvre",         ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [5,     "èvres",        ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [5,     "èvrent",       ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [5,     "èvrerai",      ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [5,     "èvreras",      ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [5,     "èvrera",       ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [5,     "èvrerons",     ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [5,     "èvrerez",      ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [5,     "èvreront",     ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [5,     "èvrerais",     ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [5,     "èvrerait",     ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [5,     "èvrerions",    ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [5,     "èvreriez",     ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [5,     "èvreraient",   ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [5,     "èvre",         ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ],

            "éyer": [
                [2,     "er",           ":Y/*",                 false],
                [2,     "ant",          ":P/*",                 false],
                [4,     "èye",          ":Ip:Sp:1s:3s/*",       false],
                [2,     "è",            ":Ip:1ś/R",             false],
                [4,     "èyes",         ":Ip:Sp:2s/*",          false],
                [2,     "ons",          ":Ip:1p/*",             false],
                [2,     "ez",           ":Ip:2p/*",             false],
                [4,     "èyent",        ":Ip:Sp:3p/*",          false],
                [2,     "ais",          ":Iq:1s:2s/*",          false],
                [2,     "ait",          ":Iq:3s/*",             false],
                [2,     "ions",         ":Iq:Sp:1p/*",          false],
                [2,     "iez",          ":Iq:Sp:2p/*",          false],
                [2,     "aient",        ":Iq:3p/*",             false],
                [2,     "ai",           ":Is:1s/*",             false],
                [2,     "as",           ":Is:2s/*",             false],
                [2,     "a",            ":Is:3s/*",             false],
                [2,     "âmes",         ":Is:1p/*",             false],
                [2,     "âtes",         ":Is:2p/*",             false],
                [2,     "èrent",        ":Is:3p!/*",            false],
                [2,     "erai",         ":If:1s/M",             false],
                [4,     "èyerai",       ":If:1s/R",             false],
                [2,     "eras",         ":If:2s/M",             false],
                [4,     "èyeras",       ":If:2s/R",             false],
                [2,     "era",          ":If:3s/M",             false],
                [4,     "èyera",        ":If:3s/R",             false],
                [2,     "erons",        ":If:1p/M",             false],
                [4,     "èyerons",      ":If:1p/R",             false],
                [2,     "erez",         ":If:2p/M",             false],
                [4,     "èyerez",       ":If:2p/R",             false],
                [2,     "eront",        ":If:3p!/M",            false],
                [4,     "èyeront",      ":If:3p!/R",            false],
                [2,     "erais",        ":K:1s:2s/M",           false],
                [4,     "èyerais",      ":K:1s:2s/R",           false],
                [2,     "erait",        ":K:3s/M",              false],
                [4,     "èyerait",      ":K:3s/R",              false],
                [2,     "erions",       ":K:1p/M",              false],
                [4,     "èyerions",     ":K:1p/R",              false],
                [2,     "eriez",        ":K:2p/M",              false],
                [4,     "èyeriez",      ":K:2p/R",              false],
                [2,     "eraient",      ":K:3p/M",              false],
                [4,     "èyeraient",    ":K:3p/R",              false],
                [2,     "asse",         ":Sq:1s/*",             false],
                [2,     "asses",        ":Sq:2s/*",             false],
                [2,     "ât",           ":Sq:3s/*",             false],
                [2,     "assions",      ":Sq:1p/*",             false],
                [2,     "assiez",       ":Sq:2p/*",             false],
                [2,     "assent",       ":Sq:3p/*",             false],
                [4,     "èye",          ":E:2s/*",              false],
                [2,     "ons",          ":E:1p/*",              false],
                [2,     "ez",           ":E:2p/*",              false]
            ]
        }
    }
};
