
############################################################################
#    Copyright (C) 2005 by Fabio Marzocca                             #
#    thesaltydog@gmail.com                                                 #
#                            
#                                                  #
#    This program is free software; you can redistribute it and or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
#
# 
# 
############################################################################
package  gtkorphan_cbk ;

use vars qw($application);

#################################
# Initialize the global variable
#################################
sub init {
my $app = shift ;
$application = $app;
}

###########################
# Display the about window
###########################


sub on_about1_activate {
	my $auth1 = "Fabio Marzocca <thesaltydog\@gmail.com>";
	my $translator = _("translator-credits");
	($application->about)->set(
				authors=>$auth1, 
				version=>$application->version,
				name=>"GtkOrphan",
				copyright=>"Fabio Marzocca <thesaltydog\@gmail.com>",
				comments=>_('A graphical tool to find and remove orphaned libraries.'),
				website=>"http://www.marzocca.net/linux/gtkorphan.html",
				translator_credits=>$translator,
				logo => Gtk2::Gdk::Pixbuf->new_from_file($application->icon_path),
				license => "GPL");
	$application->about->set_transient_for($application->window);
	$application->about->run;
	$application->about->hide;
}


##############################
### To quit the application
##############################

sub on_quit_btn_clicked {
	Gtk2->main_quit;
}

sub on_ok_btn_clicked {
	my $retcode = gtkorphan_ops::remove_packages();
	
	if ($retcode == -1) {
		Gtk2->main_quit;
		exit;
		}
		
	if ($retcode) {
		my $options = gtkorphan_ops::get_orphan_options();
		gtkorphan_ops::find_orphaned($options);
	}

}


sub on_invalidate_orphaned {
	gtkorphan_ops::invalidate_orphaned();
	my $options="";
	my $page = $application->notebook->get_current_page();
	
	if ($page==0) {
		$options = gtkorphan_ops::get_orphan_options();
		gtkorphan_ops::find_orphaned($options);
	}
	if ($page==1) {
		$options = gtkorphan_ops::get_regular_options();
		gtkorphan_ops::populate_regular($options);		
	}
}

sub on_notebook1_switch_page {
	
	($notebook, $pointer, $page) = @_;
	gtkorphan_ops::show_statusbar_on_page($page);
}

sub on_invalidate_regular {
	gtkorphan_ops::invalidate_regular();
	my $options="";
	$options = gtkorphan_ops::get_regular_options();
	gtkorphan_ops::populate_regular($options);	
}

sub on_descending1_activate {
		gtkorphan_ops::alfa_sort('GTK_SORT_DESCENDING',undef);
}

sub on_ascending1_activate {
		gtkorphan_ops::alfa_sort('GTK_SORT_ASCENDING',undef);
}

sub on_hibernated_packages_list1_activate
{
	gtkorphan_ops::show_hibernated_packages();
}

sub on_package_details1_activate
{
	my ($selected_pack,$iter,$mdl,$treeview,$hcol);
	my $page = $application->notebook->get_current_page();
	
	if ($page==0) {
		$treeview=$application->list_orphaned;
		$hcol = 2; #H_NAME_COL	
	}
	if ($page==1) {
		$treeview=$application->tv_regular;
		$hcol = 4; #TV_H_COL_NAME	
	}
	$mdl = $treeview->get_model();
	@paths= $treeview->get_selection->get_selected_rows;
	
	#check
	if (!defined($paths[0])) {
		gtkorphan_ops::message(_("You should select a package first!"),'GTK_MESSAGE_ERROR');
		return;
	}
	
	$iter = $mdl->get_iter($paths[0]);	
	$selected_pack = $mdl->get($iter, $hcol);

	gtkorphan_ops::show_pack_details($selected_pack);
}


1;
