/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Jan  7 12:56:44 EST 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gtk/gtk.h>
#include "application.h"
#include "options.h"
#include "sound.h"
#include "game.h"

/**
  *@author Brian Ashe & Jacques Fortier
  */

// FPS (Frames Per Second) This sets the heartbeat of the program.
const int FPS=64;

// Events to handle the buttons on top (and bottom somday)
void destroy_event(GtkWidget *widget, gpointer data);
void restart_event(GtkWidget *widget, gpointer data);
void replace_event(GtkWidget *widget, gpointer data);
void set_cue(GtkWidget *widget, gpointer data);
void options_event(GtkWidget *widget, gpointer data);
void toggle_event(GtkWidget *widget, gpointer data);
void entry_activate_event(GtkWidget *widget, Application *);
void connect_event(GtkWidget *widget, Application *);

// Shutdown
gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);

gint configure_event(GtkWidget *widget, GdkEventConfigure *event);
gint expose_event(GtkWidget *widget, GdkEventExpose *event);
gint motion_notify_event(GtkWidget *widget, GdkEventMotion *event);
gint button_press_event(GtkWidget *widget, GdkEventButton *event);
gint button_release_event(GtkWidget *widget, GdkEventButton *event);
gint timeout_event(gpointer widget);

gint rack_expose_event(GtkWidget *widget, GdkEventExpose *event);

void usage();

// connect dialog stuff
void setup_connect_dialog(ConnectDialog *cd);
void cd_connect_event(GtkWidget *widget, Application *);
void cd_close_event(GtkWidget *widget, GtkWidget *);
void cd_destroy_event(GtkWidget *widget, Application *);


gint old_width, old_height;
bool debug = true;

Application app;

int main(int argc, char *argv[])
{
	GtkWidget *window;			// Main Window
	GtkWidget *button;			// For buttons
	GtkWidget *parent_box;		// Primary holder
	GtkWidget *top_box;			// Where the buttons are
	GtkWidget *bottom_box;		// Where the table and rack are
	GtkWidget *entry;			// Unused. Where the dialog is

	app.sound = true;			// Set sound to on

	old_width = old_height = 0;

	gtk_init(&argc, &argv);

	// setup main window
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "GTK Pool");
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy_event), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	// start setting up boxes
	parent_box = gtk_vbox_new(FALSE, 0);
	top_box = gtk_hbox_new(TRUE, 0);
	bottom_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), parent_box);
	gtk_box_pack_start(GTK_BOX(parent_box), top_box, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent_box), bottom_box, FALSE, FALSE, 0);

	// setup drawing_area -- where pool table will be displayed
	app.drawing_area = gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"configure_event",
	                   GTK_SIGNAL_FUNC(configure_event), NULL);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"expose_event",
	                   GTK_SIGNAL_FUNC(expose_event), NULL);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"motion_notify_event",
	                   GTK_SIGNAL_FUNC(motion_notify_event), NULL);
	app.button_press_handler_id = gtk_signal_connect(GTK_OBJECT(app.drawing_area),
	          "button_press_event",GTK_SIGNAL_FUNC(button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"button_release_event",
	                   GTK_SIGNAL_FUNC(button_release_event), NULL);
	gtk_widget_set_events (app.drawing_area, GDK_EXPOSURE_MASK
	                                   | GDK_LEAVE_NOTIFY_MASK
								| GDK_BUTTON_PRESS_MASK
								| GDK_BUTTON_RELEASE_MASK
								| GDK_POINTER_MOTION_MASK
								| GDK_POINTER_MOTION_HINT_MASK);
	gtk_drawing_area_size(GTK_DRAWING_AREA(app.drawing_area), app.width, app.height);

	app.rack_area = gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(app.rack_area),"expose_event",
	                   GTK_SIGNAL_FUNC(rack_expose_event), NULL);
	gtk_widget_set_events (app.rack_area, GDK_EXPOSURE_MASK);
	gtk_drawing_area_size(GTK_DRAWING_AREA(app.rack_area), app.width, 70);


	// setup buttons that go along top of window -- quit pause restart
	button = gtk_button_new_with_label("Quit");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(destroy_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_toggle_button_new_with_label("Pause");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(toggle_event), app.drawing_area);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Options");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(options_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Restart");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(restart_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Spot Last Ball");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(replace_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Ball in Hand");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(set_cue), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

/*	button = gtk_button_new_with_label("Connect");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(connect_event), &app);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);*/

	//setup chat box for multiplayer
	app.chat_text = gtk_text_new((GtkAdjustment *)NULL, (GtkAdjustment *)NULL);
	gtk_widget_set_usize(app.chat_text, -2, 60);
	gtk_text_set_editable(GTK_TEXT(app.chat_text), FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(app.chat_text), TRUE);
	gtk_widget_set_events (app.chat_text, GDK_NOTHING);
//	networking not ready for this version

	entry = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(entry), "activate",
	                   GTK_SIGNAL_FUNC(entry_activate_event), &app);
//	gtk_widget_show(entry);
//	networking not ready for this version

	gtk_box_pack_start(GTK_BOX(bottom_box), app.drawing_area, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), app.rack_area, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), app.chat_text, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), entry, TRUE, FALSE, 0);
	gtk_widget_show(app.drawing_area);
	gtk_widget_show(app.rack_area);
	gtk_widget_show(app.chat_text);
	gtk_widget_show(top_box);
	gtk_widget_show(bottom_box);
	gtk_widget_show(parent_box);

	app.init();

	gtk_widget_show  (window);

	app.print_message("GTKPool version 0.5.0, Copyright (C) 1999-2002 Brian Ashe & Jacques Fortier");
	app.print_message("This is free software, and you are welcome to redistribute it under the terms of the GPL.");
	app.print_message("However, it comes with ABSOLUTELY NO WARRANTY; for details see the file 'COPYING'.");

	app.running = true;
	gtk_timeout_add(1024 / FPS, GtkFunction(timeout_event), app.drawing_area);
	gtk_main ();

	return(0);

}

gint expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	gdk_draw_pixmap(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
	                app.buf_pixmap, event->area.x, event->area.y, event->area.x,
				 event->area.y, event->area.width, event->area.height);
	return FALSE;
}

gint configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	if(old_width != widget->allocation.width || old_height != widget->allocation.height)
	{
		if(app.buf_pixmap)
			gdk_pixmap_unref(app.buf_pixmap);
		app.buf_pixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
		                                widget->allocation.height, -1);
		app.gc = gdk_gc_new(widget->window);
		gdk_gc_set_foreground(app.gc, app.black);
		gdk_draw_rectangle(app.buf_pixmap, app.gc, 1, 0, 0,
		                   widget->allocation.width, widget->allocation.height);
		app.paint(app.buf_pixmap, app.gc);
		gdk_gc_unref(app.gc);
		old_width = widget->allocation.width; old_height = widget->allocation.height;
	}
	return TRUE;
}


gint motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
	int x, y;
	GdkModifierType state;
	if(event->is_hint)
		gdk_window_get_pointer(widget->window, &x, &y, &state);
	else
	{
		x = int(event->x); y = int(event->y);
		state = (GdkModifierType)event->state;
	}
	if(state & GDK_BUTTON1_MASK && app.running)
		app.mouse_drag(x, y);
	return TRUE;
}


gint button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	if(event->button == 1 && app.running)
	{
		app.mouse_down(int(event->x), int(event->y));
		gtk_grab_add(widget);
	}
	return TRUE;
}
gint button_release_event(GtkWidget *widget, GdkEventButton *event)
{
	if(event->button == 1 && app.running)
	{
		app.mouse_up(int(event->x), int(event->y));
		gtk_grab_remove(widget);
	}
	return TRUE;
}


void destroy_event(GtkWidget *widget, gpointer data)
{
	app.running = false;
	app.destroy();
	gtk_main_quit();
}

void replace_event(GtkWidget *widget, gpointer data)
{
	app.replaceBall();
}
				
void set_cue(GtkWidget *widget, gpointer data)
{				
	app.ball_in_hand();
}

void restart_event(GtkWidget *widget, gpointer data)
{
	app.resetTable();
}

void options_event(GtkWidget *widget, gpointer data)
{
	if(app.opt_dlg == (GtkWidget *)NULL) {
		app.opt_dlg = open_opt_dlg(&app);
		gtk_widget_show(app.opt_dlg);
	} else
	{
		gtk_widget_show(app.opt_dlg);
	}
}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return FALSE; // okay to close down--could later add ok to quit thing
}

void toggle_event(GtkWidget *widget, gpointer data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
	{
		app.running = false; // pause the game
	}
	else
	{
		app.running = true; // unpause
		gtk_timeout_add(1024 / FPS, GtkFunction(timeout_event),
		                GTK_WIDGET(data)); // data = drawing_area
	}
}

/*******************************************************************
This is the function that controls the beat of the game.  Every time
it is called, it moves everything one animation frame and then updates
the screen.  It uses a sort of "compromise dirty rectangle" system.
The buffer is updated at every iteration, but only the parts of the
buffer that have changed are copied to the screen.
*******************************************************************/
gint timeout_event(gpointer widget)
{
	if(!app.running)
		return FALSE; // no more timeouts, no more animation
	app.updateBalls();
	if(app.collide_tf && app.sound)
		play_sound(app.coll_snd, 2048);
	if(app.sunk_tf && app.sound)
		play_sound(app.pock_snd, 8192);
	
	// Redraw to clean up stuff on screen
	if(udl != -1)
	{
		GdkRectangle ud_rect;
		ud_rect.x = udl; ud_rect.width  = udr - udl;
		ud_rect.y = udt; ud_rect.height = udb - udt;
		app.gc = gdk_gc_new(GTK_WIDGET(widget)->window);
		app.paint(app.buf_pixmap, app.gc);
		gdk_gc_unref(app.gc);
		gtk_widget_draw(GTK_WIDGET(widget), &ud_rect);
		udl = -1;
	}	
	
	if (app.thegame->shot)
	{
		if (app.thegame->shot_over(app.balls))
		{
			if(app.thegame->switch_turns(app.game_name))
		   		app.update_rack();
		 	
			if (app.thegame->scratched)
   				app.new_cue_ball();

			if (app.thegame->do_foul && !app.thegame->scratched)
				app.ball_in_hand();
				
			// Replace the errant ball if playing rotation
			if ((app.thegame->do_foul || app.thegame->scratched)
				 && app.game_name == rotation
				 && app.thegame->first_ball_sunk)
			{
				app.replaceBall();
			}
   	
			// Give a comment on the shot and then reset for the next one.
			app.print_message("");
			app.print_message(app.thegame->comment);
			app.thegame->shot = false;
		}
	}
	
	return TRUE; // keep them timeouts coming
}

gint rack_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	int c = 0;
	char p1_name [31];
	char p2_name [31];
	//GdkFont *fixed_font;
	GdkFont *big_font;

	/* Load a fixed font */
	//fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");
	big_font = gdk_font_load ("-macromedia-Helmet-bold-r-normal-*-24-*-*-*-p-*-ascii-0");
	if (big_font == NULL)
		big_font = gdk_font_load ("-*-*-bold-r-normal-*-24-*-*-*-p-*-*");
	
	GdkGC *gc = gdk_gc_new(widget->window);
	// Draw in our black background
	gdk_gc_set_foreground(gc, app.black);
	gdk_draw_rectangle(widget->window, gc, 1, event->area.x, event->area.y,
	                   event->area.width, event->area.height);
	gdk_gc_set_clip_mask(gc, app.rack_mask);
	gdk_gc_set_clip_origin(gc, (app.width - 256) / 2, 3);

	// Set the color for each player by turn
	switch (app.thegame->turn)
	{
		case tplayer1:
			app.p1_color = app.red;
			app.p2_color = app.yellow;
			strcpy(p1_name, "*");
			strcpy(p2_name, " ");
			break;
		
		case tplayer2:
			app.p1_color = app.yellow;
			app.p2_color = app.red;
			strcpy(p1_name, " ");
			strcpy(p2_name, "*");
			break;
		
	}
	
	// Show winner if there is one
	if (app.thegame->winner >= 0)
	{
		gdk_gc_set_foreground(gc, app.red);
		// See who won
		if (app.thegame->winner == tplayer1)
			gdk_draw_string(widget->window, big_font, gc, 23, 28, app.thegame->player_1.player_name);
		if (app.thegame->winner == tplayer2)
			gdk_draw_string(widget->window, big_font, gc, 23, 28, app.thegame->player_2.player_name);

		gdk_draw_string(widget->window, big_font, gc, (app.width / 3), 28, "Is the WINNER!!!");
		gdk_gc_unref(gc);
		gdk_font_unref(big_font);
		return FALSE;
	}
	
	// Write the player names on the screen
	if (app.game_name != no_rules)
	{
		strcat(p1_name, app.thegame->player_1.player_name);
		strcat(p2_name, app.thegame->player_2.player_name);
		gdk_gc_set_foreground(gc, app.p1_color);
		gdk_draw_string(widget->window, big_font, gc, 23, 28, p1_name);
		gdk_gc_set_foreground(gc, app.p2_color);
		gdk_draw_string(widget->window, big_font, gc, 23, 64, p2_name);
	
	// Show scores in Rotation
		if (app.game_name == rotation)
		{
			strcpy(app.s1, g_strdup_printf("-%d-", app.thegame->player_1.score));
			strcpy(app.s2, g_strdup_printf("-%d-", app.thegame->player_2.score));
			gdk_gc_set_foreground(gc, app.p1_color);
			gdk_draw_string(widget->window, big_font, gc, (app.width - 80), 28, app.s1);
			gdk_gc_set_foreground(gc, app.p2_color);
			gdk_draw_string(widget->window, big_font, gc, (app.width - 80), 64, app.s2);
		}	
	}	
	
	// Show Player 1 balls sunk
	for(std::vector<int>::iterator i = app.thegame->player_1.sunkballs.begin();
	    i < app.thegame->player_1.sunkballs.end(); i++)
	{
		// draw each sunk ball onto the rack, in the order it was sunk
		int rx = (app.width / 3) + (c * 36) + 3; // 32 pixels for the ball image, plus 4 for spacing, and a 3 px border
		int ry = 3;
		gdk_gc_set_clip_mask(gc, app.balls_big_pixmap_masks[*i]);
		gdk_gc_set_clip_origin(gc, rx, ry);
		gdk_draw_pixmap(widget->window, gc, app.balls_big_pixmaps[*i], 0, 0, rx, ry, 32, 32);
		c++;
	}
	c = 0;
	// Show Player 2 balls sunk
	for(std::vector<int>::iterator i = app.thegame->player_2.sunkballs.begin();
	    i < app.thegame->player_2.sunkballs.end(); i++)
	{
		// draw each sunk ball onto the rack, in the order it was sunk
		int rx = (app.width / 3) + (c * 36) + 3; // 32 pixels for the ball image, plus 4 for spacing, and a 3 px border
		int ry = 3 + 36; // second row
		gdk_gc_set_clip_mask(gc, app.balls_big_pixmap_masks[*i]);
		gdk_gc_set_clip_origin(gc, rx, ry);
		gdk_draw_pixmap(widget->window, gc, app.balls_big_pixmaps[*i], 0, 0, rx, ry, 32, 32);
		c++;
	}

	gdk_gc_unref(gc);
	gdk_font_unref(big_font);
	return FALSE;
}

void entry_activate_event(GtkWidget *widget, Application *app)
{
	if(app->connected)
	{
		app->print_message(gtk_entry_get_text(GTK_ENTRY(widget)), 4);
	}
	else
		app->print_message("You are not currently in a network game");
	gtk_entry_set_text(GTK_ENTRY(widget), "");
}

void connect_event(GtkWidget *widget, Application *app)
{
	if(app->connect_dialog)
		return;
	app->connect_dialog = new ConnectDialog;
	setup_connect_dialog(app->connect_dialog);
}

void setup_connect_dialog(ConnectDialog *cd)
{
	cd->dialog = gtk_dialog_new();
//	GtkWidget *button;
	GtkWidget *table;;
	GtkWidget *label;
//	GtkWidget *hbox;
//	GtkWidget *frame;
//	GtkWidget *btn_box;
//	GSList *group;
	gtk_window_set_title(GTK_WINDOW(cd->dialog), "Multiplayer Setup");

	// setup table
	table = gtk_table_new(4, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->vbox), table, TRUE, TRUE, 0);
	gtk_widget_show(table);

	label = gtk_label_new("Hostname");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_widget_show(label);
	label = gtk_label_new("Port");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	gtk_widget_show(label);
	label = gtk_label_new("Handle");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	gtk_widget_show(label);

	cd->host_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), cd->host_entry, 1, 2, 0, 1);
	gtk_widget_show(cd->host_entry);

	cd->port_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cd->port_entry), "9874");
	gtk_table_attach_defaults(GTK_TABLE(table), cd->port_entry, 1, 2, 1, 2);
	gtk_widget_show(cd->port_entry);

	cd->handle_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), cd->handle_entry, 1, 2, 2, 3);
	gtk_widget_show(cd->handle_entry);

	cd->connect_button = gtk_button_new_with_label("Connect");
	gtk_signal_connect(GTK_OBJECT(cd->connect_button), "clicked",
	                   GTK_SIGNAL_FUNC(cd_connect_event), &app);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->action_area), cd->connect_button,
	                   TRUE, TRUE, 0);
	gtk_widget_show(cd->connect_button);

	cd->cancel_button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(cd->cancel_button), "clicked",
	                   GTK_SIGNAL_FUNC(cd_close_event), cd->dialog);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->action_area), cd->cancel_button,
	                   TRUE, TRUE, 0);
	gtk_widget_show(cd->cancel_button);

//	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(cd->dialog), "destroy", GTK_SIGNAL_FUNC(cd_destroy_event), &app);
//	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);

	gtk_widget_show(cd->dialog);
}

void cd_connect_event(GtkWidget *widget, Application *app)
{
	if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->host_entry))))
	{
		app->print_message("You must specify a host to connect to");
	}
	else if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->port_entry))))
	{
		app->print_message("You must specify a port to connect to");
	}
	else if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->handle_entry))))
	{
		app->print_message("You must give yourself a handle");
	}
	else
	{
//connect
		app->print_message("Network mode unimplemented");
		gtk_widget_destroy(app->connect_dialog->dialog);
	}
}

void cd_close_event(GtkWidget *widget, GtkWidget *cd)
{
	gtk_widget_destroy(cd);
}

void cd_destroy_event(GtkWidget *widget, Application *app)
{
	delete app->connect_dialog;
	app->connect_dialog = (ConnectDialog *)NULL;
}


void usage()
{
	g_message("Usage not implemented right now.\n");
}
