/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggpageobject.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "ishell.h"
#include "iviewmodule.h"
#include "iviewobject.h"
#include "iviewobjectfamily.h"
#include "iviewsubject.h"

#include "iggdatatypeprovider.h"
#include "iggframedatatypeselector.h"

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


iggPageObject::iggPageObject(iggFrameBase *parent, int type) : iggPageMain(parent), mType(type)
{
	mProvider = new iggViewSubjectDataTypeProvider(this); IERROR_ASSERT(mProvider);
	mScalarProvider = new iggScalarDataTypeProvider(this); IERROR_ASSERT(mScalarProvider);
}


iggPageObject::~iggPageObject()
{
	delete mProvider;
	delete mScalarProvider;
}


const iViewModule* iggPageObject::GetViewModule() const
{
	return this->GetShell()->GetControlModule()->GetViewModule();
}


iggFrame* iggPageObject::CreateFlipFrame(iggFrameBase *parent) const
{
	return new iggFrameDataTypeSelector(mProvider,false,"Use data",parent);
}


iViewObject* iggPageObject::GetViewObject() const
{
	return this->GetViewModule()->GetViewObjectFamily(mType)->GetCurrentMember();
}

#endif
