/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.testng.ITestNGMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;

public class AnnotationHelper {
    private static Class[] ALL_ANNOTATIONS = new Class[]{ITest.class, IConfiguration.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class, IDataProvider.class, IExpectedExceptions.class, IFactory.class, IParameters.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class};
    public static Class[] CONFIGURATION_CLASSES = new Class[]{IConfiguration.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class};

    public static ITest findTest(IAnnotationFinder finder, Class cls) {
        return (ITest)finder.findAnnotation(cls, ITest.class);
    }

    public static ITest findTest(IAnnotationFinder finder, Method m) {
        return (ITest)finder.findAnnotation(m, ITest.class);
    }

    public static IFactory findFactory(IAnnotationFinder finder, Method m) {
        return (IFactory)finder.findAnnotation(m, IFactory.class);
    }

    public static ITest findTest(IAnnotationFinder finder, Constructor ctor) {
        return (ITest)finder.findAnnotation(ctor, ITest.class);
    }

    public static IConfiguration findConfiguration(IAnnotationFinder finder, Constructor ctor) {
        IConfiguration result = (IConfiguration)finder.findAnnotation(ctor, IConfiguration.class);
        if (result == null) {
            IConfiguration bs = (IConfiguration)finder.findAnnotation(ctor, IBeforeSuite.class);
            IConfiguration as = (IConfiguration)finder.findAnnotation(ctor, IAfterSuite.class);
            IConfiguration bt = (IConfiguration)finder.findAnnotation(ctor, IBeforeTest.class);
            IConfiguration at = (IConfiguration)finder.findAnnotation(ctor, IAfterTest.class);
            IConfiguration bg = (IConfiguration)finder.findAnnotation(ctor, IBeforeGroups.class);
            IConfiguration ag = (IConfiguration)finder.findAnnotation(ctor, IAfterGroups.class);
            IConfiguration bc = (IConfiguration)finder.findAnnotation(ctor, IBeforeClass.class);
            IConfiguration ac = (IConfiguration)finder.findAnnotation(ctor, IAfterClass.class);
            IConfiguration bm = (IConfiguration)finder.findAnnotation(ctor, IBeforeMethod.class);
            IConfiguration am = (IConfiguration)finder.findAnnotation(ctor, IAfterMethod.class);
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    public static IConfiguration findConfiguration(IAnnotationFinder finder, Method m) {
        IConfiguration result = (IConfiguration)finder.findAnnotation(m, IConfiguration.class);
        if (result == null) {
            IConfiguration bs = (IConfiguration)finder.findAnnotation(m, IBeforeSuite.class);
            IConfiguration as = (IConfiguration)finder.findAnnotation(m, IAfterSuite.class);
            IConfiguration bt = (IConfiguration)finder.findAnnotation(m, IBeforeTest.class);
            IConfiguration at = (IConfiguration)finder.findAnnotation(m, IAfterTest.class);
            IConfiguration bg = (IConfiguration)finder.findAnnotation(m, IBeforeGroups.class);
            IConfiguration ag = (IConfiguration)finder.findAnnotation(m, IAfterGroups.class);
            IConfiguration bc = (IConfiguration)finder.findAnnotation(m, IBeforeClass.class);
            IConfiguration ac = (IConfiguration)finder.findAnnotation(m, IAfterClass.class);
            IConfiguration bm = (IConfiguration)finder.findAnnotation(m, IBeforeMethod.class);
            IConfiguration am = (IConfiguration)finder.findAnnotation(m, IAfterMethod.class);
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    private static IConfiguration createConfiguration(IConfiguration bs, IConfiguration as, IConfiguration bt, IConfiguration at, IConfiguration bg, IConfiguration ag, IConfiguration bc, IConfiguration ac, IConfiguration bm, IConfiguration am) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        if (bs != null) {
            result.setBeforeSuite(true);
            AnnotationHelper.finishInitialize(result, bs);
        }
        if (as != null) {
            result.setAfterSuite(true);
            AnnotationHelper.finishInitialize(result, as);
        }
        if (bt != null) {
            result.setBeforeTest(true);
            AnnotationHelper.finishInitialize(result, bt);
        }
        if (at != null) {
            result.setAfterTest(true);
            AnnotationHelper.finishInitialize(result, at);
        }
        if (bg != null) {
            result.setBeforeGroups(bg.getBeforeGroups());
            AnnotationHelper.finishInitialize(result, bg);
        }
        if (ag != null) {
            result.setAfterGroups(ag.getAfterGroups());
            AnnotationHelper.finishInitialize(result, ag);
        }
        if (bc != null) {
            result.setBeforeTestClass(true);
            AnnotationHelper.finishInitialize(result, bc);
        }
        if (ac != null) {
            result.setAfterTestClass(true);
            AnnotationHelper.finishInitialize(result, ac);
        }
        if (bm != null) {
            result.setBeforeTestMethod(true);
            AnnotationHelper.finishInitialize(result, bm);
        }
        if (am != null) {
            result.setAfterTestMethod(true);
            AnnotationHelper.finishInitialize(result, am);
        }
        return result;
    }

    private static void finishInitialize(ConfigurationAnnotation result, IConfiguration bs) {
        result.setFakeConfiguration(true);
        result.setAlwaysRun(bs.getAlwaysRun());
        result.setDependsOnGroups(bs.getDependsOnGroups());
        result.setDependsOnMethods(bs.getDependsOnGroups());
        result.setDescription(bs.getDescription());
        result.setEnabled(bs.getEnabled());
        result.setGroups(bs.getGroups());
        result.setInheritGroups(bs.getInheritGroups());
        result.setParameters(bs.getParameters());
    }

    public static Class[] getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class rootClass, Class annotationClass, IAnnotationFinder annotationFinder) {
        HashMap<String, TestNGMethod> vResult = new HashMap<String, TestNGMethod>();
        try {
            vResult = new HashMap();
            for (Class cls = rootClass; null != cls; cls = cls.getSuperclass()) {
                boolean hasClassAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, cls, annotationClass);
                Method[] methods = cls.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    boolean hasMethodAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, annotationClass);
                    boolean hasTestNGAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, IFactory.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, ITest.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, CONFIGURATION_CLASSES);
                    boolean isPublic = Modifier.isPublic(m.getModifiers());
                    if ((!isPublic || !hasClassAnnotation || hasTestNGAnnotation) && !hasMethodAnnotation) continue;
                    if (AnnotationHelper.isAnnotationPresent(annotationFinder, m, IConfiguration.class) && AnnotationHelper.isAnnotationPresent(annotationFinder, cls, ITest.class)) {
                        Utils.log("", 3, "Method " + m + " has a local @Configuration and a class-level @Test." + "This method will only be kept as a @Configuration.");
                        continue;
                    }
                    if (m.getReturnType() != Void.TYPE) {
                        Utils.log("", 3, "Method " + m + " has a @Test annotation" + " but also a return value:  ignoring it.");
                        continue;
                    }
                    String key = AnnotationHelper.createMethodKey(m);
                    if (null != vResult.get(key)) continue;
                    TestNGMethod tm = new TestNGMethod(m, annotationFinder);
                    vResult.put(key, tm);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        ITestNGMethod[] result = vResult.values().toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class[] annotationClasses) {
        for (Class a : annotationClasses) {
            if (annotationFinder.findAnnotation(m, a) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class annotationClass) {
        return annotationFinder.findAnnotation(m, annotationClass) != null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Class cls, Class annotationClass) {
        return annotationFinder.findAnnotation(cls, annotationClass) != null;
    }

    private static String createMethodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        for (Class<?> paramClass : m.getParameterTypes()) {
            result.append(' ').append(paramClass.toString());
        }
        return result.toString();
    }
}

