/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterName
implements Comparable<ParameterName> {
    public static final Pattern pattern = Pattern.compile("\\[.*?\\]");
    private String name;
    private String strippedName;
    private boolean indexed;

    public ParameterName(String name) {
        this.name = name;
        Matcher matcher = pattern.matcher(this.name);
        this.indexed = matcher.find();
        this.strippedName = this.indexed ? matcher.replaceAll("") : this.name;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public String getName() {
        return this.name;
    }

    public String getStrippedName() {
        return this.strippedName;
    }

    @Override
    public int compareTo(ParameterName that) {
        int result = new Integer(this.name.length()).compareTo(that.name.length());
        if (result == 0) {
            result = this.name.compareTo(that.name);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof ParameterName && (this == obj || this.compareTo((ParameterName)obj) == 0);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

