/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class InternetExplorerCustomProxyLauncher
extends AbstractBrowserLauncher {
    static Log log = LogFactory.getLog(InternetExplorerCustomProxyLauncher.class);
    private File customProxyPACDir;
    private String[] cmdarray;
    private String commandPath;
    private Process process;
    protected boolean customPACappropriate = true;
    protected WindowsProxyManager wpm;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;

    public InternetExplorerCustomProxyLauncher(int port, String sessionId) {
        this(port, sessionId, InternetExplorerCustomProxyLauncher.findBrowserLaunchLocation());
    }

    public InternetExplorerCustomProxyLauncher(int port, String sessionId, String browserLaunchLocation) {
        super(sessionId);
        this.commandPath = browserLaunchLocation;
        this.sessionId = sessionId;
        this.wpm = new WindowsProxyManager(true, sessionId, port);
    }

    protected void changeRegistrySettings() throws IOException {
        this.wpm.changeRegistrySettings();
    }

    protected static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("internetExplorerDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.getProgramFilesPath() + "\\Internet Explorer\\iexplore.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File iexploreEXE = AsyncExecute.whichExec("iexplore.exe");
        if (iexploreEXE != null) {
            return iexploreEXE.getAbsolutePath();
        }
        throw new RuntimeException("Internet Explorer couldn't be found in the path!\nPlease add the directory containing iexplore.exe to your PATH environment\nvariable, or explicitly specify a path to IE like this:\n*iexplore c:\\blah\\iexplore.exe");
    }

    public void launch(String url) {
        try {
            if (WindowsUtils.thisIsWindows()) {
                this.wpm.backupRegistrySettings();
                this.changeRegistrySettings();
                this.customProxyPACDir = this.wpm.getCustomProxyPACDir();
                File killableProcessWrapper = new File(this.customProxyPACDir, "killableprocess.exe");
                ResourceExtractor.extractResourcePath(InternetExplorerCustomProxyLauncher.class, "/killableprocess/killableprocess.exe", killableProcessWrapper);
                this.cmdarray = new String[]{killableProcessWrapper.getAbsolutePath(), this.commandPath, "-new", url};
            } else {
                this.cmdarray = new String[]{this.commandPath, url};
            }
            log.info("Launching Internet Explorer...");
            AsyncExecute exe = new AsyncExecute();
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        Throwable taskKillException = null;
        if (WindowsUtils.thisIsWindows()) {
            this.wpm.restoreRegistrySettings();
        }
        if (this.process == null) {
            return;
        }
        try {
            this.process.getOutputStream().write(10);
            this.process.getOutputStream().flush();
            Thread.sleep(200L);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        AsyncExecute.killProcess(this.process);
        if (this.customPACappropriate) {
            try {
                LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
            }
            catch (RuntimeException e) {
                if (taskKillException != null) {
                    log.error("Couldn't delete custom IE proxy directory", e);
                    log.error("Perhaps IE proxy delete error was caused by this exception", taskKillException);
                    throw new RuntimeException("Couldn't delete custom IE proxy directory, presumably because task kill failed; see error log!", e);
                }
                throw e;
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(4444, "CUSTIE");
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }
}

