/*
 * Copyright (c) 2005, KNOPFLERFISH project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following
 * conditions are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the KNOPFLERFISH project nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.knopflerfish.bundle.event;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Constants;
import org.osgi.service.event.EventAdmin;
import org.knopflerfish.service.log.LogRef;

/**
 * The Activator class is the startup class for the EventHandlerService.
 *
 * @author Magnus Klack
 */
public class Activator implements BundleActivator {

    /** the service id string */
    final static String SERVICE_PID = "org.osgi.service.event.EventAdmin";

    protected static BundleContext bundleContext;
    protected static LogRef log;

    private EventAdminService eventAdmin;

    /**
     * Main entry for the service
     *
     * @param context the BundleContext ,ie, the handle to the OSGi framework
     */
    public void start(BundleContext context) throws Exception {
        /* assign the context variable to a local variable */
        bundleContext = context;
        log = new LogRef(context);

        /* create the event admin service */
        eventAdmin = new EventAdminService(bundleContext);
        /* create the hashtable */
        Hashtable propsTable = new Hashtable();
        /* add the Constant variable and the id to the Hashtable */
        propsTable.put(Constants.SERVICE_PID, SERVICE_PID);
        /* register the service to the framework */
        bundleContext.registerService(EventAdmin.class.getName(), eventAdmin,
                propsTable);
    }

    /**
     * Stop the service
     *
     * @param context the BundleContext ,ie, the handle to the OSGi framework
     */
    public void stop(BundleContext context) throws Exception {
      eventAdmin.stop();
      eventAdmin = null;
    }
}
