/***************************************************************************
 *   Copyright (C) 2005-2013 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORPRESET_H_
#define _KOMPARATORPRESET_H_

#include <QDate>

class KomparatorWidget;
class KUrl;
class QString;

class KomparatorPreset
{
	public:
		KomparatorPreset( KomparatorWidget *_parent, KSharedConfigPtr &config );
		QString title();
		bool readConfig( uint preset_number );
		bool saveConfig( uint preset_number );
		bool readFromInterface( bool reread = false );
		void setToInterface();

	private:
		KomparatorWidget *m_parent;
		QString m_preset_title;
		KSharedConfigPtr m_config;

		QString m_slot_preset_title;
		QString m_slot_url1;
		QString m_slot_url2;

		KUrl m_url1;
		KUrl m_url2;
		QString m_regex_contains;
		QString m_regex_containsnot;
		uint m_size_selection; // 0 = none, 1 = at least, 2 = at most, 3 = equal to.
		uint m_size; // spin box content
		uint m_size_multiple; // 0 = bytes, 1 = KB, 2 = MB
		uint m_modified_or_created; // 0 = any, 1 = between, 2 = during the last
		QDate m_date1;
		QDate m_date2;
		uint m_date3_num;
		uint m_modified_last; // 0 = minutes, 1 = hours, 2 = days, 3 = months, 4 = years
		bool m_ignore_empty;
		bool m_size_comparison;
		bool m_md5_sum;
		bool m_binary_comparison;
		uint m_binary_comparison_size; // in MB
		bool m_duplicates_right_url_only;
		bool m_empty_directories;
		bool m_include_subdirectories;
		bool m_include_hidden_items;
		bool m_use_locate;
		bool m_case_sensitive;
		bool m_soft_links;
		bool m_enable_duplicates_search;
		bool m_enable_missing_search;
		bool m_enable_newer_search;
		bool m_reference_directory_left;
		QStringList m_filter_string;
		QList<int> m_filter_int;
		QStringList m_virtual_subdirectories;
};

#endif
