package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGPathElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPathElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/14/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPathElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGPathElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try 
		{ 
			new SVGPathElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){ /**/ }
		
		try 
		{ 
			node.setAttribute(SVGAttributes.SVG_D, "test");
			new SVGPathElement(node, null);
		}
		catch(MalformedSVGDocument e){  fail(); }
	}
	
	
	@Test
	public void testGetPathData()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_D, "M 0 0 L 10 10");
			SVGPathElement e = new SVGPathElement(node, null);
			assertEquals(e.getPathData(), "M 0 0 L 10 10");
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_PATH;
	}
}
