l = require "luxio"
s = require "luxio.simple"

local mq, errno

mq, errno = l.mq_open("/luxio.test", l.bit.bor(l.O_RDONLY, l.O_CREAT), s.tomode "0777")

if mq == -1 then
	error(l.strerror(errno))
end


io.stdout:write(tostring(mq) .. " attributes:\n")

r, errno, attr = l.mq_getattr(mq)

for i, v in pairs(attr) do
	io.stdout:write("  ", i, " ", v, "\n")
end

local message, bytes, priority

repeat
	bytes, errno, message, priority = l.mq_receive(mq)
	print(bytes, errno, message, priority)	
until message == "QUIT" or bytes == -1

l.mq_close(mq)
l.mq_unlink "/luxio-test"
