/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Measurement;
import com.google.caliper.MeasurementSet;
import com.google.caliper.Run;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class Json {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).registerTypeAdapter(Run.class, (Object)new RunTypeAdapter()).registerTypeAdapter(Measurement.class, (Object)new MeasurementDeserializer()).create();

    public static Gson getGsonInstance() {
        return GSON_INSTANCE;
    }

    public static String measurementSetToJson(MeasurementSet measurementSet) {
        return new Gson().toJson((Object)measurementSet);
    }

    public static MeasurementSet measurementSetFromJson(String measurementSetJson) {
        try {
            return (MeasurementSet)Json.getGsonInstance().fromJson(measurementSetJson, MeasurementSet.class);
        }
        catch (JsonParseException e) {
            try {
                String[] measurementStrings = measurementSetJson.split("\\s+");
                ArrayList<Measurement> measurements = new ArrayList<Measurement>();
                for (String s : measurementStrings) {
                    measurements.add(new Measurement((Map<String, Integer>)ImmutableMap.of((Object)"ns", (Object)1, (Object)"us", (Object)1000, (Object)"ms", (Object)1000000, (Object)"s", (Object)1000000000), Double.valueOf(s), Double.valueOf(s)));
                }
                return new MeasurementSet(measurements.toArray(new Measurement[measurements.size()]));
            }
            catch (NumberFormatException ignore) {
                throw new IllegalArgumentException("Not a measurement set: " + measurementSetJson);
            }
        }
    }

    public static MeasurementSet measurementSetFromJson(JsonObject measurementSetJson) {
        return (MeasurementSet)Json.getGsonInstance().fromJson((JsonElement)measurementSetJson, MeasurementSet.class);
    }

    private Json() {
    }

    private static class KeyValuePair<K, V> {
        private K k;
        private V v;

        KeyValuePair(K k, V v) {
            this.k = k;
            this.v = v;
        }

        public K getKey() {
            return this.k;
        }

        public V getValue() {
            return this.v;
        }

        private KeyValuePair() {
        }
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz", Locale.US);

        private DateTypeAdapter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(this.dateFormat.format(date));
        }

        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            String dateString = jsonElement.getAsString();
            try {
                return this.dateFormat.parse(dateString);
            }
            catch (ParseException ignored) {
                try {
                    return DateFormat.getDateTimeInstance().parse(dateString);
                }
                catch (ParseException ignored2) {
                    throw new JsonParseException(dateString);
                }
            }
        }
    }

    private static class RunTypeAdapter
    implements JsonSerializer<Run>,
    JsonDeserializer<Run> {
        private RunTypeAdapter() {
        }

        public Run deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            List mapList = (List)context.deserialize(jsonElement.getAsJsonObject().get("measurements"), new TypeToken<List<KeyValuePair<Scenario, ScenarioResult>>>(){}.getType());
            LinkedHashMap<Scenario, ScenarioResult> measurements = new LinkedHashMap<Scenario, ScenarioResult>();
            for (KeyValuePair entry : mapList) {
                measurements.put((Scenario)entry.getKey(), (ScenarioResult)entry.getValue());
            }
            String benchmarkName = (String)context.deserialize(jsonElement.getAsJsonObject().get("benchmarkName"), String.class);
            Date executedTimestamp = (Date)context.deserialize(jsonElement.getAsJsonObject().get("executedTimestamp"), Date.class);
            return new Run(measurements, benchmarkName, executedTimestamp);
        }

        public JsonElement serialize(Run run, Type type, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.add("benchmarkName", context.serialize((Object)run.getBenchmarkName()));
            result.add("executedTimestamp", context.serialize((Object)run.getExecutedTimestamp()));
            ArrayList<KeyValuePair<Scenario, ScenarioResult>> mapList = new ArrayList<KeyValuePair<Scenario, ScenarioResult>>();
            for (Map.Entry<Scenario, ScenarioResult> entry : run.getMeasurements().entrySet()) {
                mapList.add(new KeyValuePair<Scenario, ScenarioResult>(entry.getKey(), entry.getValue()));
            }
            result.add("measurements", context.serialize(mapList, new TypeToken<List<KeyValuePair<Scenario, ScenarioResult>>>(){}.getType()));
            return result;
        }
    }

    private static class MeasurementDeserializer
    implements JsonDeserializer<Measurement> {
        private MeasurementDeserializer() {
        }

        public Measurement deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.has("raw") && obj.has("processed")) {
                return new Measurement((Map)context.deserialize(obj.get("unitNames"), new TypeToken<Map<String, Integer>>(){}.getType()), (Double)context.deserialize(obj.get("raw"), Double.class), (Double)context.deserialize(obj.get("processed"), Double.class));
            }
            if (obj.has("nanosPerRep") && obj.has("unitsPerRep") && obj.has("unitNames")) {
                return new Measurement((Map)context.deserialize(obj.get("unitNames"), new TypeToken<Map<String, Integer>>(){}.getType()), (Double)context.deserialize(obj.get("nanosPerRep"), Double.class), (Double)context.deserialize(obj.get("unitsPerRep"), Double.class));
            }
            throw new JsonParseException(obj.toString());
        }
    }
}

