# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1NodeSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'pod_cidr': 'str',
            'external_id': 'str',
            'provider_id': 'str',
            'unschedulable': 'bool'
        }

        self.attribute_map = {
            'pod_cidr': 'podCIDR',
            'external_id': 'externalID',
            'provider_id': 'providerID',
            'unschedulable': 'unschedulable'
        }

        self._pod_cidr = None
        self._external_id = None
        self._provider_id = None
        self._unschedulable = None

    @property
    def pod_cidr(self):
        """
        Gets the pod_cidr of this V1NodeSpec.
        pod IP range assigned to the node

        :return: The pod_cidr of this V1NodeSpec.
        :rtype: str
        """
        return self._pod_cidr

    @pod_cidr.setter
    def pod_cidr(self, pod_cidr):
        """
        Sets the pod_cidr of this V1NodeSpec.
        pod IP range assigned to the node

        :param pod_cidr: The pod_cidr of this V1NodeSpec.
        :type: str
        """
        self._pod_cidr = pod_cidr

    @property
    def external_id(self):
        """
        Gets the external_id of this V1NodeSpec.
        deprecated. External ID assigned to the node by some machine database (e.g. a cloud provider). Defaults to node name when empty.

        :return: The external_id of this V1NodeSpec.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this V1NodeSpec.
        deprecated. External ID assigned to the node by some machine database (e.g. a cloud provider). Defaults to node name when empty.

        :param external_id: The external_id of this V1NodeSpec.
        :type: str
        """
        self._external_id = external_id

    @property
    def provider_id(self):
        """
        Gets the provider_id of this V1NodeSpec.
        ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>

        :return: The provider_id of this V1NodeSpec.
        :rtype: str
        """
        return self._provider_id

    @provider_id.setter
    def provider_id(self, provider_id):
        """
        Sets the provider_id of this V1NodeSpec.
        ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>

        :param provider_id: The provider_id of this V1NodeSpec.
        :type: str
        """
        self._provider_id = provider_id

    @property
    def unschedulable(self):
        """
        Gets the unschedulable of this V1NodeSpec.
        disable pod scheduling on the node; see http://releases.k8s.io/v1.0.4/docs/node.md#manual-node-administration

        :return: The unschedulable of this V1NodeSpec.
        :rtype: bool
        """
        return self._unschedulable

    @unschedulable.setter
    def unschedulable(self, unschedulable):
        """
        Sets the unschedulable of this V1NodeSpec.
        disable pod scheduling on the node; see http://releases.k8s.io/v1.0.4/docs/node.md#manual-node-administration

        :param unschedulable: The unschedulable of this V1NodeSpec.
        :type: bool
        """
        self._unschedulable = unschedulable

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
