/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.BaseSession;
import com.mysql.cj.api.x.DatabaseObject;
import com.mysql.cj.api.x.DeleteStatement;
import com.mysql.cj.api.x.InsertStatement;
import com.mysql.cj.api.x.Schema;
import com.mysql.cj.api.x.SelectStatement;
import com.mysql.cj.api.x.Table;
import com.mysql.cj.api.x.UpdateStatement;
import com.mysql.cj.mysqlx.ExprUnparser;
import com.mysql.cj.mysqlx.devapi.DeleteStatementImpl;
import com.mysql.cj.mysqlx.devapi.InsertStatementImpl;
import com.mysql.cj.mysqlx.devapi.SchemaImpl;
import com.mysql.cj.mysqlx.devapi.SelectStatementImpl;
import com.mysql.cj.mysqlx.devapi.UpdateStatementImpl;
import java.util.Map;

public class TableImpl
implements Table {
    private SchemaImpl schema;
    private String name;

    TableImpl(SchemaImpl schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    @Override
    public BaseSession getSession() {
        return this.schema.getSession();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.schema.getSession().getMysqlxSession().tableExists(this.schema.getName(), this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public InsertStatement insert() {
        return new InsertStatementImpl(this, new String[0]);
    }

    @Override
    public InsertStatement insert(String ... fields) {
        return new InsertStatementImpl(this, fields);
    }

    @Override
    public InsertStatement insert(Map<String, Object> fieldsAndValues) {
        return new InsertStatementImpl(this, fieldsAndValues);
    }

    @Override
    public SelectStatement select(String searchFields) {
        return new SelectStatementImpl(this, searchFields);
    }

    @Override
    public UpdateStatement update() {
        return new UpdateStatementImpl(this);
    }

    @Override
    public DeleteStatement delete() {
        return new DeleteStatementImpl(this);
    }

    @Override
    public long count() {
        return this.schema.getSession().getMysqlxSession().tableCount(this.schema.getName(), this.name);
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == TableImpl.class && ((TableImpl)other).schema.equals(this.schema) && ((TableImpl)other).schema.getSession() == this.schema.getSession()) {
            return this.name.equals(((TableImpl)other).name);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        sb.append(ExprUnparser.quoteIdentifier(this.schema.getName()));
        sb.append(".");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }
}

