# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class PiecewiseFunction(DataObject):
    r"""
    PiecewiseFunction - Defines a 1D piecewise function.
    
    Superclass: DataObject
    
    Defines a piecewise function mapping. This mapping allows the
    addition of control points, and allows the user to control the
    function between the control points. A piecewise hermite curve is
    used between control points, based on the sharpness and midpoint
    parameters. A sharpness of 0 yields a piecewise linear function and a
    sharpness of 1 yields a piecewise constant function. The midpoint is
    the normalized distance between control points at which the curve
    reaches the median Y value. The midpoint and sharpness values
    specified when adding a node are used to control the transition to
    the next node (the last node's values are ignored) Outside the range
    of nodes, the values are 0 if Clamping is off, or the nearest node
    point if Clamping is on. Using the legacy methods for adding points 
    (which do not have Sharpness and Midpoint parameters) will default to
    Midpoint = 0.5 (halfway between the control points) and Sharpness =
    0.0 (linear).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPiecewiseFunction, obj, update, **traits)
    
    allow_duplicate_scalars = tvtk_base.false_bool_trait(desc=\
        r"""
        Toggle whether to allow duplicate scalar values in the piecewise
        function (off by default).
        """
    )

    def _allow_duplicate_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllowDuplicateScalars,
                        self.allow_duplicate_scalars_)

    clamping = tvtk_base.true_bool_trait(desc=\
        r"""
        When zero range clamping is Off, get_value() returns 0.0 when a
        value is requested outside of the points specified. When zero
        range clamping is On, get_value() returns the value at the value
        at the lowest point for a request below all points specified and
        returns the value at the highest point for a request above all
        points specified. On is the default.
        """
    )

    def _clamping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClamping,
                        self.clamping_)

    use_log_scale = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _use_log_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseLogScale,
                        self.use_log_scale_)

    def get_node_value(self, *args):
        """
        get_node_value(self, index:int, val:[float, float, float, float])
            -> int
        C++: int get_node_value(int index, double val[4])
        For the node specified by index, set/get the location (X), value
        (Y), midpoint, and sharpness values at the node. Returns -1 if
        the index is out of range, returns 1 otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.GetNodeValue, *args)
        return ret

    def set_node_value(self, *args):
        """
        set_node_value(self, index:int, val:[float, float, float, float])
            -> int
        C++: int set_node_value(int index, double val[4])"""
        ret = self._wrap_call(self._vtk_obj.SetNodeValue, *args)
        return ret

    def _get_data_pointer(self):
        return self._vtk_obj.GetDataPointer()
    data_pointer = traits.Property(_get_data_pointer, desc=\
        r"""
        Returns a pointer to the data stored in the table. Fills from a
        pointer to data stored in a similar table. These are legacy
        methods which will be maintained for compatibility - however,
        note that the PiecewiseFunction no longer stores the nodes in
        a double array internally.
        """
    )

    def _get_first_non_zero_value(self):
        return self._vtk_obj.GetFirstNonZeroValue()
    first_non_zero_value = traits.Property(_get_first_non_zero_value, desc=\
        r"""
        Returns the first point location which precedes a non-zero
        segment of the function. Note that the value at this point may be
        zero.
        """
    )

    def _get_range(self):
        return self._vtk_obj.GetRange()
    range = traits.Property(_get_range, desc=\
        r"""
        Returns the min and max node locations of the function.
        """
    )

    def _get_size(self):
        return self._vtk_obj.GetSize()
    size = traits.Property(_get_size, desc=\
        r"""
        Get the number of points used to specify the function
        """
    )

    def get_table(self, *args):
        """
        get_table(self, x1:float, x2:float, size:int, table:[float, ...],
            stride:int=1, logIncrements:int=0) -> None
        C++: void get_table(double x1, double x2, int size, double *table,
            int stride=1, int logIncrements=0)"""
        ret = self._wrap_call(self._vtk_obj.GetTable, *args)
        return ret

    def _get_type(self):
        return self._vtk_obj.GetType()
    type = traits.Property(_get_type, desc=\
        r"""
        Return the type of function: Function Types: 0 : Constant       
        (No change in slope between end points) 1 : non_decreasing  
        (Always increasing or zero slope) 2 : non_increasing   (Always
        decreasing or zero slope) 3 : Varied          (Contains both
        decreasing and increasing slopes)
        """
    )

    def get_value(self, *args):
        """
        get_value(self, x:float) -> float
        C++: double get_value(double x)
        Returns the value of the function at the specified location using
        the specified interpolation.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def add_point(self, *args):
        """
        add_point(self, x:float, y:float) -> int
        C++: int add_point(double x, double y)
        add_point(self, x:float, y:float, midpoint:float, sharpness:float)
            -> int
        C++: int add_point(double x, double y, double midpoint,
            double sharpness)
        Add points to the function. If a duplicate point is added then
        the previous point is removed unless allow_duplicate_scalars is set
        to true Return the index of the point (0 based), or -1 on error.
        """
        ret = self._wrap_call(self._vtk_obj.AddPoint, *args)
        return ret

    def add_segment(self, *args):
        """
        add_segment(self, x1:float, y1:float, x2:float, y2:float) -> None
        C++: void add_segment(double x1, double y1, double x2, double y2)
        Add a line segment to the function. All points defined between
        the two points specified are removed from the function. To
        specify the sharpness and midpoint values, use add_point method
        instead.
        """
        ret = self._wrap_call(self._vtk_obj.AddSegment, *args)
        return ret

    def adjust_range(self, *args):
        """
        adjust_range(self, range:[float, float]) -> int
        C++: int adjust_range(double range[2])
        Remove all points out of the new range, and make sure there is a
        point at each end of that range. Return 1 on success, 0
        otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.AdjustRange, *args)
        return ret

    def build_function_from_table(self, *args):
        """
        build_function_from_table(self, x1:float, x2:float, size:int,
            table:[float, ...], stride:int=1) -> None
        C++: void build_function_from_table(double x1, double x2, int size,
            double *table, int stride=1)
        Constructs a piecewise function from a table.  Function range is
        is set to [x1, x2], function size is set to size, and function
        points are regularly spaced between x1 and x2.  Parameter
        "stride" is is step through the input table.
        """
        ret = self._wrap_call(self._vtk_obj.BuildFunctionFromTable, *args)
        return ret

    def estimate_min_number_of_samples(self, *args):
        """
        estimate_min_number_of_samples(self, x1:float, x2:float) -> int
        C++: int estimate_min_number_of_samples(double const &x1,
            double const &x2)
        Estimates the minimum size of a table such that it would
        correctly sample this function. The returned value should be
        passed as parameter 'n' when calling get_table().
        """
        ret = self._wrap_call(self._vtk_obj.EstimateMinNumberOfSamples, *args)
        return ret

    def fill_from_data_pointer(self, *args):
        """
        fill_from_data_pointer(self, __a:int, __b:[float, ...]) -> None
        C++: void fill_from_data_pointer(int, double *)"""
        ret = self._wrap_call(self._vtk_obj.FillFromDataPointer, *args)
        return ret

    def remove_all_points(self):
        """
        remove_all_points(self) -> None
        C++: void remove_all_points()
        Removes all points from the function.
        """
        ret = self._vtk_obj.RemoveAllPoints()
        return ret
        

    def remove_point(self, *args):
        """
        remove_point(self, x:float) -> int
        C++: int remove_point(double x)
        remove_point(self, x:float, y:float) -> int
        C++: int remove_point(double x, double y)
        Remove the first point found at the given x location Return the
        index of the remove point if any, -1 otherwise
        """
        ret = self._wrap_call(self._vtk_obj.RemovePoint, *args)
        return ret

    def remove_point_by_index(self, *args):
        """
        remove_point_by_index(self, id:int) -> bool
        C++: bool remove_point_by_index(size_t id)
        Remove a point from the function at a given id Return true if
        point has been found and removed, false other wise
        """
        ret = self._wrap_call(self._vtk_obj.RemovePointByIndex, *args)
        return ret

    _updateable_traits_ = \
    (('allow_duplicate_scalars', 'GetAllowDuplicateScalars'), ('clamping',
    'GetClamping'), ('use_log_scale', 'GetUseLogScale'),
    ('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['allow_duplicate_scalars', 'clamping', 'debug',
    'global_release_data_flag', 'global_warning_display', 'use_log_scale',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PiecewiseFunction, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PiecewiseFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['allow_duplicate_scalars', 'clamping',
            'global_release_data_flag', 'use_log_scale'], [], ['object_name']),
            title='Edit PiecewiseFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PiecewiseFunction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

