/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef GribExaminer_H
#define GribExaminer_H

#include <QStringList> 

#include "MvQAbstractMessageExaminer.h"

class QComboBox;
class QLabel;
class QSpinBox;
class QSplitter;
class QStackedWidget;
class QTabWidget;
class QTextBrowser;

class MvQGribMvDumpModel;
class MvQGribWmoDumpModel;
class MvQGribStdDumpModel;
class MvQGribValueDumpModel;
class MvQTextEditSearchLine;
class MvQTreeView;
class MvQTreeViewSearchLine;

class GribExaminer : public MvQAbstractMessageExaminer
{
    Q_OBJECT

public:
    	GribExaminer(string &tmpfilename, QWidget *parent = 0);
    	~GribExaminer();
  
public slots:	
	void slotChangeCurrentDump(int);	
	void slotSetGribNameSpace(const QString &);
	void slotCurrentStdDumpChanged(int);
	void slotCurrentWmoDumpChanged(int);
	void slotValueRowSpinChanged(int);
	void slotSelectValueRow(const QModelIndex &);
	void slotShowAboutBox();
	void slotStatusMessage(QString);
	
protected:
	void closeEvent(QCloseEvent *);
	void setupDumpBox();
 	
	void initDumps();
	void initAllKeys();

	void loadDumps();
	void loadMvDump();
	void loadWmoDump();
	void loadStdDump();
	void loadValueDump();
	
	void updateFileInfoLabel();
	void settatusMessage(QString);
	
	void writeSettings();
	void readSettings();
	
	QSplitter*   centralSplitter_;
	QSplitter*   mainSplitter_;
	
	QLabel *statusMessageLabel_;
	QString lastKeyProfileName_;
	
	QStackedWidget* dumpStacked_;
	QComboBox*   dumpCombo_;

	QComboBox*   nsCombo_;
	QStringList  gribNameSpace_;

	MvQTreeView*   mvDumpTree_;
	MvQGribMvDumpModel* mvDumpModel_;
	QSortFilterProxyModel* mvDumpSortModel_;
	bool mvDumpLoaded_;
	MvQTreeViewSearchLine* mvDumpSearch_;

	QTabWidget*   stdDumpTab_;
	MvQTreeView*   stdDumpTree_;
	MvQGribStdDumpModel* stdDumpModel_;
	QTextBrowser*  stdDumpBrowser_;
	bool stdDumpLoaded_;
	MvQTreeViewSearchLine* stdDumpSearch_;
	MvQTextEditSearchLine* stdDumpTextSearch_;

	QTabWidget*   wmoDumpTab_;
	MvQTreeView*   wmoDumpTree_;
	MvQGribWmoDumpModel* wmoDumpModel_;
	QTextBrowser*  wmoDumpBrowser_;
	bool wmoDumpLoaded_;
	MvQTreeViewSearchLine* wmoDumpSearch_;
	MvQTextEditSearchLine* wmoDumpTextSearch_;
	
	QSpinBox* valueRowSpin_;
	QLabel* valueDumpLabel_;
	MvQTreeView*   valueDumpTree_;
	MvQGribValueDumpModel* valueDumpModel_;
	QSortFilterProxyModel* valueDumpSortModel_;
	bool valueDumpLoaded_;
	MvQTreeViewSearchLine* valueDumpSearch_;
	bool ignoreValueRowSpinChangeSignal_;
		
	bool fileInfoLabelNeedsUpdating_;

	string tmpfilename_;

};

#endif
