/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FolderWindow_H
#include "FolderWindow.h"
#endif

#ifndef MetviewUI_H
#include "MetviewUI.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef Protocol_H
#include "Protocol.h"
#endif


static XrmDatabase db;
static Widget top;

MetviewUI::MetviewUI(XtAppContext app,int argc, char **argv):
	MvXApplication(app,argc,argv)
{

	Display* d = XtOpenDisplay(app, NULL, argv[0], "Metview", 
		NULL, 0, &argc, argv);

	if(d == 0)
	{
		cerr << argv[0] << ": can't open display, exiting..." << endl;
		exit (-1);
	}

	top = XtAppCreateShell(argv[0],"Metview",applicationShellWidgetClass,d,0,0);
	db = XtDatabase(d);

	loadResources();
	Protocol::init();
	FolderWindow::start();

}

MetviewUI::~MetviewUI()
{
}

Widget MetviewUI::root()
{
	return top;
}

void MetviewUI::load(request *r)
{	
	const char *p = get_value(r, "class", 0);
	const char *q = get_value(r, "pixmap", 0);
	if (p && q) {
		char res[1024];		
		sprintf(res, "Metview*%s.iconLargeBitmap", p);
		XrmPutStringResource(&db, res, q);
	}
}

void MetviewUI::loadResources()
{
	int order = 0;
	bool more = true;

	while(more)
	{
		more = false;
		request  *r = mars.setup;
		while (r) {
			if(ConfigLoader::process(r,order))
				more = true;
			r = r->next;
		}
		order++;
	}
}


static SimpleLoader<MetviewUI> loadClasses("object",1);

