/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQGui_H
#define MvQGui_H

#include <QList>
#include <QObject>
#include <QString>

class QBoxLayout;
class QGridLayout;
class QPushButton;

class MvQGuiItem;
class MvKeyProfile;
class MvRequest;

#ifdef METVIEW_ODB
class MvQOdbColumn;
#endif

class MvQGui : public QObject
{
	Q_OBJECT

public:
	MvQGui(QBoxLayout*);
	~MvQGui();

	void buildFromMacro(QString);
	void buildFromDefinition(MvRequest&);
	void buildFromKeyProfile(MvKeyProfile*);
	void update(MvKeyProfile *);
#ifdef METVIEW_ODB
	void updateFromOdbMetaData(QList<MvQOdbColumn*>&);
#endif
	void clear();
	MvQGuiItem* item(int i) {return (i >= 0 && i < item_.count())?item_[i]:0;} 
	int itemNum() {return item_.count();}

	void interface(QString);

signals:
	void editFinished();

private:
	QBoxLayout*	parentLayout_;
	QGridLayout*    layout_;

	QList<MvQGuiItem*>	item_;
	QPushButton*	okPb_;	
};

#endif
