/*
 * Copyright (C) 2008-2024 Meltytech, LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <framework/mlt.h>
#include <limits.h>
#include <string.h>
#include <QtGlobal>

#ifdef USE_QT_OPENGL
extern mlt_consumer consumer_qglsl_init(mlt_profile profile,
                                        mlt_service_type type,
                                        const char *id,
                                        char *arg);
#endif
extern mlt_filter filter_audiolevelgraph_init(mlt_profile profile,
                                              mlt_service_type type,
                                              const char *id,
                                              char *arg);
extern mlt_filter filter_audiowaveform_init(mlt_profile profile,
                                            mlt_service_type type,
                                            const char *id,
                                            char *arg);
extern mlt_filter filter_dropshadow_init(mlt_profile profile,
                                         mlt_service_type type,
                                         const char *id,
                                         char *arg);
extern mlt_filter filter_gpsgraphic_init(mlt_profile profile,
                                         mlt_service_type type,
                                         const char *id,
                                         char *arg);
extern mlt_filter filter_gpstext_init(mlt_profile profile,
                                      mlt_service_type type,
                                      const char *id,
                                      char *arg);
extern mlt_filter filter_qtext_init(mlt_profile profile,
                                    mlt_service_type type,
                                    const char *id,
                                    char *arg);
extern mlt_producer producer_qimage_init(mlt_profile profile,
                                         mlt_service_type type,
                                         const char *id,
                                         char *arg);
extern mlt_producer producer_qtext_init(mlt_profile profile,
                                        mlt_service_type type,
                                        const char *id,
                                        char *arg);
extern mlt_producer producer_kdenlivetitle_init(mlt_profile profile,
                                                mlt_service_type type,
                                                const char *id,
                                                char *arg);
extern mlt_transition transition_vqm_init(mlt_profile profile,
                                          mlt_service_type type,
                                          const char *id,
                                          void *arg);
extern mlt_transition transition_qtblend_init(mlt_profile profile,
                                              mlt_service_type type,
                                              const char *id,
                                              void *arg);
extern mlt_filter filter_qtblend_init(mlt_profile profile,
                                      mlt_service_type type,
                                      const char *id,
                                      char *arg);
extern mlt_filter filter_qtcrop_init(mlt_profile profile,
                                     mlt_service_type type,
                                     const char *id,
                                     char *arg);
extern mlt_filter filter_typewriter_init(mlt_profile profile,
                                         mlt_service_type type,
                                         const char *id,
                                         char *arg);

#ifdef USE_FFTW
extern mlt_filter filter_audiospectrum_init(mlt_profile profile,
                                            mlt_service_type type,
                                            const char *id,
                                            char *arg);
extern mlt_filter filter_lightshow_init(mlt_profile profile,
                                        mlt_service_type type,
                                        const char *id,
                                        char *arg);
#endif

static mlt_properties metadata(mlt_service_type type, const char *id, void *data)
{
    char file[PATH_MAX];
#if QT_VERSION_MAJOR < 6
    snprintf(file, PATH_MAX, "%s/qt/%s", mlt_environment("MLT_DATA"), (char *) data);
#else
    snprintf(file, PATH_MAX, "%s/qt6/%s", mlt_environment("MLT_DATA"), (char *) data);
#endif
    return mlt_properties_parse_yaml(file);
}

MLT_REPOSITORY
{
#ifdef USE_QT_OPENGL
    MLT_REGISTER(mlt_service_consumer_type, "qglsl", consumer_qglsl_init);
#endif
    MLT_REGISTER(mlt_service_filter_type, "audiolevelgraph", filter_audiolevelgraph_init);
    MLT_REGISTER(mlt_service_filter_type, "audiowaveform", filter_audiowaveform_init);
    MLT_REGISTER(mlt_service_filter_type, "dropshadow", filter_dropshadow_init);
    MLT_REGISTER(mlt_service_filter_type, "gpsgraphic", filter_gpsgraphic_init);
    MLT_REGISTER(mlt_service_filter_type, "gpstext", filter_gpstext_init);
    MLT_REGISTER(mlt_service_filter_type, "qtext", filter_qtext_init);
    MLT_REGISTER(mlt_service_producer_type, "qimage", producer_qimage_init);
    MLT_REGISTER(mlt_service_producer_type, "qtext", producer_qtext_init);
    MLT_REGISTER(mlt_service_producer_type, "kdenlivetitle", producer_kdenlivetitle_init);
    MLT_REGISTER(mlt_service_transition_type, "qtblend", transition_qtblend_init);
    MLT_REGISTER(mlt_service_filter_type, "qtblend", filter_qtblend_init);
    MLT_REGISTER(mlt_service_filter_type, "qtcrop", filter_qtcrop_init);
    MLT_REGISTER(mlt_service_filter_type, "typewriter", filter_typewriter_init);
    MLT_REGISTER_METADATA(mlt_service_consumer_type, "qglsl", metadata, "consumer_qglsl.yml");
    MLT_REGISTER_METADATA(mlt_service_transition_type,
                          "qtblend",
                          metadata,
                          "transition_qtblend.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "qtblend", metadata, "filter_qtblend.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "qtcrop", metadata, "filter_qtcrop.yml");
#ifdef USE_FFTW
    MLT_REGISTER(mlt_service_filter_type, "audiospectrum", filter_audiospectrum_init);
    MLT_REGISTER(mlt_service_filter_type, "lightshow", filter_lightshow_init);
#endif
    MLT_REGISTER_METADATA(mlt_service_filter_type,
                          "audiolevelgraph",
                          metadata,
                          "filter_audiolevelgraph.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type,
                          "audiowaveform",
                          metadata,
                          "filter_audiowaveform.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "dropshadow", metadata, "filter_dropshadow.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "gpsgraphic", metadata, "filter_gpsgraphic.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "gpstext", metadata, "filter_gpstext.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type, "qtext", metadata, "filter_qtext.yml");
#ifdef USE_FFTW
    MLT_REGISTER_METADATA(mlt_service_filter_type, "lightshow", metadata, "filter_lightshow.yml");
    MLT_REGISTER_METADATA(mlt_service_filter_type,
                          "audiospectrum",
                          metadata,
                          "filter_audiospectrum.yml");
#endif
    MLT_REGISTER_METADATA(mlt_service_producer_type, "qimage", metadata, "producer_qimage.yml");
    MLT_REGISTER_METADATA(mlt_service_producer_type, "qtext", metadata, "producer_qtext.yml");
    MLT_REGISTER_METADATA(mlt_service_producer_type,
                          "kdenlivetitle",
                          metadata,
                          "producer_kdenlivetitle.yml");
#ifdef GPL3
    MLT_REGISTER(mlt_service_transition_type, "vqm", transition_vqm_init);
    MLT_REGISTER_METADATA(mlt_service_transition_type, "vqm", metadata, "transition_vqm.yml");
#endif
    MLT_REGISTER_METADATA(mlt_service_filter_type, "typewriter", metadata, "filter_typewriter.yml");
}
