// This is an open source non-commercial project. Dear PVS-Studio, please check
// it. PVS-Studio Static Code Analyzer for C, C++ and C#: http://www.viva64.com

// Built-in fallback terminfo entries.

#include <unibilium.h>

#include "nvim/tui/terminfo.h"
#include "nvim/tui/tui.h"

#ifdef INCLUDE_GENERATED_DECLARATIONS
# include "tui/terminfo.c.generated.h"
#endif

// One creates the dumps from terminfo.src by using
//      od -t d1 -w | cut -c9- | sed -e 's/\>/,/g'
// on the compiled files.

// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
// This is a 256-colour terminfo description that lacks true-colour and
// DECSTBM/DECSLRM/DECLRMM capabilities that xterm actually has.
static const signed char xterm_256colour_terminfo[] = {
  26,   1,  37,   0,  29,   0,  15,   0, 105,   1, -42,   5, 120, 116, 101, 114, 109,  45,  50,  53,  54,  99, 111, 108, 111, 114, 124, 120, 116, 101, 114, 109,  32, 119, 105, 116, 104,  32,  50,  53,  54,  32,  99, 111, 108, 111, 114, 115,   0,   0,   1,   0,   0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   1,   1,  80,   0,   8,   0,  24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,  -1, 127,   0,   0,   4,   0,   6,   0,   8,   0,  25,   0,  30,   0,  38,   0,  42,   0,  46,   0,  -1,  -1,  57,   0,  74,   0,  76,   0,  80,   0,  87,   0,  -1,  -1,  89,   0, 102,   0,  -1,  -1, 106,   0, 110,   0, 120,   0, 124,   0,  -1,  -1,  -1,  -1,-128,   0,-124,   0,-119,   0,-114,   0,  -1,  -1,-105,   0,-100,   0, -95,   0,  -1,  -1, -90,   0, -85,   0, -80,   0, -75,   0, -66,   0, -62,   0, -55,   0,  -1,  -1, -46,   0, -41,   0, -35,   0, -29,   0,  -1,  -1,  -1,  -1,  -1,  -1, -11,   0,  -1,  -1,  -1,  -1,  -1,  -1,   7,   1,  -1,  -1,  11,   1,  -1,  -1,  -1,  -1,  -1,  -1,  13,   1,  -1,  -1,  18,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  22,   1,  26,   1,  32,   1,  36,   1,  40,   1,  44,   1,  50,   1,  56,   1,  62,   1,  68,   1,  74,   1,  78,   1,  -1,  -1,  83,   1,  -1,  -1,  87,   1,  92,   1,  97,   1, 101,   1, 108,   1,  -1,  -1, 115,   1, 119,   1, 127,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-121,   1,-112,   1,  -1,  -1,  -1,  -1,-103,   1, -94,   1, -85,   1, -76,   1, -67,   1, -58,   1, -49,   1, -40,   1, -31,   1, -22,   1,  -1,  -1,  -1,  -1,  -1,  -1, -13,   1,  -9,   1,  -4,   1,  -1,  -1,   1,   2,  10,   2,  -1,  -1,  -1,  -1,  28,   2,  31,   2,  42,   2,  45,   2,  47,   2,  50,   2,-113,   2,  -1,  -1,-110,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-108,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-104,   2,  -1,  -1, -51,   2,  -1,  -1,  -1,  -1, -47,   2, -41,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -35,   2, -31,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -27,   2,  -1,  -1,  -1,  -1, -20,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -13,   2,  -6,   2,   1,   3,  -1,  -1,  -1,  -1,   8,   3,  -1,  -1,  15,   3,  -1,  -1,  -1,  -1,  -1,  -1,  22,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  29,   3,  35,   3,  41,   3,  48,   3,  55,   3,  62,   3,  69,   3,  77,   3,  85,   3,  93,   3, 101,   3, 109,   3, 117,   3, 125,   3,-123,   3,-116,   3,-109,   3,-102,   3, -95,   3, -87,   3, -79,   3, -71,   3, -63,   3, -55,   3, -47,   3, -39,   3, -31,   3, -24,   3, -17,   3, -10,   3,  -3,   3,   5,   4,  13,   4,  21,   4,  29,   4,  37,   4,  45,   4,  53,   4,  61,   4,  68,   4,  75,   4,  82,   4,  89,   4,  97,   4, 105,   4, 113,   4, 121,   4,-127,   4,-119,   4,-111,   4,-103,   4, -96,   4, -89,   4, -82,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -77,   4, -66,   4, -61,   4, -42,   4, -38,   4, -29,   4, -22,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  72,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  83,   5,  -1,  -1,  -1,  -1,  -1,  -1,  87,   5,-106,   5,  27,  91,  90,   0,   7,   0,  13,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100, 114,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  50,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,   0,   8,   0,  27,  91,  63,  49,  50, 108,  27,  91,  63,  50,  53, 104,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  63,  49,  50,  59,  50,  53, 104,   0,  27,  91,  80,   0,  27,  91,  77,   0,  27,  40,  48,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  91,  63,  49,  48,  52,  57, 104,   0,  27,  91,  50, 109,   0,  27,  91,  52, 104,   0,  27,  91,  56, 109,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  37, 112,  49,  37, 100,  88,   0,  27,  40,  66,   0,  27,  40,  66,  27,  91, 109,   0,  27,  91,  63,  49,  48,  52,  57, 108,   0,  27,  91,  52, 108,   0,  27,  91,  50,  55, 109,   0,  27,  91,  50,  52, 109,   0,  27,  91,  63,  53, 104,  36,  60,  49,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,  27,  91,  33, 112,  27,  91,  63,  51,  59,  52, 108,  27,  91,  52, 108,  27,  62,   0,  27,  91,  76,   0,   8,   0,  27,  91,  51, 126,   0,  27,  79,  66,   0,  27,  79,  80,   0,  27,  91,  50,  49, 126,   0,  27,  79,  81,   0,  27,  79,  82,   0,  27,  79,  83,   0,  27,  91,  49,  53, 126,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  79,  72,   0,  27,  91,  50, 126,   0,  27,  79,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  79,  67,   0,  27,  91,  49,  59,  50,  66,   0,  27,  91,  49,  59,  50,  65,   0,  27,  79,  65,   0,  27,  91,  63,  49, 108,  27,  62,   0,  27,  91,  63,  49, 104,  27,  61,   0,  27,  91,  63,  49,  48,  51,  52, 108,   0,  27,  91,  63,  49,  48,  51,  52, 104,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  83,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  84,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  91, 105,   0,  27,  91,  52, 105,   0,  27,  91,  53, 105,   0,  27,  99,  27,  93,  49,  48,  52,   7,   0,  27,  91,  33, 112,  27,  91,  63,  51,  59,  52, 108,  27,  91,  52, 108,  27,  62,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  37,  63,  37, 112,  57,  37, 116,  27,  40,  48,  37, 101,  27,  40,  66,  37,  59,  27,  91,  48,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  53,  37, 116,  59,  50,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  49,  37, 112,  51,  37, 124,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59,  37,  63,  37, 112,  55,  37, 116,  59,  56,  37,  59, 109,   0,  27,  72,   0,   9,   0,  27,  79,  69,   0,  96,  96,  97,  97, 102, 102, 103, 103, 105, 105, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,   0,  27,  91,  90,   0,  27,  91,  63,  55, 104,   0,  27,  91,  63,  55, 108,   0,  27,  79,  70,   0,  27,  79,  77,   0,  27,  91,  51,  59,  50, 126,   0,  27,  91,  49,  59,  50,  70,   0,  27,  91,  49,  59,  50,  72,   0,  27,  91,  50,  59,  50, 126,   0,  27,  91,  49,  59,  50,  68,   0,  27,  91,  54,  59,  50, 126,   0,  27,  91,  53,  59,  50, 126,   0,  27,  91,  49,  59,  50,  67,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  49,  59,  50,  80,   0,  27,  91,  49,  59,  50,  81,   0,  27,  91,  49,  59,  50,  82,   0,  27,  91,  49,  59,  50,  83,   0,  27,  91,  49,  53,  59,  50, 126,   0,  27,  91,  49,  55,  59,  50, 126,   0,  27,  91,  49,  56,  59,  50, 126,   0,  27,  91,  49,  57,  59,  50, 126,   0,  27,  91,  50,  48,  59,  50, 126,   0,  27,  91,  50,  49,  59,  50, 126,   0,  27,  91,  50,  51,  59,  50, 126,   0,  27,  91,  50,  52,  59,  50, 126,   0,  27,  91,  49,  59,  53,  80,   0,  27,  91,  49,  59,  53,  81,   0,  27,  91,  49,  59,  53,  82,   0,  27,  91,  49,  59,  53,  83,   0,  27,  91,  49,  53,  59,  53, 126,   0,  27,  91,  49,  55,  59,  53, 126,   0,  27,  91,  49,  56,  59,  53, 126,   0,  27,  91,  49,  57,  59,  53, 126,   0,  27,  91,  50,  48,  59,  53, 126,   0,  27,  91,  50,  49,  59,  53, 126,   0,  27,  91,  50,  51,  59,  53, 126,   0,  27,  91,  50,  52,  59,  53, 126,   0,  27,  91,  49,  59,  54,  80,   0,  27,  91,  49,  59,  54,  81,   0,  27,  91,  49,  59,  54,  82,   0,  27,  91,  49,  59,  54,  83,   0,  27,  91,  49,  53,  59,  54, 126,   0,  27,  91,  49,  55,  59,  54, 126,   0,  27,  91,  49,  56,  59,  54, 126,   0,  27,  91,  49,  57,  59,  54, 126,   0,  27,  91,  50,  48,  59,  54, 126,   0,  27,  91,  50,  49,  59,  54, 126,   0,  27,  91,  50,  51,  59,  54, 126,   0,  27,  91,  50,  52,  59,  54, 126,   0,  27,  91,  49,  59,  51,  80,   0,  27,  91,  49,  59,  51,  81,   0,  27,  91,  49,  59,  51,  82,   0,  27,  91,  49,  59,  51,  83,   0,  27,  91,  49,  53,  59,  51, 126,   0,  27,  91,  49,  55,  59,  51, 126,   0,  27,  91,  49,  56,  59,  51, 126,   0,  27,  91,  49,  57,  59,  51, 126,   0,  27,  91,  50,  48,  59,  51, 126,   0,  27,  91,  50,  49,  59,  51, 126,   0,  27,  91,  50,  51,  59,  51, 126,   0,  27,  91,  50,  52,  59,  51, 126,   0,  27,  91,  49,  59,  52,  80,   0,  27,  91,  49,  59,  52,  81,   0,  27,  91,  49,  59,  52,  82,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  37,  91,  59,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  93,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  93,  49,  48,  52,   7,   0,  27,  93,  52,  59,  37, 112,  49,  37, 100,  59, 114, 103,  98,  58,  37, 112,  50,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  47,  37, 112,  51,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  47,  37, 112,  52,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  27,  92,   0,  27,  91,  51, 109,   0,  27,  91,  50,  51, 109,   0,  27,  91,  77,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  51,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  57,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  51,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  52,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  49,  48,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  52,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0
};
// Taken from unibilium/t/static_tmux.c as of 2015-08-14.
// This is an 256-colour terminfo description that lacks
// status line capabilities that tmux actually has.
static const signed char tmux_256colour_terminfo[] = {
  26, 1, 56, 0, 15, 0, 15, 0, 105, 1, -48, 2, 116, 109, 117, 120, 124, 86, 84, 32, 49, 48, 48, 47, 65, 78, 83, 73, 32, 88, 51, 46, 54, 52, 32, 118, 105, 114, 116, 117, 97, 108, 32, 116, 101, 114, 109, 105, 110, 97, 108, 32, 119, 105, 116, 104, 32, 50, 53, 54, 32, 99, 111, 108, 111, 114, 115, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 80, 0, 8, 0, 24, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -1, 127, 0, 0, 4, 0, 6, 0, 8, 0, 25, 0, 30, 0, 37, 0, 41, 0, -1, -1, -1, -1, 45, 0, 62, 0, 64, 0, 68, 0, 75, 0, -1, -1, 77, 0, 89, 0, -1, -1, 93, 0, 96, 0, 102, 0, 106, 0, -1, -1, -1, -1, 110, 0, 112, 0, 117, 0, 122, 0, -1, -1, -1, -1, 123, 0, -1, -1, -1, -1, -128, 0, -123, 0, -118, 0, -1, -1, -113, 0, -111, 0, -106, 0, -1, -1, -105, 0, -100, 0, -94, 0, -88, 0, -1, -1, -1, -1, -1, -1, -85, 0, -1, -1, -1, -1, -1, -1, -81, 0, -1, -1, -77, 0, -1, -1, -1, -1, -1, -1, -75, 0, -1, -1, -70, 0, -1, -1, -1, -1, -1, -1, -1, -1, -66, 0, -62, 0, -56, 0, -52, 0, -48, 0, -44, 0, -38, 0, -32, 0, -26, 0, -20, 0, -14, 0, -9, 0, -1, -1, -4, 0, -1, -1, 0, 1, 5, 1, 10, 1, -1, -1, -1, -1, -1, -1, 14, 1, 18, 1, 26, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 34, 1, -1, -1, 37, 1, 46, 1, 55, 1, 64, 1, -1, -1, 73, 1, 82, 1, 91, 1, -1, -1, 100, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 109, 1, -1, -1, -1, -1, 126, 1, -1, -1, -127, 1, -124, 1, -122, 1, -119, 1, -46, 1, -1, -1, -43, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -41, 1, -1, -1, 24, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 35, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 40, 2, 46, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 52, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 71, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 77, 2, -1, -1, -1, -1, -1, -1, 81, 2, -112, 2, 27, 91, 90, 0, 7, 0, 13, 0, 27, 91, 37, 105, 37, 112, 49, 37, 100, 59, 37, 112, 50, 37, 100, 114, 0, 27, 91, 51, 103, 0, 27, 91, 72, 27, 91, 74, 0, 27, 91, 75, 0, 27, 91, 74, 0, 27, 91, 37, 105, 37, 112, 49, 37, 100, 59, 37, 112, 50, 37, 100, 72, 0, 10, 0, 27, 91, 72, 0, 27, 91, 63, 50, 53, 108, 0, 8, 0, 27, 91, 51, 52, 104, 27, 91, 63, 50, 53, 104, 0, 27, 91, 67, 0, 27, 77, 0, 27, 91, 51, 52, 108, 0, 27, 91, 80, 0, 27, 91, 77, 0, 14, 0, 27, 91, 53, 109, 0, 27, 91, 49, 109, 0, 0, 27, 91, 52, 104, 0, 27, 91, 55, 109, 0, 27, 91, 55, 109, 0, 27, 91, 52, 109, 0, 15, 0, 27, 91, 109, 15, 0, 0, 27, 91, 52, 108, 0, 27, 91, 50, 55, 109, 0, 27, 91, 50, 52, 109, 0, 27, 103, 0, 27, 41, 48, 0, 27, 91, 76, 0, 8, 0, 27, 91, 51, 126, 0, 27, 79, 66, 0, 27, 79, 80, 0, 27, 91, 50, 49, 126, 0, 27, 79, 81, 0, 27, 79, 82, 0, 27, 79, 83, 0, 27, 91, 49, 53, 126, 0, 27, 91, 49, 55, 126, 0, 27, 91, 49, 56, 126, 0, 27, 91, 49, 57, 126, 0, 27, 91, 50, 48, 126, 0, 27, 91, 49, 126, 0, 27, 91, 50, 126, 0, 27, 79, 68, 0, 27, 91, 54, 126, 0, 27, 91, 53, 126, 0, 27, 79, 67, 0, 27, 79, 65, 0, 27, 91, 63, 49, 108, 27, 62, 0, 27, 91, 63, 49, 104, 27, 61, 0, 27, 69, 0, 27, 91, 37, 112, 49, 37, 100, 80, 0, 27, 91, 37, 112, 49, 37, 100, 77, 0, 27, 91, 37, 112, 49, 37, 100, 66, 0, 27, 91, 37, 112, 49, 37, 100, 64, 0, 27, 91, 37, 112, 49, 37, 100, 76, 0, 27, 91, 37, 112, 49, 37, 100, 68, 0, 27, 91, 37, 112, 49, 37, 100, 67, 0, 27, 91, 37, 112, 49, 37, 100, 65, 0, 27, 99, 27, 91, 63, 49, 48, 48, 48, 108, 27, 91, 63, 50, 53, 104, 0, 27, 56, 0, 27, 55, 0, 10, 0, 27, 77, 0, 27, 91, 48, 37, 63, 37, 112, 54, 37, 116, 59, 49, 37, 59, 37, 63, 37, 112, 49, 37, 116, 59, 55, 37, 59, 37, 63, 37, 112, 50, 37, 116, 59, 52, 37, 59, 37, 63, 37, 112, 51, 37, 116, 59, 55, 37, 59, 37, 63, 37, 112, 52, 37, 116, 59, 53, 37, 59, 109, 37, 63, 37, 112, 57, 37, 116, 14, 37, 101, 15, 37, 59, 0, 27, 72, 0, 9, 0, 43, 43, 44, 44, 45, 45, 46, 46, 48, 48, 96, 96, 97, 97, 102, 102, 103, 103, 104, 104, 105, 105, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126, 0, 27, 91, 90, 0, 27, 40, 66, 27, 41, 48, 0, 27, 91, 52, 126, 0, 27, 91, 50, 51, 126, 0, 27, 91, 50, 52, 126, 0, 27, 91, 49, 75, 0, 27, 91, 51, 57, 59, 52, 57, 109, 0, 27, 91, 51, 109, 0, 27, 91, 50, 51, 109, 0, 27, 91, 77, 0, 27, 91, 37, 63, 37, 112, 49, 37, 123, 56, 125, 37, 60, 37, 116, 51, 37, 112, 49, 37, 100, 37, 101, 37, 112, 49, 37, 123, 49, 54, 125, 37, 60, 37, 116, 57, 37, 112, 49, 37, 123, 56, 125, 37, 45, 37, 100, 37, 101, 51, 56, 59, 53, 59, 37, 112, 49, 37, 100, 37, 59, 109, 0, 27, 91, 37, 63, 37, 112, 49, 37, 123, 56, 125, 37, 60, 37, 116, 52, 37, 112, 49, 37, 100, 37, 101, 37, 112, 49, 37, 123, 49, 54, 125, 37, 60, 37, 116, 49, 48, 37, 112, 49, 37, 123, 56, 125, 37, 45, 37, 100, 37, 101, 52, 56, 59, 53, 59, 37, 112, 49, 37, 100, 37, 59, 109, 0
};
// Taken from unibilium/t/static_screen-256color.c as of 2015-08-14.
// This is an 256-colour terminfo description that lacks
// status line capabilities that screen actually has.
static const signed char screen_256colour_terminfo[] = {
  26, 1, 43, 0, 43, 0, 15, 0, 105, 1, -43, 2, 115, 99, 114, 101, 101, 110, 45, 50, 53, 54, 99, 111, 108, 111, 114, 124, 71, 78, 85, 32, 83, 99, 114, 101, 101, 110, 32, 119, 105, 116, 104, 32, 50, 53, 54, 32, 99, 111, 108, 111, 114, 115, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 80, 0, 8, 0, 24, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -1, 127, 0, 0, 4, 0, 6, 0, 8, 0, 25, 0, 30, 0, 37, 0, 41, 0, -1, -1, -1, -1, 45, 0, 62, 0, 64, 0, 68, 0, 75, 0, -1, -1, 77, 0, 89, 0, -1, -1, 93, 0, 96, 0, 102, 0, 106, 0, -1, -1, -1, -1, 110, 0, 112, 0, 117, 0, 122, 0, -1, -1, -1, -1, -125, 0, -1, -1, -1, -1, -120, 0, -115, 0, -110, 0, -1, -1, -105, 0, -103, 0, -98, 0, -1, -1, -89, 0, -84, 0, -78, 0, -72, 0, -1, -1, -1, -1, -1, -1, -69, 0, -1, -1, -1, -1, -1, -1, -65, 0, -1, -1, -61, 0, -1, -1, -1, -1, -1, -1, -59, 0, -1, -1, -54, 0, -1, -1, -1, -1, -1, -1, -1, -1, -50, 0, -46, 0, -40, 0, -36, 0, -32, 0, -28, 0, -22, 0, -16, 0, -10, 0, -4, 0, 2, 1, 7, 1, -1, -1, 12, 1, -1, -1, 16, 1, 21, 1, 26, 1, -1, -1, -1, -1, -1, -1, 30, 1, 34, 1, 42, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50, 1, -1, -1, 53, 1, 62, 1, 71, 1, 80, 1, -1, -1, 89, 1, 98, 1, 107, 1, -1, -1, 116, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 125, 1, -1, -1, -1, -1, -114, 1, -1, -1, -111, 1, -108, 1, -106, 1, -103, 1, -30, 1, -1, -1, -27, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -25, 1, -1, -1, 40, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 44, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 51, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 2, 62, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 73, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, 2, -1, -1, -1, -1, -1, -1, 86, 2, -107, 2, 27, 91, 90, 0, 7, 0, 13, 0, 27, 91, 37, 105, 37, 112, 49, 37, 100, 59, 37, 112, 50, 37, 100, 114, 0, 27, 91, 51, 103, 0, 27, 91, 72, 27, 91, 74, 0, 27, 91, 75, 0, 27, 91, 74, 0, 27, 91, 37, 105, 37, 112, 49, 37, 100, 59, 37, 112, 50, 37, 100, 72, 0, 10, 0, 27, 91, 72, 0, 27, 91, 63, 50, 53, 108, 0, 8, 0, 27, 91, 51, 52, 104, 27, 91, 63, 50, 53, 104, 0, 27, 91, 67, 0, 27, 77, 0, 27, 91, 51, 52, 108, 0, 27, 91, 80, 0, 27, 91, 77, 0, 14, 0, 27, 91, 53, 109, 0, 27, 91, 49, 109, 0, 27, 91, 63, 49, 48, 52, 57, 104, 0, 27, 91, 52, 104, 0, 27, 91, 55, 109, 0, 27, 91, 51, 109, 0, 27, 91, 52, 109, 0, 15, 0, 27, 91, 109, 15, 0, 27, 91, 63, 49, 48, 52, 57, 108, 0, 27, 91, 52, 108, 0, 27, 91, 50, 51, 109, 0, 27, 91, 50, 52, 109, 0, 27, 103, 0, 27, 41, 48, 0, 27, 91, 76, 0, 8, 0, 27, 91, 51, 126, 0, 27, 79, 66, 0, 27, 79, 80, 0, 27, 91, 50, 49, 126, 0, 27, 79, 81, 0, 27, 79, 82, 0, 27, 79, 83, 0, 27, 91, 49, 53, 126, 0, 27, 91, 49, 55, 126, 0, 27, 91, 49, 56, 126, 0, 27, 91, 49, 57, 126, 0, 27, 91, 50, 48, 126, 0, 27, 91, 49, 126, 0, 27, 91, 50, 126, 0, 27, 79, 68, 0, 27, 91, 54, 126, 0, 27, 91, 53, 126, 0, 27, 79, 67, 0, 27, 79, 65, 0, 27, 91, 63, 49, 108, 27, 62, 0, 27, 91, 63, 49, 104, 27, 61, 0, 27, 69, 0, 27, 91, 37, 112, 49, 37, 100, 80, 0, 27, 91, 37, 112, 49, 37, 100, 77, 0, 27, 91, 37, 112, 49, 37, 100, 66, 0, 27, 91, 37, 112, 49, 37, 100, 64, 0, 27, 91, 37, 112, 49, 37, 100, 76, 0, 27, 91, 37, 112, 49, 37, 100, 68, 0, 27, 91, 37, 112, 49, 37, 100, 67, 0, 27, 91, 37, 112, 49, 37, 100, 65, 0, 27, 99, 27, 91, 63, 49, 48, 48, 48, 108, 27, 91, 63, 50, 53, 104, 0, 27, 56, 0, 27, 55, 0, 10, 0, 27, 77, 0, 27, 91, 48, 37, 63, 37, 112, 54, 37, 116, 59, 49, 37, 59, 37, 63, 37, 112, 49, 37, 116, 59, 51, 37, 59, 37, 63, 37, 112, 50, 37, 116, 59, 52, 37, 59, 37, 63, 37, 112, 51, 37, 116, 59, 55, 37, 59, 37, 63, 37, 112, 52, 37, 116, 59, 53, 37, 59, 109, 37, 63, 37, 112, 57, 37, 116, 14, 37, 101, 15, 37, 59, 0, 27, 72, 0, 9, 0, 43, 43, 44, 44, 45, 45, 46, 46, 48, 48, 96, 96, 97, 97, 102, 102, 103, 103, 104, 104, 105, 105, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126, 0, 27, 91, 90, 0, 27, 40, 66, 27, 41, 48, 0, 27, 91, 52, 126, 0, 27, 91, 50, 51, 126, 0, 27, 91, 50, 52, 126, 0, 27, 91, 49, 75, 0, 27, 91, 51, 57, 59, 52, 57, 109, 0, 27, 91, 77, 0, 27, 91, 37, 63, 37, 112, 49, 37, 123, 56, 125, 37, 60, 37, 116, 51, 37, 112, 49, 37, 100, 37, 101, 37, 112, 49, 37, 123, 49, 54, 125, 37, 60, 37, 116, 57, 37, 112, 49, 37, 123, 56, 125, 37, 45, 37, 100, 37, 101, 51, 56, 59, 53, 59, 37, 112, 49, 37, 100, 37, 59, 109, 0, 27, 91, 37, 63, 37, 112, 49, 37, 123, 56, 125, 37, 60, 37, 116, 52, 37, 112, 49, 37, 100, 37, 101, 37, 112, 49, 37, 123, 49, 54, 125, 37, 60, 37, 116, 49, 48, 37, 112, 49, 37, 123, 56, 125, 37, 45, 37, 100, 37, 101, 52, 56, 59, 53, 59, 37, 112, 49, 37, 100, 37, 59, 109, 0, 0, 3, 0, 1, 0, 24, 0, 52, 0, -112, 0, 1, 1, 0, 0, 1, 0, 0, 0, 4, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 3, 0, 6, 0, 9, 0, 12, 0, 15, 0, 18, 0, 23, 0, 28, 0, 32, 0, 37, 0, 43, 0, 49, 0, 55, 0, 61, 0, 66, 0, 71, 0, 77, 0, 83, 0, 89, 0, 95, 0, 101, 0, 107, 0, 111, 0, 116, 0, 120, 0, 124, 0, -128, 0, 27, 40, 66, 0, 27, 40, 37, 112, 49, 37, 99, 0, 65, 88, 0, 71, 48, 0, 88, 84, 0, 85, 56, 0, 69, 48, 0, 83, 48, 0, 107, 68, 67, 53, 0, 107, 68, 67, 54, 0, 107, 68, 78, 0, 107, 68, 78, 53, 0, 107, 69, 78, 68, 53, 0, 107, 69, 78, 68, 54, 0, 107, 72, 79, 77, 53, 0, 107, 72, 79, 77, 54, 0, 107, 73, 67, 53, 0, 107, 73, 67, 54, 0, 107, 76, 70, 84, 53, 0, 107, 78, 88, 84, 53, 0, 107, 78, 88, 84, 54, 0, 107, 80, 82, 86, 53, 0, 107, 80, 82, 86, 54, 0, 107, 82, 73, 84, 53, 0, 107, 85, 80, 0, 107, 85, 80, 53, 0, 107, 97, 50, 0, 107, 98, 49, 0, 107, 98, 51, 0, 107, 99, 50, 0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
static const signed char iterm_256colour_terminfo[] = {
  26,   1,  57,   0,  29,   0,  15,   0, 105,   1,  73,   3, 105,  84, 101, 114, 109,  46,  97, 112, 112, 124, 105, 116, 101, 114, 109, 124, 105,  84, 101, 114, 109,  46,  97, 112, 112,  32, 116, 101, 114, 109, 105, 110,  97, 108,  32, 101, 109, 117, 108,  97, 116, 111, 114,  32, 102, 111, 114,  32,  77,  97,  99,  32,  79,  83,  32,  88,   0,   0,   1,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   1,  80,   0,   8,   0,  24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  50,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,  -1, 127,  -1,  -1,   0,   0,   2,   0,  -2,  -1,   4,   0,   9,   0,  16,   0,  20,   0,  24,   0,  -1,  -1,  35,   0,  52,   0,  54,   0,  58,   0,  65,   0,  -1,  -1,  67,   0,  74,   0,  -1,  -1,  78,   0,  -1,  -1,  82,   0,  86,   0,  90,   0,  -1,  -1,  96,   0,  98,   0, 103,   0, 108,   0,  -1,  -1,  -2,  -1, 117,   0, 122,   0,  -1,  -1, 127,   0,-124,   0,-119,   0,  -1,  -1,-114,   0,-112,   0,-107,   0,  -1,  -1, -94,   0, -89,   0, -85,   0, -81,   0,  -1,  -1, -63,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -61,   0, -57,   0,  -1,  -1, -53,   0,  -1,  -1,  -1,  -1,  -1,  -1, -51,   0,  -1,  -1, -46,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -42,   0, -38,   0, -32,   0, -28,   0, -24,   0, -20,   0, -14,   0,  -8,   0,  -2,   0,   4,   1,  10,   1,  -1,  -1,  -1,  -1,  14,   1,  -1,  -1,  18,   1,  23,   1,  28,   1,  -1,  -1,  -1,  -1,  -1,  -1,  32,   1,  36,   1,  44,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  52,   1,  61,   1,  70,   1,  79,   1,  -1,  -1,  88,   1,  97,   1, 106,   1,  -1,  -1, 115,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 124,   1,  -1,  -1,  -1,  -1,-104,   1,-101,   1, -90,   1, -87,   1, -85,   1, -82,   1,  -4,   1,  -1,  -1,  -1,   1,   1,   2,  -1,  -1,  -1,  -1,  -1,  -1,   6,   2,  10,   2,  14,   2,  18,   2,  22,   2,  -1,  -1,  -1,  -1,  26,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  77,   2,  83,   2,  -1,  -1,  -1,  -1,  89,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  96,   2, 100,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 104,   2, 110,   2, 116,   2, 122,   2,-128,   2,-122,   2,-116,   2,-110,   2, 104,   2, -98,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -92,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -87,   2, -76,   2, -71,   2, -63,   2, -59,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -54,   2,   9,   3,   7,   0,  13,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,   0,   8,   0,  27,  91,  63,  50,  53, 104,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  80,   0,  27,  91,  77,   0,  27,  93,  50,  59,   7,   0,  14,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  55,  27,  91,  63,  52,  55, 104,   0,  27,  91,  52, 104,   0,  27,  91,  56, 109,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  15,   0,  27,  91, 109,  15,   0,  27,  91,  50,  74,  27,  91,  63,  52,  55, 108,  27,  56,   0,  27,  91,  52, 108,   0,  27,  91, 109,   0,  27,  91, 109,   0,  27,  91,  63,  53, 104,  36,  60,  50,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,   7,   0,  27,  91,  64,   0,  27,  91,  76,   0, 127,   0,  27,  91,  51, 126,   0,  27,  79,  66,   0,  27,  79,  80,   0,  27,  91,  50,  49, 126,   0,  27,  79,  81,   0,  27,  79,  82,   0,  27,  79,  83,   0,  27,  91,  49,  53, 126,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  79,  72,   0,  27,  79,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  79,  67,   0,  27,  79,  65,   0,  27,  91,  63,  49, 108,  27,  62,   0,  27,  91,  63,  49, 104,  27,  61,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  62,  27,  91,  63,  51, 108,  27,  91,  63,  52, 108,  27,  91,  63,  53, 108,  27,  91,  63,  55, 104,  27,  91,  63,  56, 104,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  27,  91,  48,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  49,  37, 112,  51,  37, 124,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59,  37,  63,  37, 112,  55,  37, 116,  59,  56,  37,  59, 109,  37,  63,  37, 112,  57,  37, 116,  14,  37, 101,  15,  37,  59,   0,  27,  72,   0,   9,   0,  27,  93,  50,  59,   0,  27,  79, 113,   0,  27,  79, 115,   0,  27,  79, 114,   0,  27,  79, 112,   0,  27,  79, 110,   0,  96,  96,  97,  97, 102, 102, 103, 103, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,   0,  27,  91,  63,  55, 104,   0,  27,  91,  63,  55, 108,   0,  27,  40,  66,  27,  41,  48,   0,  27,  79,  70,   0,  27,  79,  77,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  50,  53, 126,   0,  27,  91,  50,  54, 126,   0,  27,  91,  50,  56, 126,   0,  27,  91,  50,  57, 126,   0,  27,  91,  51,  49, 126,   0,  27,  91,  50,  50, 126,   0,  27,  91,  51,  51, 126,   0,  27,  91,  51,  52, 126,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  49,  59,  50,  99,   0,  27,  91,  99,   0,  27,  91,  48, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  51,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  57,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  51,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  52,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  49,  48,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  52,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
// This is a 256-colour terminfo description that lacks true-colour
// capabilities that rxvt actually has.
static const signed char rxvt_256colour_terminfo[] = {
  26,   1,  47,   0,  29,   0,  15,   0, 110,   1, -31,   4, 114, 120, 118, 116,  45,  50,  53,  54,  99, 111, 108, 111, 114, 124, 114, 120, 118, 116,  32,  50,  46,  55,  46,  57,  32, 119, 105, 116, 104,  32, 120, 116, 101, 114, 109,  32,  50,  53,  54,  45,  99, 111, 108, 111, 114, 115,   0,   0,   1,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   1,  80,   0,   8,   0,  24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,  -1, 127,  -1,  -1,   0,   0,   2,   0,   4,   0,  21,   0,  26,   0,  34,   0,  38,   0,  42,   0,  -1,  -1,  53,   0,  70,   0,  72,   0,  76,   0,  83,   0,  -1,  -1,  85,   0,  92,   0,  -1,  -1,  96,   0,  -1,  -1,  -1,  -1, 100,   0,  -1,  -1,  -1,  -1, 104,   0, 106,   0, 111,   0, 116,   0,  -1,  -1,  -1,  -1, 125,   0,  -1,  -1,  -1,  -1,-126,   0,-121,   0,-116,   0,  -1,  -1,-111,   0,-109,   0,-104,   0,  -1,  -1, -91,   0, -86,   0, -80,   0, -74,   0,  -1,  -1,  -1,  -1, -56,   0, -42,   0,  -1,  -1,  -1,  -1,  -8,   0,  -4,   0,  -1,  -1,   0,   1,  -1,  -1,  -1,  -1,  -1,  -1,   2,   1,  -1,  -1,   7,   1,  -1,  -1,  11,   1,  -1,  -1,  16,   1,  22,   1,  28,   1,  34,   1,  40,   1,  46,   1,  52,   1,  58,   1,  64,   1,  70,   1,  76,   1,  82,   1,  87,   1,  -1,  -1,  92,   1,  -1,  -1,  96,   1, 101,   1, 106,   1, 110,   1, 114,   1,  -1,  -1, 118,   1, 122,   1, 125,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-128,   1,-119,   1,-110,   1,  -1,  -1,-101,   1, -92,   1, -83,   1,  -1,  -1, -74,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -65,   1, -32,   1,  -1,  -1,  -1,  -1,  18,   2,  21,   2,  32,   2,  35,   2,  37,   2,  40,   2, 107,   2,  -1,  -1, 110,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 112,   2, 116,   2, 120,   2, 124,   2,-128,   2,  -1,  -1,  -1,  -1,-124,   2,  -1,  -1, -73,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -69,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -62,   2, -57,   2,  -1,  -1, -53,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -48,   2,  -1,  -1, -43,   2, -38,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -33,   2, -28,   2, -23,   2,  -1,  -1,  -1,  -1, -19,   2,  -1,  -1, -14,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -9,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -5,   2,   1,   3,   7,   3,  13,   3,  19,   3,  25,   3,  31,   3,  37,   3,  43,   3,  49,   3,  55,   3,  61,   3,  67,   3,  73,   3,  79,   3,  85,   3,  91,   3,  97,   3, 103,   3, 109,   3, 115,   3, 121,   3, 127,   3,-123,   3,-117,   3,-111,   3,-105,   3, -99,   3, -93,   3, -87,   3, -81,   3, -75,   3, -69,   3, -63,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -57,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -52,   3, -41,   3, -36,   3, -28,   3, -24,   3, -15,   3,  -8,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  86,   4,  -1,  -1,  -1,  -1,  -1,  -1,  90,   4,-103,   4,  -1,  -1,  -1,  -1,  -1,  -1, -39,   4, -35,   4,   7,   0,  13,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100, 114,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  50,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,   0,   8,   0,  27,  91,  63,  50,  53, 104,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  77,   0,  14,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  55,  27,  91,  63,  52,  55, 104,   0,  27,  91,  52, 104,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  15,   0,  27,  91, 109,  15,   0,  27,  91,  50,  74,  27,  91,  63,  52,  55, 108,  27,  56,   0,  27,  91,  52, 108,   0,  27,  91,  50,  55, 109,   0,  27,  91,  50,  52, 109,   0,  27,  91,  63,  53, 104,  36,  60,  49,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,  27,  91,  63,  52,  55, 108,  27,  61,  27,  91,  63,  49, 108,   0,  27,  91, 114,  27,  91, 109,  27,  91,  50,  74,  27,  91,  72,  27,  91,  63,  55, 104,  27,  91,  63,  49,  59,  51,  59,  52,  59,  54, 108,  27,  91,  52, 108,   0,  27,  91,  64,   0,  27,  91,  76,   0,   8,   0,  27,  91,  51, 126,   0,  27,  91,  66,   0,  27,  91,  56,  94,   0,  27,  91,  50,  49, 126,   0,  27,  91,  49,  49, 126,   0,  27,  91,  50,  49, 126,   0,  27,  91,  49,  50, 126,   0,  27,  91,  49,  51, 126,   0,  27,  91,  49,  52, 126,   0,  27,  91,  49,  53, 126,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  91,  55, 126,   0,  27,  91,  50, 126,   0,  27,  91,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  91,  67,   0,  27,  91,  97,   0,  27,  91,  98,   0,  27,  91,  65,   0,  27,  62,   0,  27,  61,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  62,  27,  91,  49,  59,  51,  59,  52,  59,  53,  59,  54, 108,  27,  91,  63,  55, 104,  27,  91, 109,  27,  91, 114,  27,  91,  50,  74,  27,  91,  72,   0,  27,  91, 114,  27,  91, 109,  27,  91,  50,  74,  27,  91,  72,  27,  91,  63,  55, 104,  27,  91,  63,  49,  59,  51,  59,  52,  59,  54, 108,  27,  91,  52, 108,  27,  62,  27,  91,  63,  49,  48,  48,  48, 108,  27,  91,  63,  50,  53, 104,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  27,  91,  48,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  49,  37, 112,  51,  37, 124,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59, 109,  37,  63,  37, 112,  57,  37, 116,  14,  37, 101,  15,  37,  59,   0,  27,  72,   0,   9,   0,  27,  79, 119,   0,  27,  79, 121,   0,  27,  79, 117,   0,  27,  79, 113,   0,  27,  79, 115,   0,  96,  96,  97,  97, 102, 102, 103, 103, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,   0,  27,  91,  90,   0,  27,  40,  66,  27,  41,  48,   0,  27,  91,  56, 126,   0,  27,  79,  77,   0,  27,  91,  49, 126,   0,  27,  91,  51,  36,   0,  27,  91,  52, 126,   0,  27,  91,  56,  36,   0,  27,  91,  55,  36,   0,  27,  91,  50,  36,   0,  27,  91, 100,   0,  27,  91,  54,  36,   0,  27,  91,  53,  36,   0,  27,  91,  99,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  50,  53, 126,   0,  27,  91,  50,  54, 126,   0,  27,  91,  50,  56, 126,   0,  27,  91,  50,  57, 126,   0,  27,  91,  51,  49, 126,   0,  27,  91,  51,  50, 126,   0,  27,  91,  51,  51, 126,   0,  27,  91,  51,  52, 126,   0,  27,  91,  50,  51,  36,   0,  27,  91,  50,  52,  36,   0,  27,  91,  49,  49,  94,   0,  27,  91,  49,  50,  94,   0,  27,  91,  49,  51,  94,   0,  27,  91,  49,  52,  94,   0,  27,  91,  49,  53,  94,   0,  27,  91,  49,  55,  94,   0,  27,  91,  49,  56,  94,   0,  27,  91,  49,  57,  94,   0,  27,  91,  50,  48,  94,   0,  27,  91,  50,  49,  94,   0,  27,  91,  50,  51,  94,   0,  27,  91,  50,  52,  94,   0,  27,  91,  50,  53,  94,   0,  27,  91,  50,  54,  94,   0,  27,  91,  50,  56,  94,   0,  27,  91,  50,  57,  94,   0,  27,  91,  51,  49,  94,   0,  27,  91,  51,  50,  94,   0,  27,  91,  51,  51,  94,   0,  27,  91,  51,  52,  94,   0,  27,  91,  50,  51,  64,   0,  27,  91,  50,  52,  64,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  49,  59,  50,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  93,  49,  48,  52,   7,   0,  27,  93,  52,  59,  37, 112,  49,  37, 100,  59, 114, 103,  98,  58,  37, 112,  50,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  47,  37, 112,  51,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  47,  37, 112,  52,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  50,  46,  50,  88,  27,  92,   0,  27,  91,  77,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  51,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  57,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  51,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  52,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  49,  48,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  52,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  40,  66,   0,  27,  40,  48,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
// This is a 16-colour terminfo description that lacks true-colour
// and 256-colour capabilities that linux (4.8+) actually has.
static const signed char linux_16colour_terminfo[] = {
  26,   1,  43,   0,  29,   0,  16,   0, 125,   1, 125,   3, 108, 105, 110, 117, 120,  45,  49,  54,  99, 111, 108, 111, 114, 124, 108, 105, 110, 117, 120,  32,  99, 111, 110, 115, 111, 108, 101,  32, 119, 105, 116, 104,  32,  49,  54,  32,  99, 111, 108, 111, 114, 115,   0,   0,   1,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   1,  -1,  -1,   8,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  16,   0,   0,   1,  42,   0,  -1,  -1,   0,   0,   2,   0,   4,   0,  21,   0,  26,   0,  33,   0,  37,   0,  41,   0,  -1,  -1,  52,   0,  69,   0,  71,   0,  75,   0,  87,   0,  -1,  -1,  89,   0, 101,   0,  -1,  -1, 105,   0, 109,   0, 121,   0, 125,   0,  -1,  -1,  -1,  -1,-127,   0,-125,   0,-120,   0,  -1,  -1,  -1,  -1,-115,   0,-110,   0,  -1,  -1,  -1,  -1,-105,   0,-100,   0, -95,   0, -90,   0, -81,   0, -79,   0,  -1,  -1,  -1,  -1, -74,   0, -69,   0, -63,   0, -57,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -39,   0, -35,   0,  -1,  -1, -31,   0,  -1,  -1,  -1,  -1,  -1,  -1, -29,   0,  -1,  -1, -24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -20,   0, -15,   0,  -9,   0,  -4,   0,   1,   1,   6,   1,  11,   1,  17,   1,  23,   1,  29,   1,  35,   1,  40,   1,  -1,  -1,  45,   1,  -1,  -1,  49,   1,  54,   1,  59,   1,  -1,  -1,  -1,  -1,  -1,  -1,  63,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  67,   1,  -1,  -1,  70,   1,  79,   1,  88,   1,  97,   1,  -1,  -1, 106,   1, 115,   1, 124,   1,  -1,  -1,-123,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-114,   1,  -1,  -1,  -1,  -1,  -1,  -1,-108,   1,-105,   1, -94,   1, -91,   1, -89,   1, -86,   1,   1,   2,  -1,  -1,   4,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   6,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  10,   2,  -1,  -1,  77,   2,  -1,  -1,  -1,  -1,  81,   2,  87,   2,  -1,  -1,  -1,  -1,  93,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  97,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 102,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 104,   2, 110,   2, 116,   2, 122,   2,-128,   2,-122,   2,-116,   2,-110,   2,-104,   2, -98,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -92,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -87,   2, -76,   2, -71,   2, -65,   2, -61,   2, -52,   2, -48,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  33,   3,  -1,  -1,  -1,  -1,  -1,  -1,  37,   3,  75,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 113,   3, 119,   3,   7,   0,  13,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100, 114,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,  27,  91,  63,  49,  99,   0,   8,   0,  27,  91,  63,  50,  53, 104,  27,  91,  63,  48,  99,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  63,  50,  53, 104,  27,  91,  63,  56,  99,   0,  27,  91,  80,   0,  27,  91,  77,   0,  14,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  91,  50, 109,   0,  27,  91,  52, 104,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  37, 112,  49,  37, 100,  88,   0,  15,   0,  27,  91, 109,  15,   0,  27,  91,  52, 108,   0,  27,  91,  50,  55, 109,   0,  27,  91,  50,  52, 109,   0,  27,  91,  63,  53, 104,  36,  60,  50,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,  27,  91,  64,   0,  27,  91,  76,   0, 127,   0,  27,  91,  51, 126,   0,  27,  91,  66,   0,  27,  91,  91,  65,   0,  27,  91,  50,  49, 126,   0,  27,  91,  91,  66,   0,  27,  91,  91,  67,   0,  27,  91,  91,  68,   0,  27,  91,  91,  69,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  91,  49, 126,   0,  27,  91,  50, 126,   0,  27,  91,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  91,  67,   0,  27,  91,  65,   0,  13,  10,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  99,  27,  93,  82,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  27,  91,  48,  59,  49,  48,  37,  63,  37, 112,  49,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  51,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59,  37,  63,  37, 112,  53,  37, 116,  59,  50,  37,  59,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59, 109,  37,  63,  37, 112,  57,  37, 116,  14,  37, 101,  15,  37,  59,   0,  27,  72,   0,   9,   0,  27,  91,  71,   0,  43,  43,  44,  44,  45,  45,  46,  46,  48,  48,  95,  95,  96,  96,  97,  97, 102, 102, 103, 103, 104, 104, 105, 105, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125,  99, 126, 126,   0,  27,  91,  90,   0,  27,  91,  63,  55, 104,   0,  27,  91,  63,  55, 108,   0,  27,  41,  48,   0,  27,  91,  52, 126,   0,  26,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  50,  53, 126,   0,  27,  91,  50,  54, 126,   0,  27,  91,  50,  56, 126,   0,  27,  91,  50,  57, 126,   0,  27,  91,  51,  49, 126,   0,  27,  91,  51,  50, 126,   0,  27,  91,  51,  51, 126,   0,  27,  91,  51,  52, 126,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  54,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  93,  82,   0,  27,  93,  80,  37, 112,  49,  37, 120,  37, 112,  50,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  48,  50, 120,  37, 112,  51,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  48,  50, 120,  37, 112,  52,  37, 123,  50,  53,  53, 125,  37,  42,  37, 123,  49,  48,  48,  48, 125,  37,  47,  37,  48,  50, 120,   0,  27,  91,  77,   0,  27,  91,  51,  37, 112,  49,  37, 123,  56, 125,  37, 109,  37, 100,  37,  63,  37, 112,  49,  37, 123,  55, 125,  37,  62,  37, 116,  59,  49,  37, 101,  59,  50,  49,  37,  59, 109,   0,  27,  91,  52,  37, 112,  49,  37, 123,  56, 125,  37, 109,  37, 100,  37,  63,  37, 112,  49,  37, 123,  55, 125,  37,  62,  37, 116,  59,  53,  37, 101,  59,  50,  53,  37,  59, 109,   0,  27,  91,  49,  49, 109,   0,  27,  91,  49,  48, 109,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
static const signed char putty_256colour_terminfo[] = {
  26,   1,  48,   0,  29,   0,  16,   0, 125,   1,-106,   4, 112, 117, 116, 116, 121,  45,  50,  53,  54,  99, 111, 108, 111, 114, 124,  80, 117,  84,  84,  89,  32,  48,  46,  53,  56,  32, 119, 105, 116, 104,  32, 120, 116, 101, 114, 109,  32,  50,  53,  54,  45,  99, 111, 108, 111, 114, 115,   0,   1,   1,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,  -1,   8,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,  -1, 127,  22,   0,   0,   0,   4,   0,   6,   0,   8,   0,  25,   0,  30,   0,  37,   0,  41,   0,  45,   0,  -1,  -1,  56,   0,  73,   0,  76,   0,  80,   0,  87,   0,  -1,  -1,  89,   0,  96,   0,  -1,  -1, 100,   0,  -1,  -1, 103,   0, 107,   0, 111,   0,  -1,  -1, 117,   0, 119,   0, 124,   0,-127,   0,  -1,  -1,  -1,  -1,-120,   0,  -1,  -1,  -1,  -1,-115,   0,-110,   0,-105,   0,-100,   0, -91,   0, -89,   0, -84,   0,  -1,  -1, -73,   0, -68,   0, -62,   0, -56,   0,  -1,  -1, -38,   0,  -1,  -1, -36,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -2,   0,  -1,  -1,   2,   1,  -1,  -1,  -1,  -1,  -1,  -1,   4,   1,  -1,  -1,   9,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  13,   1,  19,   1,  25,   1,  31,   1,  37,   1,  43,   1,  49,   1,  55,   1,  61,   1,  67,   1,  73,   1,  78,   1,  -1,  -1,  83,   1,  -1,  -1,  87,   1,  92,   1,  97,   1, 101,   1, 105,   1,  -1,  -1, 109,   1, 113,   1, 121,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-127,   1,  -1,  -1,-124,   1,-115,   1,-106,   1,  -1,  -1, -97,   1, -88,   1, -79,   1, -70,   1, -61,   1, -52,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -43,   1,  -1,  -1,  -1,  -1, -10,   1,  -7,   1,   4,   2,   7,   2,   9,   2,  12,   2,  84,   2,  -1,  -1,  87,   2,  89,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  94,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  98,   2,  -1,  -1,-107,   2,  -1,  -1,  -1,  -1,-103,   2, -97,   2,  -1,  -1,  -1,  -1, -91,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -84,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -79,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -77,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -73,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -69,   2, -63,   2, -57,   2, -51,   2, -45,   2, -39,   2, -33,   2, -27,   2, -21,   2, -15,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -9,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -4,   2,   7,   3,  12,   3,  18,   3,  22,   3,  31,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  35,   3,  -1,  -1,  -1,  -1,  -1,  -1,  39,   3, 102,   3,  -1,  -1,  -1,  -1,  -1,  -1, -90,   3, -84,   3, -78,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -72,   3,-118,   4,-112,   4,  27,  91,  90,   0,   7,   0,  13,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100, 114,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  27,  68,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,   0,   8,   0,  27,  91,  63,  50,  53, 104,   0,  27,  91,  67,   0,  27,  77,   0,  27,  91,  80,   0,  27,  91,  77,   0,  27,  93,  48,  59,   7,   0,  14,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  91,  63,  52,  55, 104,   0,  27,  91,  52, 104,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  37, 112,  49,  37, 100,  88,   0,  15,   0,  27,  91, 109,  15,   0,  27,  91,  50,  74,  27,  91,  63,  52,  55, 108,   0,  27,  91,  52, 108,   0,  27,  91,  50,  55, 109,   0,  27,  91,  50,  52, 109,   0,  27,  91,  63,  53, 104,  36,  60,  49,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,   7,   0,  27,  55,  27,  91, 114,  27,  91, 109,  27,  91,  63,  55, 104,  27,  91,  63,  49,  59,  52,  59,  54, 108,  27,  91,  52, 108,  27,  56,  27,  62,  27,  93,  82,   0,  27,  91,  76,   0, 127,   0,  27,  91,  51, 126,   0,  27,  79,  66,   0,  27,  91,  49,  49, 126,   0,  27,  91,  50,  49, 126,   0,  27,  91,  49,  50, 126,   0,  27,  91,  49,  51, 126,   0,  27,  91,  49,  52, 126,   0,  27,  91,  49,  53, 126,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  91,  49, 126,   0,  27,  91,  50, 126,   0,  27,  79,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  79,  67,   0,  27,  91,  66,   0,  27,  91,  65,   0,  27,  79,  65,   0,  27,  91,  63,  49, 108,  27,  62,   0,  27,  91,  63,  49, 104,  27,  61,   0,  13,  10,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  83,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  84,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  60,  27,  91,  34, 112,  27,  91,  53,  48,  59,  54,  34, 112,  27,  99,  27,  91,  63,  51, 108,  27,  93,  82,  27,  91,  63,  49,  48,  48,  48, 108,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  27,  91,  48,  37,  63,  37, 112,  49,  37, 112,  54,  37, 124,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  49,  37, 112,  51,  37, 124,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59, 109,  37,  63,  37, 112,  57,  37, 116,  14,  37, 101,  15,  37,  59,   0,  27,  72,   0,   9,   0,  27,  93,  48,  59,   0,  27,  91,  71,   0,  96,  96,  97,  97, 102, 102, 103, 103, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,   0,  27,  91,  90,   0,  27,  91,  63,  55, 104,   0,  27,  91,  63,  55, 108,   0,  27,  40,  66,  27,  41,  48,   0,  27,  91,  52, 126,   0,  26,   0,  27,  91,  68,   0,  27,  91,  67,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  50,  53, 126,   0,  27,  91,  50,  54, 126,   0,  27,  91,  50,  56, 126,   0,  27,  91,  50,  57, 126,   0,  27,  91,  51,  49, 126,   0,  27,  91,  51,  50, 126,   0,  27,  91,  51,  51, 126,   0,  27,  91,  51,  52, 126,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  54,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  93,  82,   0,  27,  91,  77,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  51,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  57,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  51,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  52,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  49,  48,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  52,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  49,  48, 109,   0,  27,  91,  49,  49, 109,   0,  27,  91,  49,  50, 109,   0,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-105,-104,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  48, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-105,-103,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  50, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-103,-128,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  51, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-103, -86,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  52, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-103, -85,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  53, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-104, -68,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  50,  55, 125,  37,  61,  37, 116,  27,  37,  37,  71, -30,-122,-112,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37, 123,  49,  53,  53, 125,  37,  61,  37, 116,  27,  37,  37,  71, -32,-126, -94,  27,  37,  37,  64,  37, 101,  37, 112,  49,  37,  99,  37,  59,   0,  27,  91,  49,  49, 109,   0,  27,  91,  49,  48, 109,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
static const signed char interix_8colour_terminfo[] = {
  26,   1,  82,   0,  15,   0,  16,   0, 105,   1, 123,   2, 105, 110, 116, 101, 114, 105, 120, 124, 111, 112, 101, 110, 110, 116, 124, 111, 112, 101, 110, 110, 116,  45,  50,  53, 124, 110, 116,  99, 111, 110, 115, 111, 108, 101, 124, 110, 116,  99, 111, 110, 115, 111, 108, 101,  45,  50,  53, 124,  79, 112, 101, 110,  78,  84,  45, 116, 101, 114, 109,  32,  99, 111, 109, 112,  97, 116, 105,  98, 108, 101,  32, 119, 105, 116, 104,  32,  99, 111, 108, 111, 114,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,  80,   0,  -1,  -1,  25,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   8,   0,  64,   0,   3,   0,   0,   0,   4,   0,  -1,  -1,  -1,  -1,  -1,  -1,   6,   0,  11,   0,  15,   0,  -1,  -1,  -1,  -1,  19,   0,  36,   0,  38,   0,  -1,  -1,  42,   0,  -1,  -1,  -1,  -1,  46,   0,  50,   0,  54,   0,  -1,  -1,  -1,  -1,  58,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  62,   0,  67,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  75,   0,  80,   0,  85,   0,  -1,  -1,  -1,  -1,  90,   0,  95,   0,  -1,  -1,  -1,  -1, 107,   0, 111,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 115,   0,  -1,  -1, 119,   0,  -1,  -1,  -1,  -1,  -1,  -1, 121,   0,  -1,  -1, 125,   0,  -1,  -1,  -1,  -1,  -1,  -1,-127,   0,-123,   0,-119,   0,-115,   0,-111,   0,-107,   0,-103,   0, -99,   0, -95,   0, -91,   0, -87,   0,  -1,  -1, -83,   0,  -1,  -1, -79,   0, -75,   0, -71,   0, -67,   0, -63,   0,  -1,  -1,  -1,  -1,  -1,  -1, -59,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -55,   0,  -1,  -1,  -1,  -1, -52,   0, -43,   0,  -1,  -1, -34,   0, -25,   0, -16,   0,  -7,   0,   2,   1,  11,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  20,   1,  -1,  -1,  -1,  -1,  -1,  -1,  23,   1,  -1,  -1,  27,   1,  31,   1,  35,   1,  -1,  -1,  -1,  -1,  -1,  -1,  39,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  41,   1,  -1,  -1, 104,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 108,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 112,   1, 116,   1, 120,   1, 124,   1,-128,   1,-124,   1,-120,   1,-116,   1,-112,   1,-108,   1,-104,   1,-100,   1, -96,   1, -92,   1, -88,   1, -84,   1, -80,   1, -76,   1, -72,   1, -68,   1, -64,   1, -60,   1, -56,   1, -52,   1, -48,   1, -44,   1, -40,   1, -36,   1, -32,   1, -28,   1, -24,   1, -20,   1, -16,   1, -12,   1,  -8,   1,  -4,   1,   0,   2,   4,   2,   8,   2,  12,   2,  16,   2,  20,   2,  24,   2,  28,   2,  32,   2,  36,   2,  40,   2,  44,   2,  48,   2,  52,   2,  56,   2,  60,   2,  64,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  68,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  72,   2,  88,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 103,   2, 113,   2,  27,  91,  90,   0,   7,   0,  27,  91,  50,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  68,   0,  27,  91,  67,   0,  27,  91,  85,   0,  27,  91,  65,   0,  27,  91,  77,   0,  27,  91,  49, 109,   0,  27,  91, 115,  27,  91,  49,  98,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  48, 109,   0,  27,  91,  50,  98,  27,  91, 117,  13,  27,  91,  75,   0,  27,  91, 109,   0,  27,  91, 109,   0,  27,  91,  76,   0,   8,   0,  27,  91,  77,   0,  27,  91,  66,   0,  27,  70,  65,   0,  27,  70,  49,   0,  27,  70,  65,   0,  27,  70,  50,   0,  27,  70,  51,   0,  27,  70,  52,   0,  27,  70,  53,   0,  27,  70,  54,   0,  27,  70,  55,   0,  27,  70,  56,   0,  27,  70,  57,   0,  27,  91,  76,   0,  27,  91,  68,   0,  27,  91,  85,   0,  27,  91,  84,   0,  27,  91,  83,   0,  27,  91,  67,   0,  27,  91,  65,   0,  13,  10,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  83,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  84,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  99,   0,  27,  91, 117,   0,  27,  91, 115,   0,  27,  91,  83,   0,  27,  91,  84,   0,   9,   0,  43,  16,  44,  17,  45,  24,  46,  25,  48, -37,  96,   4,  97, -79, 102,  -8, 103, -15, 104, -80, 106, -39, 107, -65, 108, -38, 109, -64, 110, -59, 111, 126, 112, -60, 113, -60, 114, -60, 115,  95, 116, -61, 117, -76, 118, -63, 119, -62, 120, -77, 121, -13, 122, -14, 123, -29, 124, -40, 125,-100, 126,  -2,   0,  27,  91,  90,   0,  27,  91,  85,   0,  27,  70,  66,   0,  27,  70,  67,   0,  27,  70,  68,   0,  27,  70,  69,   0,  27,  70,  70,   0,  27,  70,  71,   0,  27,  70,  72,   0,  27,  70,  73,   0,  27,  70,  74,   0,  27,  70,  75,   0,  27,  70,  76,   0,  27,  70,  77,   0,  27,  70,  78,   0,  27,  70,  79,   0,  27,  70,  80,   0,  27,  70,  81,   0,  27,  70,  82,   0,  27,  70,  83,   0,  27,  70,  84,   0,  27,  70,  85,   0,  27,  70,  86,   0,  27,  70,  87,   0,  27,  70,  88,   0,  27,  70,  89,   0,  27,  70,  90,   0,  27,  70,  97,   0,  27,  70,  98,   0,  27,  70,  99,   0,  27,  70, 100,   0,  27,  70, 101,   0,  27,  70, 102,   0,  27,  70, 103,   0,  27,  70, 104,   0,  27,  70, 105,   0,  27,  70, 106,   0,  27,  70, 107,   0,  27,  70, 109,   0,  27,  70, 110,   0,  27,  70, 111,   0,  27,  70, 112,   0,  27,  70, 113,   0,  27,  70, 114,   0,  27,  70, 115,   0,  27,  70, 116,   0,  27,  70, 117,   0,  27,  70, 118,   0,  27,  70, 119,   0,  27,  70, 120,   0,  27,  70, 121,   0,  27,  70, 122,   0,  27,  70,  43,   0,  27,  70,  45,   0,  27,  70,  12,   0,  27,  91, 109,   0,  27,  91,  37, 112,  49,  37, 123,  51,  48, 125,  37,  43,  37, 100, 109,   0,  27,  91,  37, 112,  49,  37,  39,  40,  39,  37,  43,  37, 100, 109,   0,  27,  91,  51,  37, 112,  49,  37, 100, 109,   0,  27,  91,  52,  37, 112,  49,  37, 100, 109,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
// This is a 256-colour terminfo description that lacks true-colour
// capabilities that stterm actually has.
static const signed char st_256colour_terminfo[] = {
  26,   1,  55,   0,  29,   0,  15,   0, 105,   1, 117,   5, 115, 116,  45,  50,  53,  54,  99, 111, 108, 111, 114, 124, 115, 116, 116, 101, 114, 109,  45,  50,  53,  54,  99, 111, 108, 111, 114, 124, 115, 105, 109, 112, 108, 101, 116, 101, 114, 109,  32, 119, 105, 116, 104,  32,  50,  53,  54,  32,  99, 111, 108, 111, 114, 115,   0,   0,   1,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,  80,   0,   8,   0,  24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,  -1, 127,   0,   0,   4,   0,   6,   0,   8,   0,  25,   0,  30,   0,  38,   0,  42,   0,  46,   0,  -1,  -1,  57,   0,  74,   0,  76,   0,  80,   0,  87,   0,  -1,  -1,  89,   0, 102,   0,  -1,  -1, 106,   0, 110,   0, 117,   0, 121,   0,  -1,  -1,  -1,  -1, 125,   0,-127,   0,-122,   0,-117,   0,  -1,  -1,  -1,  -1,-108,   0,-103,   0,  -1,  -1, -98,   0, -93,   0, -88,   0, -83,   0, -74,   0, -70,   0, -65,   0,  -1,  -1, -56,   0, -51,   0, -45,   0, -39,   0,  -1,  -1, -21,   0,  -1,  -1, -19,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -4,   0,  -1,  -1,   0,   1,  -1,  -1,   2,   1,  -1,  -1,   9,   1,  14,   1,  21,   1,  25,   1,  32,   1,  39,   1,  -1,  -1,  46,   1,  50,   1,  56,   1,  60,   1,  64,   1,  68,   1,  74,   1,  80,   1,  86,   1,  92,   1,  98,   1, 103,   1, 108,   1, 115,   1,  -1,  -1, 119,   1, 124,   1,-127,   1,-123,   1,-116,   1,  -1,  -1,-109,   1,-105,   1, -97,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -89,   1, -80,   1, -71,   1, -62,   1, -53,   1, -44,   1, -35,   1, -26,   1,  -1,  -1, -17,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -8,   1,  -4,   1,   1,   2,  -1,  -1,   6,   2,   9,   2,  -1,  -1,  -1,  -1,  24,   2,  27,   2,  38,   2,  41,   2,  43,   2,  46,   2,-128,   2,  -1,  -1,-125,   2,-123,   2,  -1,  -1,  -1,  -1,  -1,  -1,-118,   2,-113,   2,-108,   2,-104,   2, -99,   2,  -1,  -1,  -1,  -1, -94,   2,  -1,  -1, -29,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -25,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -21,   2, -16,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -12,   2,  -1,  -1,  -1,  -1,  -5,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   2,   3,   9,   3,  16,   3,  -1,  -1,  -1,  -1,  23,   3,  -1,  -1,  30,   3,  -1,  -1,  -1,  -1,  -1,  -1,  37,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  44,   3,  50,   3,  56,   3,  63,   3,  70,   3,  77,   3,  84,   3,  92,   3, 100,   3, 108,   3, 116,   3, 124,   3,-124,   3,-116,   3,-108,   3,-101,   3, -94,   3, -87,   3, -80,   3, -72,   3, -64,   3, -56,   3, -48,   3, -40,   3, -32,   3, -24,   3, -16,   3,  -9,   3,  -2,   3,   5,   4,  12,   4,  20,   4,  28,   4,  36,   4,  44,   4,  52,   4,  60,   4,  68,   4,  76,   4,  83,   4,  90,   4,  97,   4, 104,   4, 112,   4, 120,   4,-128,   4,-120,   4,-112,   4,-104,   4, -96,   4, -88,   4, -81,   4, -74,   4, -67,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -62,   4, -51,   4, -46,   4, -38,   4, -34,   4,  -2,  -1,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -25,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -20,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -14,   4,  -1,  -1,  -1,  -1,  -1,  -1, -10,   4,  53,   5,  27,  91,  90,   0,   7,   0,  13,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100, 114,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  50,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  10,   0,  27,  91,  72,   0,  27,  91,  63,  50,  53, 108,   0,   8,   0,  27,  91,  63,  49,  50, 108,  27,  91,  63,  50,  53, 104,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  63,  50,  53, 104,   0,  27,  91,  80,   0,  27,  91,  77,   0,  27,  40,  48,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  91,  63,  49,  48,  52,  57, 104,   0,  27,  91,  52, 104,   0,  27,  91,  56, 109,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  37, 112,  49,  37, 100,  88,   0,  27,  40,  66,   0,  27,  91,  48, 109,   0,  27,  91,  63,  49,  48,  52,  57, 108,   0,  27,  91,  52, 108,   0,  27,  91,  50,  55, 109,   0,  27,  91,  50,  52, 109,   0,  27,  91,  63,  53, 104,  36,  60,  49,  48,  48,  47,  62,  27,  91,  63,  53, 108,   0,   7,   0,  27,  91,  52, 108,  27,  62,  27,  91,  63,  49,  48,  51,  52, 108,   0,  27,  91,  76,   0, 127,   0,  27,  91,  51,  59,  53, 126,   0,  27,  91,  51, 126,   0,  27,  91,  51,  59,  50, 126,   0,  27,  79,  66,   0,  27,  91,  50,  59,  50, 126,   0,  27,  91,  49,  59,  50,  70,   0,  27,  91,  49,  59,  53,  70,   0,  27,  79,  80,   0,  27,  91,  50,  49, 126,   0,  27,  79,  81,   0,  27,  79,  82,   0,  27,  79,  83,   0,  27,  91,  49,  53, 126,   0,  27,  91,  49,  55, 126,   0,  27,  91,  49,  56, 126,   0,  27,  91,  49,  57, 126,   0,  27,  91,  50,  48, 126,   0,  27,  91,  49, 126,   0,  27,  91,  50, 126,   0,  27,  91,  50,  59,  53, 126,   0,  27,  79,  68,   0,  27,  91,  54, 126,   0,  27,  91,  53, 126,   0,  27,  79,  67,   0,  27,  91,  49,  59,  50,  66,   0,  27,  91,  49,  59,  50,  65,   0,  27,  79,  65,   0,  27,  91,  63,  49, 108,  27,  62,   0,  27,  91,  63,  49, 104,  27,  61,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  83,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  91, 105,   0,  27,  91,  52, 105,   0,  27,  91,  53, 105,   0,  27,  99,   0,  27,  91,  52, 108,  27,  62,  27,  91,  63,  49,  48,  51,  52, 108,   0,  27,  56,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  27,  55,   0,  10,   0,  27,  77,   0,  37,  63,  37, 112,  57,  37, 116,  27,  40,  48,  37, 101,  27,  40,  66,  37,  59,  27,  91,  48,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  49,  37, 112,  51,  37, 124,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59,  37,  63,  37, 112,  55,  37, 116,  59,  56,  37,  59, 109,   0,  27,  72,   0,   9,   0,  27,  93,  48,  59,   0,  27,  91,  49, 126,   0,  27,  91,  53, 126,   0,  27,  79, 117,   0,  27,  91,  52, 126,   0,  27,  91,  54, 126,   0,  43,  67,  44,  68,  45,  65,  46,  66,  48,  69,  96,  96,  97,  97, 102, 102, 103, 103, 104,  70, 105,  71, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,   0,  27,  91,  90,   0,  27,  41,  48,   0,  27,  91,  52, 126,   0,  27,  79,  77,   0,  27,  91,  51,  59,  50, 126,   0,  27,  91,  49,  59,  50,  70,   0,  27,  91,  49,  59,  50,  72,   0,  27,  91,  50,  59,  50, 126,   0,  27,  91,  49,  59,  50,  68,   0,  27,  91,  54,  59,  50, 126,   0,  27,  91,  53,  59,  50, 126,   0,  27,  91,  49,  59,  50,  67,   0,  27,  91,  50,  51, 126,   0,  27,  91,  50,  52, 126,   0,  27,  91,  49,  59,  50,  80,   0,  27,  91,  49,  59,  50,  81,   0,  27,  91,  49,  59,  50,  82,   0,  27,  91,  49,  59,  50,  83,   0,  27,  91,  49,  53,  59,  50, 126,   0,  27,  91,  49,  55,  59,  50, 126,   0,  27,  91,  49,  56,  59,  50, 126,   0,  27,  91,  49,  57,  59,  50, 126,   0,  27,  91,  50,  48,  59,  50, 126,   0,  27,  91,  50,  49,  59,  50, 126,   0,  27,  91,  50,  51,  59,  50, 126,   0,  27,  91,  50,  52,  59,  50, 126,   0,  27,  91,  49,  59,  53,  80,   0,  27,  91,  49,  59,  53,  81,   0,  27,  91,  49,  59,  53,  82,   0,  27,  91,  49,  59,  53,  83,   0,  27,  91,  49,  53,  59,  53, 126,   0,  27,  91,  49,  55,  59,  53, 126,   0,  27,  91,  49,  56,  59,  53, 126,   0,  27,  91,  49,  57,  59,  53, 126,   0,  27,  91,  50,  48,  59,  53, 126,   0,  27,  91,  50,  49,  59,  53, 126,   0,  27,  91,  50,  51,  59,  53, 126,   0,  27,  91,  50,  52,  59,  53, 126,   0,  27,  91,  49,  59,  54,  80,   0,  27,  91,  49,  59,  54,  81,   0,  27,  91,  49,  59,  54,  82,   0,  27,  91,  49,  59,  54,  83,   0,  27,  91,  49,  53,  59,  54, 126,   0,  27,  91,  49,  55,  59,  54, 126,   0,  27,  91,  49,  56,  59,  54, 126,   0,  27,  91,  49,  57,  59,  54, 126,   0,  27,  91,  50,  48,  59,  54, 126,   0,  27,  91,  50,  49,  59,  54, 126,   0,  27,  91,  50,  51,  59,  54, 126,   0,  27,  91,  50,  52,  59,  54, 126,   0,  27,  91,  49,  59,  51,  80,   0,  27,  91,  49,  59,  51,  81,   0,  27,  91,  49,  59,  51,  82,   0,  27,  91,  49,  59,  51,  83,   0,  27,  91,  49,  53,  59,  51, 126,   0,  27,  91,  49,  55,  59,  51, 126,   0,  27,  91,  49,  56,  59,  51, 126,   0,  27,  91,  49,  57,  59,  51, 126,   0,  27,  91,  50,  48,  59,  51, 126,   0,  27,  91,  50,  49,  59,  51, 126,   0,  27,  91,  50,  51,  59,  51, 126,   0,  27,  91,  50,  52,  59,  51, 126,   0,  27,  91,  49,  59,  52,  80,   0,  27,  91,  49,  59,  52,  81,   0,  27,  91,  49,  59,  52,  82,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  49,  59,  50,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  91,  51, 109,   0,  27,  91,  50,  51, 109,   0,  27,  91,  77,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  51,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  57,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  51,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0,  27,  91,  37,  63,  37, 112,  49,  37, 123,  56, 125,  37,  60,  37, 116,  52,  37, 112,  49,  37, 100,  37, 101,  37, 112,  49,  37, 123,  49,  54, 125,  37,  60,  37, 116,  49,  48,  37, 112,  49,  37, 123,  56, 125,  37,  45,  37, 100,  37, 101,  52,  56,  59,  53,  59,  37, 112,  49,  37, 100,  37,  59, 109,   0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
// This is a 256-colour terminfo description that lacks true-colour
// capabilities that gnome actually has.
static const signed char vte_256colour_terminfo[] = {
  26,    1,   52,    0,   29,    0,   15,    0,  105,    1,  -55,    5,  103,  110,  111,  109, 101,   45,   50,   53,   54,   99,  111,  108,  111,  114,  124,   71,   78,   79,   77,   69,  32,   84,  101,  114,  109,  105,  110,   97,  108,   32,  119,  105,  116,  104,   32,  120, 116,  101,  114,  109,   32,   50,   53,   54,   45,   99,  111,  108,  111,  114,  115,    0,   0,    1,    0,    0,    1,    0,    0,    0,    0,    0,    0,    0,    0,    1,    1,    0,   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    1,    0,   80,    0,   8,    0,   24,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,    1,   -1,  127,    0,    0,    4,    0,   6,    0,    8,    0,   25,    0,   30,    0,   38,    0,   42,    0,   46,    0,   -1,   -1,  57,    0,   74,    0,   76,    0,   80,    0,   87,    0,   -1,   -1,   89,    0,   96,    0,  -1,   -1,  100,    0,   -1,   -1,  104,    0,  108,    0,   -1,   -1,   -1,   -1,  112,    0,  -1,   -1,  114,    0,  119,    0,   -1,   -1, -128,    0, -123,    0, -118,    0,   -1,   -1,-113,    0, -108,    0, -103,    0,  -98,    0,  -89,    0,  -87,    0,  -81,    0,   -1,   -1, -68,    0,  -63,    0,  -57,    0,  -51,    0,   -1,   -1,   -1,   -1,   -1,   -1,  -33,    0,  -1,   -1,   -1,   -1,   -1,   -1,    0,    1,   -1,   -1,    4,    1,   -1,   -1,   -1,   -1,  -1,   -1,    6,    1,   -1,   -1,   11,    1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  15,    1,   19,    1,   25,    1,   29,    1,   33,    1,   37,    1,   43,    1,   49,    1,  55,    1,   61,    1,   67,    1,   71,    1,   -1,   -1,   76,    1,   -1,   -1,   80,    1,  85,    1,   90,    1,   94,    1,  101,    1,   -1,   -1,  108,    1,  112,    1,  120,    1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, -128,    1,-119,    1, -110,    1, -101,    1,  -92,    1,  -83,    1,  -74,    1,  -65,    1,  -56,    1, -47,    1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, -38,    1,  -35,    1,   -1,   -1,   -1,   -1,   16,    2,   19,    2,   30,    2,   33,    2,  35,    2,   38,    2,  116,    2,   -1,   -1,  119,    2,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,  121,    2,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 125,    2,   -1,   -1,  -78,    2,   -1,   -1,   -1,   -1,  -74,    2,  -68,    2,   -1,   -1,  -1,   -1,  -62,    2,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,  -58,    2,  -54,    2,   -1,   -1,  -50,    2,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -45,    2,   -1,   -1,  -38,    2, -33,    2,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -26,    2,  -19,    2,  -12,    2,  -1,   -1,   -1,   -1,   -5,    2,   -1,   -1,    2,    3,   -1,   -1,   -1,   -1,   -1,   -1,   9,    3,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   16,    3,   22,    3,  28,    3,   35,    3,   42,    3,   49,    3,   56,    3,   64,    3,   72,    3,   80,    3,  88,    3,   96,    3,  104,    3,  112,    3,  120,    3,  127,    3, -122,    3, -115,    3,-108,    3, -100,    3,  -92,    3,  -84,    3,  -76,    3,  -68,    3,  -60,    3,  -52,    3, -44,    3,  -37,    3,  -30,    3,  -23,    3,  -16,    3,   -8,    3,    0,    4,    8,    4,  16,    4,   24,    4,   32,    4,   40,    4,   48,    4,   55,    4,   62,    4,   69,    4,  76,    4,   84,    4,   92,    4,  100,    4,  108,    4,  116,    4,  124,    4, -124,    4,-116,    4, -109,    4, -102,    4,  -95,    4,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,  -90,    4,  -79,    4,  -74,    4,  -55,    4,  -51,    4, -42,    4,  -35,    4,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,    5,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   64,    5,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  -1,   -1,   70,    5,   -1,   -1,   -1,   -1,   -1,   -1,   74,    5, -119,    5,   27,   91,  90,    0,    7,    0,   13,    0,   27,   91,   37,  105,   37,  112,   49,   37,  100,   59,  37,  112,   50,   37,  100,  114,    0,   27,   91,   51,  103,    0,   27,   91,   72,   27,  91,   50,   74,    0,   27,   91,   75,    0,   27,   91,   74,    0,   27,   91,   37,  105,  37,  112,   49,   37,  100,   71,    0,   27,   91,   37,  105,   37,  112,   49,   37,  100,  59,   37,  112,   50,   37,  100,   72,    0,   10,    0,   27,   91,   72,    0,   27,   91,  63,   50,   53,  108,    0,    8,    0,   27,   91,   63,   50,   53,  104,    0,   27,   91,  67,    0,   27,   91,   65,    0,   27,   91,   80,    0,   27,   91,   77,    0,   14,    0,  27,   91,   49,  109,    0,   27,   55,   27,   91,   63,   52,   55,  104,    0,   27,   91,  50,  109,    0,   27,   91,   52,  104,    0,   27,   91,   56,  109,    0,   27,   91,   55, 109,    0,   27,   91,   55,  109,    0,   27,   91,   52,  109,    0,   27,   91,   37,  112,  49,   37,  100,   88,    0,   15,    0,   27,   91,   48,  109,   15,    0,   27,   91,   50,  74,   27,   91,   63,   52,   55,  108,   27,   56,    0,   27,   91,   52,  108,    0,   27,  91,   50,   55,  109,    0,   27,   91,   50,   52,  109,    0,   27,   91,   63,   53,  104,  36,   60,   49,   48,   48,   47,   62,   27,   91,   63,   53,  108,    0,   27,   91,  109,  27,   91,   63,   55,  104,   27,   91,   52,  108,   27,   62,   27,   55,   27,   91,  114,  27,   91,   63,   49,   59,   51,   59,   52,   59,   54,  108,   27,   56,    0,   27,   91,  76,    0,  127,    0,   27,   91,   51,  126,    0,   27,   79,   66,    0,   27,   79,   80,   0,   27,   91,   50,   49,  126,    0,   27,   79,   81,    0,   27,   79,   82,    0,   27,  79,   83,    0,   27,   91,   49,   53,  126,    0,   27,   91,   49,   55,  126,    0,   27,  91,   49,   56,  126,    0,   27,   91,   49,   57,  126,    0,   27,   91,   50,   48,  126,   0,   27,   79,   72,    0,   27,   91,   50,  126,    0,   27,   79,   68,    0,   27,   91,  54,  126,    0,   27,   91,   53,  126,    0,   27,   79,   67,    0,   27,   91,   49,   59,  50,   66,    0,   27,   91,   49,   59,   50,   65,    0,   27,   79,   65,    0,   27,   91,  63,   49,  108,   27,   62,    0,   27,   91,   63,   49,  104,   27,   61,    0,   27,   91,  37,  112,   49,   37,  100,   80,    0,   27,   91,   37,  112,   49,   37,  100,   77,    0,  27,   91,   37,  112,   49,   37,  100,   66,    0,   27,   91,   37,  112,   49,   37,  100,  64,    0,   27,   91,   37,  112,   49,   37,  100,   83,    0,   27,   91,   37,  112,   49,  37,  100,   76,    0,   27,   91,   37,  112,   49,   37,  100,   68,    0,   27,   91,   37, 112,   49,   37,  100,   67,    0,   27,   91,   37,  112,   49,   37,  100,   84,    0,   27,  91,   37,  112,   49,   37,  100,   65,    0,   27,   99,    0,   27,   55,   27,   91,  114,  27,   56,   27,   91,  109,   27,   91,   63,   55,  104,   27,   91,   33,  112,   27,   91,  63,   49,   59,   51,   59,   52,   59,   54,  108,   27,   91,   52,  108,   27,   62,   27,  91,   63,   49,   48,   48,   48,  108,   27,   91,   63,   50,   53,  104,    0,   27,   56,   0,   27,   91,   37,  105,   37,  112,   49,   37,  100,  100,    0,   27,   55,    0,   10,   0,   27,   77,    0,   27,   91,   48,   37,   63,   37,  112,   54,   37,  116,   59,   49,  37,   59,   37,   63,   37,  112,   50,   37,  116,   59,   52,   37,   59,   37,   63,   37, 112,   53,   37,  116,   59,   50,   37,   59,   37,   63,   37,  112,   55,   37,  116,   59,  56,   37,   59,   37,   63,   37,  112,   49,   37,  112,   51,   37,  124,   37,  116,   59,  55,   37,   59,  109,   37,   63,   37,  112,   57,   37,  116,   14,   37,  101,   15,   37,  59,    0,   27,   72,    0,    9,    0,   27,   91,   69,    0,   96,   96,   97,   97,  102, 102,  103,  103,  105,  105,  106,  106,  107,  107,  108,  108,  109,  109,  110,  110,  111, 111,  112,  112,  113,  113,  114,  114,  115,  115,  116,  116,  117,  117,  118,  118,  119, 119,  120,  120,  121,  121,  122,  122,  123,  123,  124,  124,  125,  125,  126,  126,    0,  27,   91,   90,    0,   27,   91,   63,   55,  104,    0,   27,   91,   63,   55,  108,    0,  27,   41,   48,    0,   27,   79,   70,    0,   27,   79,   77,    0,   27,   91,   49,  126,   0,   27,   91,   51,   59,   50,  126,    0,   27,   91,   52,  126,    0,   27,   91,   49,  59,   50,   70,    0,   27,   91,   49,   59,   50,   72,    0,   27,   91,   50,   59,   50, 126,    0,   27,   91,   49,   59,   50,   68,    0,   27,   91,   54,   59,   50,  126,    0,  27,   91,   53,   59,   50,  126,    0,   27,   91,   49,   59,   50,   67,    0,   27,   91,  50,   51,  126,    0,   27,   91,   50,   52,  126,    0,   27,   91,   49,   59,   50,   80,   0,   27,   91,   49,   59,   50,   81,    0,   27,   91,   49,   59,   50,   82,    0,   27,  91,   49,   59,   50,   83,    0,   27,   91,   49,   53,   59,   50,  126,    0,   27,   91,  49,   55,   59,   50,  126,    0,   27,   91,   49,   56,   59,   50,  126,    0,   27,   91,  49,   57,   59,   50,  126,    0,   27,   91,   50,   48,   59,   50,  126,    0,   27,   91,  50,   49,   59,   50,  126,    0,   27,   91,   50,   51,   59,   50,  126,    0,   27,   91,  50,   52,   59,   50,  126,    0,   27,   91,   49,   59,   53,   80,    0,   27,   91,   49,  59,   53,   81,    0,   27,   91,   49,   59,   53,   82,    0,   27,   91,   49,   59,   53,  83,    0,   27,   91,   49,   53,   59,   53,  126,    0,   27,   91,   49,   55,   59,   53, 126,    0,   27,   91,   49,   56,   59,   53,  126,    0,   27,   91,   49,   57,   59,   53, 126,    0,   27,   91,   50,   48,   59,   53,  126,    0,   27,   91,   50,   49,   59,   53, 126,    0,   27,   91,   50,   51,   59,   53,  126,    0,   27,   91,   50,   52,   59,   53, 126,    0,   27,   91,   49,   59,   54,   80,    0,   27,   91,   49,   59,   54,   81,    0,  27,   91,   49,   59,   54,   82,    0,   27,   91,   49,   59,   54,   83,    0,   27,   91,  49,   53,   59,   54,  126,    0,   27,   91,   49,   55,   59,   54,  126,    0,   27,   91,  49,   56,   59,   54,  126,    0,   27,   91,   49,   57,   59,   54,  126,    0,   27,   91,  50,   48,   59,   54,  126,    0,   27,   91,   50,   49,   59,   54,  126,    0,   27,   91,  50,   51,   59,   54,  126,    0,   27,   91,   50,   52,   59,   54,  126,    0,   27,   91,  49,   59,   51,   80,    0,   27,   91,   49,   59,   51,   81,    0,   27,   91,   49,   59,  51,   82,    0,   27,   91,   49,   59,   51,   83,    0,   27,   91,   49,   53,   59,   51, 126,    0,   27,   91,   49,   55,   59,   51,  126,    0,   27,   91,   49,   56,   59,   51, 126,    0,   27,   91,   49,   57,   59,   51,  126,    0,   27,   91,   50,   48,   59,   51, 126,    0,   27,   91,   50,   49,   59,   51,  126,    0,   27,   91,   50,   51,   59,   51, 126,    0,   27,   91,   50,   52,   59,   51,  126,    0,   27,   91,   49,   59,   52,   80,   0,   27,   91,   49,   59,   52,   81,    0,   27,   91,   49,   59,   52,   82,    0,   27,  91,   49,   75,    0,   27,   91,   37,  105,   37,  100,   59,   37,  100,   82,    0,   27,  91,   54,  110,    0,   27,   91,   63,   37,   91,   59,   48,   49,   50,   51,   52,   53,  54,   55,   56,   57,   93,   99,    0,   27,   91,   99,    0,   27,   91,   51,   57,   59,  52,   57,  109,    0,   27,   93,   49,   48,   52,    7,    0,   27,   93,   52,   59,   37, 112,   49,   37,  100,   59,  114,  103,   98,   58,   37,  112,   50,   37,  123,   50,   53,  53,  125,   37,   42,   37,  123,   49,   48,   48,   48,  125,   37,   47,   37,   50,   46,  50,   88,   47,   37,  112,   51,   37,  123,   50,   53,   53,  125,   37,   42,   37,  123,  49,   48,   48,   48,  125,   37,   47,   37,   50,   46,   50,   88,   47,   37,  112,   52,  37,  123,   50,   53,   53,  125,   37,   42,   37,  123,   49,   48,   48,   48,  125,   37,  47,   37,   50,   46,   50,   88,   27,   92,    0,   27,   91,   51,  109,    0,   27,   91,  50,   51,  109,    0,   27,   91,   77,    0,   27,   91,   37,   63,   37,  112,   49,   37, 123,   56,  125,   37,   60,   37,  116,   51,   37,  112,   49,   37,  100,   37,  101,   37, 112,   49,   37,  123,   49,   54,  125,   37,   60,   37,  116,   57,   37,  112,   49,   37, 123,   56,  125,   37,   45,   37,  100,   37,  101,   51,   56,   59,   53,   59,   37,  112,  49,   37,  100,   37,   59,  109,    0,   27,   91,   37,   63,   37,  112,   49,   37,  123,  56,  125,   37,   60,   37,  116,   52,   37,  112,   49,   37,  100,   37,  101,   37,  112,  49,   37,  123,   49,   54,  125,   37,   60,   37,  116,   49,   48,   37,  112,   49,   37, 123,   56,  125,   37,   45,   37,  100,   37,  101,   52,   56,   59,   53,   59,   37,  112,  49,   37,  100,   37,   59,  109,    0
};
// Taken from Dickey ncurses terminfo.src dated 2017-04-22.
static const signed char ansi_terminfo[] = {
  26,   1,  40,   0,  23,   0,  16,   0, 125,   1,  68,   2,  97, 110, 115, 105, 124,  97, 110, 115, 105,  47, 112,  99,  45, 116, 101, 114, 109,  32,  99, 111, 109, 112,  97, 116, 105,  98, 108, 101,  32, 119, 105, 116, 104,  32,  99, 111, 108, 111, 114,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   1,   0,  80,   0,   8,   0,  24,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   8,   0,  64,   0,   3,   0,   0,   0,   4,   0,   6,   0,  -1,  -1,   8,   0,  13,   0,  20,   0,  24,   0,  28,   0,  -1,  -1,  39,   0,  56,   0,  60,   0,  -1,  -1,  64,   0,  -1,  -1,  -1,  -1,  68,   0,  -1,  -1,  72,   0,  -1,  -1,  76,   0,  80,   0,  -1,  -1,  -1,  -1,  84,   0,  90,   0,  95,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 100,   0,  -1,  -1, 105,   0, 110,   0, 115,   0, 120,   0,-127,   0,-121,   0,  -1,  -1,  -1,  -1,  -1,  -1,-113,   0,-109,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-105,   0,  -1,  -1,-101,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -99,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -95,   0, -91,   0,  -1,  -1, -87,   0,  -1,  -1,  -1,  -1,  -1,  -1, -83,   0,  -1,  -1,  -1,  -1,  -1,  -1, -79,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -75,   0,  -1,  -1, -70,   0, -61,   0, -52,   0, -43,   0, -34,   0, -25,   0, -16,   0,  -7,   0,   2,   1,  11,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  20,   1,  25,   1,  30,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  50,   1,  -1,  -1,  61,   1,  -1,  -1,  63,   1,-107,   1,  -1,  -1,-104,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-100,   1,  -1,  -1, -37,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -33,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -28,   1, -17,   1, -12,   1,   7,   2,  11,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  20,   2,  30,   2,  -1,  -1,  -1,  -1,  -1,  -1,  40,   2,  44,   2,  48,   2,  52,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  56,   2,  62,   2,  27,  91,  90,   0,   7,   0,  13,   0,  27,  91,  51, 103,   0,  27,  91,  72,  27,  91,  74,   0,  27,  91,  75,   0,  27,  91,  74,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  71,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100,  59,  37, 112,  50,  37, 100,  72,   0,  27,  91,  66,   0,  27,  91,  72,   0,  27,  91,  68,   0,  27,  91,  67,   0,  27,  91,  65,   0,  27,  91,  80,   0,  27,  91,  77,   0,  27,  91,  49,  49, 109,   0,  27,  91,  53, 109,   0,  27,  91,  49, 109,   0,  27,  91,  56, 109,   0,  27,  91,  55, 109,   0,  27,  91,  55, 109,   0,  27,  91,  52, 109,   0,  27,  91,  37, 112,  49,  37, 100,  88,   0,  27,  91,  49,  48, 109,   0,  27,  91,  48,  59,  49,  48, 109,   0,  27,  91, 109,   0,  27,  91, 109,   0,  27,  91,  76,   0,   8,   0,  27,  91,  66,   0,  27,  91,  72,   0,  27,  91,  76,   0,  27,  91,  68,   0,  27,  91,  67,   0,  27,  91,  65,   0,  13,  27,  91,  83,   0,  27,  91,  37, 112,  49,  37, 100,  80,   0,  27,  91,  37, 112,  49,  37, 100,  77,   0,  27,  91,  37, 112,  49,  37, 100,  66,   0,  27,  91,  37, 112,  49,  37, 100,  64,   0,  27,  91,  37, 112,  49,  37, 100,  83,   0,  27,  91,  37, 112,  49,  37, 100,  76,   0,  27,  91,  37, 112,  49,  37, 100,  68,   0,  27,  91,  37, 112,  49,  37, 100,  67,   0,  27,  91,  37, 112,  49,  37, 100,  84,   0,  27,  91,  37, 112,  49,  37, 100,  65,   0,  27,  91,  52, 105,   0,  27,  91,  53, 105,   0,  37, 112,  49,  37,  99,  27,  91,  37, 112,  50,  37, 123,  49, 125,  37,  45,  37, 100,  98,   0,  27,  91,  37, 105,  37, 112,  49,  37, 100, 100,   0,  10,   0,  27,  91,  48,  59,  49,  48,  37,  63,  37, 112,  49,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  50,  37, 116,  59,  52,  37,  59,  37,  63,  37, 112,  51,  37, 116,  59,  55,  37,  59,  37,  63,  37, 112,  52,  37, 116,  59,  53,  37,  59,  37,  63,  37, 112,  54,  37, 116,  59,  49,  37,  59,  37,  63,  37, 112,  55,  37, 116,  59,  56,  37,  59,  37,  63,  37, 112,  57,  37, 116,  59,  49,  49,  37,  59, 109,   0,  27,  72,   0,  27,  91,  73,   0,  43,  16,  44,  17,  45,  24,  46,  25,  48, -37,  96,   4,  97, -79, 102,  -8, 103, -15, 104, -80, 106, -39, 107, -65, 108, -38, 109, -64, 110, -59, 111, 126, 112, -60, 113, -60, 114, -60, 115,  95, 116, -61, 117, -76, 118, -63, 119, -62, 120, -77, 121, -13, 122, -14, 123, -29, 124, -40, 125,-100, 126,  -2,   0,  27,  91,  90,   0,  27,  91,  49,  75,   0,  27,  91,  37, 105,  37, 100,  59,  37, 100,  82,   0,  27,  91,  54, 110,   0,  27,  91,  63,  37,  91,  59,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  93,  99,   0,  27,  91,  99,   0,  27,  91,  51,  57,  59,  52,  57, 109,   0,  27,  91,  51,  37, 112,  49,  37, 100, 109,   0,  27,  91,  52,  37, 112,  49,  37, 100, 109,   0,  27,  40,  66,   0,  27,  41,  66,   0,  27,  42,  66,   0,  27,  43,  66,   0,  27,  91,  49,  49, 109,   0,  27,  91,  49,  48, 109,   0
};

/// Load one of the built-in terminfo entries when unibilium has failed to
/// load a terminfo record from an external database, as it does on termcap-
/// -only systems.  We do not do any fancy recognition of xterm pretenders
/// here.  An external terminfo database would not do that, and we want to
/// behave as much like an external terminfo database as possible.
unibi_term *load_builtin_terminfo(const char * term)
{
  if (terminfo_is_term_family(term, "xterm")) {
    return unibi_from_mem((const char *)xterm_256colour_terminfo,
                          sizeof xterm_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "screen")) {
    return unibi_from_mem((const char *)screen_256colour_terminfo,
                          sizeof screen_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "tmux")) {
    return unibi_from_mem((const char *)tmux_256colour_terminfo,
                          sizeof tmux_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "rxvt")) {
    return unibi_from_mem((const char *)rxvt_256colour_terminfo,
                          sizeof rxvt_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "putty")) {
    return unibi_from_mem((const char *)putty_256colour_terminfo,
                          sizeof putty_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "linux")) {
    return unibi_from_mem((const char *)linux_16colour_terminfo,
                          sizeof linux_16colour_terminfo);
  } else if (terminfo_is_term_family(term, "interix")) {
    return unibi_from_mem((const char *)interix_8colour_terminfo,
                          sizeof interix_8colour_terminfo);
  } else if (terminfo_is_term_family(term, "iterm")
             || terminfo_is_term_family(term, "iterm2")
             || terminfo_is_term_family(term, "iTerm.app")
             || terminfo_is_term_family(term, "iTerm2.app")) {
    return unibi_from_mem((const char *)iterm_256colour_terminfo,
                          sizeof iterm_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "st")) {
    return unibi_from_mem((const char *)st_256colour_terminfo,
                          sizeof st_256colour_terminfo);
  } else if (terminfo_is_term_family(term, "gnome")
             || terminfo_is_term_family(term, "vte")) {
    return unibi_from_mem((const char *)vte_256colour_terminfo,
                          sizeof vte_256colour_terminfo);
  } else {
    return unibi_from_mem((const char *)ansi_terminfo,
                          sizeof ansi_terminfo);
  }
}
