/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * UnusedVariableCustomizer.java
 *
 * Created on 30.9.2011, 13:16:20
 */
package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;

/**
 *
 * @author Ondrej Brejla <obrejla@netbeans.org>
 */
public class UnusedVariableCustomizer extends javax.swing.JPanel {
    private final UnusedVariableHint unusedVariableHint;
    private final Preferences preferences;

    public UnusedVariableCustomizer(Preferences preferences, UnusedVariableHint unusedVariableHint) {
        this.preferences = preferences;
        this.unusedVariableHint = unusedVariableHint;
        initComponents();
        checkUnusedFormalParametersCheckBox.setSelected(unusedVariableHint.checkUnusedFormalParameters(preferences));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        checkUnusedFormalParametersCheckBox = new javax.swing.JCheckBox();

        checkUnusedFormalParametersCheckBox.setMnemonic('C');
        checkUnusedFormalParametersCheckBox.setText(org.openide.util.NbBundle.getMessage(UnusedVariableCustomizer.class, "UnusedVariableCustomizer.checkUnusedFormalParametersCheckBox.text")); // NOI18N
        checkUnusedFormalParametersCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkUnusedFormalParametersCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(checkUnusedFormalParametersCheckBox)
                .addContainerGap(53, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(checkUnusedFormalParametersCheckBox)
                .addContainerGap(264, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void checkUnusedFormalParametersCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkUnusedFormalParametersCheckBoxActionPerformed
        unusedVariableHint.setCheckUnusedFormalParameters(preferences, checkUnusedFormalParametersCheckBox.isSelected());
    }//GEN-LAST:event_checkUnusedFormalParametersCheckBoxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox checkUnusedFormalParametersCheckBox;
    // End of variables declaration//GEN-END:variables
}
