<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/health/notifications/syslog/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/health/notifications/syslog/metadata.yaml"
sidebar_label: "syslog"
learn_status: "Published"
learn_rel_path: "Alerting/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# syslog


<img src="https://netdata.cloud/img/syslog.png" width="150"/>


Send notifications to Syslog using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- A working `logger` command for this to work. This is the case on pretty much every Linux system in existence, and most BSD systems.
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SYSLOG_FACILITY | Set `SYSLOG_FACILITY` to the facility used for logging, by default this value is set to `local6`. |  | True |
| DEFAULT_RECIPIENT_SYSLOG | Set `DEFAULT_RECIPIENT_SYSLOG` to the recipient you want the alert notifications to be sent to. |  | True |
| SEND_SYSLOG | Set SEND_SYSLOG to YES, make sure you have everything else configured before turning this on. |  | True |

##### DEFAULT_RECIPIENT_SYSLOG

Targets are defined as follows:

```
[[facility.level][@host[:port]]/]prefix
```

prefix defines what the log messages are prefixed with. By default, all lines are prefixed with 'netdata'.

The facility and level are the standard syslog facility and level options, for more info on them see your local logger and syslog documentation. By default, Netdata will log to the local6 facility, with a log level dependent on the type of message (crit for CRITICAL, warning for WARNING, and info for everything else).

You can configure sending directly to remote log servers by specifying a host (and optionally a port). However, this has a somewhat high overhead, so it is much preferred to use your local syslog daemon to handle the forwarding of messages to remote systems (pretty much all of them allow at least simple forwarding, and most of the really popular ones support complex queueing and routing of messages to remote log servers).

You can define multiple recipients like this: daemon.notice@loghost:514/netdata daemon.notice@loghost2:514/netdata.
All roles will default to this variable if left unconfigured.


##### SEND_SYSLOG 

You can then have different recipients per role, by editing DEFAULT_RECIPIENT_SYSLOG with the recipient you want, in the following entries at the bottom of the same file:

```conf
role_recipients_syslog[sysadmin]="daemon.notice@loghost1:514/netdata"
role_recipients_syslog[domainadmin]="daemon.notice@loghost2:514/netdata"
role_recipients_syslog[dba]="daemon.notice@loghost3:514/netdata"
role_recipients_syslog[webmaster]="daemon.notice@loghost4:514/netdata"
role_recipients_syslog[proxyadmin]="daemon.notice@loghost5:514/netdata"
role_recipients_syslog[sitemgr]="daemon.notice@loghost6:514/netdata"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# syslog notifications

SEND_SYSLOG="YES"
SYSLOG_FACILITY='local6'
DEFAULT_RECIPIENT_SYSLOG="daemon.notice@loghost6:514/netdata"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


