# Questions regarding how to use GraphQL

We want to keep signal strong in the GitHub issue tracker – to make sure that it remains the best place to track bugs and features that affect development.

If you have a question on how to use GraphQL, please [post it to Stack Overflow](https://stackoverflow.com/questions/ask?tags=graphql) with the tag [#graphql](https://stackoverflow.com/questions/tagged/graphql).

Please do not post general questions directly as GitHub issues. They may sit for weeks unanswered, or may be spontaneously closed without answer.

# Reporting issues with GraphQL.js

Before filing a new issue, make sure an issue for your problem doesn't already exist.

The best way to get a bug fixed is to provide a _pull request_ with a simplified failing test case (or better yet, include a fix).

# Feature requests

GraphQL.js is a reference implementation of the [GraphQL specification](https://github.com/graphql/graphql-spec). To discuss new features which are not GraphQL.js specific and fundamentally change the way GraphQL works, open an issue against the specification.

# Security bugs

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe disclosure of security bugs. With that in mind, please do not file public issues; go through the process outlined on that page.
