if (typeof T === 'undefined') require('../setup');

T('log10', function () {

  function t(n, expected, sd, rm) {
    Decimal.precision = sd;
    Decimal.rounding = rm;
    T.assertEqual(expected, Decimal.log10(n).valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: 0,
    toExpPos: 0,
    minE: -9e15,
    maxE: 9e15
  });

  t('4841183675443663188762.78', '2.16849516e+1', 9, 0);
  t('2.2001084261754258861227E-824263894', '-8.242638936575559156644572542921e+8', 31, 6);
  t('9.841678323183423382979E+889', '8.8999306917e+2', 11, 2);
  t('6.674865349047819300515860303037383179383821E-556564097058', '-6e+11', 1, 4);
  t('8.45466498447465675136763E+70601305204', '7.07e+10', 3, 2);
  t('4.0697767991474535745859451E+8734161', '8.7341616095705916437228490323670178068211817e+6', 44, 2);
  t('6.70979951730012416235067887E-4547', '-4.546173290455960817819339e+3', 25, 5);
  t('1.961351051236741863413961315199797E+4394416', '4.3944162925e+6', 11, 1);
  t('1.20350E+4555', '4.55508044609461104879595186822027e+3', 33, 1);
  t('5.343396356119981189485859467758323594750088722349E+24892595', '2e+7', 1, 5);
  t('2.7775691E+2645806266', '2.64580626644366e+9', 15, 5);
  t('1.764240941317483253710000989961978299234E+5939', '5.93924655789618074686663713956005233457194e+3', 42, 4);
  t('8.68143916033713750663285740502710E+89575', '8.95759385917261e+4', 15, 5);
  t('2.0184251149898158170597E-39207177567322', '-3.9207177567321694987359e+13', 23, 0);
  t('7.8630374961E+539873632527965', '5.39873632527965895590346671032e+14', 30, 0);
  t('1.770739036205380713465840899E+522651', '5.226512481545614797481e+5', 22, 5);
  t('56.141270516453102320117316389420550463886324330', '1.74928223679933121812e+0', 21, 1);
  t('2.6E+5789', '5.78941497334797081796442024405e+3', 30, 6);
  t('8.407507657913886653E-27559', '-2.755807533272843934770788577111161e+4', 34, 2);
  t('4.1537022577487997501227235564273504628803975515504335733E+8622517869456', '8.622517869456618435362577e+12', 25, 4);
  t('3.726614237233359549085256054317096792396039592E+7200803438362342', '7.20080343836234257131444e+15', 24, 6);
  t('3.07938388321764455968132812427213516E+38172329267940', '3.817232926794048846383244686011975e+13', 34, 5);
  t('8.6068240435353592489E+94696427410', '9.469642741e+10', 10, 5);
  t('9.37151210825471283E-865158860842', '-8.65158860841028190329358923938336e+11', 33, 1);
  t('34073473340739909295181032371.558228583698065018839103', '2.853241641e+1', 10, 0);
  t('2.28321371080052769522193640E+397673232597', '3.976732325973585465637362e+11', 26, 6);
  t('5.53931220752051773202347E+2499', '2.499743455843605290956496e+3', 25, 3);
  t('5.4924555890498123253396556014992712521439747540053861140793E+504', '5.047397665539842493968484323e+2', 28, 4);
  t('4.914452734123226135400656595986723583025E-1514546', '-1.514545308524837502946553307e+6', 28, 4);
  t('4.215555113580235490775E+55076305', '5.507630562485e+7', 13, 4);
  t('1.3930997480622E-57275499306', '-5.7e+10', 2, 6);
  t('85038.039893969528357085115812100515349', '4.929613241248970252641e+0', 22, 5);
  t('7.047729155038798766423401020155837037817938179206464104E+488246', '4.8824684804920574277260014554145031e+5', 35, 3);
  t('3.88173E+2768', '2.7685890253240487e+3', 17, 1);
  t('6.33149E+1646322918853513', '1.646322918854e+15', 13, 5);
  t('6.43213140539E+60', '6.080835490826104516024510232434e+1', 31, 6);
  t('5.050356774201666667327888987E+215326920301064', '2.1532692e+14', 8, 6);
  t('2739258.451754141451285499174145021701678302438665131045', '6.4376330103e+0', 12, 5);
  t('1.7192003502495036108123878166266976088E+7685', '7.685235326490961406452549530538800289e+3', 37, 6);
  t('9.6E+85774181', '8.57741819822712e+7', 15, 5);
  t('1.87124860546679312974E+3052798657448', '3.052798658e+12', 10, 0);
  t('3.083315086E-33', '-3.251098209216645436858e+1', 22, 4);
  t('7.2156825787920272800526474440273278298991942831883189391E+61531910219648', '6.153191021964885827742013e+13', 25, 1);
  t('8.468E-3306315551035784', '-3.306315551e+15', 10, 2);
  t('4.69070189E+72479', '7.24796712378329382129172143247016859e+4', 36, 1);
  t('3.35742E+835737', '8.35737526005673173223374107868535147886e+5', 39, 5);
  t('3.45402661747687024737712705E+1600722944676', '1.60072294467653832568001163266841e+12', 34, 1);
  t('4.7922316977869430764493052417197764722676671E+2312846442', '2.3128464426805378074275316244e+9', 29, 6);
  t('9.851193152845829667E+66954099', '6.69541e+7', 9, 0);
  t('1.1854901245488693749594005242978061319893665204E+36534622', '3.6e+7', 2, 1);
  t('2.36333459535347419E+18828941140', '1.882894114037352521237663e+10', 25, 0);
  t('3.85857292671500073837429E+902683316', '9.026833165864267128e+8', 19, 6);
  t('9.6016490111491709821226489279E+51808023', '5.1808e+7', 6, 4);
  t('5.17351178517133458351944997054985443108308070481852782E+72447629057', '7.2447629057713785442739598355e+10', 29, 4);
  t('1.110105859069230266011E-30284901880', '-3.0284902e+10', 8, 5);
  t('9.048827409E+7267517760358', '7.267517760358956592304863221501460291e+12', 39, 1);
  t('1.088912795176892276835248776534961914045425466464600675903E+31952', '3.1952036994e+4', 11, 2);
  t('970.687987526534321426239801143994613178912', '2.9870796551693774977726248e+0', 26, 0);
  t('1.96809E+340418195', '3.4041819529404495466933301447841666e+8', 35, 0);
  t('6.86872871627264284462705542579681663626E-9', '-8.1631e+0', 5, 2);
  t('9.67348055315179509539189364657869462004005689059E-35611', '-3.561001441723707953133e+4', 22, 5);
  t('1.8744707925587479720553595210808247818401843056803276529372E+810679', '8.1067927e+5', 8, 1);
  t('8.942329972495772937474882956276E-40155184557896', '-4.015518455789504854931e+13', 22, 5);
  t('5.012575871519977416116054585544633184998370041087525008E+73424', '7.34247e+4', 6, 5);
  t('7.683518340090388031524844343382673720835893274744999E+2054546124012473', '2.05454612401247388556013e+15', 24, 5);
  t('3.815810146227322026775444113884081509750E+36773121563', '3.67731215635815867584594686290771255e+10', 36, 5);
  t('7.4861378005232013255069E+1485805', '1.485806e+6', 7, 0);
  t('9.07761360146935072886298392797676264735146941104416705855E+5852', '5.85295797169258163209871826529944651947e+3', 39, 4);
  t('3.4888777700553647252456603687651697829004766607593E+790861779850044', '7.9086177985004454268575e+14', 23, 4);
  t('7.6776640508986078666E-160824', '-1.6e+5', 3, 1);
  t('6.0310855923559920575167841704099767E+220096231795', '2.20096231796e+11', 12, 0);
  t('5.354591927609993818150377979653E+206804676737', '2.06804676737728726e+11', 18, 1);
  t('6.635487235E+6294451574004', '6.29445157400482187e+12', 18, 3);
  t('8.8584E-7247204157652366', '-7.2472041576523650526447131e+15', 27, 3);
  t('3.565918492306569022483822438092572617805207953592E+730255', '7.302555521714121e+5', 16, 4);
  t('354539328516823449672.983298997050733493', '2.054966441782787142944577776331757526e+1', 37, 4);
  t('5.1031831539356080897895506E-82341', '-8.2340292158844500189385823717987586e+4', 35, 0);
  t('9.3648851529395696724E+3631', '3.63197150245573683604e+3', 21, 6);
  t('9.353521E+1822', '1.822970975e+3', 10, 5);
  t('7.93249517949211819801840221693753800779017848E-53570', '-5.356910059018314442492287309e+4', 28, 3);
  t('51.59851352524098568099996391240738929', '1.712637190443409949195148634e+0', 28, 5);
  t('8.69810649237836206E+4576415322', '4.57641532293942472050213e+9', 24, 1);
  t('5.743720268213722512570210325542067E+58', '5.8759193280654602219732387e+1', 26, 3);
  t('8.619379022453270498382221769546056490709529450344410959315E+47788560', '4.77885609354759784887019304047e+7', 30, 5);
  t('6.544820735E+43543', '4.35438158977555672160892806801649648482e+4', 39, 6);
  t('9.7140458707335387296463547584212801920234541874110852E+56136', '5.613699e+4', 7, 0);
  t('670.08557647535', '2.8261302698e+0', 11, 1);
  t('8.3343821492312863357729036128803472E+20716943608421', '2.0716943609e+13', 11, 2);
  t('8.0445178773508301187593293762052E-5077691', '-5.077690094499978846538805108623135e+6', 34, 3);
  t('22.767730836345951349056967', '1.3573198e+0', 8, 2);
  t('7.457764361860907275E+83607531272', '8.360753127287260865712126e+10', 25, 6);
  t('3.415842397810612774258963557343915245829E-783248777', '-7.8324877646650217526059645247e+8', 29, 5);
  t('6.781552710927048827039026094701379639485822363E-63935527', '-6.39355261686708582592412650368413182e+7', 36, 5);
  t('6.18215839966859296918377E-95603', '-9.560220885987160841432001e+4', 25, 1);
  t('9.4568E-890882', '-8.90881024255795675e+5', 18, 5);
  t('5.1258099656456511679058622861734211977997669237E-5298117838', '-5.298e+9', 4, 1);
  t('6.29591891528059956655696230115941216487334752792035E-1099146', '-1.0991452009408738626139726375999e+6', 32, 3);
  t('8.0754743E-772876752955', '-7.7287675295409283196066e+11', 23, 0);
  t('1.469473602473045923603275116E-3456356954867', '-3.4563569548668328382111587476011e+12', 34, 6);
  t('5.275444573067300813303017433E+1246343974825', '1.246343974826e+12', 13, 0);
  t('9.357019981170384806302965944044067572833526212960677676185E+919738937', '9.197389e+8', 7, 6);
  t('3.9438932490723162010961026802042639423318395E+81451', '8.1451595925151206732965697738591566e+4', 35, 6);
  t('8.6846426025687648324E+5885', '5.886e+3', 5, 0);
  t('5.9725023280777779427848795005502784720E+15955137', '1.59551377761563277e+7', 18, 6);
  t('4.9108147887698410693495984791291047177096873731080442999E+256', '2.566911535550373155e+2', 19, 4);
  t('7.7891782748328973413016239994909833278529860E+5147735', '5.14773589149164386906993465073054e+6', 33, 6);
  t('1.3446738004511849218508667329449356E-104', '-1.0387e+2', 5, 6);
  t('9.4585604116535644814652908019807413769068321E+8657106925648', '8.6571069e+12', 8, 3);
  t('473796.95276', '5.675592263217112e+0', 17, 2);
  t('6.7975863449656604442210773071454621832E+911843', '9e+5', 1, 6);
  t('3.246E-892605', '-8.92604488651484509786930611884958125035e+5', 39, 0);
  t('7.95794039837E+53', '5.3900800682139352423105080345e+1', 29, 6);
  t('5.678427235419145307694573911035564508172906E+947452164', '9.474521647542280650134995059521995e+8', 34, 1);
  t('8.0029879722391808789882801725596316284E+390572713525', '3.905727135259032e+11', 16, 3);
  t('5.9907384197073313096317126931E+438', '4.388e+2', 4, 0);
  t('9.780224646978402584108429856691E-991154968270', '-9.9115496826900965116956591580413645e+11', 35, 0);
  t('4.0789430894606339087011E-68068516', '-6.806851538945235403706815e+7', 25, 4);
  t('6.27212568421917649954621498988165460E+964956854808', '9.64956854808797414752389e+11', 24, 3);
  t('8.1285688633483981E+10047259786', '1.004725978691001408932568816558895806e+10', 37, 6);
  t('3.1728152468829356912309147407245214539710141133899042E+1655257278', '1.655257278502e+9', 13, 0);
  t('9.176094625036158762929748341685687808135628065919022704611E+754162756635', '7.54162756635962657883415352047953e+11', 34, 6);
  t('1.7913862265763242730616208060249388655022492727773301E-239576700616', '-2.3958e+11', 5, 5);
  t('8.75596177370E+15252741413', '1.525274141394230385688088809408546e+10', 34, 5);
  t('7.484860784482E+8186', '8.18687418372e+3', 12, 1);
  t('7.4550422084407536881639416021211E+31334619524362', '3.2e+13', 2, 0);
  t('338.0180791974408458407648664273', '2.52893992952530145949164e+0', 24, 1);
  t('111.522870347581464280157552128257477754581', '2.047363938659902688627435e+0', 25, 5);
  t('8.7234E+6747953961417', '6.747e+12', 4, 3);
  t('5.078468711341770084967E+877358148263834', '8.7735814826383470573278108977878e+14', 32, 2);
  t('2.341942200530809328432361125802E+11440534189151', '1.144053418915136957617241854576e+13', 31, 0);
  t('3.39486879133784644485267648691675642751667E+179533', '1.79533530823e+5', 12, 4);
  t('8.92409276216985731888299548546727483294336E-906957612', '-9.0695761104943592405728109779e+8', 29, 2);
  t('6.1439191715203256047657562390017034647E+7017', '7.01778845e+3', 9, 6);
  t('0.0607565815281965620', '-1.21640666972047895359738631018593e+0', 33, 1);
  t('1.26909860997369767419453053919499402281899674939E+90874', '9.08741034953684332361358740036169927e+4', 36, 4);
  t('8.0331252127E+293887', '2.9388790488453638465032e+5', 23, 6);
  t('2.30551730283257381646749362695831153232E+690979756252091', '6.9097975e+14', 8, 1);
  t('4.834354800443539089821414753900904180773116496518816E+406287936', '4.062879367e+8', 10, 2);
  t('9.78143205772408908E+8880', '8.8809904e+3', 9, 3);
  t('7.20267097210042335643600516492543902753411809195260386415528E-843', '-8.421425064239384218021880814198309397e+2', 37, 6);
  t('5E+8794086216615750', '8.794086216615750698970005e+15', 25, 0);
  t('2.2230867570633275409316194970723911385E+42569127', '4.25691e+7', 6, 5);
  t('4.05179770267110143930997262E+6702495011458367', '6.702495e+15', 8, 6);
  t('8.8769455861184153541120093E+14381620996623', '1.438162099662394826355775109194182e+13', 34, 1);
  t('5.55E+67416654', '6.741665474429298312268e+7', 22, 0);
  t('9.936193379889E+9340', '9.340997220035227980491424693376424e+3', 34, 4);
  t('1.6293380311554057252084909989087523183E-629443289410211', '-6.294432894102107879888052949467041124e+14', 37, 1);
  t('6.535720212535925818263E-6016865', '-6.016864184706547778054995494541617498e+6', 37, 5);
  t('8.26030664595E+27993', '2.8e+4', 2, 4);
  t('8.58844737E-64797968909', '-6.47979689081e+10', 12, 6);
  t('2.89074766828843309E+80683', '8.068346e+4', 7, 4);
  t('5.914787661096986461920174515416305183764410E-229133', '-2.2913222806084178315871148029698774e+5', 35, 4);
  t('6.611970244E-8755011013', '-8.756e+9', 4, 3);
  t('4.7499572E+9079499490292', '9.07949949029267668969638538e+12', 27, 5);
  t('6E+89592077', '8.959207778e+7', 10, 6);
  t('2.8939846181700349595255006347368997997E+245588275', '2.455882754615e+8', 13, 2);
  t('9.72535836507884579605194672928453281902058875E+961918318165', '9.619183181659879056134e+11', 22, 1);
  t('1.802571230724667168480756934002949337067746121E+42330194', '4.2330194255892435388381046734221557465e+7', 38, 2);
  t('1.291996644845554714675888790E+329589440762', '3.295894408e+11', 10, 4);
  t('1.057909734340004695619340250E+391253093', '3.91253094e+8', 9, 2);
  t('8.9822369527734239294875384027479645330225153967804276E-700117169572369', '-7.001171695723680466155e+14', 22, 0);
  t('7.45867503089770208658991644494696036321625401664926340E+3178562323202', '3.1785623233e+12', 11, 0);
  t('9.347942753E+9361211', '9.3612119707160440997000626e+6', 26, 2);
  t('1.21145320194702852291842307817094E+1899683', '1.89968308330664213946e+6', 21, 4);
  t('4.46661546613826630813244418390131151141E-623', '-6.22350021434616288e+2', 18, 5);
  t('1.4E+9', '9.14612803567823802592596e+0', 24, 2);
  t('4.5E+97105311', '9.71e+7', 3, 3);
  t('4.201530151746487591796293480191397700881554324272425E+723480211317860', '7.23480211317860623407484e+14', 24, 3);
  t('1.762216E-864', '-8.63753940859908806915202533635e+2', 30, 2);
  t('8.642227400751456E+6087945602262', '6.0879456022629366256e+12', 20, 1);
  t('6.523314129677137548107192190002930715248594495481671162E+598', '5.988144682924425501602464837799e+2', 31, 6);
  t('2.2403991884402140E+24395579910347', '2.44e+13', 3, 6);
  t('1.6557366956033476E+70057240', '7.0057240218991274031917e+7', 23, 6);
  t('9.9343328233987582609641213169601E+15633099572', '1.56330995729971387057e+10', 21, 1);
  t('7.68263067382226322729272701061395977949395460570024940310836E+10175', '1.0175885509955903658e+4', 20, 2);
  t('8.21658797619717429167944100449766461100777451E+167541', '1.6754191469150966433790137774168e+5', 32, 4);
  t('8.274172700943149949248680999419886629978E+55223547', '5.5223547917724581375045860432e+7', 29, 3);
  t('4.459590759E+2120225', '2.12022565e+6', 9, 5);
  t('2119293200287310544361006449292.097790087086884621200104', '3.03261910447042660599268663431444993e+1', 36, 6);
  t('9.648537852327574E+137078236442', '1.37078236442984461504973030348183e+11', 33, 3);
  t('5.7903459194922814675456E-9701270005', '-9.701270004237295490428153e+9', 25, 4);
  t('7.342558758386103195254009211254457570228171605E-4943687121', '-4.9436871201341525694e+9', 20, 0);
  t('2.282545429409039868294662520556324477527757977536E+6695763172262261', '6.69576317226226135841943003780236539e+15', 36, 4);
  t('8.4985445E+5296565596620', '5.2965655966209293445529e+12', 23, 2);
  t('6.66867820057434922039563598610448084365023382055459E+7882014', '7.88201482403976089e+6', 18, 4);
  t('7.6622494809303404482041186857493199308751059E-70020501626429', '-7e+13', 2, 5);
  t('7.98673156225E-75063484', '-7.506348309763091216108166285e+7', 28, 0);
  t('5.232969470376787870655528179123539518571846237E+95896', '9.589671875e+4', 10, 5);
  t('1.239584E+881548295', '8.81548295093275961924e+8', 21, 2);
  t('1.8882461259780200932716727517429440850023951693614993E-29676693042490', '-3e+13', 2, 3);
  t('3.5413691828218E-9', '-8.4508287962848912e+0', 17, 6);
  t('9.58573533146370355175749633935031597475E+32021008', '3.2021008981625433661436e+7', 23, 6);
  t('792761.93385093612011907717194655264284481632519605064178', '5.89914278840534e+0', 15, 0);
  t('6.3955989097974232284047639485531180916376215E-57323114414217', '-5.7323114414216194118780185915422e+13', 32, 3);
  t('6.9019088922329566961649111017E-632349784', '-6.323e+8', 4, 4);
  t('4.62685910E-480838608091', '-4.80838608090334713725705251106331291e+11', 37, 6);
  t('8.311855917119072957E+7154', '7e+3', 1, 6);
  t('4.8159504049967133953919395504883957993255351483817314E+405363840', '4.0536384068268200587701e+8', 23, 3);
  t('6.9580783101209078140E-48581', '-4.85801575106877669287286809338773712e+4', 36, 6);
  t('9744128587282332519285270430948194876663392379.213638707444', '4.598874300644e+1', 13, 6);
  t('2.766501232677186977E+737011644', '7.37011644441930868059942073866556713753e+8', 39, 1);
  t('2.6900544536085441652753777658456769593839030E-446077922855484', '-4.4607792286e+14', 11, 3);
  t('9.0732956736279418804179350529593096E+5862634', '5.86263495776506356e+6', 18, 1);
  t('2.80882768445289586E+559928111119', '5.59928111119448525096985e+11', 24, 0);
  t('7.3788369345555762835103181872689688744053494426218E+6730765357554464', '6.730765357554464867987912946224e+15', 31, 6);
  t('2.959460383657043931925109388039896307947059E+217118802', '2.171188024712125307332e+8', 22, 5);
  t('3.956189822575E+31473', '3.147359727712138e+4', 16, 6);
  t('5.66115558664E+656037', '6.5603775290509084832386e+5', 24, 1);
  t('2.22832507208902004302625237287424619121911957244944985098E+965119341084500', '9.651193410845003e+14', 16, 6);
  t('4.924937211894443794211731987696726309241E+961', '9.6169240069804e+2', 14, 1);
  t('6.74532192538022727744623280343816817441519585193095942574196E+274000599011', '2.74000599011829002681522e+11', 24, 2);
  t('7.209E+208438', '2.0843885787502552356253390365498272e+5', 35, 1);
  t('3.66697296539827857449270491425623117403827284683586725756528E-2693946', '-2.6939454356922918e+6', 17, 1);
  t('9.66672E+117', '1.1798527913928017009e+2', 20, 0);
  t('6.35397593596472700403828628827329751167708023099200772E+42960', '4.296080304557e+4', 13, 6);
  t('6.9268983421699860434226567468545468532202E-50369901213127', '-5.0369901213126159461e+13', 20, 1);
  t('2.7752758404982212331606452073789068022122859E+572216430298383', '5.7221643029838344330615504524e+14', 29, 3);
  t('5.9258659730795671523367757357164829426084718E-5779', '-5.8e+3', 2, 5);
  t('8.651770318575700584685873853475430890180871856E+1831200086', '1.83120008693710498156002691964e+9', 30, 6);
  t('7.811677E+59875', '6e+4', 2, 4);
  t('8.069294827273051E+60413580', '6.0413580906835583544206068198867779449e+7', 38, 1);
  t('96665.84467385029724052359044402479905118965902303', '4.9852730501952027669068e+0', 23, 4);
  t('5.6731273082624732574896505617039E-747376', '-7.4737524617747050624329252258e+5', 29, 6);
  t('3.74224118190321841992531573E+30710', '3.07105731317737022950403907165374789e+4', 36, 1);
  t('1.880930049536958430407325630040606122564969559449375102711E+6994552', '6.9e+6', 2, 1);
  t('2.6006760504974637046746E-584358746865379', '-5.843587468653785849e+14', 19, 2);
  t('4.58411E+47', '4.8e+1', 2, 4);
  t('4.8472940870263640617671667416887043990955652178E+722180', '7.221806854993693201e+5', 19, 5);
  t('4.41132498237110029E+49926409', '4.992640964456905343733638300111372e+7', 34, 4);
  t('5.955180538536509606243984685694900793228258492011E+249149478', '2.5e+8', 2, 5);
  t('2.55444785662336E-338393366512546', '-3.3839336651254559270295804802e+14', 30, 1);
  t('6.451901656123260006240045354922178833320449E+109909171528', '1.0990917152880968773898219e+11', 29, 3);
  t('1.710514210188E-797', '-8e+2', 1, 3);
  t('8.1009E-1730350', '-1.73e+6', 3, 4);
  t('6.4931410787499275369834890711938163837E+89747838', '8.97478388124548390435534618704031653e+7', 36, 2);
  t('6.3496571795452363841138351936963590345581E-6935067975204336', '-6.935068e+15', 8, 4);
  t('1.913624275E+7985454456610', '7.99e+12', 3, 5);
  t('4.7516451294602805754081622774048795977503526E+296', '2.966768439984562e+2', 16, 1);
  t('7.2727487252E+78582919900076', '7.9e+13', 2, 5);
  t('9.9865454795458494E+1089656', '1.089656999415284159183e+6', 23, 4);
  t('4.2018E-11544', '-1.1543377e+4', 8, 0);
  t('5973677.8938888646013555597779580024611356600086806925613', '6.776242e+0', 7, 5);
  t('1.785067221240412565271613355740530371935437309566266992884E+9012', '9.012251654575218e+3', 16, 5);
  t('6.77262870644E+6524865', '6.525e+6', 4, 5);
  t('5.401E+511754', '5.117547324742e+5', 13, 5);
  t('4.350575000774444710047916754464678E+6459269855', '6.45927e+9', 6, 0);
  t('2.32195277540589382014822154598157053567762490148686198057E+608316438358', '6.08316438358365853383e+11', 21, 0);
  t('3.572760520633713318131179974412938E+6806', '6.81e+3', 3, 4);
  t('8.610880702359934210E-170943074757322', '-1.7094307475732106495242757e+14', 26, 0);
  t('8.1124646679657343581775011534919850721271601470915952884E+2753677807', '2.7537e+9', 5, 0);
  t('7.657060557417E+7004', '7.00488406208181354696172876236543438249e+3', 39, 1);
  t('1.094879339057202065200575548271891233128089058656211E+5216487789997', '5e+12', 1, 1);
  t('7.01458738335172723967235286302265082E-92570843', '-9.25708421539978702e+7', 18, 1);
  t('2.25E+533', '5e+2', 1, 1);
  t('4.628672919927535486155536E+4800249379', '4.8002493796654564929259595102215430412e+9', 38, 5);
  t('1.9732236825240345467809524550476270818E+9940971', '9.94097e+6', 6, 4);
  t('0.000855603314909656837', '-3.06772754148692485696222290491457355e+0', 36, 3);
  t('8.4439743851E+7039', '7.0399265469072e+3', 15, 2);
  t('1.965407355492395E+2641', '2.641293452577056282791097210449374e+3', 35, 3);
  t('8.77139E+43903', '4.3903943068421358703475e+4', 23, 4);
  t('5.6313680606869681980405411323367891136242806344419E+673496449331', '6.73496449331750613913329559541527910906e+11', 39, 0);
  t('3.70306748317210360217571459282646861523E+114549656', '2e+8', 1, 2);
  t('7.9114974323311922708214149955178938396453680456512556208E+337714', '3.37714898258691468596e+5', 21, 0);
  t('4.5241008127108799713242E+92522989', '9.252298e+7', 7, 1);
  t('6.8084805182416E+4122762480376', '4.122762480376833050199111848192603042e+12', 37, 1);
  t('7.3147485894705860825228409814E+6295', '6.2958641994038609222771252895147509e+3', 35, 6);
  t('6.46562047642498844954E+863581336896', '8.6358133689681061020849827277507e+11', 32, 1);
  t('6.9164633640051450512951E+55676', '5.5676839884080855434e+4', 20, 5);
  t('6.0917452602066E+92256', '9.22567847417340599791691820043e+4', 30, 2);
  t('0.001510148291305447959465032592', '-2.82098040440647561863609e+0', 25, 2);
  t('6.431896480622181048622277E-61873878791340', '-6.187387879133919166e+13', 19, 2);
  t('6.6912701039557846323852298837E+6543285327637841', '6.5432853276378418255085612e+15', 26, 3);
  t('4.630341805517258573405153915987E+84165036', '8.4165036665613051227654781093827e+7', 32, 5);
  t('6.6767502E-769588258', '-7.695882571754348719005572207e+8', 28, 5);
  t('5.3660664E+9937317733853', '1e+13', 1, 4);
  t('7.1104058881899289022794101576230407E+2931553762', '2.93155376286e+9', 12, 2);
  t('9.0851565025843092256354899724035225E-574', '-5.7304e+2', 5, 1);
  t('8.3224026230079773841863189513325893044219334182578E+9379449140735', '9.37944914073592024e+12', 18, 1);
  t('7.3148E+964538455935', '9.64e+11', 3, 3);
  t('0.088925797553215699187518', '-1.050972231046232305698200949769295607e+0', 37, 4);
  t('3.344526235079323928990625352E+118763', '1.18763524334606987858365877234611e+5', 33, 3);
  t('5.25123229692563277522479E+17940635681', '1.79406356817202612304450305496852e+10', 33, 0);
  t('3.760845196952513780E+979276087629549', '9.7927608763e+14', 12, 4);
  t('3.558E+527', '5.2755120594375e+2', 14, 4);
  t('9.6965442455388605748343160757809944360E-86', '-8.5013384e+1', 8, 3);
  t('4.105569485528819786620782603033703933E+88797225395276', '8.879722539527661337340683150145e+13', 31, 4);
  t('1.91555944621E+813', '8.132822956341370931533119992804509e+2', 35, 6);
  t('9.68951676654401806E+253127258067', '3e+11', 1, 4);
  t('8E+5', '5.903e+0', 4, 4);
  t('1836.634244419306349744257939937833631670519823', '3.26402267e+0', 9, 1);
  t('4397784391509474398016375655554633061123389089.8634817139642', '4.564323393355751008e+1', 19, 5);
  t('9.58322571E+731476802160807', '7.31476802160807981511717e+14', 25, 4);
  t('7.01201371678194158217581603456218E+6878052429', '6.87805243e+9', 10, 4);
  t('3.041163573728602511700770124120098256116370007710598988E+411', '4.1148e+2', 5, 1);
  t('1.967922198E+61733161', '6.1733161294007924559145088394728e+7', 32, 6);
  t('425.6382600813202', '2.62904065921972255e+0', 18, 1);
  t('8.0822478421743991E+68533', '6.853390753216395349522e+4', 22, 5);
  t('2.1228162931375958562519008684361087507E+8090388', '8.09038832691241228719325e+6', 24, 6);
  t('203110.992750698269353255', '5.30773342887884e+0', 15, 2);
  t('7.48005636875895E+2937', '2.9378e+3', 5, 3);
  t('4.16308890258537660817667952193346640552129139713E+86307216', '8.63072166194156853e+7', 18, 6);
  t('1.837949274E+6774278101554978', '6.7742782e+15', 8, 0);
  t('8.79134871951167023906325966695773979628115E+2294220087861', '2.294220087861944056e+12', 19, 6);
  t('8.48392244778725902939519101308465866886622E+87', '8.792859668994212084008e+1', 22, 3);
  t('3.277969751826558179529913334137335285368628126773876030E+870', '8.7051560494170689524582890328993518e+2', 35, 4);
  t('9270.9466671234823512338', '3.967e+0', 4, 3);
  t('2.05000850836E+7932', '7.93231175566355e+3', 15, 1);
  t('2.8771E+457370240210', '4.573702e+11', 7, 3);
  t('1.0401380741318923836486E+963745538', '9.6374553801709099396546639851e+8', 29, 3);
  t('7.565084298622151223299800630215724758148082623284064089163E-7708241360680', '-7.7082413606791211862e+12', 20, 6);
  t('2.202424317826404394525541194184509298850156534E+6682', '6.68234290099362661e+3', 18, 6);
  t('2.301525704833612235599549077113939656987426316438237947E+352351588647043', '3.52351588647043362015829721e+14', 27, 6);
  t('2.3E+69', '6.936172783601759287886777711225e+1', 31, 4);
  t('0.0023724981953987595', '-2.624794109239e+0', 13, 4);
  t('1.636856E+832', '8.32214010474673898960782798539167823293e+2', 39, 0);
  t('6.023E-92998', '-9.29972e+4', 6, 4);
  t('5.750066890974305701482238212778089E-213689', '-2.13688240327103e+5', 15, 6);
  t('6E+620838161', '6.2083816177815126e+8', 17, 2);
  t('4.1964793930094E+1235150489006', '1.2351504890066228850948328e+12', 26, 5);
  t('5.65102392645855754045555512257227119E+747964', '7.5e+5', 2, 0);
  t('3.747046938286996368687346559251063750074E+55104332582', '5.5e+10', 2, 4);
  t('7.316024918931619975E+28', '2.886427517605e+1', 13, 2);
  t('7.188182778879818939E-84858665754', '-8.48586658e+10', 9, 6);
  t('6.46323461493736556247481975257051362291072091E+357481253', '3.58e+8', 3, 0);
  t('7.2362803608381682631379135460041040392E+285046289079184', '2.8504628907918485951538472263279356188e+14', 38, 5);
  t('8.82583049866E+5498885147', '5.4988851479457555825035e+9', 23, 6);
  t('8.262733965223247826311588406300E+398526734255312', '3.9852673425532e+14', 14, 0);
  t('7.9724498208761428598305797621108619E+9680', '9.680901591794446e+3', 16, 5);
  t('5.358807684948694056397783740398961810436E+135', '1.3572906817151193724055824197500226e+2', 35, 5);
  t('7.50452481987293059567804821632785100731441200223007722872E+2647', '2.647875323198293e+3', 16, 5);
  t('1.861461E+9765741622802', '9.76574162280226985394162224667547e+12', 33, 2);
  t('5.3024E+18854', '1.88547244724867392427181951867e+4', 31, 2);
  t('3.83567154703630127817968E+800', '8.00583841410955099993108474050708348e+2', 36, 5);
  t('6.058225248967488175416955447960471E+45', '4.578234541666356245010242759860926972e+1', 37, 5);
  t('5.583839582E+116575', '1.1657574693293295805902330044e+5', 29, 4);
  t('5.45305449487944883848104927757569550811171661855161528497E+95598', '9.55987366398378128398982292162333013618e+4', 39, 1);
  t('7.2E-1565', '-1.5641426675035687315397687275093163e+3', 35, 3);
  t('5.688412098470009264410177753102487670040610414E+588291', '5.8829175499105143628966275381434335459e+5', 38, 3);
  t('4.98687953451750846362292968828642954842916767E-8976294073461431', '-8.97629407346143030217112268322195e+15', 33, 3);
  t('6.4059724761943175459267148700508435280570604843E+9068767037', '9.07e+9', 3, 2);
  t('1.2558188143253810752E+5309', '5.3090989269852492340203207e+3', 26, 0);
  t('2.9500993033018210931127104257014011E+6087', '6.0874e+3', 5, 3);
  t('6.3695895298144359051982808553323123578E+67347444222', '6.7347444222804111446357e+10', 23, 1);
  t('1.6970240931142969870064278143954369E+5862362', '5.8623622296880081587565662032e+6', 29, 0);
  t('7.269866317942465252993451469798183786315582691680988137666E+6170368171023', '6.17036817102386152642490116878e+12', 30, 0);
  t('5.010931460057255056843380556922E+952799', '9.527997e+5', 8, 6);
  t('8.133134838508903211104693919333E+981997020692', '9.8199702069291025798e+11', 20, 0);
  t('1.70776601623E+84', '8.42325e+1', 6, 0);
  t('11.60521553826555618167636122646191312', '1.06465321081607303039810006711404092473e+0', 39, 4);
  t('4.190828079947720296599477701349354520240413371E+88722', '8.87226e+4', 6, 3);
  t('2.1159289143262425E+9818509', '9.818509325501073e+6', 16, 5);
  t('4.70706E+1342622659861', '1.342622659861672749734211174727e+12', 31, 2);
  t('4.3897940E-37', '-3.6357e+1', 5, 2);
  t('3.223190179078E-9459981404844', '-9.45998140484349171406889429071e+12', 30, 5);
  t('7.63774540593993554693734475525176E-2338460665997443', '-2.338460665997e+15', 13, 6);
  t('7.08395369461253774236501117501869481991E+75775709160114', '7.57e+13', 3, 3);
  t('4.764349864880E+2714827071468', '2.714e+12', 4, 3);
  t('4.673416448899800598981630284876539E-328423146423', '-3.2842314642233036552e+11', 20, 6);
  t('7.826045736338822738638958732226685960362E-1412', '-1.41110645761835949762542371879e+3', 30, 0);
  t('5.796700333799240103896E-28859', '-2.885823681e+4', 10, 1);
  t('8.97096663631613993250462383164860567863227128721354276181812E+176', '1.7695283924150562685124197e+2', 26, 0);
  t('7.8585954305551819623439174147023744645039746762452852218E+73629027', '7.362902789534493137419777269992467e+7', 34, 5);
  t('3.4382907684711E-42584717', '-4.258471647e+7', 10, 3);
  t('1.41699080539874712712879548325887844471678E+3194156', '3.194156151367032196972e+6', 22, 0);
  t('7.331289659351565E+1696410', '1.6964108651803788e+6', 17, 6);
  t('1.745022889562179361781933066447101432E+535599', '5.355992418011279974051832982044808e+5', 34, 6);
  t('4.30739431731149846909077453595545769250098838827929287457735E+6256201941', '6.2562019416342146307581404214050605352e+9', 38, 6);
  t('1.588554116485404477492730355848E+3496', '3.4962010020143099479653792462688377e+3', 35, 3);
  t('9.900888E-106498', '-1.064970043258522504e+5', 19, 1);
  t('8.83580012650210959E+73456', '7.345694624589e+4', 13, 0);
  t('8.8949043525769342851448782098279774889770917544263726E-82775565', '-8.2775e+7', 5, 2);
  t('3.6224442E-141', '-1.4045e+2', 5, 0);
  t('8.59405672549749313626581182770673689820022E-32033035', '-3.20331e+7', 6, 3);
  t('9.51074073247087480768657837136488292943959703869E+275930276482999', '2.7593027648299997821435e+14', 23, 2);
  t('2.54065063418647762504692974337669E+406474715003143', '4.064747150031434e+14', 17, 1);
  t('9489953385.25328239339198556294098175754101987164777', '9.977264079173657754167815e+0', 25, 0);
  t('4.5232942439068434456152833847455813722535773E-4462', '-4.46e+3', 3, 1);
  t('7.0802826525E+787135580', '7.87135580850050595538747730277159237612e+8', 39, 4);
  t('5.8216966113439E+223611', '2.2361176504956911165649331380712912243e+5', 38, 4);
  t('3.33244818745948041153812422494096916019823856474870E+517782641176005', '5.1778264117600552276340578e+14', 26, 5);
  t('2.05912361945417878137840483E+5552624271309', '5.552624e+12', 7, 1);
  t('6.84742824413083454475067895412838639947431E-39838897', '-3.9838896164472510127860873720016710505e+7', 38, 2);
  t('3.95807149459035557997365582562827797684887001622411167547181E+1549', '1.54959748363e+3', 12, 5);
  t('2.0195949695778122120385695521227579706871529732687E-55200', '-5.5199694735719719133330807334889920748e+4', 38, 4);
  t('7.8171596648329304689657474893269001820416900818139E+131702572699', '1.31702572699893048982476210061446323262e+11', 39, 2);
  t('5.0668399219162114869148E+3655', '3.655704737183720975024589242605e+3', 31, 0);
  t('4.75555399593131396464117509556003E+610', '6.10677201117143314e+2', 19, 4);
  t('4.478467972936253610790510078714E+1024', '1.024651129472772477335e+3', 23, 3);
  t('1.4408051213207621033E+529220956779', '5.292209567791586053e+11', 19, 0);
  t('7.10903333703321992919455115881016884828773E+216193', '2.161938518105508e+5', 16, 5);
  t('3.01777E+59773', '5.97734796861368520217703676e+4', 27, 3);
  t('8.207881805736931035390756744751707691802017739454540300E-2164854877141559', '-2.16485487714155e+15', 15, 2);
  t('9.633610519523911273743199583415128174038760209192103E-124', '-1.23016210915904169742864e+2', 24, 6);
  t('4.69414682782169969201733241661926387578671440642216E-7082634132334465', '-7.08263413233446432844333026e+15', 27, 1);
  t('3.739788296386425205173905702442336339893085E+3772780166993', '3.772780167e+12', 11, 4);
  t('2.55408368428247917203004684693105826775753E+390699550133', '3.90699550133407235122773402e+11', 27, 6);
  t('7.251474452851442402672495958892746452E+49940264985545', '4.9940264985545860426321279e+13', 26, 5);
  t('1.721182063637637944851802912796631080152254327700488E+39830', '3.98302358268116704603889e+4', 24, 5);
  t('6.0160E+6432654', '6.432654779e+6', 10, 4);
  t('6.1412E+58567968', '5.856796878825e+7', 13, 4);
  t('4.6942768850847549904995671905357285207275829424268523550395E+813', '8.136716e+2', 7, 2);
  t('4E-20586837', '-2e+7', 1, 5);
  t('9.581407894052410E+716956335992', '7.169563359929814293290882793134e+11', 31, 0);
  t('9.02517435211003151096977993840249057659E+49790830466082', '4.97908304660829554556005420051e+13', 30, 0);
  t('6.35042592535315544207236947351E+38', '3.8802802854556101872830211083071e+1', 32, 4);
  t('7.3857993596821934361411966047009506536956121E+769171391', '7.692e+8', 4, 6);
  t('8.62E-5441684634440', '-5.441684634439064492735e+12', 22, 0);
  t('3.38129500769046530005909717304004367640216011150E-19802852', '-1.980285147091693671045805032352e+7', 31, 5);
  t('6.529755524524004983762782691926155E+41790', '4.17908148969214990010338098e+4', 28, 6);
  t('6.2356159650232275E+435456077183', '4.35456077183794879360300148491e+11', 30, 0);
  t('1.06610584819233041984469468751207423544105865915E-54045758', '-5.404575797219967e+7', 16, 6);
  t('4.0645298587882401075248650399370490791E+1661984', '1.66198460901031830839250688097659180396e+6', 39, 1);
  t('5.293607557105180254720699965156017448949177246642E+70986909', '7.098690972375174163076659557650674483e+7', 37, 2);
  t('3.3597230648953198398658762540008674386627018103381E+556809183042954', '5.5680918e+14', 8, 4);
  t('4.5827E-3063727', '-3.06372634e+6', 9, 5);
  t('6.827387820647755116E+91567807', '9.15678078342545730704445336689514619209e+7', 39, 3);
  t('2.107416729706044661767557E-507964854044716', '-5.08e+14', 3, 3);
  t('5.50927251577102E+865656592439', '8.656565e+11', 7, 3);
  t('3.98021181734497757342512733248537061996368597496710547724438E+36994589', '3.699458959990618480139602631124e+7', 31, 5);
  t('5.301444115538624029E-123333622739', '-1.23333622738275605812289583781e+11', 30, 0);
  t('7.76903608002529822525212598E-5393243350993', '-5.3932433509922e+12', 14, 0);
  t('8.99577590795471215209062998374857929772E+27728726', '2.7728726954e+7', 11, 5);
  t('9.2800343E+116', '1.16967549581420715521021089418e+2', 30, 3);
  t('3.977785722122324570544976154849E+2026608816324425', '2.0266088163244255997e+15', 20, 2);
  t('5.076612022561327891899414337745979097225486208822555E+1487002218', '1.4870022187055739739424853775232485e+9', 36, 6);
  t('6.0380E+10771969', '1.0771969780893108687079e+7', 24, 0);
  t('4.136300926E+4521437761', '4.5214377616166121272201e+9', 23, 5);
  t('9.22197478861493479118165328708963109905458469027359887185E+9801078721222', '9.8010787212229648239e+12', 20, 1);
  t('9.4956474346866285754042480762819121552440915291460650971217E+71762533504', '7.176253350497752458126112751125707e+10', 34, 1);
  t('1.2644471156926304326001813E+84', '8.41019006701033912892e+1', 21, 3);
  t('9.506977552139186104379591692476780E-76004', '-7.600302195753154429093352099592805779e+4', 37, 1);
  t('2.957532705030717197E+99157', '9.915747092955584801104179643091e+4', 31, 6);
  t('7.09E-856335', '-8e+5', 1, 1);
  t('3.07871052E-960121094972360', '-9.60121094972359511631144314377046968e+14', 36, 2);
  t('6.8E+958593705', '9.58593705832508912706236318968e+8', 30, 5);
  t('5.6609E-810185', '-8.1018e+5', 5, 6);
  t('3.6558695839138249990426146888447712E-845885711328867', '-8.45885711328866437009e+14', 21, 5);
  t('4.3751179237797712870357135036405450959980035923344E+88017014', '8.8017014641e+7', 11, 0);
  t('3.126326E+7', '7.5e+0', 3, 2);
  t('5.5446354250391559981621639541476945764347487E+99', '9.9743872995372639427954942e+1', 27, 5);
  t('6.83359216868393351813673053376398E-768516737', '-7.685167362e+8', 10, 3);
  t('3.5756036122224666277275933636622914974272944179692E-33164602799132', '-3.3164602799131446650632651919e+13', 29, 4);
  t('6.3647380108303890323974286224992387800147568486084145918E+92960', '9.29608037805316672236175396822532819958e+4', 39, 4);
  t('3.655327513874682496408952E+241392', '2.41392562926295410475695688e+5', 27, 3);
  t('3.50605948150100548853692707939376333427406113641347093729713E+82773535153', '8.277353515354481927977504146210064151e+10', 37, 0);
  t('7.310307960686719E+1014647837216539', '1.014647837216539863935672827860541609e+15', 38, 1);
  t('8.9958342461392085028378371339449567463900820E+9042', '9.04296e+3', 6, 0);
  t('7.9074217927308678583E-8055', '-8.05410196509472092e+3', 18, 1);
  t('4.71498107545049919E+3918717021260325', '3.91871702126032567347995394e+15', 27, 1);
  t('3.95444611001117195409E+86', '8.65970857e+1', 9, 5);
  t('3.18843306841991860797879308596248315871925802644766577402711E+45977468583', '4.597746858350357730471013599925e+10', 31, 3);
  t('6.22570422125935111934774E+4254868031441062', '4.2548680314410627942e+15', 20, 5);
  t('16.03204924004841325542492869198973017652', '1.204989e+0', 8, 3);
  t('1.3654185685412343953580259247722E-531996253', '-5.31996253e+8', 9, 6);
  t('4.71252353423253553966540276306417102E+953823831', '9.53e+8', 3, 3);
  t('1.278141210944641028302392491356322105E+23751988941935', '2.375198e+13', 7, 1);
  t('2.953816209213038450561378564E+63693096648', '6.369309664847e+10', 13, 3);
  t('9.83165012596577211760566749445836512198588929716039287E+84414627', '8.4414628e+7', 9, 2);
  t('4.68956719459375555E+6671031', '6.67103167113276304063696287334162702e+6', 36, 2);
  t('8.5619E+46140632620', '4.61406326209325701511e+10', 21, 6);
  t('6.7286418039128390E+53588775321541', '5.358878e+13', 7, 4);
  t('9.21845775502E+309965433290', '3.0996543329096465826980535055070799804e+11', 38, 6);
  t('1.3869745783736495958786116744238903364E+825322', '8.25e+5', 3, 3);
  t('1.825E-2472008736902690', '-2.47200873690268973873713120751e+15', 30, 4);
  t('5.9219317E+3999610292171', '3.999610292171772463394190706e+12', 28, 6);
  t('5.72750456430116440072740529290526066460700960580E+57751419', '5.775141975796544395484753985352e+7', 31, 4);
  t('2.68091712962E-815', '-8.1457171661037557e+2', 17, 5);
  t('1.38094E+2063', '2e+3', 1, 4);
  t('8.5209845773496385982442318897466408E+48727127237', '4.9e+10', 2, 5);
  t('2.302011E+6115146295', '6.1151462953621073945448099e+9', 26, 3);
  t('2.89175443197729017916360237450799650414E-3096072526420', '-3.096072526419538839e+12', 19, 0);
  t('9202.20225997385641312038794860942786773', '3.96389177461e+0', 12, 3);
  t('0.000007310305777806927856977926355044917154612541', '-5.136064456853788246578869978739617164e+0', 37, 1);
  t('3.92871079665090398794493191930758E-213143923295', '-2.13143923294e+11', 12, 1);
  t('4.938356900829494427605602164551241E+430201502312221', '4.30201502312222e+14', 15, 4);
  t('6.491874137133116252625941441690426276235236284508843505192E-97563443', '-9.756344219e+7', 10, 0);
  t('6.15092047610497936007038744E+8208499133204', '8.2084991332047889401e+12', 20, 4);
  t('286.92707068747734494438523412969996882', '2.46e+0', 3, 2);
  t('7.60950578077754732903891601421880E-83599', '-8.35981186435487026309413e+4', 24, 3);
  t('6.977587013708000E+6917', '6.917843705261045671e+3', 19, 4);
  t('9.63689981460249470383307333E-98768150428115', '-9.87681504281140160626559e+13', 24, 2);
  t('1.738318789984661940353053893061128387825642031515449517E+5964494192', '5.9644941922401e+9', 14, 4);
  t('8.38787701253582907E+463', '4.6392365205398588e+2', 17, 1);
  t('9.802636321113883267418E+484162298747106', '4.8416229874710699134e+14', 20, 1);
  t('4.492325834E+59858434', '5.985843465247124865269261063433e+7', 31, 4);
  t('9.336327683727813389043806701E+25573134966275', '2.55731349662759701e+13', 18, 3);
  t('5.7690E+6930821612762', '6.930821612762761100538958142296e+12', 31, 1);
  t('7.234860786329978712579251553140673876E+4617', '4.61785943017881229510597105156e+3', 30, 5);
  t('2.31892719704128397385272539633537327546738574387107382E-343156242878', '-3.4315624287763471289e+11', 20, 3);
  t('2223999943.89810311445890834443656215387', '9.3471347719546491108598298398282171e+0', 35, 3);
  t('3.7327171497158E-7', '-6.427974917915026222e+0', 19, 5);
  t('2.793677314157573549808840E+532', '5.3244617624115755788973705e+2', 26, 6);
  t('7.640898943682386533902335E+536009329594188', '5.36e+14', 4, 4);
  t('8.9074250430447141026785391328342688479479051E+21963922635578', '2.1963922635578949e+13', 17, 3);
  t('5.5762216618089304820E-6976208', '-6.976207253659970816237e+6', 22, 5);
  t('1.91357401642E+49961236827', '4.99612368272818452652545816872375e+10', 33, 2);
  t('5.957297990106291252829815394260394318083353E-26245957645478', '-2.6245957645477e+13', 14, 1);
  t('8.01844860599820804155768000879876725329864650214532E+436946856', '4.36946856904090349951357241211271e+8', 33, 2);
  t('5.5574947893333547365232067522673911E+7059', '7.05974487906417987536846332910957964e+3', 36, 5);
  t('9.552816484569040E+6270', '6.2709801314347641e+3', 17, 0);
});
