/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square root of `3`.
*
* @module @stdlib/constants/float64/sqrt-three
* @type {number}
*
* @example
* var SQRT3 = require( '@stdlib/constants/float64/sqrt-three' );
* // returns 1.7320508075688772
*/


// MAIN //

/**
* Square root of `3`.
*
* ```tex
* \sqrt{3}
* ```
*
* @constant
* @type {number}
* @default 1.7320508075688772
*/
var SQRT3 = 1.732050807568877293527446341505872366942805253810380628055e+00;


// EXPORTS //

module.exports = SQRT3;
