type EcmaVersion = "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022";
type CaniuseBrowser = "and_chr" | "and_ff" | "and_qq" | "and_uc" | "android" | "baidu" | "bb" | "chrome" | "edge" | "firefox" | "ie" | "ie_mob" | "ios_saf" | "op_mini" | "op_mob" | "opera" | "safari" | "samsung";
/**
 * Normalizes the given Browserslist
 */
declare function normalizeBrowserslist(browserslist: string | string[]): string[];
/**
 * Generates a Browserslist based on browser support for the given features
 *
 * @param features
 * @returns
 */
declare function browsersWithSupportForFeatures(...features: string[]): string[];
/**
 * Returns true if the given Browserslist supports the given EcmaVersion
 * @param browserslist
 * @param version
 */
declare function browserslistSupportsEcmaVersion(browserslist: string[], version: EcmaVersion): boolean;
/**
 * Returns the appropriate Ecma version for the given Browserslist
 */
declare function getAppropriateEcmaVersionForBrowserslist(browserslist: string[]): EcmaVersion;
/**
 * Generates a Browserslist based on browser support for the given ECMA version
 */
declare function browsersWithSupportForEcmaVersion(version: EcmaVersion): string[];
/**
 * Returns true if the given browserslist support all of the given features
 *
 * @param browserslist
 * @param features
 * @returns
 */
declare function browserslistSupportsFeatures(browserslist: string[], ...features: string[]): boolean;
/**
 * Generates a Browserslist based on browsers that *doesn't* support the given features
 *
 * @param features
 * @returns
 */
declare function browsersWithoutSupportForFeatures(...features: string[]): string[];
/**
 * Gets a Map between browser names and the first version of them that supported the given feature
 *
 * @param feature
 * @returns
 */
declare function getFirstVersionsWithFullSupport(feature: string): Map<CaniuseBrowser, string>;
/**
 * Generates a browserslist from the provided useragent string
 */
declare function generateBrowserslistFromUseragent(useragent: string): string[];
/**
 * Generates a browserslist from the provided useragent string and checks if it matches
 * the given browserslist
 */
declare function matchBrowserslistOnUserAgent(useragent: string, browserslist: string[]): boolean;
/**
 * Returns true if the given user agent supports the given features
 */
declare function userAgentSupportsFeatures(useragent: string, ...features: string[]): boolean;
export { normalizeBrowserslist, browsersWithSupportForFeatures, browserslistSupportsEcmaVersion, getAppropriateEcmaVersionForBrowserslist, browsersWithSupportForEcmaVersion, browserslistSupportsFeatures, browsersWithoutSupportForFeatures, getFirstVersionsWithFullSupport, generateBrowserslistFromUseragent, matchBrowserslistOnUserAgent, userAgentSupportsFeatures };
//# sourceMappingURL=index.d.ts.map