unit ChildWin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SynEditHighlighter, SynEdit, Main, ExtCtrls, SynHighlighterNyquist;

type
  TMDIChild = class(TForm)
    SynEdit: TSynEdit;
    SynNyquistSyn: TSynNyquistSyn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SynEditStatusChange(Sender: TObject;
      Changes: TSynStatusChanges);
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SynEditChange(Sender: TObject);
    procedure SynEditKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SynEditEnter(Sender: TObject);
    procedure SynEditDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MDIChild: TMDIChild;

resourcestring
  sSaveChanges = 'Save changes to %s?';
  sOverWrite = 'OK to overwrite %s';
  sUntitled = 'Untitled%d';
  csUntitled = 'Untitled';
  sModified = 'Modified';
  sColRowInfo = 'Line: %3d   Col: %3d';
    
implementation

{$R *.DFM}

procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if MainForm.MDIChildCount = 1 then
   with MainForm do
    begin
      StatusLine.Panels[1].Text := '';
      SetModified(false);
      MainForm.MenuEnabled(false);
      MainForm.FileCloseItem.Enabled := false;
      MainForm.FileCloseAllItem.Enabled := false;      
    end;
  Action := caFree;
end;

procedure TMDIChild.SynEditStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
begin
  if (scCaretX in Changes) or (scCaretY in Changes) then
    MainForm.StatusLine.Panels[1].Text := 'Ln ' + inttostr(SynEdit.CaretY) + ', Col ' + inttostr(SynEdit.CaretX);
{  if scAll in Changes then
    if MainForm.ActiveMDIChild = nil then
      MainForm.StatusLine.Panels[1].Text := 'Ln 1, Col 1';
    else MainForm.StatusLine.Panels[1].Text := 'Ln ' + inttostr((MainForm.ActiveMDIChild as TMDIChild).SynEdit.CaretX) + ', Col ' + inttostr((MainForm.ActiveMDIChild as TMDIChild).SynEdit.CaretY);
  if scInsertMode in Changes then
    MainForm.StatusLine.Panels[2].
    Enabled := not(MainForm.StatusLine.Panels[2].Enabled)
  if scReadOnly in Changes then
    MainForm.StatusLine.Panels[3].Enabled := not(MainForm.StatusLine.Panels[3].Enabled)}
//  MainForm.StatusLine.Panels[0].Text := SynEdit.Text;
//  else MainForm.SetModified(false);
end;

procedure TMDIChild.FormActivate(Sender: TObject);
begin
  MainForm.StatusLine.Panels[1].Text := 'Ln ' + inttostr(SynEdit.CaretY) + ', Col ' + inttostr(SynEdit.CaretX);
  MainForm.SetModified(SynEdit.Modified);
  MainForm.MenuEnabled(true);
end;

procedure TMDIChild.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  SaveResp: Integer;
begin
  try
    CanClose := true;
    if Self.SynEdit.Modified then
    begin
      SaveResp := MessageDlg(Format(sSaveChanges, [Self.Caption]),
        mtConfirmation, mbYesNoCancel, 0);
      case SaveResp of
        idYes: MainForm.FileSave(Sender);
        idNo: {Nothing};
        idCancel: Abort;
      end;
    end;  
    if (pos('Untitled', Caption) <> 1)
      and (MainForm.MRUFileList.Items.IndexOf(Caption) = -1) then
      MainForm.MRUFileList.AddItem(Caption);
  except
    CanClose := False;
  end;
end;

procedure TMDIChild.SynEditChange(Sender: TObject);
begin
  MainForm.SetModified(SynEdit.Modified);
end;

procedure TMDIChild.SynEditKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  procedure RoundClose();
  var
    findx, findy, round, oldx, oldy: integer;
    find, insert: boolean;
    starttime, fractime: double;
    Token: string;
    Attri: TSynHighlighterAttributes;
  begin
    with SynEdit do
      begin
        if (GetHighlighterAttriAtRowCol(Point(CaretX-1,CaretY), Token, Attri)) and (Attri.Name = 'Symbol') then
          begin
            findx := CaretX - 1;
            findy := CaretY;
            find := false;
            round := 0;
            repeat
              findx := findx - 1;
              if findx <= 0 then
                begin
                  findy:= findy-1;
                  if findy>0 then findx := length(Lines[findy - 1]);
                end;
              if (findy>0) and (findx>0) then
                begin
                  if (Lines[findy - 1][findx] = ')') and (GetHighlighterAttriAtRowCol(Point(findx,findy), Token, Attri)) and (Attri.Name = 'Symbol')
                    then round := round + 1;
                  if (Lines[findy - 1][findx] = '(') and (GetHighlighterAttriAtRowCol(Point(findx,findy), Token, Attri)) and (Attri.Name = 'Symbol')
                    then if round>0 then round := round -1
                         else find := true;
                end;
            until find or (findy <= 0);
            if find then
              begin
                oldx := CaretX;
                oldy := CaretY;
                CaretX := findx;
                CaretY := findy;
                insert := InsertMode;
                InsertMode := false;
                SynEdit.Repaint;
                starttime := now;
                fractime := interval/(60*60*24);
                repeat
                until now-starttime >=fractime;
                CaretX := oldx;
                CaretY := oldy;
                InsertMode := insert;
              end;
          end;
      end;
  end;
begin
  if (MainForm.ParenMatchingItem.Checked = true) and (Shift = [ssShift]) and (Key = 48) then
    RoundClose();
end;

procedure TMDIChild.SynEditEnter(Sender: TObject);
begin
  with SynEdit do
    if CaretX-1 > length(Lines[CaretY-1]) then CaretX := length(Lines[CaretY-1])+1;
end;

procedure TMDIChild.SynEditDblClick(Sender: TObject);
var OldX, OldY, findx, findy, round: integer;
begin
  with SynEdit do
    if (CaretY<=Lines.Count) and (CaretX<=length(Lines[CaretY-1])) and (Lines[CaretY-1][CaretX] = '(') then
      begin
        OldX := CaretX;
        OldY := CaretY;
        findx := CaretX;
        findy := CaretY-1;
        BlockBegin := CaretXY;
        round := 1;
        repeat
          if findy<Lines.Count then
            begin
              findx := findx + 1;
              if (findx<=length(Lines[findy])) then
               begin
                case Lines[findy][findx] of
                  '(': round := round + 1;
                  ')': round := round - 1;
                end;
               end
              else
                begin
                  findx := 0;
                  findy := findy + 1;
                end;
            end;
        until (round = 0) or (findy >= Lines.Count);
        if round = 0 then
         begin
          CaretX := findx + 1;
          CaretY := findy + 1;
         end;
        BlockEnd := CaretXY;
        CaretX := OldX;
        CaretY := OldY;
      end;
end;

end.
