macro(add_installation_script_test name path)

  # Copy the source to the binary tree
  file( COPY "${CMAKE_CURRENT_SOURCE_DIR}/${path}/${name}" DESTINATION "${CMAKE_CURRENT_BINARY_DIR}/${path}"
    FILE_PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE
    DIRECTORY_PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE
  )
  file( COPY "${CMAKE_CURRENT_SOURCE_DIR}/${path}/${name}-usage" DESTINATION "${CMAKE_CURRENT_BINARY_DIR}/${path}"
    FILE_PERMISSIONS OWNER_READ OWNER_WRITE GROUP_READ WORLD_READ
  )
  add_test(NAME test-${name} COMMAND "${CMAKE_BINARY_DIR}/${path}/${name}")
  set_property(TEST test-${name} PROPERTY WORKING_DIRECTORY "${CMAKE_BINARY_DIR}/${path}")
  set_property(TEST test-${name} PROPERTY ENVIRONMENT "OPENCOARRAYS_SRC_DIR=${CMAKE_SOURCE_DIR}")
endmacro(add_installation_script_test)
