/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_EnabledPCICapabilities.h"

CMPIObjectPath* PCI_OpenDRIM_EnabledPCICapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_EnabledPCICapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_EnabledPCICapabilities_classnames[0], OpenDRIM_EnabledPCICapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* PCI_OpenDRIM_EnabledPCICapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_EnabledPCICapabilities& instance) {
	_E_;
	Objectpath op(broker, PCI_OpenDRIM_EnabledPCICapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.ElementNameEditSupported_isNULL)
		ci.setProperty("ElementNameEditSupported", instance.ElementNameEditSupported);

	if (!instance.MaxElementNameLen_isNULL)
		ci.setProperty("MaxElementNameLen", instance.MaxElementNameLen);

	if (!instance.RequestedStatesSupported_isNULL)
		ci.setProperty("RequestedStatesSupported", instance.RequestedStatesSupported);

	if (!instance.ElementNameMask_isNULL)
		ci.setProperty("ElementNameMask", instance.ElementNameMask);

	if (!instance.StateAwareness_isNULL)
		ci.setProperty("StateAwareness", instance.StateAwareness);

	_L_;
	return ci.getHdl();
}

void PCI_OpenDRIM_EnabledPCICapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_EnabledPCICapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_EnabledPCICapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_EnabledPCICapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("ElementNameEditSupported", instance.ElementNameEditSupported) == OK)
		instance.ElementNameEditSupported_isNULL = false;

	if (inst.getProperty("MaxElementNameLen", instance.MaxElementNameLen) == OK)
		instance.MaxElementNameLen_isNULL = false;

	if (inst.getProperty("RequestedStatesSupported", instance.RequestedStatesSupported) == OK)
		instance.RequestedStatesSupported_isNULL = false;

	if (inst.getProperty("ElementNameMask", instance.ElementNameMask) == OK)
		instance.ElementNameMask_isNULL = false;

	if (inst.getProperty("StateAwareness", instance.StateAwareness) == OK)
		instance.StateAwareness_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_EnabledPCICapabilities_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_EnabledPCICapabilities_CreateGoalSettings_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	vector<string> TemplateGoalSettings;
	data = in->ft->getArg(in, "TemplateGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, TemplateGoalSettings);	
		args.setTemplateGoalSettings(TemplateGoalSettings);
	}			

	vector<string> SupportedGoalSettings;
	data = in->ft->getArg(in, "SupportedGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, SupportedGoalSettings);	
		args.setSupportedGoalSettings(SupportedGoalSettings);
	}			

	_L_;
}

void PCI_OpenDRIM_EnabledPCICapabilities_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_EnabledPCICapabilities_CreateGoalSettings_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	vector<string> SupportedGoalSettings;
	errorMessage = args.getSupportedGoalSettings(SupportedGoalSettings);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, SupportedGoalSettings);
		out->ft->addArg(out, "SupportedGoalSettings", &value, CMPI_stringA);
	}

	_L_;
}
