/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_MemberOfPowerSupplyCollectionAccess.h"

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PowerSupply_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(PowerSupply_CIM_Collection_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PowerSupply_CIM_ManagedElement_unload(errorMessage));
	CF_assert(PowerSupply_CIM_Collection_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_isAssociated(const Instance& Member, const Instance& Collection, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemberOfPowerSupplyCollection>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateMembers(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateMembers(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Member_classnames[0], Collection_classnames[0],
			Member_role.c_str(), Collection_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_referenceMemberToCollection(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemberOfPowerSupplyCollection& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Member_objectpath;
	instance.getMember(Member_objectpath);
	Instance Member_instance;
	CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_getMember(broker, ctx, Member_objectpath, Member_instance, NULL, errorMessage));
	
	Objectpath Collection_objectpath;
	instance.getCollection(Collection_objectpath);
	Instance Collection_instance;
	CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_getCollection(broker, ctx, Collection_objectpath, Collection_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_isAssociated(Member_instance, Collection_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& newInstance, const OpenDRIM_MemberOfPowerSupplyCollection& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Collection_instances;
	if (discriminant=="a")
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateCollections(broker, ctx, Collection_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateCollections(broker, ctx, Collection_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateCollections(broker, ctx, Collection_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Collection_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_isAssociated(Member_instance, Collection_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Collection_associatedInstances.push_back(Collection_instances[i]);
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Member_instances;
	if (discriminant=="a")
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateMembers(broker, ctx, Member_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateMembers(broker, ctx, Member_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_enumerateMembers(broker, ctx, Member_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Member_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_isAssociated(Member_instances[i], Collection_instance, isAssociated, errorMessage));
		if (isAssociated)
			Member_associatedInstances.push_back(Member_instances[i]);
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_MemberOfPowerSupplyCollection>& OpenDRIM_MemberOfPowerSupplyCollection_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Collection_instances.size(); i++) {
		OpenDRIM_MemberOfPowerSupplyCollection instance;
		instance.setMember(((Instance) Member_instance).getObjectpath());
		instance.setCollection(((Instance) Collection_instances[i]).getObjectpath());
		
		OpenDRIM_MemberOfPowerSupplyCollection_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_MemberOfPowerSupplyCollection>& OpenDRIM_MemberOfPowerSupplyCollection_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Member_instances.size(); i++) {
		OpenDRIM_MemberOfPowerSupplyCollection instance;
		instance.setMember(((Instance) Member_instances[i]).getObjectpath());
		instance.setCollection(((Instance) Collection_instance).getObjectpath());
		
		OpenDRIM_MemberOfPowerSupplyCollection_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_populate(OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

