#include "CheckImage.h"

#include <cstring>

#include <GTLCore/PixelDescription.h>

CheckImage::CheckImage(int width, int height, const GTLCore::PixelDescription& _pixelDescription): AbstractImage(_pixelDescription), m_width(width), m_height(height), m_valid_accessed(false)
{
  int pixelSize = _pixelDescription.bitsSize() / 8;
  pixel = new char[pixelSize];
  std::memset(pixel, 0, pixelSize);
}

CheckImage::~CheckImage()
{

}

GTLCore::RegionI CheckImage::accessed()
{
  return m_accessed;
}

void CheckImage::accessPixel(int _x, int _y) const
{
  GTLCore::RegionI pixelRegion(_x, _y, 1, 1);
  if(m_valid_accessed)
  {
    m_accessed = m_accessed.united(pixelRegion);
  } else {
    m_accessed = pixelRegion;
    m_valid_accessed = true;
  }
}

GTLCore::RegionI CheckImage::boundingBox() const
{
  return GTLCore::RegionI(0, 0, m_width, m_height);
}

GTLCore::AbstractImage::ConstIterator* CheckImage::createIterator() const
{
  return 0;
}

GTLCore::AbstractImage::Iterator* CheckImage::createIterator()
{
  return 0;
}

char* CheckImage::rawData(int _x, int _y)
{
  accessPixel(_x, _y);
  return pixel;
}

const char* CheckImage::rawData(int _x, int _y) const
{
  accessPixel(_x, _y);
  return pixel;
}

void CheckImage::reset()
{
  m_accessed = GTLCore::RegionI();
  m_valid_accessed = false;
}
