/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import widgets.CounterWidget;
import widgets.FloatPanel;
import widgets.IntegerPanel;
import widgets.myFileDialog;
import xmlObjects.EnumClass;
import xmlObjects.EnumSelectionClass;
import xmlObjects.Item;
import xmlObjects.ValDesc;
import xmlObjects.VtEnv;
/**
 * This class has some helpful methods to work on items
 */
public class MyComponentHandler {

	public MyComponentHandler(){;}
	
	/***
	 * set a component to a value
	 * @param comp component set should be set to value
	 * @param val value that is set.
	 */
	public void SetComponent(Component comp, String val)
	{
		
		if(comp == null)
		{
			comp = new JFormattedTextField();
		}
		
		if(comp.getClass() == CounterWidget.class)
		{
			((CounterWidget)comp).load(val);
		}
		
		//if it is a boolean (checkbox)
		if(comp != null && comp.getClass() == new JCheckBox().getClass())
		{
			if(val.compareTo("yes")==0)
				((JCheckBox) comp).setSelected(true);
			else
				((JCheckBox) comp).setSelected(false);
		}
		
		//if it is a Textfield or large integer (textfield)
		if(comp.getClass() == new JFormattedTextField().getClass())
			((JFormattedTextField) comp).setText(val);
		
		
		//if it is an enum (combobox)
		if(comp.getClass() == new JComboBox().getClass()){
			for(int i=0;i<=((JComboBox) comp).getComponentCount();i++)
			{
				if(((JComboBox) comp).getItemAt(i).toString().compareTo(val)==0)
				{
					((JComboBox) comp).setSelectedIndex(i);
				}
			}
		}
		
		if(comp.getClass() == new myFileDialog().getClass())
		{
			Component compHelp = ((JPanel)comp).getComponent(0);
			((JFormattedTextField) compHelp).setText(val);
		}
		
		//if it is something else... (Jpanel collection of different types)
		if(comp.getClass() == new JPanel().getClass())
		{
			
			//FilePath; Path
			Component compHelp = ((JPanel)comp).getComponent(0);
			
			if(compHelp.getClass() == new JFormattedTextField().getClass())
				((JFormattedTextField) compHelp).setText(val);
			
			// multi selection
			if(compHelp.getClass() == new JCheckBox().getClass())
			{
				String[] values = val.split(":");
				for(int i=0;i< ((JPanel)comp).getComponentCount(); i++)
				{
					
					  if(isInArray(values,((JCheckBox)((JPanel)comp).getComponent(i)).getText()))
						  ((JCheckBox)((JPanel)comp).getComponent(i)).setSelected(true);
					  else
						  ((JCheckBox)((JPanel)comp).getComponent(i)).setSelected(false);
				}
			}
			
			
			// integer, float
		}
		
		if(comp.getClass() == new IntegerPanel().getClass())
		{
			((IntegerPanel) comp).changeSlider(val);
		}
		
		if(comp.getClass() == new FloatPanel().getClass())
		{
			((FloatPanel) comp).changeSlider(val);
		}
		
	}

	/***
	 * Set a value to its default value
	 * @param val  value set should be reset to default
	 * @param vtenv environment to get the enum and enumselection values
	 */
	public void SetDefault(ValDesc val,VtEnv vtenv)
	{
		Component comp = val.getComponent();
		if(comp == null)
		{
			comp = new JFormattedTextField();
			((JFormattedTextField) comp).setText(val.getValue());
		}
		
		// ******* for boolean ********** /
		if(val.getType().trim().compareTo("bool") == 0)
		{
			JCheckBox check = (JCheckBox)comp;
			if(val.getValue().compareTo("1")==0)
				check.setSelected(true);
			else
				check.setSelected(false);
		}
		
		// ****** If item is string ***** /
		if(val.getType().trim().compareTo("string") == 0)
		{
			JFormattedTextField text = (JFormattedTextField) comp;
			text.setText(val.getValue());
		}
		
		// ****** If item is path ***** /
		if(val.getType().trim().compareTo("path") == 0 || val.getType().trim().compareTo("filepath") == 0)
		{		
			myFileDialog path = (myFileDialog) comp;
			((JFormattedTextField)path.getComponent(0)).setText(val.getValue());
			
		}
		
		// ****** If item is integer ***** /
		if(val.getType().trim().compareTo("integer") == 0)
		{
			
			try{
				if(comp.getClass() == IntegerPanel.class)
				{
					IntegerPanel integ = (IntegerPanel) comp;
					integ.changeSlider(val.getValue());
				}else
					((JFormattedTextField) comp).setText(val.getValue());		
			}catch(Exception ex)
			{
			
				Config.errorHandler(ex);
			}
		}
		// ****** If item is float ***** /
		if(val.getType().trim().compareTo("float") == 0)
		{
			try{
				if(comp.getClass() == IntegerPanel.class)
				{
					FloatPanel integ = (FloatPanel) comp;
					integ.changeText(Float.parseFloat(val.getValue()));
				}
				else
					((JFormattedTextField) comp).setText(val.getValue());	
			}catch(Exception ex)
			{
			
				Config.errorHandler(ex);
			}
		}
		
		// ****** If item is enum ***** /
		if(val.getType().trim().compareTo("enum") == 0)
		{
			EnumClass myenum = null;
			try{
				myenum = vtenv.getEnumById(val.getEnumId());
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
			JComboBox combo = (JComboBox) comp;
			combo.setSelectedIndex(myenum.getEntrys().indexOf(val.getValue()));
		}
		
		// ****** If item is enumselection ***** /
		if(val.getType().trim().compareTo("enumselection") == 0)
		{
			EnumSelectionClass myenum = null;
			JPanel entr = (JPanel) comp;
			try{
				myenum = vtenv.getEnumSelectionById(val.getEnumId());
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
		
			String valDefault[] = {};
			if(val.getValue() != null)
			{
				valDefault = val.getValue().split(";");
			}
			
			for(int j=0;j < myenum.getEntrys().size();j++)
			{
				boolean isfalse = true;
				for(int k=0; k < valDefault.length;k++)
				{
					if(valDefault[k].compareTo(myenum.getEntrys().get(j))==0)
					{
						((JCheckBox) entr.getComponent(j)).setSelected(true);
						isfalse=false;
						break;
					}
				}
				if(isfalse)
					((JCheckBox) entr.getComponent(j)).setSelected(false);
			}
		}
		
		if(val.getType().trim().equals("special"))
		{
			try{
				if(val.getEnumId().equals("papiCounter"))
					((CounterWidget)val.getComponent()).setDefault();
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
		}
		
		
		
	}
	
	/***
	 * Set all values to its default value
	 * @param vtenv environment that containts all entries, enums and enumselections
	 */
	public void SetAllDefault(VtEnv vtenv)
	{
		ArrayList<Item> items = vtenv.getItems();
		vtenv.hasChanged=false;
		if(vtenv.getGrpFiltWidget() != null)
			vtenv.getGrpFiltWidget().setDefault();
		for(int i=0;i<items.size();i++)
		{
			this.SetItemDefault(items.get(i),vtenv);
		}
	}
	
	/***
	 * set all value Descriiptions of a Item to the default value
	 * @param item Item that should be set to default
	 * @param vtenv environment with enum and enumselections
	 */
	public void SetItemDefault(Item item,VtEnv vtenv)
	{
		ArrayList<ValDesc> val = item.getValue();
		for(int k=0;k<val.size();k++)
		{
			SetDefault(val.get(k),vtenv);
		}
	}
	
	private boolean isInArray(String[] val1, String val2)
	{
		for(int i=0;i<val1.length;i++)
		{
			if(val1[i].compareTo(val2)==0)
				return true;
		}
		
		return false;
	}


	/***
	 * Set descriptions and tool tips for every Item. 
	 * @param vtenv environment with all items and toolbar
	 */
	public void setAllDesc(final VtEnv vtenv )
	{
		ArrayList<Item> items = vtenv.getItems();
		boolean overwriteWithEnv = false;
		boolean overwriteEnvAsked = false;
		Map<String,String> p = System.getenv();
		 
		if(vtenv.executable.endsWith(".xml"))
			overwriteEnvAsked = true;
		
		for(int i=0;i<items.size();i++)
		{
			final Item item =items.get(i);
			
			//set Tooltip	
			item.getComponent().addMouseListener(new MouseListener()
			{
				//private String old_text = "";		
				public void mousePressed(MouseEvent e){;}
				
				public void mouseEntered(MouseEvent e){
				//	old_text = vtenv.getToolTip().getText();
					String text = new String();
					String defaultval = "";
					String def = "";
					ArrayList <ValDesc> val = item.getValue();
					for(int i=0;i<val.size();i++)
					{
						def = val.get(i).getValue();
						if(val.get(i).getType().trim().compareTo("bool")== 0)
							if(def.compareTo("1")==0)
								def = "yes";
							else
								def = "no";
						
						if(def == null)
							def = " - ";
						
						defaultval += def+" ";
					}
					
					text = "";
					if(!item.isAvailable())
					{
						text += "<h3 style=\"color:#AA0000\">This setting is not available for this VampirTrace installation!</h3>";

					}
					
						text +=item.getDescription();
						text +="<br/><br/><b>Default:</b> "+defaultval;
						if(!item.getEnvname().equals("VTSetup_EXECUTABLE"))
							text +="<br/><br/><b>Variable:</b> "+item.getEnvname();
					
					try{
						String val1 = item.getDescname();
						if(val1.trim().equals(""))
							val1 = item.getGroup().getName();

						vtenv.ToolTipView.setText(Config.setToolTipString(val1, text));
						if(vtenv.getToolTip().getComponent(0) != vtenv.ToolTipView)
						{
					       	vtenv.getToolTip().removeAll();
		        			vtenv.getToolTip().add(vtenv.ToolTipView);
						}

							
					}catch(Exception ex)
					{
						Config.errorHandler(ex);
					}
				}
				public void mouseExited(MouseEvent e){
				}
				public void mouseClicked(MouseEvent e){;}
				public void mouseReleased(MouseEvent e){;}
			});
			
			ArrayList<ValDesc> val = item.getValue();
			for(int j=0;j<val.size();j++)
			{
				if(val.get(j).getComponent().getClass() == JPanel.class || 
						val.get(j).getComponent().getClass() == IntegerPanel.class ||
						val.get(j).getComponent().getClass() == FloatPanel.class ||
						val.get(j).getComponent().getClass() == myFileDialog.class
				)
				{
					JPanel help = (JPanel) val.get(j).getComponent();
					
					for(int k=0;k<help.getComponentCount();k++)
					{
						help.getComponent(k).addMouseListener(item.getComponent().getMouseListeners()[item.getComponent().getMouseListeners().length-1]);
					}
				}
				else if (val.get(j).getComponent().getClass() == CounterWidget.class)
				{
					ArrayList<Component> compHelp = ((CounterWidget)val.get(j).getComponent()).getAllComponents();
					for(int k=0;k<compHelp.size();k++)
					{
						compHelp.get(k).addMouseListener(item.getComponent().getMouseListeners()[item.getComponent().getMouseListeners().length-1]);
					}
				}
				else
					val.get(j).getComponent().addMouseListener(item.getComponent().getMouseListeners()[item.getComponent().getMouseListeners().length-1]);
			}
			
			
			if(!overwriteEnvAsked && p.containsKey(item.getEnvname().trim()))
			{
				String[] options = { "yes", "no"};
    			int answer = JOptionPane.showOptionDialog(null, VtEnv.mytext.getText("dialog_use_env"), VtEnv.mytext.getText("dialog_use_env_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
    			if(answer == 0)
    				overwriteWithEnv = true;
    			overwriteEnvAsked = true;
			}
			
			if(overwriteWithEnv && p.containsKey(item.getEnvname().trim()))
			{
				//System.out.println("overwrite: "+item.getEnvname());
				ValDesc comp = null;
				String value = p.get(item.getEnvname().trim());
				
				
				//Metric counter can have a different seperator
				if(item.getEnvname().trim().equals("VT_METRICS") && p.get("VT_METRICS_SEP") != null)
				{
					value = value.replace(p.get("VT_METRICS_SEP").trim().toCharArray()[0],':');
				}
				String value_comp = value;
				//set components of this item
				for(int j=0;j<item.getValue().size();j++)
				{
					comp = item.getValue().get(j);
					
					//output files will be ignored
					if(comp.getIOBehavior().contains("out"))
						break;
					
					if( comp.getType().equals("integer"))
					{
						Pattern pat = Pattern.compile("^([0-9]*)");
						Matcher m = pat.matcher(value);
						if(m.find())
						{
							value_comp = m.group(0);
							value = value.substring(value_comp.length()).trim();
						}
						else
						{
							break;
						}
					}
					
					if( comp.getType().equals("float"))
					{
						Pattern pat = Pattern.compile("^([0-9]*[.|,]?[0-9]*)");
						Matcher m = pat.matcher(value);
						if(m.find())
						{
							value_comp = m.group(0);
							value = value.substring(value_comp.length()).trim();
						}
						else
						{
							break;
						}
					}
					
					if( comp.getType().equals("enum"))
					{
						EnumClass enu = null;
						try{
							enu = vtenv.getEnumById(comp.getEnumId());
						}catch(Exception e)
						{
							break;
						}
						ArrayList<String>enumlst = enu.getEntrys();
						String pattern = "^(";
						for(int k=0;k<enumlst.size();k++)
							pattern = pattern + enumlst.get(k)+"|";
						pattern = pattern.substring(0,pattern.length()-1) + ")";
						
						Pattern pat = Pattern.compile(pattern);
						Matcher m = pat.matcher(value);
						if(m.find())
						{
							value_comp = m.group(0);
							value = value.substring(value_comp.length()).trim();
						}
						else
						{
							break;
						}
					}
					
					if( comp.getType().equals("enumselection"))
					{
						EnumSelectionClass enu = null;
						try{
							enu = vtenv.getEnumSelectionById(comp.getEnumId());
						}catch(Exception e)
						{
							break;
						}
						ArrayList<String>enumlst = enu.getEntrys();
						String pattern = "(";
						for(int k=0;k<enumlst.size();k++)
							pattern = pattern + enumlst.get(k)+"|";
						pattern = pattern.substring(0,pattern.length()-1) + ")";
						
						Pattern pat = Pattern.compile("^("+pattern+":)*"+pattern);
						Matcher m = pat.matcher(value);
						if(m.find())
						{
							value_comp = m.group(0);
							value = value.substring(value_comp.length()).trim();
						}
						else
						{
							break;
						}
					}
					
					if( comp.getType().equals("bool"))
					{
						Pattern pat = Pattern.compile("^(yes|no)");
						Matcher m = pat.matcher(value);
						if(m.find())
						{
							value_comp = m.group(0);
							value = value.substring(value_comp.length()).trim();
							if(value_comp.equals("1"))
								value_comp = "yes";
							if(value_comp.equals("0"))
								value_comp = "no";
						}
						else
						{
							break;
						}
					}
				
					if( comp.getType().equals("filepath"))
					{
						File f = new File(value_comp);
						while(!f.isFile() || value_comp.equals(""))
						{
							value_comp = value_comp.substring(0,value_comp.length()-1);
							f = new File(value_comp);
						}
						if(value_comp.equals(""))
							break;
						
						value = value.substring(value_comp.length()).trim();
					}
					
					if( comp.getType().equals("path"))
					{
						File f = new File(value_comp);
						while(!f.isDirectory() || value_comp.equals(""))
						{
							value_comp = value_comp.substring(0,value_comp.length()-1);
							f = new File(value_comp);
						}
						if(value_comp.equals(""))
							break;
						
						value = value.substring(value_comp.length()).trim();
					}
					
					SetComponent(comp.getComponent(),value_comp);
				}
			}
			//Set some special settings to specified Components
			if(item.getEnvname().trim().equals("VTSetup_EXECUTABLE"))
			{
				final JFormattedTextField prefix = (JFormattedTextField) vtenv.getItemById("VT_FILE_PREFIX").getValue().get(0).getComponent();
			    myFileDialog fdia = (myFileDialog) item.getValue().get(0).getComponent();
				final JFormattedTextField execut = (JFormattedTextField) fdia.getComponent(0);
				
				fdia.setIsVTLExecutable(vtenv);
				if(!vtenv.executable.endsWith(".xml"))
				execut.setText(vtenv.executable);

					
				final boolean isDefault = ((ValDesc)vtenv.getItemById("VT_FILE_PREFIX").getValue().get(0)).isDefault();
				if(isDefault && !execut.getText().trim().equals(""))
				{
					String Text = execut.getText().trim();
					if(Text.contains("/"))
						Text = Text.substring(Text.lastIndexOf("/")+1);
					if(Text.trim().toLowerCase().endsWith(".exe") || Text.toLowerCase().endsWith(".out")) 
						Text = Text.substring(0,Text.lastIndexOf("."));
					prefix.setText(Text);
				}
				
				execut.addFocusListener(new FocusListener(){
					public void focusGained(FocusEvent e) {;}
					public void focusLost(FocusEvent e) {
						
							String Text = execut.getText().trim();
							String out = "";
							if(!VtEnv.nm.trim().equals("") && !vtenv.executable.equals(execut.getText()))
							{
								vtenv.executable = execut.getText();
								try {
									
									Process p = Runtime.getRuntime().exec(VtEnv.nm+" "+Text,null);
									BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));   
									String line;
									
									line = br.readLine();
									if(line != null)
										out += line;
									
									out = out.trim();
									br.close();
									p.destroy();
									
									if(out.equals(""))
									{
										JOptionPane.showMessageDialog(null, "Nm can't get symbol information from this executable!"); 
										out = "no";
									}
									
									if(!out.equals("no") && vtenv.executableLoaded)
									{
										String[] options = { VtEnv.mytext.getText("dialog_chanche_exec_takenew"),VtEnv.mytext.getText("dialog_chanche_exec_merge"),VtEnv.mytext.getText("dialog_chanche_exec_takeold")};
				            			int answer = JOptionPane.showOptionDialog(null, VtEnv.mytext.getText("dialog_chanche_exec"), VtEnv.mytext.getText("dialog_chanche_exec_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
				            			VtEnv.executableAnswer = answer;
									}
									
									if(((ValDesc)vtenv.getItemById("VT_FILE_PREFIX").getValue().get(0)).isDefault())
									{
										if(!out.equals("no"))
										{
											if(Text.contains("/"))
												Text = Text.substring(Text.lastIndexOf("/")+1);
											if(Text.trim().toLowerCase().endsWith(".exe") || Text.toLowerCase().endsWith(".out")) 
												Text = Text.substring(0,Text.lastIndexOf("."));
											if(!Text.trim().equals(""))
												prefix.setText(Text);
										}
									}
								} catch (Exception err) {
									
									Config.errorHandler(err);
								}
								
								
							}
							
					}
						
				});
			}
		}
	}

	

}
