/*
 * Copyright (c) 2015 Cisco Systems, Inc.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef OPAL_DL_LIBLTDL
#define OPAL_DL_LIBLTDL

#include "opal_config.h"

#include "opal/mca/dl/dl.h"

#include <ltdl.h>

OPAL_DECLSPEC extern opal_dl_base_module_t opal_dl_libltdl_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct opal_dl_handle_t {
    lt_dlhandle ltdl_handle;
#if OPAL_ENABLE_DEBUG
    char *filename;
#endif
};

typedef struct {
    opal_dl_base_component_t base;

#if OPAL_DL_LIBLTDL_HAVE_LT_DLADVISE
    /* If the version of libltdl that we are compiling against has
       lt_dladvise, use it to support opening DSOs in a variety of
       modes. */
    lt_dladvise advise_private_noext;
    lt_dladvise advise_private_ext;
    lt_dladvise advise_public_noext;
    lt_dladvise advise_public_ext;
#endif
} opal_dl_libltdl_component_t;

OPAL_DECLSPEC extern opal_dl_libltdl_component_t mca_dl_libltdl_component;

#endif /* OPAL_DL_LIBLTDL */
