#ifndef SDLSNOW_HH
#define SDLSNOW_HH

#include "Layer.hh"
#include "noncopyable.hh"

namespace openmsx {

class OutputSurface;
class Display;

/** Snow effect for background layer.
  */
template <class Pixel>
class SDLSnow final : public Layer, private noncopyable
{
public:
	SDLSnow(OutputSurface& output, Display& display);

	// Layer interface:
	void paint(OutputSurface& output) override;

private:
	Display& display;

	/** Gray values for noise.
	  */
	Pixel gray[256];
};

} // namespace openmsx

#endif
