#
# This script was written by Sullo (sullo@cirt.net)
#

if(description)
{
 script_id(11220);
 script_version ("$Revision: 7515 $");
 script_tag(name:"risk_factor", value:"Low");
 name = "Netscape /.perf accessible";
 
 script_name(name);
 
 desc = "
Requesting the URI /.perf gives information about
the currently running Netscape/iPlanet web server.

Risk factor : Low
Solution : If you don't use this feature, server monitoring should be
disabled in the magnus.conf file or web server admin.";

 script_description(desc);
 
 summary = "Makes a request like http://www.example.com/.perf";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2003 Sullo");
 script_family("Web Servers");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/netscape-commerce", "www/netscape-fasttrack", "www/iplanet");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);
str = "ListenSocket";

if(get_port_state(port))
{
 soc = http_open_socket(port);
 if(soc)
 {
  buffer = http_get(item:"/.perf", port:port);
  send(socket:soc, data:buffer);
  data = http_recv(socket:soc);
  if( str >< data )
  {
   security_warning(port);
  }
  http_close_socket(soc);
 }
}
