# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:009
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63891);
 script_cve_id("CVE-2008-4311", "CVE-2008-4989", "CVE-2009-0193", "CVE-2009-0196", "CVE-2009-0365", "CVE-2009-0578", "CVE-2009-0586", "CVE-2009-0658", "CVE-2009-0698", "CVE-2009-0790", "CVE-2009-0792", "CVE-2009-0922", "CVE-2009-0927", "CVE-2009-0928", "CVE-2009-1061", "CVE-2009-1062", "CVE-2009-1171", "CVE-2009-1241");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Summary SUSE-SR:2009:009";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:009.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:009";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-branding-upstream", rpm:"MozillaFirefox-branding-upstream~3.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.7.0.r4359~15.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.7.0.r4359~15.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-doc", rpm:"NetworkManager-doc~0.7.0.r4359~15.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.7.0.r4359~15.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs", rpm:"aufs~cvs20081020~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-debug", rpm:"aufs-kmp-debug~cvs20081020_2.6.27.21_0.1~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-default", rpm:"aufs-kmp-default~cvs20081020_2.6.27.21_0.1~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-pae", rpm:"aufs-kmp-pae~cvs20081020_2.6.27.21_0.1~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-trace", rpm:"aufs-kmp-trace~cvs20081020_2.6.27.21_0.1~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-xen", rpm:"aufs-kmp-xen~cvs20081020_2.6.27.21_0.1~1.32.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.95.1~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.95.1~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1", rpm:"dbus-1~1.2.10~5.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel", rpm:"dbus-1-devel~1.2.10~5.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel-doc", rpm:"dbus-1-devel-doc~1.2.10~5.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"deb", rpm:"deb~1.14.21~10.38.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-branding-upstream", rpm:"glib2-branding-upstream~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel", rpm:"gnome-panel~2.24.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-devel", rpm:"gnome-panel-devel~2.24.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-doc", rpm:"gnome-panel-doc~2.24.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-extras", rpm:"gnome-panel-extras~2.24.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-lang", rpm:"gnome-panel-lang~2.24.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~2.4.1~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpg2", rpm:"gpg2~2.0.9~25.108.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpg2-lang", rpm:"gpg2-lang~2.0.9~25.108.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-base", rpm:"gstreamer-0_10-plugins-base~0.10.21~2.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-base-devel", rpm:"gstreamer-0_10-plugins-base-devel~0.10.21~2.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-base-doc", rpm:"gstreamer-0_10-plugins-base-doc~0.10.21~2.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-base-lang", rpm:"gstreamer-0_10-plugins-base-lang~0.10.21~2.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.4.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-akonadi", rpm:"kde4-akonadi~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-akonadi-devel", rpm:"kde4-akonadi-devel~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-akregator", rpm:"kde4-akregator~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-dolphin", rpm:"kde4-dolphin~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kaddressbook", rpm:"kde4-kaddressbook~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kalarm", rpm:"kde4-kalarm~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdepasswd", rpm:"kde4-kdepasswd~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdialog", rpm:"kde4-kdialog~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm", rpm:"kde4-kdm~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm-branding-upstream", rpm:"kde4-kdm-branding-upstream~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-keditbookmarks", rpm:"kde4-keditbookmarks~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kfind", rpm:"kde4-kfind~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kgreeter-plugins", rpm:"kde4-kgreeter-plugins~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kinfocenter", rpm:"kde4-kinfocenter~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kjots", rpm:"kde4-kjots~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kmail", rpm:"kde4-kmail~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-knode", rpm:"kde4-knode~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-knotes", rpm:"kde4-knotes~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-konqueror", rpm:"kde4-konqueror~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-konsole", rpm:"kde4-konsole~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kontact", rpm:"kde4-kontact~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-korganizer", rpm:"kde4-korganizer~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-ktimetracker", rpm:"kde4-ktimetracker~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-ktnef", rpm:"kde4-ktnef~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kwin", rpm:"kde4-kwin~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kwrite", rpm:"kde4-kwrite~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4", rpm:"kdebase4~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-libkonq", rpm:"kdebase4-libkonq~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-nsplugin", rpm:"kdebase4-nsplugin~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-runtime", rpm:"kdebase4-runtime~4.1.3~4.2.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace", rpm:"kdebase4-workspace~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-branding-upstream", rpm:"kdebase4-workspace-branding-upstream~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-devel", rpm:"kdebase4-workspace-devel~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-ksysguardd", rpm:"kdebase4-workspace-ksysguardd~4.1.3~10.3.7", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4", rpm:"kdelibs4~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4-core", rpm:"kdelibs4-core~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4-doc", rpm:"kdelibs4-doc~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3", rpm:"kdepim3~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-devel", rpm:"kdepim3-devel~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-kpilot", rpm:"kdepim3-kpilot~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-mobile", rpm:"kdepim3-mobile~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-notes", rpm:"kdepim3-notes~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-time-management", rpm:"kdepim3-time-management~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4", rpm:"kdepim4~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4-devel", rpm:"kdepim4-devel~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4-wizards", rpm:"kdepim4-wizards~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepimlibs4", rpm:"kdepimlibs4~4.1.3~5.2.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-base", rpm:"kernel-debug-base~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-extra", rpm:"kernel-debug-extra~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-base", rpm:"kernel-default-base~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-extra", rpm:"kernel-default-extra~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae", rpm:"kernel-pae~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-base", rpm:"kernel-pae-base~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-extra", rpm:"kernel-pae-extra~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.27.21~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.27.21~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace", rpm:"kernel-trace~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-base", rpm:"kernel-trace-base~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-extra", rpm:"kernel-trace-extra~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-vanilla", rpm:"kernel-vanilla~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-base", rpm:"kernel-xen-base~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-extra", rpm:"kernel-xen-extra~2.6.27.21~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kio_iso", rpm:"kio_iso~1.99.2.beta2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kitchensync", rpm:"kitchensync~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.46~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-mysql", rpm:"koffice-database-mysql~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-psql", rpm:"koffice-database-psql~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-planning", rpm:"koffice-planning~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-python", rpm:"koffice-python~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-ruby", rpm:"koffice-ruby~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.6.3~211.12.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.3~132.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krusader", rpm:"krusader~1.99.2.beta2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libakonadi4", rpm:"libakonadi4~4.1.3~5.2.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0", rpm:"libgio-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-fam", rpm:"libgio-fam~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0", rpm:"libglib-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0", rpm:"libgmodule-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas", rpm:"libgnomecanvas~2.20.1.1~25.81.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas-devel", rpm:"libgnomecanvas-devel~2.20.1.1~25.81.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas-doc", rpm:"libgnomecanvas-doc~2.20.1.1~25.81.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas-lang", rpm:"libgnomecanvas-lang~2.20.1.1~25.81.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-devel", rpm:"libgnutls-devel~2.4.1~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra-devel", rpm:"libgnutls-extra-devel~2.4.1~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra26", rpm:"libgnutls-extra26~2.4.1~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls26", rpm:"libgnutls26~2.4.1~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0", rpm:"libgobject-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstinterfaces-0_10-0", rpm:"libgstinterfaces-0_10-0~0.10.21~2.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0", rpm:"libgthread-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal", rpm:"libkcal~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal-devel", rpm:"libkcal-devel~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal2", rpm:"libkcal2~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkde4", rpm:"libkde4~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkde4-devel", rpm:"libkde4-devel~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdecore4", rpm:"libkdecore4~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdecore4-devel", rpm:"libkdecore4-devel~4.1.3~4.10.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepim4", rpm:"libkdepim4~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepim4-devel", rpm:"libkdepim4-devel~4.1.3~3.14.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepimlibs4", rpm:"libkdepimlibs4~4.1.3~5.2.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepimlibs4-devel", rpm:"libkdepimlibs4-devel~4.1.3~5.2.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkmime-devel", rpm:"libkmime-devel~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkmime2", rpm:"libkmime2~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkonq-devel", rpm:"libkonq-devel~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkonq5", rpm:"libkonq5~4.1.3~3.8.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libktnef-devel", rpm:"libktnef-devel~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libktnef1", rpm:"libktnef1~3.5.10~8.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpcap-devel", rpm:"libpcap-devel~0.9.8~50.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpcap0", rpm:"libpcap0~0.9.8~50.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libudev-devel", rpm:"libudev-devel~128~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libudev0", rpm:"libudev0~128~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id", rpm:"libvolume_id~126~17.38.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id-devel", rpm:"libvolume_id-devel~128~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id1", rpm:"libvolume_id1~128~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine-devel", rpm:"libxine-devel~1.1.15~23.3.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine1", rpm:"libxine1~1.1.15~23.3.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine1-gnome-vfs", rpm:"libxine1-gnome-vfs~1.1.15~23.3.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine1-pulse", rpm:"libxine1-pulse~1.1.15~23.3.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"module-init-tools", rpm:"module-init-tools~3.4~56.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan", rpm:"openswan~2.6.16~1.47.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan-doc", rpm:"openswan-doc~2.6.16~1.47.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"phonon-backend-xine", rpm:"phonon-backend-xine~4.1.3~4.2.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.3.7~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xpcom190", rpm:"python-xpcom190~1.9.0.8~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan", rpm:"strongswan~4.2.8~1.24.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan-doc", rpm:"strongswan-doc~4.2.8~1.24.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysconfig", rpm:"sysconfig~0.71.11~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~128~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~97.78.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~97.78.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-audio", rpm:"bluez-audio~3.32~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~3.32~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~3.32~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.32~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.95.1~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.95.1~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-branding-upstream", rpm:"glib2-branding-upstream~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~2.2.2~17.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpg2", rpm:"gpg2~2.0.9~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpg2-lang", rpm:"gpg2-lang~2.0.9~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.11~8.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.11~8.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3", rpm:"kdepim3~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-devel", rpm:"kdepim3-devel~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-kpilot", rpm:"kdepim3-kpilot~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-mobile", rpm:"kdepim3-mobile~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-notes", rpm:"kdepim3-notes~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-time-management", rpm:"kdepim3-time-management~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kitchensync", rpm:"kitchensync~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.46~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-mysql", rpm:"koffice-database-mysql~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-psql", rpm:"koffice-database-psql~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-planning", rpm:"koffice-planning~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-python", rpm:"koffice-python~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-ruby", rpm:"koffice-ruby~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.6.3~157.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.3~50.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0", rpm:"libgio-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-fam", rpm:"libgio-fam~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0", rpm:"libglib-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0", rpm:"libgmodule-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-devel", rpm:"libgnutls-devel~2.2.2~17.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra-devel", rpm:"libgnutls-extra-devel~2.2.2~17.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra26", rpm:"libgnutls-extra26~2.2.2~17.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls26", rpm:"libgnutls26~2.2.2~17.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0", rpm:"libgobject-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0", rpm:"libgthread-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal", rpm:"libkcal~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal-devel", rpm:"libkcal-devel~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkcal2", rpm:"libkcal2~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkmime-devel", rpm:"libkmime-devel~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkmime2", rpm:"libkmime2~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libktnef-devel", rpm:"libktnef-devel~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libktnef1", rpm:"libktnef1~3.5.9~53.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id", rpm:"libvolume_id~120~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id-devel", rpm:"libvolume_id-devel~120~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.8~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan", rpm:"openswan~2.4.7~130.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan-doc", rpm:"openswan-doc~2.4.7~130.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.3.7~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan", rpm:"strongswan~4.2.1~11.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan-doc", rpm:"strongswan-doc~4.2.1~11.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysconfig", rpm:"sysconfig~0.70.8~3.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"timezone", rpm:"timezone~2009d~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~120~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.12~8.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.12~8.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.12~8.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~95.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~95.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zypper", rpm:"zypper~0.11.11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.21post~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.21post~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~3.18~13.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~3.18~13.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.18~13.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.95.1~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.95.1~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.6.1~36.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.6.1~36.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpg2", rpm:"gpg2~2.0.4~49.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3", rpm:"kdepim3~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-devel", rpm:"kdepim3-devel~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-kpilot", rpm:"kdepim3-kpilot~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-mobile", rpm:"kdepim3-mobile~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-notes", rpm:"kdepim3-notes~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim3-time-management", rpm:"kdepim3-time-management~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kitchensync", rpm:"kitchensync~3.5.7.enterprise.0.20070904.708012~9.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.46~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-mysql", rpm:"koffice-database-mysql~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-database-psql", rpm:"koffice-database-psql~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-planning", rpm:"koffice-planning~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-python", rpm:"koffice-python~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-ruby", rpm:"koffice-ruby~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.6.3~51.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.2~22.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id", rpm:"libvolume_id~114~19.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id-devel", rpm:"libvolume_id-devel~114~19.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan", rpm:"openswan~2.4.7~64.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan-doc", rpm:"openswan-doc~2.4.7~64.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.13~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysconfig", rpm:"sysconfig~0.70.2~4.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"timezone", rpm:"timezone~2009d~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~114~19.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.8~14.14", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.8~14.14", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.8~14.14", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~19.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~19.8", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
